<?php
//============================================================+
// File name   : example_051.php
// Begin       : 2009-04-16
// Last Update : 2013-05-14
//
// Description : Example 051 for TCPDF class
//               Full page background
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Full page background
 * @author Nicola Asuni
 * @since 2009-04-16
 */

// Include the main TCPDF library (search for installation path).



// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {
    //Page header
      public function Header() {
          
       
        // get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->AutoPageBreak;
        // disable auto-page-break
        $this->SetAutoPageBreak(false, 0);
        // set bacground image
        
        $img_file = base_url().'assets/uploads/'.$_SESSION['logo'];
        $this->Image($img_file, 0, 0, 80, 28, '', '', '', false, 300, '', false, false, 0);
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $this->setPageMark();
    }
    // Page footer
    public function Footer() {
       
        $this->SetY(-15);
         $this->SetFont('helvetica', 'I', 8);
         
            $this->Cell(0, 15, $_SESSION['company_address'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
         $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        // Set font
        
            }
    
}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
//$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('Employee Shift  Report');
//$pdf->SetSubject('TCPDF Tutorial');
//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(0);
$pdf->SetFooterMargin(0);
 $add = $this->mastermodel->get_srow('company','company_address');
  $company = $this->mastermodel->get_srow('company','company_logo');
$_SESSION['company_address'] = $add->company_address;
$_SESSION['logo'] = $company->company_logo;
// remove default footer
$pdf->setPrintFooter(false);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 48);

$pdf->setPrintHeader(true);
$pdf->SetMargins(20, 40, 20, true);
// add a page
$pdf->AddPage();

$bMargin = $pdf->getBreakMargin();
// get current auto-page-break mode
$auto_page_break = $pdf->getAutoPageBreak();
// disable auto-page-break
$pdf->SetAutoPageBreak(false, 0);
// set bacground image
// restore auto-page-break status


$pdf->SetAutoPageBreak($auto_page_break, $bMargin);
// set the starting point for the page content
$pdf->setPageMark();
// Print a text
// set some text to print
$pdf->SetFont('helvetica', 'B', 20);
  $frmdate = date('Y-m-d', strtotime($payslip->hr_employee_salary_salary_date . ' -1 months'));
         $todate = date('Y-m-d', strtotime($payslip->hr_employee_salary_salary_date . ' -1 day'));
$html = '<div style="text-align:center">Payslip for <u>'.$this->mastermodel->convertdatenormalformat($frmdate).'</u>  to  <u>'.$this->mastermodel->convertdatenormalformat($todate).'</u></div><br>';
$pdf->writeHTML($html, true, false, true, false, '');

$pdf->SetFont('helvetica', '', 8);
$tbl = '<table cellpadding="8px" border="0">
      
        <thead>
    
            <tr>

              <th style="font-style:italic;font-size:13px;background-color: #434343;border-right:4px #fff" color="#f3f3f3"><b>Name of Employer</b></th>
                             <th style="font-style:italic;font-size:13px;background-color: #434343;border-left:4px #fff" color="#f3f3f3"><b>Date of Payment</b> </th>
                 </tr>
    <tr>
    <td style="font-style:italic;font-size:12px;" ><b>'.$company->company_name.'</b>
    </td>
       <td style="font-style:italic;font-size:12px;" ><b>'.$this->mastermodel->convertdatenormalformat($payslip->hr_employee_salary_pay_date).'</b>
    </td>
</tr>
    </table>';

$pdf->writeHTML($tbl, false, false, true, false, '');

$pdf->SetFont('helvetica', '', 8);
$tbl = '<table cellpadding="8px" border="0">
      
        <thead>
    
            <tr>

              <th style="font-style:italic;font-size:13px;background-color: #434343;border-right:4px #fff" color="#f3f3f3"><b>Name of Employee</b></th>
                             <th style="font-style:italic;font-size:13px;background-color: #434343;border-left:4px #fff" color="#f3f3f3"><b>Mode of Payment</b> </th>
                 </tr>
    <tr>
    <td style="font-style:italic;font-size:12px;" ><b>'.$employee->hr_employees_name.'</b>
    </td>
      <td style="font-style:italic;font-size:12px;" ><b>'.$payslip->hr_employee_salary_payment_method.'</b>
    </td>
</tr>
    </table>';

$pdf->writeHTML($tbl, false, false, true, false, '');


$pdf->SetFont('helvetica', '', 8);
  $sllowance=$this->hrmodel->get_allwnce_deduc_dtls($payslip->hr_employee_salary_slip_id,'Allowance');
                                
$tbl = '<table width="100%" cellpadding="0" border="0">
    <tr>
      
        <td width="50%">
            <table width="100%" border="1" cellpadding="8px">
                <tr style="font-style:italic;font-size:13px;background-color: #434343;border-right:4px #fff" color="#f3f3f3">
                <td><b>Item</b></td>
                 <td><b>Amount</b></td>
                </tr>
                <tr align="center" >
                <td  style="font-style:italic;font-size:12px;background-color: #ededed; " color="#828189">Gross Pay
                </td>
                <td>
               '.number_format((float)$payslip->hr_employee_salary_gross_salary, 2, ".", "").'
</td>
</tr>
   <tr align="center" >
                <td  style="font-style:italic;font-size:12px;background-color: #ededed;" color="#828189">
Total Allowances (Breakdown shown below)
                </td>
                <td>
               '.number_format((float)$payslip->hr_employee_salary_allowance_amount, 2, ".", "").'
</td>
</tr>';
           foreach($sllowance as $sllowance){
                if($sllowance->hr_allowdeduc_mode=="Percentage"){
                 $allowance_amount= $sllowance->hr_employee_salary_slip_allowdeduc_amount/100*$payslip->hr_employee_salary_gross_salary;
           }
           else{
            $allowance_amount=$sllowance->hr_employee_salary_slip_allowdeduc_amount;
           }
  $tbl .='<tr align="center" >
                <td  >
'.$sllowance->hr_allowdeduc_name.'
                </td>
                <td>
              '.number_format((float)$allowance_amount, 2, ".", "").'
</td>
           </tr>';
           }
  $tbl .='<tr align="center" >
                <td  style="font-style:italic;font-size:12px;background-color: #ededed;" color="#828189">
Total Deductions (Breakdown shown below)
                </td>
                <td>
                 '.number_format((float)$payslip->hr_employee_salary_deduction_amount, 2, ".", "").'
</td>
</tr>';
   $dllowance=$this->hrmodel->get_allwnce_deduc_dtls($payslip->hr_employee_salary_slip_id,'Deduction');
     foreach ($dllowance as $dllowance){    
           if($dllowance->hr_allowdeduc_mode=="Percentage"){
                 $allototal= $dllowance->hr_employee_salary_slip_allowdeduc_amount/100*$payslip->hr_employee_salary_gross_salary;
           }
           else{
            $allototal=     $dllowance->hr_employee_salary_slip_allowdeduc_amount;
           }
  $tbl .='<tr align="center" >
                <td  >
                '.$dllowance->hr_allowdeduc_name.'
                </td>
                <td>
                '.number_format((float)$allototal, 2, ".", "").'
</td>
</tr>';
     }
            $tbl .=' </table>    
        </td>

      
        <td width="50%">
            <table width="100%" border="1" cellpadding="8px">
                <tr style="font-style:italic;font-size:13px;background-color: #434343;border-right:4px #fff" color="#f3f3f3" >
                <td colspan="2" ><b>Overtime Details*</b></td>
                
          
</tr>
<tr align="center" >
                <td  style="font-style:italic;font-size:12px;background-color: #ededed;" color="#828189">
Overtime Minutes Worked
                </td>
                <td>
            '. $payslip->hr_employee_salary_overtime_minutes.'
</td>
</tr>
<tr align="center" >
                <td  style="font-style:italic;font-size:12px;background-color: #ededed;" color="#828189">
Total Overtime Pay
                </td>
                <td>
            '.number_format((float)$payslip->hr_employee_salary_overtime_amount, 2, ".", "").'
</td>
</tr>
     <tr style="font-style:italic;font-size:13px;background-color: #434343;border-right:4px #fff" color="#f3f3f3">
                <td><b>Item</b></td>
                 <td><b>Amount</b></td>
                </tr>
                <tr align="center" >
                <td  style="font-style:italic;font-size:12px;background-color: #ededed;" color="#828189">
Holiday Minutes Worked
                </td>
                <td>
            '. $payslip->hr_employee_salary_holiday_minutes.'
</td>
</tr>
<tr align="center" >
                <td  style="font-style:italic;font-size:12px;background-color: #ededed;" color="#828189">
Total Holiday Pay
                </td>
                <td>
            '. number_format((float)$payslip->hr_employee_salary_holiday_payment, 2, ".", "").'
</td>
</tr>
<tr align="center" >
                <td  style="font-style:italic;font-size:12px;background-color: #ededed;" color="#828189">
Net Pay
                </td>
                <td>
            '.number_format((float)$payslip->hr_employee_salary_net_payment, 2, ".", "") .'
</td>
</tr>

            </table>   
        </td>
    </tr>
</table>


';

$pdf->writeHTML($tbl, true, false, true, false, '');
$pdf->setPrintFooter(TRUE);

//Close and output PDF documentAll Files	/var/www/html/qzaakacc_new/assets/images
//$pdf->Output('/var/www/html/qzaakacc_new/assets/quotation/'.$id.'.pdf', 'F');
//$pdf->Output('/var/www/html/demo/qzaakacc_new/assets/quotation/'.$id.'.pdf', 'F');
//============================================================+
// END OF FILE
//============================================================+
$pdf->Output('PaySlip.pdf', 'D');

//============================================================+
// END OF FILE
//============================================================+