<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Settingsmodel extends CI_Model
{

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }

    /* functions for profile  */


    function get_profile_permission($user_profile_id)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('user_profile');
        $this->db->join('master', 'master.master_id=user_profile.profile_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('profile_id', $user_profile_id);
        $this->db->order_by('profile_id', 'asc');
        $Q = $this->db->get();
        if ($Q->num_rows() > 0)
        {
            foreach ($Q->result_array() as $row)
            {
                $data[] = $row;
            }
        }
        $Q->free_result();
        return $data;
    }

    function get_user_permission_by_user_id($user_id)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('user');
          $this->db->join('user_profile', 'user_profile.profile_id=user.profile_id');
            $this->db->join('master', 'master.master_id=user.user_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('user_id', $user_id);
        $Q = $this->db->get();
        if ($Q->num_rows() > 0)
        {
            foreach ($Q->result_array() as $row)
            {
                $data[] = $row;
            }
        }
        $Q->free_result();
        return $data;
    }

    function getmoduledatamaster()
    {
        $data = array();
        $res = $this->db->query("select module.module_name,module.module_title,menu.caption,menu.target,menu.menu_id,menu.module_id,menu.sort from module join menu on module.module_id=menu.module_id
             where module.active = '1' and menu.active='1' and menu.project_id='".$_SESSION['project_id']."'
            order by module.sort, menu.sort");
        foreach ($res->result_array() as $row)
        {
            $data[] = $row;
        }
        return $data;
    }

    /* functions for profile  */

    function search_profile()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('user_profile');
        $this->db->join('master', 'master.master_id=user_profile.profile_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('profile_id', 'asc');
        $data['results'] = $this->db->get();
        return $data;
    }


    function insert_profile($postdata)
    {
        $data = array();
        $this->db->trans_begin();
          $masterid = $this->mastermodel->insertmasterdata();
      $project_access =  implode(',', $postdata['project_access']);
            if (isset($postdata['administrator_privilage']))
        {
            $administrator_privilage = 'yes';
        } else
        {
            $administrator_privilage = 'no';
        }
        $tblValues = array(
            'profile_id'=>$masterid,
            'profile_name' => $postdata['profile_name'],
            'project_access' =>$_SESSION['project_id'],
            'profile_modules' => $postdata['role_permission'],
            'profile_modules_home_page' => $postdata['role_home_page'],
            'profile_modules_permission' => $postdata['role_edit_del_permission'],
             'administrator_privilage' => $administrator_privilage
        );
      
        $this->db->insert('user_profile', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function update_profile($postdata)
    {
        $data = array();
        $this->db->trans_begin();
         $project_access =  implode(',', $postdata['project_access']);
            if (isset($postdata['administrator_privilage']))
       {
            $administrator_privilage = 'yes';
        } else
        {
            $administrator_privilage = 'no';
        }
        $tblValues = array(
            'profile_name' => $postdata['profile_name'],
             'project_access' =>$project_access,
            'profile_modules' => $postdata['role_permission'],
            'profile_modules_home_page' => $postdata['role_home_page'],
            'profile_modules_permission' => $postdata['role_edit_del_permission'],
              'administrator_privilage' => $administrator_privilage
        );
        $this->db->where('profile_id', $postdata['profile_id']);
        $this->db->update('user_profile', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Updating Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    /* functions for reminder */

    function search_reminder()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('reminder');
        $this->db->join('master', 'master_id=reminder_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('reminder_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function insert_reminder($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'reminder_id' => $masterid,
            'reminder_subject' => $postdata['reminder_subject'],
            'reminder_date' => $this->mastermodel->convertdateformat($postdata['reminder_date']),
            'remind_before' => $postdata['remind_before'],
            'reminder_description' => $postdata['reminder_description']
        );
        $this->db->insert('reminder', $tblValues);
        $data['resfunction'] = 'search_reminder';
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function update_reminder($postdata)
    {
        $data = array();
        $this->db->trans_begin();
      //  $this->mastermodel->updatemasterdata($postdata['reminder_id']);
        $tblValues = array(
            'reminder_subject' => $postdata['reminder_subject'],
            'reminder_date' => $this->mastermodel->convertdateformat($postdata['reminder_date']),
            'remind_before' => $postdata['remind_before'],
            'reminder_description' => $postdata['reminder_description']
        );
        $this->db->where('reminder_id', $postdata['reminder_id']);
        $this->db->update('reminder', $tblValues);
        $data['resfunction'] = 'search_reminder';
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Updating Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    /* functions for user */

    function update_password($postdata)
    {

        $data = array();
        $data['resfunction'] = 'search_user';
        if ($postdata['newpassword'] == $postdata['retypepassword'])
        {
            $tblValues = array('password' => md5($postdata['newpassword']));
            $this->db->where('user_id', $postdata['user_id']);
            $this->db->update('user', $tblValues);
            $data['res'] = 'password';
            $data['msg'] = 'Password Changed Sucessfully';
            return $data;
        } 
        else
        {
            $data['res'] = 'password';
            $data['msg'] = 'Passwords do not match';
            return $data;
        }
    }
    function search_user()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('user');
       // $this->db->join('hr_employees', 'hr_employees.user_id=user.user_id','left');
        $this->db->join('user_profile', 'user_profile.profile_id=user.profile_id');
        $this->db->join('master', 'master.master_id=user.user_id');
         $this->db->where('master.project_id', $_SESSION['project_id']);
          $user_branch = $_SESSION['master_branch'];
             $query = "(";    
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";    
             $query.=")";     
             if($user_branch!=4906){
             $this->db->where($query);
             }
        $this->mastermodel->user_access();
        $this->db->order_by('user_id', 'asc');
        $data['results'] = $this->db->get();
        return $data;
    }
    
    function insert_user($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
           if (isset($postdata['manager_approve']))
        {
            $manager_approve = 1;
        } else
        {
            $manager_approve = 0;
        }
        if (isset($postdata['gm_approve']))
        {
            $gm_approve = 1;
        } else
        {
            $gm_approve = 0;
        }
         $username=trim( $postdata['user_name'] );
        $tblValues = array(
            'user_id'=>$masterid,
            'user_name' => $username,
            'phone' => $postdata['phone'],
            'email' => $postdata['email'],
            'password' => md5($postdata['password']),
            'profile_id' => $postdata['profile_id'],
           // 'employee_id' => $postdata['employee_id'],
            'user_modules' => $postdata['role_permission'],
            'modules_permission' => $postdata['role_edit_del_permission'],
            'home_page' => $postdata['role_home_page'],
            'manager_approve' => $manager_approve,
            'gm_approve' => $gm_approve,
            'sub_branch_id' => implode(",", $postdata['sub_branch_id']),
            'branch_id' => implode(",", $postdata['branch'])
        );
        $upload_data = $this->mastermodel->upload_image('photo');
        if (!empty($upload_data['file_name'])) {
            $tblValues['photo'] = $upload_data['file_name'];
        }else{
                $tblValues['photo'] = 'profile1.png';
        }
        $_SESSION['user_prof'] = $tblValues['photo'];
        
        $this->db->insert('user', $tblValues);
        
        $user_id = $this->db->insert_id();
        if(isset($postdata['report_id']))
        {
        foreach($postdata['report_id'] as $report_id)
        {
            $tblValues = array(
                'user_id' => $user_id,
                'report_id' => $report_id
            );
            $this->db->insert('report_list_permission', $tblValues);
        }
        }
        
        if (isset($postdata['sales_view']) || isset($postdata['purchase_view']))
        {
            if (isset($postdata['sales_view']))
            {
                $sales_view = 1;
            } else
            {
                $sales_view = 0;
            }
            if (isset($postdata['purchase_view']))
            {
                $purchase_view = 1;
            } else
            {
                $purchase_view = 0;
            }
            if (isset($postdata['leave_approval']))
            {
                $leave_approval = 1;
            } else
            {
                $leave_approval = 0;
            }


            if (isset($postdata['approve_lpr']))
            {
                $approve_lpr = 1;
            } else
            {
                $approve_lpr = 0;
            }


            if (isset($postdata['verified']))
            {
                $verified = 1;
            } else
            {
                $verified = 0;
            }
            if (isset($postdata['po_manager_approval']))
            {
                $po_manager_approval = 1;
            } else
            {
                $po_manager_approval = 0;
            }
            if (isset($postdata['po_gm_approval']))
            {
                $po_gm_approval = 1;
            } else
            {
                $po_gm_approval = 0;
            }
            $tblValues = array(
                'user' => $masterid,
                'purchase_view' => $purchase_view,
                'sales_view' => $sales_view,
                'leave_approval' => $leave_approval,
                'approve_lpr' => $approve_lpr,
                'verified' => $verified,
                 'po_manager_approval' => $po_manager_approval,
                'po_gm_approval' => $po_gm_approval,
            );
            $output = $this->db->insert('dashbord_permission', $tblValues);
        }
        $data['resfunction'] = 'search_user';
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function update_user($postdata)
    {
//        var_dump($postdata);
//        die();
        $data = array();
        $this->db->trans_begin();
          if (isset($postdata['manager_approve']))
        {
            $manager_approve = 1;
        } else
        {
            $manager_approve = 0;
        }
        if (isset($postdata['gm_approve']))
        {
            $gm_approve = 1;
        } else
        {
            $gm_approve = 0;
        }
        $tblValues = array(
             'user_modules' => $postdata['user_modules'],
           'modules_permission' => $postdata['modules_permission'],
              'phone' => $postdata['phone'],
             'email' => $postdata['email'],
             'profile_id' => $postdata['profile_id'],
            //'employee_id' => $postdata['employee_id'],
           'manager_approve' => $manager_approve,
            'gm_approve' => $gm_approve,
               'branch_id' => implode(",", $postdata['branch']),
            'sub_branch_id' => implode(",", $postdata['sub_branch']),
//            'home_page' => $postdata['role_home_page'],
        );
        $upload_data = $this->mastermodel->upload_image('photo');
        if (!empty($upload_data['file_name'])) {
            $tblValues['photo'] = $upload_data['file_name'];
        }else{
            if(isset($postdata['prev_photo'])){
                $tblValues['photo'] = $postdata['prev_photo'];
            }else{
                $tblValues['photo'] = 'profile1.png';
            }
        }
        $_SESSION['user_prof'] = $tblValues['photo'];
        
        $this->db->where('user_id', $postdata['user_id']);
        $this->db->update('user', $tblValues);
        
        $agency_id=$this->mastermodel->get_single_field_value('user','agency_id','user_id',$postdata['user_id']);
        $emp_id=$this->mastermodel->get_single_field_value('user','employee_id','user_id',$postdata['user_id']);
        $creditor=$this->mastermodel->get_single_field_value('user','contact_id','user_id',$postdata['user_id']);
        $lawyer=$this->mastermodel->get_single_field_value('user','lawyer_id','user_id',$postdata['user_id']);
        
        if($agency_id!=''){
            
        }
        
        if($emp_id!=''){
            $tblValues_emp = array(
                //'hr_employees_email' => $postdata['email'],
             'hr_employees_contact_no' => $postdata['phone'],
             'hr_employees_branch'=>$postdata['sub_branch'][0]
            );
        $this->db->where('hr_employees_id',$emp_id);
        $this->db->update('hr_employees', $tblValues_emp);
        }
        if($creditor!=''){
            
        }
        if($lawyer!=''){
            
        }
        
        
        
        $this->db->where('user_id', $postdata['user_id']);
        $this->db->delete('report_list_permission');
        if(isset($postdata['report_id']))
        {
        foreach($postdata['report_id'] as $report_id)
        {
            $tblValues = array(
                'user_id' => $postdata['user_id'],
                'report_id' => $report_id
            );
            $this->db->insert('report_list_permission', $tblValues);
        }
        }
        $data['resfunction'] = 'search_user';
        if (isset($postdata['sales_view']))
        {
            $sales_view = 1;
        } else
        {
            $sales_view = 0;
        }
        if (isset($postdata['purchase_view']))
        {
            $purchase_view = 1;
        } else
        {
            $purchase_view = 0;
        }

        if (isset($postdata['leave_approval']))
        {
            $leave_approval = 1;
        } else
        {
            $leave_approval = 0;
        }


        if (isset($postdata['approve_lpr']))
        {
            $approve_lpr = 1;
        } else
        {
            $approve_lpr = 0;
        }


        if (isset($postdata['verified']))
        {
            $verified = 1;
        } else
        {
            $verified = 0;
        }
        if (isset($postdata['po_manager_approval']))
        {
            $po_manager_approval = 1;
        } else
        {
            $po_manager_approval = 0;
        }
        if (isset($postdata['po_gm_approval']))
        {
            $po_gm_approval = 1;
        } else
        {
            $po_gm_approval = 0;
        }



        if ($postdata['dashboard_permissions_id'] == "")
        {
            if (isset($postdata['sales_view']) || isset($postdata['purchase_view']))
            {

                $tblValues = array(
                    'user' => $postdata['user_id'],
                    'purchase_view' => $purchase_view,
                    'sales_view' => $sales_view,
                    'leave_approval' => $leave_approval,
                    'approve_lpr' => $approve_lpr,
                    'verified' => $verified,
                    'po_manager_approval' => $po_manager_approval,
                    'po_gm_approval' => $po_gm_approval,
                );
                $output = $this->db->insert('dashbord_permission', $tblValues);
            }
        } else
        {
            $tblValues = array(
                'user' => $postdata['user_id'],
                'purchase_view' => $purchase_view,
                'sales_view' => $sales_view,
                'leave_approval' => $leave_approval,
                'approve_lpr' => $approve_lpr,
                'verified' => $verified,
                'po_manager_approval' => $po_manager_approval,
                'po_gm_approval' => $po_gm_approval,
            );
            $this->db->where('dashbord_permission_id', $postdata['dashboard_permissions_id']);
            $output = $this->db->update('dashbord_permission', $tblValues);
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Updating Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function checkprofileset($employee_id)
     {
        $this->db->from('user');
         $this->db->join('master', 'master.master_id=user.user_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('user.agency_id',$employee_id);
         $num = $this->db->count_all_results();
        return $num;
    }
    function get_report_details() 
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('report');
        $this->db->join('menu', 'menu.menu_id=report.report_module_id');
        $this->db->join('report_list_permission', 'report_list_permission.report_id=report.report_id' , 'left');
        $this->db->group_by('report.report_id');
        $Q = $this->db->get();

        if ($Q->num_rows() > 0) {
            foreach ($Q->result_array() as $row) {
                $data[] = $row;
            }
        }
        $Q->free_result();
        return $data;
    }
    
 
    function search_profile_settings()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('profile_settings');
        $this->db->join('master', 'master.master_id= profile_settings.profile_settings_id');
         $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('profile_settings_id', 'asc');
        $data['results'] = $this->db->get();
        return $data; 
    }

    
     function insert_profile_settings($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'profile_settings_id' => $masterid,
            'vendor_profile_id' => $postdata['vendor_profile_id'],
            'agency_profile_id' => $postdata['agency_profile_id'],
            'customer_profile_id' => $postdata['customer_profile_id'],
            'employeer_profile_id' => $postdata['employeer_profile_id'],
                 'lawyer_profile_id'=> $postdata['lawyer_profile_id'],
               'legal_profile_id'=> $postdata['legal_profile_id'],
               'collector_profile_id'=> $postdata['collector_profile_id'],
              'creditor_profile_id'=> $postdata['creditor_profile_id'],
        );
        $this->db->insert('profile_settings', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function update_profile_settings($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
           
            'vendor_profile_id' => $postdata['vendor_profile_id'],
            'agency_profile_id' => $postdata['agency_profile_id'],
            'customer_profile_id' => $postdata['customer_profile_id'],
            'employeer_profile_id'=> $postdata['employeer_profile_id'],
                'lawyer_profile_id'=> $postdata['lawyer_profile_id'],
               'legal_profile_id'=> $postdata['legal_profile_id'],
               'collector_profile_id'=> $postdata['collector_profile_id'],
             'creditor_profile_id'=> $postdata['creditor_profile_id'],
        );
        $this->db->where('profile_settings_id',$postdata['profile_settings_id']);
        $this->db->update('profile_settings', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function get_profile_settings()
    {
        $this->db->select('*');
        $this->db->from('profile_settings');
        $data = $this->db->get()->row();
        return $data;
    }
    function search_company_details()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('company');
        $this->db->join('master', 'master.master_id=company_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
//        $this->db->order_by('profile_id', 'asc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_company_details($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $b='company_logo';
        $files = $_FILES;
      $cc_customer= str_replace(' ','', $postdata['cc_customer']); 
      $cc_other= str_replace(' ','', $postdata['cc_other']); 
     
      
                    
        $cpt = count($_FILES[$a]['name']); 
        $files[$b]['name']= str_replace(" ","", $files[$b]['name']); 
        $_FILES[$b]['type']= $files[$b]['type'];
        $_FILES[$b]['tmp_name']= $files[$b]['tmp_name'];
        $_FILES[$b]['error']= $files[$b]['error'];
        $_FILES[$b]['size']= $files[$b]['size'];
        $uploadPath = './assets/uploads/';
        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'gif|jpg|png|ico';

        $this->load->library('upload', $config);
        $this->upload->initialize($config);
                if($this->upload->do_upload($b)){
                    $fileData = $this->upload->data();
                    $uploadData['file_name'] = $fileData['file_name'];
                    }
                    $fileName = $_FILES[$b]['name'];
                    $images = $fileName;
        
        $tblValues = array(
            'company_id' => $masterid,
            'company_name' => $postdata['company_name'],
            'company_logo' => $images,
            'company_email' => $postdata['company_email'],
            'company_contact_no' => $postdata['company_contact_no'],
            'company_address' => $postdata['company_address'],
            'company_website' => $postdata['company_website'],
            'cc_customer' =>$cc_customer,
            'cc_other' => $cc_other,
               'company_attendance_policy' => $postdata['company_attendance_policy'],
            'project_id' =>$_SESSION['project_id'],
            );
        $this->db->insert('company', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     function update_company_details($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $b='company_logo';
        $files = $_FILES;
         $cc_customer= str_replace(' ','', $postdata['cc_customer']); 
      $cc_other= str_replace(' ','', $postdata['cc_other']); 
                    
        $cpt = count($_FILES[$a]['name']); 
        $files[$b]['name']= str_replace(" ","", $files[$b]['name']); 
        $_FILES[$b]['type']= $files[$b]['type'];
        $_FILES[$b]['tmp_name']= $files[$b]['tmp_name'];
        $_FILES[$b]['error']= $files[$b]['error'];
        $_FILES[$b]['size']= $files[$b]['size'];
        $uploadPath = './assets/uploads/';
        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'gif|jpg|png|ico';

        $this->load->library('upload', $config);
        $this->upload->initialize($config);
                if($this->upload->do_upload($b)){
                    $fileData = $this->upload->data();
                    $uploadData['file_name'] = $fileData['file_name'];
                    }
                    $fileName = $_FILES[$b]['name'];
                    $images = $fileName;
//                    var_dump($images);die();
        $tblValues = array(
            'company_name' => $postdata['company_name'],
            'company_email' => $postdata['company_email'],
            'company_contact_no' => $postdata['company_contact_no'],
            'company_address' => $postdata['company_address'],
            'company_website' => $postdata['company_website'],
             'company_attendance_policy' => $postdata['company_attendance_policy'],
             'cc_customer' =>$cc_customer,
            'cc_other' => $cc_other,
             'project_id' =>$_SESSION['project_id'],
        );
        if(!empty($images)){
           $tblValues['company_logo'] = $images;
        }
        else{
            $tblValues['company_logo'] = $postdata['prev_company_logo'];
        }
        
        $this->db->where('company_id', $postdata['company_id']);
        $this->db->update('company', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Updating Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function get_dashboard_permissions_by_user($id)
    {

        $this->db->select('*');
        $this->db->from('dashbord_permission');
        $this->db->where('user', $id);
        $result = $this->db->get()->row();
        if ($result)
        {
            return $result;
        } else
        {
            return "";
        }
    }
      function search_region_branch()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('regional_branches');
        $this->db->join('master', 'master.master_id=regional_branches.id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_region_branch($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'id' => $masterid,
            'branch_id' => $postdata['branch_id'],
            'name' => $postdata['name'],
            'type' => $postdata['type'],
            );
        $this->db->insert('regional_branches', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_region_branch($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'name' => $postdata['name'],
             'type' => $postdata['type'],
            );
        $this->db->where('id',$postdata['id']);
        $this->db->update('regional_branches', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    
    
    
      function search_branch()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('branch');
        $this->db->join('master', 'master.master_id=branch.branch_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('branch_id', 'ASC');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_branch($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'branch_id' => $masterid,
            'branch_name' => $postdata['branch_name'],
             'branch_address' => $postdata['branch_address'],
            );
        $this->db->insert('branch', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_branch($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'branch_name' => $postdata['branch_name'],
             'branch_address' => $postdata['branch_address'],
            );
        $this->db->where('branch_id',$postdata['branch_id']);
        $this->db->update('branch', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

}