<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Salesmodel extends CI_Model
{

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }

    public function search_counter_sale()
    { 
        $data = array();
        $this->db->select('pos_sale.*,contact.contact_first_name');
        $this->db->from('pos_sale');
        $this->db->join('master', 'master.master_id=pos_sale.sale_id');
        $this->db->join('contact', 'contact.contact_id=pos_sale.customer_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('sale_type', 'in_direct');
        $this->db->order_by('pos_sale.sale_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_counter_sale($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $masterid = $this->mastermodel->insertmasterdata();
        $item_code=$this->mastermodel->get_ref('pos_delivery_note', 'pos_sale', 'sale_code', $postdata['sale_bill_category']);
        $tblValues = array(
            'sale_id' => $masterid,
            'sale_code' => $item_code,
            'date' => $this->mastermodel->convert_date_format($postdata['date']),
            'customer_id' => $postdata['customer_id'],
            'sale_order_id' => $postdata['sale_order_id'],
            'ref_no' => $postdata['ref_no'],
            'payment_terms' => $postdata['payment_terms'],
            'lpo_no' => $postdata['lpo_no'],
            'lpo_date' => $this->mastermodel->convert_date_format($postdata['lpo_date']),
            'prepared_by' => $postdata['prepared_by'],
            'issued_by' => $postdata['issued_by'],
            'vechile_no' => $postdata['vechile_no'],
            'driver_name' => $postdata['driver_name'],
            'verified_by' => $postdata['verified_by'],
            'sale_bill_category' => $postdata['sale_bill_category'],
            'note' => $postdata['note'],
            'sale_type' => 'in_direct',
            'total_amount' => $postdata['total_amount'],
            'discount' => $postdata['sale_discount'],
            'grand_total' => $postdata['grand_total'],
//            'order_details_grand_total' => $postdata['order_details_grand_total']
        );
        $this->db->insert('pos_sale', $tblValues);
        $i = 1;
        while (!empty($postdata['item_id_' . $i]))
        {
            $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($postdata['item_id_' . $i], $postdata['item_unit_id_' . $i], $postdata['lowest_unit_' . $i]);
            $stock_quantity = $postdata['item_qty_' . $i] * $stock_qty_multiplayer->unit_count;
      
            $this->db->set('quantity', 'quantity -' . $stock_quantity, false);
            $this->db->where('stock_id', $postdata['stock_id_' . $i]);
            $this->db->update('pos_item_stock');
            
            $detailsid = $this->mastermodel->insertmasterdata();
            $detlsValues = array(
                'details_id' => $detailsid,
                'sale_id' => $masterid,
                'sale_order_detailsId' =>$postdata['sale_order_detailsId_' . $i],
                'item_id' => $postdata['item_id_' . $i],
                'godown_id' => $postdata['godown_id_' . $i],
                'batch_no' => $postdata['batch_no_' . $i],
                'stock_id' => $postdata['stock_id_' . $i],
                'exp_date' => $this->mastermodel->convert_date_format($postdata['exp_date_' . $i]),
                'item_qty' => $postdata['item_qty_' . $i],
                'item_unit_id' => $postdata['item_unit_id_' . $i],
                'sale_price' => $postdata['sale_price_' . $i],
                'total' => $postdata['total_' . $i],
                'discount_type' => $postdata['is_percentage_' . $i],
                'discount_amount' => $postdata['discount_amount_' . $i],
                'sub_total' => $postdata['sub_total_' . $i],
                'tax_percentage' => $postdata['tax_percentage_' . $i],
                'tax_amount' => $postdata['tax_amount_' . $i],
                'total_amount' => $postdata['total_amount_' . $i],
                'account_conn_id' => $postdata['account_connection_' . $i]
            );
            $this->db->insert('pos_sale_details', $detlsValues);
            $output = $this->db->query("UPDATE pos_production_order_acceptance_details SET completed_qty = completed_qty + " . $postdata['item_qty_' . $i]. " WHERE details_id = " . $postdata['sale_order_detailsId_' . $i]);
            $stock_register_id = $this->mastermodel->insertmasterdata();
            $stockRegtbl = array(
                'stock_register_id' => $stock_register_id,
                'trans_id' => $masterid,
                'trans_details_id' => $detailsid,
                'trans_date' => $this->mastermodel->convert_date_format($postdata['date']),
                'qty' => $stock_quantity,
                'stock_type' => -1,
                'item_id' => $postdata['item_id_' . $i],
//                'bar_code' => $discount[$i],
                'batch_id' => $this->mastermodel->get_single_field_value('pos_item_stock','batch_id','stock_id',$postdata['stock_id_' . $i]),
                'expiry_date' => $postdata['exp_date_' . $i],
                'price' => $postdata['sale_price_' . $i],
                'trans_category' => 2,
                'godown_id' => $postdata['godown_id_' . $i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
            );
            $this->db->insert('pos_stock_register', $stockRegtbl);
            
            $i++;
        }
            
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    public function update_counter_sale($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $tblValues = array(
            'date' => $this->mastermodel->convert_date_format($postdata['date']),
            'payment_terms' => $postdata['payment_terms'],
            'lpo_no' => $postdata['lpo_no'],
            'lpo_date' => $this->mastermodel->convert_date_format($postdata['lpo_date']),
            'prepared_by' => $postdata['prepared_by'],
            'issued_by' => $postdata['issued_by'],
            'vechile_no' => $postdata['vechile_no'],
            'driver_name' => $postdata['driver_name'],
            'verified_by' => $postdata['verified_by'],
            'note' => $postdata['note'],
            'sale_type' => 'in_direct',
            'total_amount' => $postdata['total_amount'],
            'discount' => $postdata['sale_discount'],
            'grand_total' => $postdata['grand_total']
        );
        
        $this->db->where('sale_id', $postdata['sale_id']);
        $this->db->update('pos_sale', $tblValues);
        
//        delete function goes here
        $this->db->where('sale_id',$postdata['sale_id']);
        $this->db->delete('pos_sale_details');
        
        $this->db->where('trans_id', $postdata['sale_id']);
        $this->db->delete('pos_stock_register');
        $i = 1;
        while (!empty($postdata['item_id_' . $i]))
        {   
            $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($postdata['item_id_' . $i], $postdata['item_unit_id_' . $i], $postdata['lowest_unit_' . $i]);
            $new_quantity = $postdata['item_qty_' . $i] * $stock_qty_multiplayer->unit_count;
            $prev_quantity = $postdata['prev_qty_' . $i] * $stock_qty_multiplayer->unit_count;
            $stock_quantity = $prev_quantity - $new_quantity;
            
            $this->db->set('quantity', 'quantity +' . $stock_quantity, false);
            $this->db->where('stock_id', $postdata['stock_id_' . $i]);
            $this->db->update('pos_item_stock'); 
            $this->db->query("UPDATE pos_production_order_acceptance_details SET completed_qty = completed_qty -" . $stock_quantity. " WHERE details_id = " . $postdata['sale_order_detailsId_' . $i]);
        
            if(!empty($postdata['item_qty_' . $i]) && ($postdata['item_qty_' . $i] != 0) )
            {
            $detailsid = $this->mastermodel->insertmasterdata();
            $detlsValues = array(
                'details_id' => $detailsid,
                'sale_id' => $postdata['sale_id'],
                'sale_order_detailsId' =>$postdata['sale_order_detailsId_' . $i],
                'item_id' => $postdata['item_id_' . $i],
                'godown_id' => $postdata['godown_id_' . $i],
                'batch_no' => $postdata['batch_no_' . $i],
                'stock_id' => $postdata['stock_id_' . $i],
                'exp_date' => $postdata['exp_date_' . $i],
                'item_qty' => $postdata['item_qty_' . $i],
                'item_unit_id' => $postdata['item_unit_id_' . $i],
                'sale_price' => $postdata['sale_price_' . $i],
                'total' => $postdata['total_' . $i],
                'discount_type' => $postdata['is_percentage_' . $i],
                'discount_amount' => $postdata['discount_amount_' . $i],
                'sub_total' => $postdata['sub_total_' . $i],
                'tax_percentage' => $postdata['tax_percentage_' . $i],
                'tax_amount' => $postdata['tax_amount_' . $i],
                'total_amount' => $postdata['total_amount_' . $i],
                'account_conn_id' => $postdata['account_connection_' . $i]
            );
            $this->db->insert('pos_sale_details', $detlsValues); 
            
            $stock_register_id = $this->mastermodel->insertmasterdata();
            $stockRegtbl = array(
                'stock_register_id' => $stock_register_id,
                'trans_id' => $postdata['sale_id'],
                'trans_details_id' => $detailsid,
                'trans_date' => $this->mastermodel->convert_date_format($postdata['date']),
                'qty' => $stock_quantity,
                'stock_type' => -1,
                'item_id' => $postdata['item_id_' . $i],
//                'bar_code' => $discount[$i],
                'batch_id' => $this->mastermodel->get_single_field_value('pos_item_stock','batch_id','stock_id',$postdata['stock_id_' . $i]),
                'expiry_date' => $postdata['exp_date_' . $i],
                'price' => $postdata['sale_price_' . $i],
                'trans_category' => 2,
                'godown_id' => $postdata['godown_id_' . $i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
            );
            $this->db->insert('pos_stock_register', $stockRegtbl);
        }
            
            $i++;
        }
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    public function search_purchase_order_acceptance()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_production_order_acceptance');
//        $this->db->join('master', 'master.master_id=pos_item_master.product_id');
//        $this->db->where('master.project_id', $_SESSION['project_id']);
//        $this->db->where('pos_item_master.production', '1');
        $this->db->order_by('pos_production_order_acceptance.order_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_purchase_order_acceptance($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $masterid = $this->mastermodel->insertmasterdata();
        $item_code = $this->mastermodel->get_ref('order_code', 'pos_production_order_acceptance', 'order_code');
        $tblValues = array(
            'order_id' => $masterid,
            'order_code' => $item_code,
            'order_date' => $this->mastermodel->convert_date_format($postdata['order_date']),
            'order_customer_id' => $postdata['order_customer_id'],
            'order_contact_person' => $postdata['order_contact_person'],
            'order_contact_no' => $postdata['order_contact_no'],
            'order_ref_no' => $postdata['order_ref_no'],
            'order_ref_date' => $this->mastermodel->convert_date_format($postdata['order_ref_date']),
            'order_due_date' => $this->mastermodel->convert_date_format($postdata['order_due_date']),
            'order_payment_mode' => $postdata['order_payment_mode'],
            'order_terms_and_conditions' => $postdata['order_terms_and_conditions'],
            'order_acceptance_category_id' => $postdata['order_acceptance_category_id'],
            'order_note' => $postdata['order_note'],
            'order_show_in_goods_reciept' => $postdata['order_show_in_goods_reciept'],
            'order_details_total_amount' => $postdata['order_details_total_amount'],
            'order_details_total_discount' => $postdata['order_details_total_discount'],
            'order_details_grand_total' => $postdata['order_details_grand_total']
        );
        $this->db->insert('pos_production_order_acceptance', $tblValues);
        $i = 0;
        while (!empty($postdata['details_item_id' . ++$i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            if (isset($postdata['details_item_type' . $i]))
            {
                $type = 1;
            } else
            {
                $type = 0;
            }
            $Values = array(
                'details_id' => $contact,
                'details_item_id' => $postdata['details_item_id' . $i],
                'details_stock_id' => $postdata['details_stock_id' . $i],
                'details_workorder_id' => $masterid,
                'details_item_qty' => $postdata['details_item_qty' . $i],
                'details_item_unit_id' => $postdata['details_item_unit_id' . $i],
                'details_item_price' => $postdata['details_item_price' . $i],
                'details_item_total' => $postdata['details_item_total' . $i],
                'details_item_type' => $type,
                'details_item_discount_amount' => $postdata['details_item_discount_amount' . $i],
                'details_item_sub_total' => $postdata['details_item_sub_total' . $i],
                'details_item_tax_p' => $postdata['details_item_tax_p' . $i],
                'details_item_tax_amount' => $postdata['details_item_tax_amount' . $i],
                'details_item_total_amount' => $postdata['details_item_total_amount' . $i]
            );
            $this->db->insert('pos_production_order_acceptance_details', $Values);
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_purchase_order_acceptance($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $tblValues = array(
            'order_date' => $this->mastermodel->convert_date_format($postdata['order_date']),
            'order_customer_id' => $postdata['order_customer_id'],
            'order_contact_person' => $postdata['order_contact_person'],
            'order_contact_no' => $postdata['order_contact_no'],
            'order_ref_no' => $postdata['order_ref_no'],
            'order_ref_date' => $this->mastermodel->convert_date_format($postdata['order_ref_date']),
            'order_due_date' => $this->mastermodel->convert_date_format($postdata['order_due_date']),
            'order_payment_mode' => $postdata['order_payment_mode'],
            'order_terms_and_conditions' => $postdata['order_terms_and_conditions'],
//            'order_acceptance_category_id' => $postdata['order_acceptance_category_id'],
            'order_note' => $postdata['order_note'],
            'order_show_in_goods_reciept' => $postdata['order_show_in_goods_reciept'],
            'order_details_total_amount' => $postdata['order_details_total_amount'],
            'order_details_total_discount' => $postdata['order_details_total_discount'],
            'order_details_grand_total' => $postdata['order_details_grand_total']
        );
        $this->db->where('order_id', $postdata['order_id']);
        $this->db->update('pos_production_order_acceptance', $tblValues);
        $i = 0;
        $this->db->where('details_workorder_id', $postdata['order_id']);
        $this->db->delete('pos_production_order_acceptance_details');
        while (!empty($postdata['details_item_id' . ++$i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            if (isset($postdata['details_item_type' . $i]))
            {
                $type = 1;
            } else
            {
                $type = 0;
            }
            $Values = array(
                'details_id' => $contact,
                'details_item_id' => $postdata['details_item_id' . $i],
                'details_stock_id' => $postdata['details_stock_id' . $i],
                'details_workorder_id' => $postdata['order_id'],
                'details_item_qty' => $postdata['details_item_qty' . $i],
                'details_item_unit_id' => $postdata['details_item_unit_id' . $i],
                'details_item_price' => $postdata['details_item_price' . $i],
                'details_item_total' => $postdata['details_item_total' . $i],
                'details_item_type' => $type,
                'details_item_discount_amount' => $postdata['details_item_discount_amount' . $i],
                'details_item_sub_total' => $postdata['details_item_sub_total' . $i],
                'details_item_tax_p' => $postdata['details_item_tax_p' . $i],
                'details_item_tax_amount' => $postdata['details_item_tax_amount' . $i],
                'details_item_total_amount' => $postdata['details_item_total_amount' . $i]
            );
            $this->db->insert('pos_production_order_acceptance_details', $Values);
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function search_direct_sale()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_sale');
        $this->db->join('master', 'master.master_id=pos_sale.sale_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('sale_type', 'direct');
        $this->db->order_by('pos_sale.sale_id','desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_direct_sale($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $postdata['ref_no'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['date']),
        );
         $output = $this->db->insert('ledger_book', $tblValues);
        
        $masterid = $this->mastermodel->insertmasterdata();
        $item_code=$this->mastermodel->get_ref('pos_sale', 'pos_sale', 'sale_code', $postdata['sale_bill_category']);
        $tblValues = array(
            'sale_id' => $masterid,
            'sale_code' => $item_code,
            'date' => $this->mastermodel->convert_date_format($postdata['date']),
            'customer_id' => $postdata['customer_id'],
            'ref_no' => $postdata['ref_no'],
            'ledger_id'=>$ledger_id,
            'payment_mode' => $postdata['payment_mode'],
            'payment_terms' => $postdata['payment_terms'],
            'sale_bill_category' => $postdata['sale_bill_category'],
            'note' => $postdata['note'],
            'sale_type' => 'direct',
            'total_amount' => $postdata['total_amount'],
            'discount' => $postdata['sale_discount'],
            'grand_total' => $postdata['grand_total'],
//            'order_details_grand_total' => $postdata['order_details_grand_total']
        );
        $this->db->insert('pos_sale', $tblValues);
        
        
        
       
        if($postdata['payment_mode']=='Cash')
        {
            $cash_account=  $this->accountingmodel->get_account_settings('cash_account');
            $x = 1;
            $sum = $postdata['grand_total'];

            $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $cash_account,
            'debit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
        }
        else
            {
            $ret = $this->accountingmodel->get_accountmaster_id('contact', 'contact_id', 'ledger', $postdata['customer_id']);
            $ret_name = $this->mastermodel->get_single_field_value('contact', 'contact_first_name', 'contact_id', $postdata['customer_id']);

            $x = 1;
            $sum = $postdata['grand_total'];

            $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'debit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
           
            $cdet_id = $this->db->insert_id();
            //
            
         }
        $sale_disc = $this->accountingmodel->get_account_settings('sales_discounts');
         if ($postdata['discount'] != "0")
        {
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $sale_disc,
                'debit' => $postdata['discount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
        }
        $x=1;
        while (isset($postdata['product_master' . $x]))
        {
            if (isset($postdata['exp_date' . $x]))
            {
                $expiry_date[$x] = $this->mastermodel->convert_date_format($postdata['exp_date' . $x]);
            } else
            {
                $expiry_date[$x] = '0000-00-00';
            }

            if (isset($postdata['batch_no' . $x]))
            {
                $batch_no[$x] = $this->db->escape_str($postdata['batch_no' . $x]);
            }
            $batch_id[$x] = $this->db->escape_str($postdata['batch_id' . $x]);
            $stock_id[$x] = $this->db->escape_str($postdata['product_master' . $x]);
            $product_master[$x] = $this->db->escape_str($postdata['item_id' . $x]);
            $account_connection[$x] = $this->db->escape_str($postdata['account_connection' . $x]);
            $lowest_unit[$x] = $this->db->escape_str($postdata['lowest_unit' . $x]);
            $godown_id[$x] = $this->db->escape_str($postdata['godown_id' . $x]);
           
            $quantity[$x] = $this->db->escape_str($postdata['item_qty' . $x]);
            $unit[$x] = $this->db->escape_str($postdata['item_unit_id' . $x]);
            $sale_rate[$x] = $this->db->escape_str($postdata['item_price' . $x]);
            $is_percentage[$x] = $this->db->escape_str($postdata['discount_type' . $x]);
            $discount[$x] = $this->db->escape_str($postdata['discount_amount' . $x]);
            $percentage_tax[$x] = $this->db->escape_str($postdata['tax_percentage' . $x]);
            $tax_amount[$x] = $this->db->escape_str($postdata['tax_amount' . $x]);
            $total[$x]=$this->db->escape_str($postdata['total' . $x]);
            $sub_total[$x] = $this->db->escape_str($postdata['sub_total' . $x]);
            $total_amount[$x] = $this->db->escape_str($postdata['total_amount' . $x]);
            $x++;
        } 
        $discount_sum = 0;
        $i = 1;
         while ($x != 1)
        {
            $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($product_master[$i], $unit[$i], $lowest_unit[$i]);
            $stock_quantity = $quantity[$i] * $stock_qty_multiplayer->unit_count;
            $this->db->set('quantity', 'quantity -' . $stock_quantity, false);
            $this->db->where('stock_id', $stock_id[$i]);
            $this->db->update('pos_item_stock');
           
            $account_ledgers = $this->mastermodel->get_data_srow('pos_trading_acc_conn',$account_connection[$i],'trading_conn_id');
        
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->sale_acc,
                'credit' =>$sub_total[$i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->sale_tax_acc,
                'credit' => $tax_amount[$i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            
            $details_id = $this->mastermodel->insertmasterdata();
            $details_tbl=array(
                'details_id'=>$details_id,
                'sale_id'=>$masterid,
                'item_id'=>$product_master[$i],
                'account_conn_id'=>$account_connection[$i],
                'godown_id'=>$godown_id[$i],
                'batch_no'=>$batch_no[$i],
                'stock_id'=>$stock_id[$i],
                'exp_date'=>$exp_date[$i],
                'item_qty'=>$quantity[$i],
                'item_unit_id'=>$unit[$i],
                'sale_price'=>$sale_rate[$i],
                'total'=>$total[$i],
                'discount_type'=>$is_percentage[$i],
                'discount_amount'=>$discount[$i],
                'sub_total'=>$sub_total[$i],
                'tax_percentage'=>$percentage_tax[$i],
                'tax_amount'=>$tax_amount[$i],
                'total_amount'=>$total_amount[$i],
            );
            $output = $this->db->insert('pos_sale_details', $details_tbl);
             
            //stock register insert
            $stock_register_id = $this->mastermodel->insertmasterdata();
            $stockRegtbl = array(
                'stock_register_id' => $stock_register_id,
                'trans_id' => $masterid,
                'trans_details_id' => $details_id,
                'trans_date' => $this->mastermodel->convert_date_format($postdata['date']),
                'qty' => $quantity[$i],
                'stock_type' => -1,
                'item_id' => $product_master[$i],
//                'bar_code' => $discount[$i],
                'batch_id' => $batch_id[$i],
                'expiry_date' => $expiry_date[$i],
                'price' => $sale_rate[$i],
                'trans_category' => 2,
                'godown_id' => $godown_id[$i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
            );
            $this->db->insert('pos_stock_register', $stockRegtbl);
              $x--;
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['masterid'] = $masterid;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_direct_sale($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        
        
        $tblValues = array(
            'voucher_no' => $postdata['ref_no'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['date']),
        );
        $this->db->where('ledger_book_id',$postdata['ledger_id']);
        $output = $this->db->update('ledger_book', $tblValues);
        
        $ledger_id = $postdata['ledger_id'];
        $masterid = $postdata['sale_id'];
        
        $tblValues = array(
           
            'date' => $this->mastermodel->convert_date_format($postdata['date']),
            
            'ref_no' => $postdata['ref_no'],
            'payment_mode' => $postdata['payment_mode'],
            'payment_terms' => $postdata['payment_terms'],
            'note' => $postdata['note'],
            'total_amount' => $postdata['total_amount'],
            'discount' => $postdata['sale_discount'],
            'grand_total' => $postdata['grand_total'],
//            'order_details_grand_total' => $postdata['order_details_grand_total']
        );
        $this->db->where('sale_id',$postdata['sale_id']);
        $this->db->update('pos_sale', $tblValues);
        
        
        
        $this->db->where('ledger_book_id',$ledger_id);
        $output = $this->db->delete('ledger_book_details');
        
        if($postdata['payment_mode']=='Cash')
        {
            $cash_account=  $this->accountingmodel->get_account_settings('cash_account');
            $x = 1;
            $sum = $postdata['grand_total'];

            $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $cash_account,
            'debit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
        }
        else
            {
            
            $ret = $this->accountingmodel->get_accountmaster_id('contact', 'contact_id', 'ledger', $postdata['customer_id']);
            $ret_name = $this->mastermodel->get_single_field_value('contact', 'contact_first_name', 'contact_id', $postdata['customer_id']);

            $x = 1;
            $sum = $postdata['grand_total'];

            $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'debit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
           
            $cdet_id = $this->db->insert_id();
            //
            
         }
        $sale_disc = $this->accountingmodel->get_account_settings('sales_discounts');
         if ($postdata['discount'] != "0")
        {
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $sale_disc,
                'debit' => $postdata['discount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
        }
        
        while (isset($postdata['product_master' . $x]))
        {
            
            if (isset($postdata['exp_date' . $x]))
            {
                $expiry_date[$x] = $this->mastermodel->convert_date_format($postdata['exp_date' . $x]);
            } else
            {
                $expiry_date[$x] = '0000-00-00';
            }

            if (isset($postdata['batch_no' . $x]))
            {
                $batch_no[$x] = $this->db->escape_str($postdata['batch_no' . $x]);
            }
            $batch_id[$x] = $this->db->escape_str($postdata['batch_id' . $x]);
            $stock_id[$x] = $this->db->escape_str($postdata['product_master' . $x]);
            $product_master[$x] = $this->db->escape_str($postdata['item_id' . $x]);
            $account_connection[$x] = $this->db->escape_str($postdata['account_connection' . $x]);
            $lowest_unit[$x] = $this->db->escape_str($postdata['lowest_unit' . $x]);
            $godown_id[$x] = $this->db->escape_str($postdata['godown_id' . $x]);
           
            $quantity[$x] = $this->db->escape_str($postdata['item_qty' . $x]);
            $prev_quantity[$x] = $this->db->escape_str($postdata['prev_item_qty' . $x]);
            $unit[$x] = $this->db->escape_str($postdata['item_unit_id' . $x]);
            $sale_rate[$x] = $this->db->escape_str($postdata['item_price' . $x]);
            $is_percentage[$x] = $this->db->escape_str($postdata['discount_type' . $x]);
            $discount[$x] = $this->db->escape_str($postdata['discount_amount' . $x]);
            $percentage_tax[$x] = $this->db->escape_str($postdata['tax_percentage' . $x]);
            $tax_amount[$x] = $this->db->escape_str($postdata['tax_amount' . $x]);
            $total[$x]=$this->db->escape_str($postdata['total' . $x]);
            $sub_total[$x] = $this->db->escape_str($postdata['sub_total' . $x]);
            $total_amount[$x] = $this->db->escape_str($postdata['total_amount' . $x]);
            $x++;
        } 
        
        $discount_sum = 0;
        $i = 1;
        $this->db->where('sale_id',$masterid);
        $output = $this->db->delete('pos_sale_details');
        
        $this->db->where('trans_id',$masterid);
        $output = $this->db->delete('pos_stock_register');
         while ($x != 1)
        { 
            $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($product_master[$i], $unit[$i], $lowest_unit[$i]);
            
            $stock_quantity = $quantity[$i] * $stock_qty_multiplayer->unit_count;
            $new_quantity = $quantity[$i] * $stock_qty_multiplayer->unit_count;
            $prev_qty = $prev_quantity[$i]* $stock_qty_multiplayer->unit_count;
            $stock_quantity = $prev_qty - $new_quantity;
           
            $this->db->set('quantity', 'quantity +' . $stock_quantity, false);
            $this->db->where('stock_id', $stock_id[$i]);
            $this->db->update('pos_item_stock'); 
            
           
            if(!empty($quantity[$i]) && ($quantity[$i] != 0) ){
            $account_ledgers = $this->mastermodel->get_data_srow('pos_trading_acc_conn',$account_connection[$i],'trading_conn_id');
        
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->sale_acc,
                'credit' =>$sub_total[$i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->sale_tax_acc,
                'credit' => $tax_amount[$i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            
            $details_id = $this->mastermodel->insertmasterdata();
            $details_tbl=array(
                'details_id'=>$details_id,
                'sale_id'=>$masterid,
                'item_id'=>$product_master[$i],
                'account_conn_id'=>$account_connection[$i],
                'godown_id'=>$godown_id[$i],
                'batch_no'=>$batch_no[$i],
                'stock_id'=>$stock_id[$i],
                'exp_date'=>$exp_date[$i],
                'item_qty'=>$quantity[$i],
                'item_unit_id'=>$unit[$i],
                'sale_price'=>$sale_rate[$i],
                'total'=>$total[$i],
                'discount_type'=>$is_percentage[$i],
                'discount_amount'=>$discount[$i],
                'sub_total'=>$sub_total[$i],
                'tax_percentage'=>$percentage_tax[$i],
                'tax_amount'=>$tax_amount[$i],
                'total_amount'=>$total_amount[$i],
            );
            $output = $this->db->insert('pos_sale_details', $details_tbl);
             
            //stock register insert
            $stock_register_id = $this->mastermodel->insertmasterdata();
            $stockRegtbl = array(
                'stock_register_id' => $stock_register_id,
                'trans_id' => $masterid,
                'trans_details_id' => $details_id,
                'trans_date' => $this->mastermodel->convert_date_format($postdata['date']),
                'qty' => $quantity[$i],
                'stock_type' => -1,
                'item_id' => $product_master[$i],
//                'bar_code' => $discount[$i],
                'batch_id' => $batch_id[$i],
                'expiry_date' => $expiry_date[$i],
                'price' => $sale_rate[$i],
                'trans_category' => 2,
                'godown_id' => $godown_id[$i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
            );
            $this->db->insert('pos_stock_register', $stockRegtbl);
        }
              $x--;
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function get_customer_addr_id($id)
    {
        $this->db->select('contact.contact_official_location');
        $this->db->from('contact');
        $this->db->where('contact.contact_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    function get_unused_po_no_by_vendor($id)
    {

        $this->db->select('order_id,order_code');
        $this->db->from('pos_production_order_acceptance');
        $this->db->join('contact', 'contact.contact_id=pos_production_order_acceptance.order_customer_id');
        $this->db->join('pos_production_order_acceptance_details', 'pos_production_order_acceptance_details.details_workorder_id=pos_production_order_acceptance.order_id');
        $this->db->where('pos_production_order_acceptance.order_customer_id IN ( ' . $id . ')', null, true);
        $this->db->where('pos_production_order_acceptance.order_id in', '(SELECT  `pos_production_order_acceptance`.`order_id` 
                            FROM `pos_production_order_acceptance`
                            INNER JOIN `pos_production_order_acceptance_details` ON `pos_production_order_acceptance`.`order_id` = `pos_production_order_acceptance_details`.`details_workorder_id`
        
                            WHERE `completed_qty` < `details_item_qty`)', false);

//        $this->db->where('pos_po.po_manager_approval', 1);
//        $this->db->where('pos_po.po_gm_approval', 1);
        $this->db->group_by('pos_production_order_acceptance.order_id');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_sale_order_det($id)
    {
        $this->db->select('*');
        $this->db->from('pos_production_order_acceptance_details');
//        $this->db->join('master', 'master.master_id=pos_po_details.po_details_id');
//        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('details_workorder_id', $id);
        $this->db->order_by('details_id', 'asc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_saleOrder_purchased_quantity($id, $val)
    {

        $this->db->select('sum(completed_qty) as completed_qty');
        $this->db->from('pos_production_order_acceptance_details');

        $this->db->join('pos_production_order_acceptance', 'details_workorder_id=order_id', 'inner');
        $this->db->where('pos_production_order_acceptance_details.details_item_id', $val);
        $this->db->where('pos_production_order_acceptance.order_id', $id);

        $data = $this->db->get()->row()->completed_qty;

        return $data;
    }
    function get_customer_order($id)
    {   
        $this->db->select('order_id, order_code');
        $this->db->from('pos_production_order_acceptance');
        $this->db->where('pos_production_order_acceptance.order_customer_id', $id);
        $data = $this->db->get()->result();
        return $data;
    }
    function load_sale_no_by_po($id)
    {   
        $this->db->select('sale_id,sale_code,grand_total,discount,lpo_no');
        $this->db->from('pos_sale');
        $this->db->where('pos_sale.sale_order_id', $id);
        $this->db->where('pos_sale.invoice', 1);
        $data = $this->db->get()->result();
        return $data;
    }
    function load_sale_details_by_purchase_id($postdata)
    {   
        $this->db->select('details_item_id,details_item_qty,completed_qty');
        $this->db->from('pos_production_order_acceptance');
        $this->db->where('pos_production_order_acceptance.order_id', $postdata['sale_order_id']);
        $this->db->join('pos_production_order_acceptance_details', 'pos_production_order_acceptance.order_id=pos_production_order_acceptance_details.details_workorder_id');
        $data = $this->db->get()->result();
        
        return $data;
    }
    public function search_customer_invoice()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_customer_invoice');
        $this->db->join('master', 'master.master_id=pos_customer_invoice.customer_invoice_id');
//        $this->db->join('contact', 'contact.contact_id=pos_sale.customer_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
//        $this->db->where('sale_type', 'in_direct');
        $this->db->order_by('pos_customer_invoice.customer_invoice_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_customer_invoice($postdata)
    {
        $this->db->trans_begin();
        $invoice_no=$this->mastermodel->get_ref('customer_invoice_no', 'pos_customer_invoice', 'customer_invoice_no');
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $invoice_no,
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['customer_invoice_date']),
        );
        $output = $this->db->insert('ledger_book', $tblValues);
        
        
        

        $disc = $this->accountingmodel->get_account_settings('sales_discounts');
         
           $discount = $postdata['total_discount'];

        if ($discount != '0')
        {
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $disc,
                'debit' => $discount,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
        }
        
            if($postdata['payment_mode']=='Cash')
        {
                
                 $cash_account=  $this->accountingmodel->get_account_settings('cash_account');
            $x = 1;
            $sum = $postdata['amount'];

            $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $cash_account,
            'debit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
                
                
                
                
          
        }
        else
            {
            $ret = $this->accountingmodel->get_accountmaster_id('contact', 'contact_id', 'ledger', $postdata['customer']);
            $ret_name = $this->mastermodel->get_single_field_value('contact', 'contact_first_name', 'contact_id', $postdata['customer']);

            $x = 1;
            $sum = $postdata['amount'];

            $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'debit' => $sum ,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
         }
        
        
     


        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'customer_invoice_id' => $masterid,
            'customer_invoice_no' => $invoice_no,
            'customer_invoice_ref_no' => $postdata['customer_invoice_ref_no'],
            'customer_invoice_date' => $this->mastermodel->convert_date_format($postdata['customer_invoice_date']),
            'customer' => $postdata['customer'],
            'sale_order_id' => $postdata['sale_order_id'],
            'amount' => $postdata['amount'],
            'customer_invoice_discount' => $postdata['total_discount'],
         
            'generated_by' => $postdata['generated_by'],
            'customer_invoice_remarks' => $postdata['customer_invoice_remarks'],
            'invoice_ledger' => $ledger_id,
            
             'payment_mode' => $postdata['payment_mode'],
            'payment_terms' => $postdata['payment_terms'],
            'cheque_no' => $postdata['cheque_no'],
            'cheque_date' => $this->mastermodel->convert_date_format($postdata['cheque_date']),
              'ref_date' => $this->mastermodel->convert_date_format($postdata['ref_date']),
             'exchange_rate' => $postdata['exchange_rate'],
            
            
        );
        $output = $this->db->insert('pos_customer_invoice', $tblValues);

        $tblValues = array(
            'invoice_reference_id' => $masterid,
            'invoice_no' => $invoice_no,
            'reference_no' => $postdata['customer_invoice_ref_no'],
            'customer' => $postdata['customer'],
            'invoice_date' => $this->mastermodel->convert_date_format($postdata['customer_invoice_date']),
            'amount' => $postdata['amount'],
            'discount' => $discount,
            'payable_amount' => $postdata['amount'],
        );
        $output = $this->db->insert('pos_customer_invoice_bills', $tblValues);


        $i = 1;
        while (isset($postdata['sale_' . $i]))
        {
            if ($postdata['sale_' . $i] != '')
            {


                $tblValues = array(
                    'invoiced' => 1,
                );
                $this->db->where('sale_id', $postdata['sale_' . $i]);
                $output = $this->db->update('pos_sale', $tblValues);
                
                
                $purchase_detailes = $this->mastermodel->select_data_by_id('pos_sale_details','sale_id',$postdata['sale_' . $i]);
               foreach($purchase_detailes as $purchase_detailes){ 
                $account_ledgers = $this->mastermodel->get_data_srow('pos_trading_acc_conn',$purchase_detailes->account_conn_id,'trading_conn_id');
                $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->sale_acc,
                'credit' =>$purchase_detailes->sub_total,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
             $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->sale_tax_acc,
                'credit' => $purchase_detailes->tax_amount,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
                  } 
                $tblValues = array(
                    'customer_invoice' => $masterid,
                    'sale_id' => $postdata['sale_' . $i],
                    'total_amount' => $postdata['total_' . $i],
                );
                $output = $this->db->insert('pos_customer_invoice_details', $tblValues);
                $i++;
            }
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }
    function load_sale_bills($type){       
        $data = array();
        $this->db->select('sale_id, sale_code, date');
        $this->db->from('pos_sale');
        $this->db->where('pos_sale.sale_type', $type);
        $this->db->order_by('pos_sale.sale_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
    function load_sale_customer_dtls($postdata){       
        $data = array();
        $this->db->select('contact.contact_id, contact.contact_first_name, contact.contact_official_location,pos_sale.payment_mode');
        $this->db->from('contact');
        $this->db->join('pos_sale','pos_sale.customer_id = contact.contact_id');
        $this->db->where('pos_sale.sale_id', $postdata['id']);
        $data = $this->db->get()->row();
        return $data;
    }
    public function search_direct_sale_return(){
        $data = array();
        $this->db->select('pos_sale_return.*,contact.contact_first_name');
        $this->db->from('pos_sale_return');
        $this->db->join('contact','contact.contact_id=pos_sale_return.customer_id','right');
        $this->db->where('pos_sale_return.sale_type', 'direct');
        $this->db->order_by('pos_sale_return_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_direct_sale_return($postdata){
         
        $data = array();
        $this->db->trans_begin();
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $postdata['note'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['date']),
        );
         $output = $this->db->insert('ledger_book', $tblValues);
        
        $masterid = $this->mastermodel->insertmasterdata();
        $item_code=$this->mastermodel->get_ref('pos_sale_return', 'pos_sale_return', 'sale_return_code', $postdata['sale_bill_category']);
        $tblValues = array(
            'pos_sale_return_id' => $masterid,
            'sale_return_code' => $item_code,
            'date' => $this->mastermodel->convert_date_format($postdata['date']),
            'customer_id' => $postdata['customer_id'],
            'sale_id ' => $postdata['sale_id'],
            'sale_bill_category' => $postdata['sale_bill_category'],
            'note' => $postdata['note'],
            'sale_type' => 'direct',
            'total_amount' => $postdata['total_amount'],
            'discount' => $postdata['discount'],
            'grand_total' => $postdata['grand_total'],
            'ledger_id' =>$ledger_id,
            'payment_mode'=> $postdata['payment_mode']
//            'order_details_grand_total' => $postdata['order_details_grand_total']
        );
        $this->db->insert('pos_sale_return', $tblValues);
        
        //assumed payment mode as cash
        if($postdata['payment_mode']=='Cash'){
        $cash_account = $this->accountingmodel->get_account_settings('cash_account');
        $x = 1;
        $sum = $postdata['grand_total'];

        $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $cash_account,
            'credit' => $sum,
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $cdet_id = $this->db->insert_id();
        }
        else
            {
            $ret = $this->accountingmodel->get_accountmaster_id('contact', 'contact_id', 'ledger', $postdata['customer_id']);
            $ret_name = $this->mastermodel->get_single_field_value('contact', 'contact_first_name', 'contact_id', $postdata['customer_id']);

            $x = 1;
            $sum = $postdata['grand_total'];

            $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'credit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
           
            $cdet_id = $this->db->insert_id();
            //
            
         }
        
        $i = 1;
        while (!empty($postdata['item_id_' . $i]))
        {
            

            $this->db->set('quantity', 'quantity +' . $postdata['item_qty_' . $i], false);
            $this->db->where('stock_id', $postdata['stock_id_' . $i]);
            $this->db->update('pos_item_stock');
            
            $account_ledgers = $this->mastermodel->get_data_srow('pos_trading_acc_conn',$postdata['account_connection_' . $i],'trading_conn_id');
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->sale_return_acc,
                'debit' =>$postdata['sub_total_' . $i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->sale_tax_return,
                'debit' => $postdata['tax_amount_' . $i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            
            $detailsid = $this->mastermodel->insertmasterdata();
            $detlsValues = array(
                'details_id' => $detailsid,
                'sale_return_id' => $masterid,
                'sale_return_detailsId' =>$postdata['sale_return_detailsId_' . $i],
                'item_id' => $postdata['item_id_' . $i],
                'godown_id' => $postdata['godown_id_' . $i],
                'batch_no' => $postdata['batch_no_' . $i],
                'stock_id' => $postdata['stock_id_' . $i],
                'account_conn_id'=>$postdata['account_connection_' . $i],
                'exp_date' => $this->mastermodel->convert_date_format($postdata['exp_date_' . $i]),
                'item_qty' => $postdata['item_qty_' . $i],
                'item_unit_id' => $postdata['item_unit_id_' . $i],
                'sale_price' => $postdata['sale_price_' . $i],
                'total' => $postdata['total_' . $i],
                'discount_type' => $postdata['discount_type_' . $i],
                'discount_amount' => $postdata['discount_amount_' . $i],
                'sub_total' => $postdata['sub_total_' . $i],
                'tax_percentage' => $postdata['tax_percentage_' . $i],
                'tax_amount' => $postdata['tax_amount_' . $i],
                'total_amount' => $postdata['total_amount_' . $i],
            );
            $this->db->insert('pos_sale_return_details', $detlsValues);
           
            $stock_register_id = $this->mastermodel->insertmasterdata();
            $stockRegtbl = array(
                'stock_register_id' => $stock_register_id,
                'trans_id' => $masterid,
                'trans_details_id' => $detailsid,
                'trans_date' => $this->mastermodel->convert_date_format($postdata['date']),
                'qty' => $postdata['item_qty_' . $i],
                'stock_type' => -1,
                'item_id' => $postdata['item_id_' . $i],
//                'bar_code' => $discount[$i],
                'batch_id' => $postdata['batch_id_' . $i],
                'expiry_date' => $postdata['exp_date_' . $i],
                'price' => $postdata['sale_price_' . $i],
                'trans_category' => 4,
                'godown_id' => $postdata['godown_id_' . $i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
            );
            $this->db->insert('pos_stock_register', $stockRegtbl);
            
            $i++;
        }
            
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     public function update_direct_sale_return($postdata){
         
        $data = array();
        $this->db->trans_begin();
        $ledger_id = $postdata['ledger_book_id'];
        $tblValues = array(
            'voucher_no' => $postdata['note'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['date']),
        );
        $this->db->where('ledger_book_id',$postdata['ledger_book_id']);
        $output = $this->db->update('ledger_book', $tblValues);
        
        $masterid = $postdata['pos_sale_return_id'];
        $tblValues = array(
            'date' => $this->mastermodel->convert_date_format($postdata['date']),
//            'customer_id' => $postdata['customer_id'],
            'note' => $postdata['note'],
            'total_amount' => $postdata['total_amount'],
            'discount' => $postdata['discount'],
            'grand_total' => $postdata['grand_total'],
//            'order_details_grand_total' => $postdata['order_details_grand_total']
        );
        $this->db->where('pos_sale_return_id',$masterid);
        $this->db->update('pos_sale_return', $tblValues);
        
        $this->db->where('ledger_book_id',$ledger_id);
        $this->db->delete('ledger_book_details');
        
        $this->db->where('sale_return_id',$masterid);
        $this->db->delete('pos_sale_return_details');
        
        $this->db->where('trans_id',$masterid);
        $this->db->delete('pos_stock_register');
        //assumed payment mode as cash
         if($postdata['payment_mode']=='Cash'){
        $cash_account = $this->accountingmodel->get_account_settings('cash_account');
        $x = 1;
        $sum = $postdata['grand_total'];

        $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $cash_account,
            'credit' => $sum,
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $cdet_id = $this->db->insert_id();
        }
         else
            {
            $ret = $this->accountingmodel->get_accountmaster_id('contact', 'contact_id', 'ledger', $postdata['customer_id']);
            $ret_name = $this->mastermodel->get_single_field_value('contact', 'contact_first_name', 'contact_id', $postdata['customer_id']);

            $x = 1;
            $sum = $postdata['grand_total'];

            $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'debit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
           
            $cdet_id = $this->db->insert_id();
            //
            
         }
        $i = 1;
        while (!empty($postdata['item_id_' . $i]))
        {
            $prev_qty=$postdata['pre_item_qty_' . $i];
            $curr_qty=$postdata['item_qty_' . $i];
            $new_qty=$prev_qty-$curr_qty;
            
//            var_dump($new_qty);var_dump($postdata['item_qty_' . $i]);die();
            $this->db->set('quantity', 'quantity -' . $new_qty, false);
            $this->db->where('stock_id', $postdata['stock_id_' . $i]);
            $this->db->update('pos_item_stock');
            
            
            if($postdata['item_qty_' . $i] > 0){
            $account_ledgers = $this->mastermodel->get_data_srow('pos_trading_acc_conn',$postdata['account_connection_' . $i],'trading_conn_id');
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->sale_return_acc,
                'debit' =>$postdata['sub_total_' . $i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->sale_tax_return,
                'debit' => $postdata['tax_amount_' . $i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            
            $detailsid = $this->mastermodel->insertmasterdata();
            $detlsValues = array(
                'details_id' => $detailsid,
                'sale_return_id' => $masterid,
                'sale_return_detailsId' =>$postdata['sale_return_detailsId_' . $i],
                'item_id' => $postdata['item_id_' . $i],
                'godown_id' => $postdata['godown_id_' . $i],
                'batch_no' => $postdata['batch_no_' . $i],
                'stock_id' => $postdata['stock_id_' . $i],
                'account_conn_id'=>$postdata['account_connection_' . $i],
                'exp_date' => $this->mastermodel->convert_date_format($postdata['exp_date_' . $i]),
                'item_qty' => $postdata['item_qty_' . $i],
                'item_unit_id' => $postdata['item_unit_id_' . $i],
                'sale_price' => $postdata['sale_price_' . $i],
                'total' => $postdata['total_' . $i],
                'discount_type' => $postdata['discount_type_' . $i],
                'discount_amount' => $postdata['discount_amount_' . $i],
                'sub_total' => $postdata['sub_total_' . $i],
                'tax_percentage' => $postdata['tax_percentage_' . $i],
                'tax_amount' => $postdata['tax_amount_' . $i],
                'total_amount' => $postdata['total_amount_' . $i],
            );
            $this->db->insert('pos_sale_return_details', $detlsValues);
           
            $stock_register_id = $this->mastermodel->insertmasterdata();
            $stockRegtbl = array(
                'stock_register_id' => $stock_register_id,
                'trans_id' => $masterid,
                'trans_details_id' => $detailsid,
                'trans_date' => $this->mastermodel->convert_date_format($postdata['date']),
                'qty' => $postdata['item_qty_' . $i],
                'stock_type' => -1,
                'item_id' => $postdata['item_id_' . $i],
//                'bar_code' => $discount[$i],
                'batch_id' => $postdata['batch_id_' . $i],
                'expiry_date' => $postdata['exp_date_' . $i],
                'price' => $postdata['sale_price_' . $i],
                'trans_category' => 4,
                'godown_id' => $postdata['godown_id_' . $i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
            );
            $this->db->insert('pos_stock_register', $stockRegtbl);
        }
            $i++;
            
        }
            
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function get_sale_details_byid($id)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_sale');
        $this->db->where('pos_sale.sale_id', $id);
        $this->db->join('pos_sale_details', 'pos_sale_details.sale_id=pos_sale.sale_id');
        $data = $this->db->get()->result(); 
        return $data;
    }
}
