<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Propertymodel extends CI_Model {

    function __construct() {
        // Call the Model constructor
        parent::__construct();
    }
    
    
     
    function search_item_category()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('item_category');
        $this->db->join('master', 'master.master_id=item_category.item_category_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('item_category_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_item_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'item_category_id' => $masterid,
            'item_category_name' => $postdata['prop_item_category_name'],
            );
        $this->db->insert('item_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_item_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'item_category_name' => $postdata['prop_item_category_name'],
            );
        $this->db->where('item_category_id',$postdata['prop_item_category_id']);
        $this->db->update('item_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_item()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('item_master');
        $this->db->join('master', 'master.master_id=item_master.item_master_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('item_master_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function insert_item($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       // $prop_item_code = $this->mastermodel->get_ref('item_master_code', 'item_master', 'item_master_code');
       if(isset($postdata['prop_item_master_account'])){
    $prop_item_master_account = $postdata['prop_item_master_account'];
}   
else{
    $prop_item_master_account = NULL;
}
        $tblValues = array(
            'item_master_id' => $masterid,
            'item_master_code' => $postdata['prop_item_code'],
            'item_master_category_id' => $postdata['prop_item_category'],
            'item_master_name' => $postdata['prop_item_name'],
            'item_master_unit_id' => $postdata['prop_item_unit'],
            'item_parchasing_rate' => $postdata['prop_item_parchasing_rate'],
             'item_master_account' => $prop_item_master_account,
            );
        $this->db->insert('item_master', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_item($postdata)
    { 
        $data = array();
        $this->db->trans_begin();
   if(isset($postdata['prop_item_master_account'])){
    $prop_item_master_account = $postdata['prop_item_master_account'];
}   
else{
    $prop_item_master_account = NULL;
}
         $tblValues = array(
            'item_master_category_id' => $postdata['prop_item_category'],
            'item_master_name' => $postdata['prop_item_name'],
            'item_master_unit_id' => $postdata['item_unit'],
            'item_parchasing_rate' => $postdata['prop_item_parchasing_rate'],
                'item_master_account' => $prop_item_master_account,
            );
        $this->db->where('item_master_id',$postdata['prop_item_id']);
        $this->db->update('item_master', $tblValues);
      
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_main_category()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('main_category');
        $this->db->join('master', 'master.master_id=main_category.main_category_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('main_category_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_main_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'main_category_id' => $masterid,
            'main_category_name' => $postdata['main_category_name'],
            );
        $this->db->insert('main_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_main_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
      
       
        $tblValues = array(
            'main_category_name' => $postdata['main_category_name'],
            );
        $this->db->where('main_category_id',$postdata['main_category_id']);
        $this->db->update('main_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_sub_category()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('sub_category');
         $this->db->join('master', 'master.master_id=sub_category.sub_category_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('sub_category_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_sub_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'sub_category_id' => $masterid,
            'sub_category_name' => $postdata['sub_category_name'],
            'main_category_id' => $postdata['main_category_id'],
            'property_type' => $postdata['property_type'],
            );
        $this->db->insert('sub_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_sub_category($postdata)
    { 
        $data = array();
        $this->db->trans_begin();
       
       
        $tblValues = array(
            'sub_category_name' => $postdata['sub_category_name'],
            'main_category_id' => $postdata['main_category_id']
            );
        $this->db->where('sub_category_id',$postdata['sub_category_id']);
        $this->db->update('sub_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_label()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('label');
         $this->db->join('master', 'master.master_id=label.label_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('label_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_label($postdata)
    {   
        $data = array();
        $this->db->trans_begin();
       
        $i=1;

              while(isset($postdata['label_name'. $i]))
            {

              $label_id= $this->mastermodel->insertmasterdata();
                 $addtblValues = array(

                      'label_id'=>$label_id,
                     'label_name'=>$postdata['label_name'.$i],
                     'sub_category_id'=>$postdata['sub_category_id'],
                     'html_entity'=>$postdata['html_entities_id'.$i],
                     );
                  $this->db->insert('label', $addtblValues);
              $i++;
            }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_label($postdata)
    {  
        $data = array();
        $this->db->trans_begin();
        
        $tblValues = array(
            'label_name'=>$postdata['label_name1'],
            'html_entity'=>$postdata['html_entities_id1'],
            );
         $this->db->where('label_id',$postdata['label_id']);
         $this->db->update('label', $tblValues);
            
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function get_sub_details($main_id)
    {
        $this->db->select('*');
        $this->db->from('sub_category');
        $this->db->join('master', 'master.master_id=sub_category.sub_category_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('main_category_id',$main_id);
        
        $data = $this->db->get()->result();
        return $data;
    }
    
    
    function search_item_unit()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('unit');
        $this->db->join('master', 'master.master_id=unit.unit_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('unit_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_item_unit($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'unit_id' => $masterid,
            'unit_name' => $postdata['prop_item_unit_name'],
            );
        $this->db->insert('unit', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_item_unit($postdata)
    { 
        $data = array();
        $this->db->trans_begin();
      
       
        $tblValues = array(
            'unit_name' => $postdata['prop_item_unit_name']
            );
        $this->db->where('unit_id',$postdata['prop_item_unit_id']);
        $this->db->update('unit', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_label_support($pagenum)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('label_support');
          $this->db->join('master', 'master.master_id=label_support.label_support_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->join('label', 'label.label_id = label_support.label_id');
        $this->db->order_by('label_support_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_label_support($postdata)
    {   
        $data = array();
        $this->db->trans_begin();
       for($j=0;$j < count($postdata['label_id']);$j++){
        $i=1;
        
        while(isset($postdata[$postdata['label_id'][$j].'label_support_value'. $i]))
        {
             
          $label_support_id= $this->mastermodel->insertmasterdata();
             $addtblValues = array(
               
                  'label_support_id'=>$label_support_id,
                 'label_support_value'=>$postdata[$postdata['label_id'][$j].'label_support_value'. $i],
                 'label_id'=>$postdata['label_id'][$j],
                 );
              $this->db->insert('label_support', $addtblValues);
          
          $i++;
        }
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      function update_label_support($postdata) {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'label_support_value'=>$postdata['label_support_value'],
        );
        
        $this->db->where('label_support_id', $postdata['label_support_id']);
        $this->db->update('label_support', $tblValues);
        $data['resfunction'] = 'search_property_type';
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated successfully';
            return $data;
        }
    }
     function get_label_support_saved($id)
    {
        $this->db->select('*');
        $this->db->from('label');
        $this->db->join('html_entities', 'html_entities.html_entities_id = label.html_entity');
        $this->db->join('master', 'master.master_id=label.label_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('label.sub_category_id',$id);
        $this->db->where('html_entities.support','1');
        $this->db->order_by('label_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
    function  get_label_support($id)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('label_support');
        $this->db->join('master', 'master.master_id=label_support.label_support_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $this->db->where('label_support.label_id',$id);
           $this->db->order_by('label_support_id', 'desc');
        $data = $this->db->get()->result();
         return $data;
    }
    
    
    function search_godown()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('godown');
        $this->db->join('master', 'master.master_id=godown.godown_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('godown_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_godown($postdata)
    {  
        $data = array();
        $this->db->trans_begin();
         $i=1;
         $master_godown_id = $this->mastermodel->insertmasterdata();
        $godownValues = array(
            'godown_id' => $master_godown_id,
            'godown_name' => $postdata['prop_godown_name'],
            );
        $this->db->insert('godown', $godownValues);

    while(isset($postdata['prop_godown_rack_name'. $i]))
    {
        $master_rack_id = $this->mastermodel->insertmasterdata();
        $rackValues = array(
            'godown_rack_id' => $master_rack_id,
            'godown_rack_godown_id' => $master_godown_id,
            'godown_rack_name' => $postdata['prop_godown_rack_name' . $i   ]
            );
        $this->db->insert('godown_rack', $rackValues);
        $i++;
    }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }    
    }
     public function update_godown($postdata)
    {  
        $data = array();
        $this->db->trans_begin();
        $i=1;
        $godownValues = array(
            'godown_name' => $postdata['prop_godown_name']
            );
        $this->db->where('godown_id', $postdata['prop_godown_id']);
        $this->db->update('godown', $godownValues);
    
            
        $this->db->where('godown_rack_godown_id', $postdata['prop_godown_id']);
        $this->db->delete('godown_rack');
        
        
        while(isset($postdata['prop_godown_rack_name'. $i]))
        {
        $master_rack_id = $this->mastermodel->insertmasterdata();
        $rackValues = array(
            'godown_rack_id' => $master_rack_id,
            'godown_rack_godown_id' => $postdata['prop_godown_id'],
            'godown_rack_name' => $postdata['prop_godown_rack_name' . $i]
            );
        $this->db->insert('godown_rack', $rackValues);
        $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
      function get_label_saved($id)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('label');
        $this->db->join('html_entities', 'html_entities.html_entities_id = label.html_entity');
        $this->db->join('master', 'master.master_id=label.label_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('label.sub_category_id',$id);
        $this->db->order_by('label_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
    function search_vendor()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('vendor');
         $this->db->join('master', 'master.master_id=vendor.vendor_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('vendor_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_vendor($postdata)
    { 
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        
        $vendor_code = $this->mastermodel->get_ref('vendor_code', 'vendor', 'vendor_code');
        
        $set = $this->accountingmodel->get_account_settings('vendor');
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_id' => $ledger_id,
            'account_group_id' => $set,
            'ledger_name' => $postdata['prop_vendor_name'],
            'mailing_name' => $postdata['prop_vendor_name'],
            'address' => $postdata['prop_vendor_address'],
            'phone' => $postdata['prop_vendor_contact_no'],
            'email' => $postdata['prop_vendor_email'],
        );
        $output = $this->db->insert('account_ledger', $tblValues);
        
        $tblValues = array(
            'vendor_id' => $masterid,
            'vendor_code' => $vendor_code,
            'vendor_name' => $postdata['prop_vendor_name'],
            'vendor_email' => $postdata['prop_vendor_email'],
            'vendor_mobile' => $postdata['prop_vendor_contact_no'],
            'vendor_address' => $postdata['prop_vendor_address'],
//            'vendor_account' => $postdata['prop_vendor_account'],
            'vendor_ledger' => $ledger_id
            );
        $this->db->insert('vendor', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_vendor($postdata)
    { 
        $data = array();
        $this->db->trans_begin();
        
        $set = $this->accountingmodel->get_account_settings('vendor');
        $tblValues = array(
            'account_group_id' => $set,
            'ledger_name' => $postdata['prop_vendor_name'],
            'mailing_name' => $postdata['prop_vendor_name'],
            'address' => $postdata['prop_vendor_address'],
            'phone' => $postdata['prop_vendor_contact_no'],
            'email' => $postdata['prop_vendor_email'],
        );
        $this->db->where('ledger_id', $postdata['ledger_id']);
        $output = $this->db->update('account_ledger', $tblValues);
        
        $tblValues = array(
            'vendor_name' => $postdata['prop_vendor_name'],
            'vendor_email' => $postdata['prop_vendor_email'],
            'vendor_mobile' => $postdata['prop_vendor_contact_no'],
            'vendor_address' => $postdata['prop_vendor_address'],
            'vendor_account' =>$postdata['prop_vendor_account']
            );
        $this->db->where('vendor_id',$postdata['prop_vendor_id']);
        $this->db->update('vendor', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_purchase_category()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_purchase_category');
        $this->db->join('master', 'master.master_id=prop_purchase_category.prop_purchase_category_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_purchase_category_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_purchase_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'prop_purchase_category_id	' => $masterid,
            'prop_purchase_category_name' => $postdata['prop_purchase_category_name'],
            'prop_purchase_category_godown_id' => $postdata['prop_purchase_category_godown_id'],
//            'prop_purchase_category_account' => $postdata['prop_purchase_category_account'],
//            'prop_purchase_category_stock' => $postdata['prop_purchase_category_stock']
            );
        $this->db->insert('prop_purchase_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_purchase_category($postdata)
    { 
        $data = array();
        $this->db->trans_begin();
      
         $tblValues = array(
            'prop_purchase_category_name' => $postdata['prop_purchase_category_name'],
            'prop_purchase_category_godown_id' => $postdata['prop_purchase_category_godown_id'],
//            'prop_purchase_category_account' => $postdata['prop_purchase_category_account'],
//             'prop_purchase_category_stock' => $postdata['prop_purchase_category_stock']
            );
        $this->db->where('prop_purchase_category_id',$postdata['prop_purchase_category_id']);
        $this->db->update('prop_purchase_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    
    function search_item_tras_cat()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_item_tras_cat');
        $this->db->join('master', 'master.master_id=prop_item_tras_cat.prop_item_tras_cat_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_item_tras_cat_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_item_tras_cat($postdata)
    {   
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'prop_item_tras_cat_id	' => $masterid,
            'prop_item_tras_cat_name' => $postdata['prop_item_tras_cat_name'],
            'prop_item_tras_cat_godown_id' => $postdata['prop_item_tras_cat_godown_id'],
//            'prop_item_tras_cat_account' => $postdata['prop_item_tras_cat_account'],
//            'prop_item_tras_cat_stock' => $postdata['prop_item_tras_cat_stock']
            );
        $this->db->insert('prop_item_tras_cat', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_item_tras_cat($postdata)
    {    
        $data = array();
        $this->db->trans_begin();
   
       
         $tblValues = array(
            'prop_item_tras_cat_name' => $postdata['prop_item_tras_cat_name'],
            'prop_item_tras_cat_godown_id' => $postdata['prop_item_tras_cat_godown_id'],
//            'prop_item_tras_cat_account' => $postdata['prop_item_tras_cat_account'],
//             'prop_item_tras_cat_stock' => $postdata['prop_item_tras_cat_stock']
            );
        $this->db->where('prop_item_tras_cat_id',$postdata['prop_item_tras_cat_id']);
        $this->db->update('prop_item_tras_cat', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_purchase_item()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_purchase_item');
        $this->db->join('master', 'master.master_id=prop_purchase_item.prop_purchase_item_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_purchase_item_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     function get_search_stockmaster($item_id,$godown_id,$price) {
        $this->db->select('prop_item_stock_id,prop_item_stock_qty');
        $this->db->from('prop_item_stock');
        $this->db->join('master', 'master.master_id=prop_item_stock.prop_item_stock_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
      
        $this->db->where('prop_godown_id', $godown_id);
          $this->db->where('prop_item_id', $item_id);
           $this->db->where('price', $price);
       
        $data = $this->db->get()->row();
        
        return $data;
    }
    public function insert_purchase_item($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $postdata['prop_purchase_item_ref_no'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['prop_purchase_item_date']),
        );
        $output = $this->db->insert('ledger_book', $tblValues);
        
        $main_masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_purchase_item_id' => $main_masterid,
            'prop_purchase_item_date' => $this->mastermodel->convert_date_format($postdata['prop_purchase_item_date']),
            'prop_purchase_item_category_id' => $postdata['prop_purchase_item_category_id'],
            'prop_purchase_item_addition_description' => $postdata['prop_purchase_item_addition_description'],
            'prop_purchase_item_vendor_id' => $postdata['prop_purchase_item_vendor_id'],
            'prop_purchase_item_ref_no' => $postdata['prop_purchase_item_ref_no'],
            'prop_purchase_item_ref_date' => $this->mastermodel->convert_date_format($postdata['prop_purchase_item_ref_date']),
            'prop_purchase_item_remarks' => $postdata['prop_purchase_item_remarks'],
            'prop_purchase_item_godown_id' => $postdata['prop_purchase_item_godown_id'],
            'prop_purchase_item_total' => $postdata['prop_purchase_item_total'],
            'prop_purchase_item_discount' => $postdata['prop_purchase_item_discount'],
            'prop_purchase_item_addition' => $postdata['prop_purchase_item_addition'],
            'prop_purchase_item_grant_total' => $postdata['prop_purchase_item_grant_total'],
              'po_ledger' => $ledger_id,
            'prop_purchase_payment_type' =>$postdata['prop_purchase_payment_type']
            ); 
        $this->db->insert('prop_purchase_item', $tblValues);
        
        if($postdata['prop_purchase_payment_type']=='Credit')
        {
           
        $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['prop_purchase_item_vendor_id']);
        $ret_name = $this->mastermodel->get_single_field_value('vendor', 'vendor_name', 'vendor_id', $postdata['prop_purchase_item_vendor_id']);
        
        $x = 1;
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'credit' => $postdata['prop_purchase_item_grant_total'] - $postdata['invoice_discount'],

        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
        }
        else{
            $cash_account=  $this->accountingmodel->get_account_settings('cash_account');
            $x = 1;
            $tblValues_led = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $cash_account,
                'credit' =>  $postdata['prop_purchase_item_grant_total'] - $postdata['invoice_discount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
         }
        $disc = $this->accountingmodel->get_account_settings('purchase_discounts');
        $i=1;
        while(isset($postdata['prop_sub_purchase_item_stock'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
           
            
            //stock_ading start
            
            
              $stock_master = $this->propertymodel->get_search_stockmaster($postdata['prop_sub_purchase_item_item_id' . $i],$postdata['prop_purchase_item_godown_id'],$postdata['prop_sub_purchase_item_price'. $i]);
  $prop_item_stock_id = 0;

        if (!empty($stock_master))
        {

            $prop_item_stock_id = $stock_master->prop_item_stock_id;
            
        }
            //First Insert Item into stock table.
        if($prop_item_stock_id==0)
        {
             $stock_id = $this->mastermodel->insertmasterdata();
            $addtblValues = array(
                'prop_item_stock_id'=>$stock_id,
                'prop_item_id' => $postdata['prop_sub_purchase_item_item_id' . $i],
                'prop_godown_id' => $postdata['prop_purchase_item_godown_id'],
                'prop_item_stock_qty' => $postdata['prop_sub_purchase_item_qty' . $i],
                'price' => $postdata['prop_sub_purchase_item_price' . $i],
                'discount' => $postdata['prop_sub_purchase_item_discount_amount' . $i],
                'total' => $postdata['prop_sub_purchase_item_qty' . $i] * $postdata['prop_sub_purchase_item_price' . $i],
               'stock_date' =>$this->mastermodel->convert_date_format($postdata['prop_purchase_item_date'])
            );
            $check =$this->db->insert('prop_item_stock', $addtblValues);
         
          
        }
 else {
       $stock_quantity= $stock_master->prop_item_stock_qty;
       $updated_qty=$stock_quantity+$postdata['prop_sub_purchase_item_qty' . $i];
     $addtblValues = array(
               
                'prop_item_stock_qty' => $updated_qty,
                'price' => $postdata['prop_sub_purchase_item_price' . $i],
                'discount' => $postdata['prop_sub_purchase_item_discount_amount' . $i],
                'total' => $postdata['prop_sub_purchase_item_price' . $i] * $updated_qty,
          'stock_date' =>$this->mastermodel->convert_date_format($postdata['prop_purchase_item_date'])
          
             
            );
     $this->db->where('prop_item_stock_id', $prop_item_stock_id);
        $output = $this->db->update('prop_item_stock', $addtblValues); 
          $stock_id =$prop_item_stock_id;
 }
            
          $tblValues = array(
            'prop_sub_purchase_item_id	' => $sub_masterid,
            'prop_sub_purchase_item_item_id	' =>$postdata['prop_sub_purchase_item_item_id'. $i] ,
            'prop_sub_purchase_item_stock' => $postdata['prop_sub_purchase_item_stock'. $i],
            'prop_sub_purchase_item_rack_id' => $postdata['prop_sub_purchase_item_rack_id'. $i],
            'prop_sub_purchase_item_make' => $postdata['prop_sub_purchase_item_make'. $i],
            'prop_sub_purchase_item_serial_no' => $postdata['prop_sub_purchase_item_serial_no'. $i],
            'prop_sub_purchase_item_qty' => $postdata['prop_sub_purchase_item_qty'. $i],
            'prop_sub_purchase_item_price' => $postdata['prop_sub_purchase_item_price'. $i],
            'prop_sub_purchase_item_discount_amount' => $postdata['prop_sub_purchase_item_discount_amount'. $i],
            'prop_sub_purchase_item_tax_amount' => $postdata['prop_sub_purchase_item_tax_amount'. $i],
            'prop_sub_purchase_item_total_amount' => $postdata['prop_sub_purchase_item_total_amount'. $i],
            'prop_sub_purchase_item_purchase_item_id' =>$main_masterid ,
              'stock_id'=>$stock_id
        );
            $this->db->insert('prop_sub_purchase_item', $tblValues);   
            //stock adding end
            
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $postdata['ledger_id_'.$i],
                'debit' => $postdata['prop_sub_purchase_item_total_amount'.$i],

            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            
            $det_id = $this->db->insert_id();
            $credit = 0;
            $debit = $postdata['prop_sub_purchase_item_total_amount'.$i];

            $tblValues = array(
                'ledger_book_details' => $det_id,
//                'ref_ledger' => $costcentre[$i],
                'ref_amount' => $postdata['prop_sub_purchase_item_total_amount'.$i],
                'credit' => $credit,
                'debit' => $debit,
            );
            $output = $this->db->insert('ledger_book_reference', $tblValues);
            
            $i++;
        }
        if ($postdata['invoice_discount'] != "0")
        {
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $disc,
                'credit' => $postdata['invoice_discount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_purchase_item($postdata)
    {   
        $data = array();
        $this->db->trans_begin();
     
         $tblValues = array(
            'voucher_no' => $postdata['prop_purchase_item_ref_no'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['prop_purchase_item_date']),
        );
        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $output = $this->db->update('ledger_book', $tblValues);
         $mainValues = array(
            'prop_purchase_item_date' => $this->mastermodel->convert_date_format($postdata['prop_purchase_item_date']),
            'prop_purchase_item_category_id' => $postdata['prop_purchase_item_category_id'],
            'prop_purchase_item_vendor_id' => $postdata['prop_purchase_item_vendor_id'],
            'prop_purchase_item_addition_description' => $postdata['prop_purchase_item_addition_description'],
            'prop_purchase_item_ref_no' => $postdata['prop_purchase_item_ref_no'],
            'prop_purchase_item_ref_date' => $this->mastermodel->convert_date_format($postdata['prop_purchase_item_ref_date']),
            'prop_purchase_item_remarks' => $postdata['prop_purchase_item_remarks'],
            'prop_purchase_item_godown_id' => $postdata['prop_purchase_item_godown_id'],
            'prop_purchase_item_total' => $postdata['prop_purchase_item_total'],
            'prop_purchase_item_discount' => $postdata['prop_purchase_item_discount'],
            'prop_purchase_item_addition' => $postdata['prop_purchase_item_addition'],
            'prop_purchase_item_grant_total' => $postdata['prop_purchase_item_grant_total']
            );
        $this->db->where('prop_purchase_item_id',$postdata['prop_purchase_item_id']);
        $this->db->update('prop_purchase_item', $mainValues);
        
        
        
         $masterid = $postdata['prop_purchase_item_id'];
        $ledger_id = $postdata['ledger_book_id'];
        $pid = $this->db->query("select ledger_book_details_id from ledger_book_details where ledger_book_id='$ledger_id'order by ledger_book_details_id desc");
        $result = $pid->result();
        if (!empty($result))
        {
            foreach ($result as $value)
            {
                $pdetid = $value->ledger_book_details_id;
                $this->db->where('ledger_book_reference.ledger_book_details', $pdetid);
                $output = $this->db->delete('ledger_book_reference');
            }
        }

        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $this->db->delete('ledger_book_details');
        
        if($postdata['prop_purchase_payment_type']=='Credit')
        {
           
         $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['prop_purchase_item_vendor_id']);
        $ret_name = $this->mastermodel->get_single_field_value('vendor', 'vendor_name', 'vendor_id', $postdata['prop_purchase_item_vendor_id']);
        
        
         $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'credit' => $postdata['prop_purchase_item_grant_total'] - $postdata['invoice_discount'],
//             'debit' => $postdata['po_amount']+$discount_sum,
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
          $cdet_id = $this->db->insert_id();
        
        }
        else{
            $cash_account=  $this->accountingmodel->get_account_settings('cash_account');
            $x = 1;
            $tblValues_led = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $cash_account,
                'credit' => $postdata['prop_purchase_item_grant_total'] - $postdata['invoice_discount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
         }
        
        
        
        
        
        
        
        
        $this->db->where('prop_sub_purchase_item_purchase_item_id',$postdata['prop_purchase_item_id']);
        $this->db->delete('prop_sub_purchase_item');
        $i=1;
        while(isset($postdata['prop_sub_purchase_item_item_id'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
           if(!empty($postdata['previus_qty' . $i])){
            $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['previus_qty' . $i], false)
                        ->set('total',  'prop_item_stock_qty * price' ,false);
                $this->db->where('prop_item_stock_id', $postdata['stock_id'.$i]);
                $this->db->update('prop_item_stock');
           }
            
            
            
            $stock_master = $this->propertymodel->get_search_stockmaster($postdata['prop_sub_purchase_item_item_id' . $i],$postdata['prop_purchase_item_godown_id'],$postdata['prop_sub_purchase_item_price'. $i]);
  $prop_item_stock_id = 0;

        if (!empty($stock_master))
        {

            $prop_item_stock_id = $stock_master->prop_item_stock_id;
            
        }
            //First Insert Item into stock table.
        if($prop_item_stock_id==0)
        {
             $stock_id = $this->mastermodel->insertmasterdata();
            $addtblValues = array(
                'prop_item_stock_id'=>$stock_id,
                'prop_item_id' => $postdata['prop_sub_purchase_item_item_id' . $i],
                'prop_godown_id' => $postdata['prop_purchase_item_godown_id'],
                'prop_item_stock_qty' => $postdata['prop_sub_purchase_item_qty' . $i],
                'price' => $postdata['prop_sub_purchase_item_price' . $i],
                'discount' => $postdata['prop_sub_purchase_item_discount_amount' . $i],
                'total' => $postdata['prop_sub_purchase_item_qty' . $i] * $postdata['prop_sub_purchase_item_price' . $i],
               'stock_date' =>$this->mastermodel->convert_date_format($postdata['prop_purchase_item_date'])
            );
            $check =$this->db->insert('prop_item_stock', $addtblValues);
       
          
        }
 else {
       $stock_quantity= $stock_master->prop_item_stock_qty;
       $updated_qty=$stock_quantity+$postdata['prop_sub_purchase_item_qty' . $i];
     $addtblValues = array(
               
                'prop_item_stock_qty' => $updated_qty,
                'price' => $postdata['prop_sub_purchase_item_price' . $i],
                'discount' => $postdata['prop_sub_purchase_item_discount_amount' . $i],
                'total' => $postdata['prop_sub_purchase_item_price' . $i] * $updated_qty,
          'stock_date' =>$this->mastermodel->convert_date_format($postdata['prop_purchase_item_date'])
          
             
            );
     $this->db->where('prop_item_stock_id', $prop_item_stock_id);
        $output = $this->db->update('prop_item_stock', $addtblValues); 
          $stock_id =$prop_item_stock_id;
 }
       
        
         $tblValues = array(
            'prop_sub_purchase_item_id	' => $sub_masterid,
             'prop_sub_purchase_item_item_id	' =>$postdata['prop_sub_purchase_item_item_id'. $i] ,
            'prop_sub_purchase_item_stock' => $postdata['prop_sub_purchase_item_stock'. $i],
            'prop_sub_purchase_item_rack_id' => $postdata['prop_sub_purchase_item_rack_id'. $i],
            'prop_sub_purchase_item_make' => $postdata['prop_sub_purchase_item_make'. $i],
            'prop_sub_purchase_item_serial_no' => $postdata['prop_sub_purchase_item_serial_no'. $i],
            'prop_sub_purchase_item_qty' => $postdata['prop_sub_purchase_item_qty'. $i],
            'prop_sub_purchase_item_price' => $postdata['prop_sub_purchase_item_price'. $i],
            'prop_sub_purchase_item_discount_amount' => $postdata['prop_sub_purchase_item_discount_amount'. $i],
            'prop_sub_purchase_item_tax_amount' => $postdata['prop_sub_purchase_item_tax_amount'. $i],
            'prop_sub_purchase_item_total_amount' => $postdata['prop_sub_purchase_item_total_amount'. $i],
             'prop_sub_purchase_item_purchase_item_id' =>$postdata['prop_purchase_item_id'] ,
             'stock_id'=>$stock_id
        );
            $this->db->insert('prop_sub_purchase_item', $tblValues);
             $tblValues = array(
                    'ledger_book_id' => $ledger_id,
                    'account_ledger_id' => $postdata['ledger_id' . $i],
                    'debit' => $postdata['prop_sub_purchase_item_total_amount' . $i],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues);
                $det_id = $this->db->insert_id();
                $credit = 0;
                $debit = $postdata['prop_sub_purchase_item_total_amount' . $i];

                $tblValues = array(
                    'ledger_book_details' => $det_id,
//                    'ref_ledger' => $postdata['q_costcentre_' . $x],
                    'ref_amount' => $postdata['prop_sub_purchase_item_total_amount' . $i],
                    'credit' => $credit,
                    'debit' => $debit,
                );
                $output = $this->db->insert('ledger_book_reference', $tblValues);
                $discount_sum = $discount_sum + $postdata['prop_sub_purchase_item_discount_amount' . $i];

            $i++;
        }
         if ($postdata['invoice_discount'] != "0")
        {
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $disc,
                'credit' => $postdata['invoice_discount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    
    function search_item_transfer()
    { 
        $data = array();
        $this->db->select('*,t2.godown_name as prop_godown_name_to,t1.godown_name as prop_godown_name_from');
        $this->db->from('prop_item_transfer');
        $this->db->join('master', 'master.master_id=prop_item_transfer.prop_item_transfer_id');

        $this->db->join('user', 'user.user_id = prop_item_transfer.prop_item_transfer_incharge');
        $this->db->join('prop_item_tras_cat', 'prop_item_tras_cat.prop_item_tras_cat_id = prop_item_transfer.prop_item_transfer_category');
        $this->db->join('godown t1', 't1.godown_id = prop_item_transfer.prop_item_transfer_from_godown_id');
        $this->db->join('godown t2', 't2.godown_id = prop_item_transfer.prop_item_transfer_to_godown_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('prop_item_transfer_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_item_transfer($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $main_masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_item_transfer_id' => $main_masterid,
            'prop_item_transfer_category' => $postdata['prop_item_transfer_category'],
            'prop_item_transfer_date' => $this->mastermodel->convert_date_format($postdata['prop_item_transfer_date']),
            'prop_item_transfer_incharge' => $postdata['prop_item_transfer_incharge'],
            'prop_item_transfer_remarks' => $postdata['prop_item_transfer_remarks'],
            'prop_item_transfer_from_godown_id' => $postdata['prop_item_transfer_from_godown_id'],
            'prop_item_transfer_to_godown_id' => $postdata['prop_item_transfer_to_godown_id'],
            'prop_item_transfer_total' => $postdata['prop_item_transfer_total']
            );
        $this->db->insert('prop_item_transfer', $tblValues);
        $i=1;
        while(isset($postdata['prop_sub_item_transfer_item_id'. $i]))
        { 
             $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['prop_sub_item_transfer_item_id'. $i],'prop_item_stock_id');
      
           
            
            
            //stock add
            
              $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['prop_sub_item_transfer_qty' . $i], false);
            $this->db->where('prop_item_stock_id', $postdata['prop_sub_item_transfer_item_id' . $i]);
            $this->db->update('prop_item_stock');

            $this->db->select('*');
            $this->db->from('prop_item_stock');
            $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
              $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['prop_item_transfer_to_godown_id']);

            $count = $this->db->count_all_results();
            if ($count > 0) {

                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['prop_sub_item_transfer_qty' . $i], false);
                $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['prop_item_transfer_date']));
             $this->db->set('total', 'prop_item_stock_qty * price', false);
             
                $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
              $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['prop_item_transfer_to_godown_id']);
                $this->db->update('prop_item_stock');
                $stock_master = $this->propertymodel->get_search_stockmaster($stock_detailes->prop_item_id,$postdata['prop_item_transfer_to_godown_id'],$stock_detailes->price);


        if (!empty($stock_master))
        {

            $prop_item_stock_id = $stock_master->prop_item_stock_id;
            
        }
            } 
            else {
                
                $prop_item_stock_id = $this->mastermodel->insertmasterdata();
                $addtblValues = array(
                    'prop_item_stock_id'=>$prop_item_stock_id,
                'prop_item_id' => $stock_detailes->prop_item_id,
                     'price' => $stock_detailes->price,
                       'total' => $stock_detailes->price * $postdata['prop_sub_item_transfer_qty' . $i],
                'prop_godown_id' => $postdata['prop_item_transfer_to_godown_id'],
                'prop_item_stock_qty' => $postdata['prop_sub_item_transfer_qty' . $i],
               'stock_date' => $this->mastermodel->convert_date_format($postdata['prop_item_transfer_date'])
            );
            $this->db->insert('prop_item_stock', $addtblValues);
//            $prop_item_stock_id =  $this->db->insert_id();
            }
             $sub_masterid = $this->mastermodel->insertmasterdata();
            $sub_tblValues = array(
            'prop_sub_item_transfer_id' => $sub_masterid,
            'prop_sub_item_transfer_item_transfer_id' => $main_masterid,
            'prop_sub_item_transfer_item_id' => $stock_detailes->prop_item_id,
            'prop_sub_item_transfer_from_godown_stock' => $postdata['prop_sub_item_transfer_from_godown_stock'. $i],
            'prop_sub_item_transfer_to_godown_stock' => $postdata['prop_sub_item_transfer_to_godown_stock'. $i],
            'prop_sub_item_transfer_make' => $postdata['prop_sub_item_transfer_make'. $i],
            'prop_sub_item_transfer_serial_no' => $postdata['prop_sub_item_transfer_serial_no'.$i],
            'prop_sub_item_transfer_qty' => $postdata['prop_sub_item_transfer_qty'. $i],
            'prop_sub_item_transfer_price' => $postdata['prop_sub_item_transfer_price'. $i],
            'prop_sub_item_transfer_amount' => $postdata['prop_sub_item_transfer_amount'. $i],
                'stock_id' =>$prop_item_stock_id
        );
            $this->db->insert('prop_sub_item_transfer', $sub_tblValues);
            
            //stock end
            
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_item_transfer($postdata)
    {   
        $data = array();
        $this->db->trans_begin();
      
         $mainValues = array(
            'prop_item_transfer_category' => $postdata['prop_item_transfer_category'],
            'prop_item_transfer_date' => $this->mastermodel->convert_date_format($postdata['prop_item_transfer_date']),
            'prop_item_transfer_remarks' => $postdata['prop_item_transfer_remarks'],
            'prop_item_transfer_from_godown_id' => $postdata['prop_item_transfer_from_godown_id'],
            'prop_item_transfer_to_godown_id' => $postdata['prop_item_transfer_to_godown_id'],
            'prop_item_transfer_total' => $postdata['prop_item_transfer_total']
            );
        $this->db->where('prop_item_transfer_id',$postdata['prop_item_transfer_id']);
        $this->db->update('prop_item_transfer', $mainValues);
        
        $this->db->where('prop_sub_item_transfer_item_transfer_id',$postdata['prop_item_transfer_id']);
        $this->db->delete('prop_sub_item_transfer');
        $i=1;
        while(isset($postdata['prop_sub_item_transfer_item_id'. $i]))
        { 
                $stock_detailes_prev = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['prop_sub_item_transfer_item_id'. $i],'prop_item_stock_id');
      
             $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['previus_qty'. $i], false);
                $this->db->where('prop_item_id', $stock_detailes_prev->prop_item_id);
              $this->db->where('price', $stock_detailes_prev->price);
                $this->db->where('prop_godown_id', $postdata['prop_item_transfer_from_godown_id']);
                $this->db->update('prop_item_stock');
                
                 $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['previus_qty'. $i], false);
                $this->db->where('prop_item_stock_id', $postdata['stock_id' . $i]);
                $this->db->update('prop_item_stock');
            
            
             $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['prop_sub_item_transfer_item_id'. $i],'prop_item_stock_id');
      
           
            
            
            //stock add
            
              $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['prop_sub_item_transfer_qty' . $i], false);
            $this->db->where('prop_item_stock_id', $postdata['prop_sub_item_transfer_item_id' . $i]);
            $this->db->update('prop_item_stock');

            $this->db->select('*');
            $this->db->from('prop_item_stock');
            $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
              $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['prop_item_transfer_to_godown_id']);

            $count = $this->db->count_all_results();
            if ($count > 0) {

                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['prop_sub_item_transfer_qty' . $i], false);
                $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['prop_item_transfer_date']));
             $this->db->set('total', 'prop_item_stock_qty * price', false);
             
                $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
              $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['prop_item_transfer_to_godown_id']);
                $this->db->update('prop_item_stock');
                $stock_master = $this->propertymodel->get_search_stockmaster($stock_detailes->prop_item_id,$postdata['prop_item_transfer_to_godown_id'],$stock_detailes->price);


        if (!empty($stock_master))
        {

            $prop_item_stock_id = $stock_master->prop_item_stock_id;
            
        }
            } 
            else {
                
                 $prop_item_stock_id = $this->mastermodel->insertmasterdata();
                $addtblValues = array(
                       'prop_item_stock_id'=>$prop_item_stock_id,
                'prop_item_id' => $stock_detailes->prop_item_id,
                     'price' => $stock_detailes->price,
                       'total' => $stock_detailes->price * $postdata['prop_sub_item_transfer_qty' . $i],
                'prop_godown_id' => $postdata['prop_item_transfer_to_godown_id'],
                'prop_item_stock_qty' => $postdata['prop_sub_item_transfer_qty' . $i],
               'stock_date' => $this->mastermodel->convert_date_format($postdata['prop_item_transfer_date'])
            );
            $this->db->insert('prop_item_stock', $addtblValues);
//            $prop_item_stock_id =  $this->db->insert_id();
            }
            
            
            
            
            
            
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
           'prop_sub_item_transfer_id' => $sub_masterid,
            'prop_sub_item_transfer_item_transfer_id' => $postdata['prop_item_transfer_id'],
            'prop_sub_item_transfer_item_id' =>  $stock_detailes->prop_item_id,
            'prop_sub_item_transfer_from_godown_stock' => $postdata['prop_sub_item_transfer_from_godown_stock'. $i],
            'prop_sub_item_transfer_to_godown_stock' => $postdata['prop_sub_item_transfer_to_godown_stock'. $i],
            'prop_sub_item_transfer_make' => $postdata['prop_sub_item_transfer_make'. $i],
            'prop_sub_item_transfer_serial_no' => $postdata['prop_sub_item_transfer_serial_no'. $i],
            'prop_sub_item_transfer_qty' => $postdata['prop_sub_item_transfer_qty'. $i],
            'prop_sub_item_transfer_price' => $postdata['prop_sub_item_transfer_price'. $i],
            'prop_sub_item_transfer_amount' => $postdata['prop_sub_item_transfer_amount'. $i],
                'stock_id' => $prop_item_stock_id
        );
            $this->db->insert('prop_sub_item_transfer', $tblValues);
//             if(isset($postdata['previus_qty'. $i]) && !empty($postdata['previus_qty'. $i]))
//            {
//                $real_quntity=0;
//               
//                if($postdata['previus_qty'. $i] < $postdata['prop_sub_item_transfer_qty'. $i])
//                {
//                   $real_quntity= $postdata['prop_sub_item_transfer_qty'. $i]-$postdata['previus_qty'. $i];
//                    $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $real_quntity, false);
//                $this->db->where('prop_item_id', $postdata['prop_sub_item_transfer_item_id' . $i]);
//                $this->db->where('prop_godown_id', $postdata['prop_item_transfer_to_godown_id']);
//                $this->db->update('prop_item_stock');
//                
//                 $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $real_quntity, false);
//                $this->db->where('prop_item_id', $postdata['prop_sub_item_transfer_item_id' . $i]);
//                $this->db->where('prop_godown_id', $postdata['prop_item_transfer_from_godown_id']);
//                $this->db->update('prop_item_stock');
//                
//               
//                
//                }
//            elseif($postdata['previus_qty'. $i] > $postdata['prop_sub_item_transfer_qty'. $i]) {
//                 $real_quntity= $postdata['previus_qty'. $i]-$postdata['prop_sub_item_transfer_qty'. $i];
//                  $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $real_quntity, false);
//                 $this->db->where('prop_item_id', $postdata['prop_sub_item_transfer_item_id' . $i]);
//                $this->db->where('prop_godown_id', $postdata['prop_item_transfer_to_godown_id']);
//                $this->db->update('prop_item_stock');
//                 
//                 $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $real_quntity, false);
//                $this->db->where('prop_item_id', $postdata['prop_sub_item_transfer_item_id' . $i]);
//                $this->db->where('prop_godown_id', $postdata['prop_item_transfer_from_godown_id']);
//                $this->db->update('prop_item_stock');
//
//            }
//            }
//        else {
//  
//              $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['prop_sub_item_transfer_qty' . $i], false);
//            $this->db->where('prop_item_id', $postdata['prop_sub_item_transfer_item_id' . $i]);
//            $this->db->where('prop_godown_id', $postdata['prop_item_transfer_from_godown_id']);
//            $this->db->update('prop_item_stock');
//
//            $this->db->select('*');
//            $this->db->from('prop_item_stock');
//            $this->db->where('prop_item_id', $postdata['prop_sub_item_transfer_item_id' . $i]);
//            $this->db->where('prop_godown_id', $postdata['prop_item_transfer_to_godown_id']);
//
//            $count = $this->db->count_all_results();
//            if ($count > 0) {
//
//                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['prop_sub_item_transfer_qty' . $i], false);
//                $this->db->where('prop_item_id', $postdata['prop_sub_item_transfer_item_id' . $i]);
//                $this->db->where('prop_godown_id', $postdata['prop_item_transfer_to_godown_id']);
//                $this->db->update('prop_item_stock');
//            } else {
//                
//                
//                $addtblValues = array(
//                'prop_item_id' => $postdata['prop_sub_item_transfer_item_id' . $i],
//                'prop_godown_id' => $postdata['prop_item_transfer_to_godown_id'],
//                'prop_item_stock_qty' => $postdata['prop_sub_item_transfer_qty' . $i],
//               
//            );
//            $this->db->insert('prop_item_stock', $addtblValues);
//            }
//            
//        }
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    
    
    function search_item_return()
    { 
        $data = array();
        $this->db->select('*,t2.godown_name as godown_name_to,t1.godown_name as prop_godown_name_from');
        $this->db->from('prop_item_return');
        $this->db->join('master', 'master.master_id=prop_item_return.prop_item_return_id');

        $this->db->join('user', 'user.user_id = prop_item_return.prop_item_return_incharge');
        $this->db->join('prop_item_return_cat', 'prop_item_return_cat.prop_item_return_cat_id = prop_item_return.prop_item_return_cat');
        $this->db->join('godown t1', 't1.godown_id = prop_item_return.prop_item_return_from_godown_id');
        $this->db->join('godown t2', 't2.godown_id = prop_item_return.prop_item_return_to_godown_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('prop_item_return_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_item_return($postdata)
    {        
        $data = array();
        $this->db->trans_begin();
        $main_masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_item_return_id' => $main_masterid,    
            'prop_item_return_date' => $this->mastermodel->convert_date_format($postdata['prop_item_return_date']),
            'prop_item_return_cat' => $postdata['prop_item_return_cat'],
            'prop_item_return_incharge' => $postdata['prop_item_return_incharge'],
            'prop_item_return_remarks' => $postdata['prop_item_return_remarks'],
            'prop_item_return_from_godown_id' => $postdata['prop_item_return_from_godown_id'],
            'prop_item_return_to_godown_id' => $postdata['prop_item_return_to_godown_id'],
            'prop_item_return_total' => $postdata['prop_item_return_total']
            );
        $this->db->insert('prop_item_return', $tblValues);
        $i=1;
        while(isset($postdata['prop_sub_item_return_amount'. $i]))
        {
            $sub_masterid = $this->mastermodel->insertmasterdata();
           
             
             $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['prop_sub_item_return_item_id'. $i],'prop_item_stock_id');
      
           
            
            
            //stock add
            
              $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['prop_sub_item_return_qty' . $i], false);
            $this->db->where('prop_item_stock_id', $postdata['prop_sub_item_return_item_id' . $i]);
            $this->db->update('prop_item_stock');

            $this->db->select('*');
            $this->db->from('prop_item_stock');
            $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
              $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['prop_item_return_to_godown_id']);

            $count = $this->db->count_all_results();
            if ($count > 0) {

                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['prop_sub_item_return_qty' . $i], false);
                $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['prop_item_return_date']));
             $this->db->set('total', 'prop_item_stock_qty * price', false);
             
                $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
              $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['prop_item_return_to_godown_id']);
                $this->db->update('prop_item_stock');
                $stock_master = $this->propertymodel->get_search_stockmaster($stock_detailes->prop_item_id,$postdata['prop_item_return_to_godown_id'],$stock_detailes->price);


        if (!empty($stock_master))
        {

            $prop_item_stock_id = $stock_master->prop_item_stock_id;
            
        }
            } 
            else {
                
                  $prop_item_stock_id = $this->mastermodel->insertmasterdata();
                    
                $addtblValues = array(
                       'prop_item_stock_id'=>$prop_item_stock_id,
                'prop_item_id' => $stock_detailes->prop_item_id,
                     'price' => $stock_detailes->price,
                       'total' => $stock_detailes->price * $postdata['prop_sub_item_return_qty' . $i],
                'prop_godown_id' => $postdata['prop_item_return_to_godown_id'],
                'prop_item_stock_qty' => $postdata['prop_sub_item_return_qty' . $i],
               'stock_date' => $this->mastermodel->convert_date_format($postdata['prop_item_return_date'])
            );
            $this->db->insert('prop_item_stock', $addtblValues);
//            $prop_item_stock_id =  $this->db->insert_id();
            }
            
             $sub_tblValues = array(
            'prop_sub_item_return_id' => $sub_masterid,
            'prop_item_return_item_return_id' => $main_masterid,
            'prop_sub_item_return_item_id' => $stock_detailes->prop_item_id,
            'prop_sub_item_return_from_godown_stock' => $postdata['prop_sub_item_return_from_godown_stock'. $i],
            'prop_sub_item_return_to_godown_stock' => $postdata['prop_sub_item_return_to_godown_stock'. $i],
            'prop_sub_item_returnm_make' => $postdata['prop_sub_item_returnm_make'. $i],
            'prop_sub_item_return_serial_no' => $postdata['prop_sub_item_return_serial_no'. $i],
            'prop_sub_item_return_qty' => $postdata['prop_sub_item_return_qty'. $i],
            'prop_sub_item_return_price' => $postdata['prop_sub_item_return_price'. $i],
            'prop_sub_item_return_amount' => $postdata['prop_sub_item_return_amount'. $i],
                 'stock_id' => $prop_item_stock_id
        );
            $this->db->insert('prop_sub_item_return', $sub_tblValues);
            
            //stock add
            
//              $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['prop_sub_item_return_qty' . $i], false);
//            $this->db->where('prop_item_id', $postdata['prop_sub_item_return_item_id' . $i]);
//            $this->db->where('prop_godown_id', $postdata['prop_item_return_from_godown_id']);
//            $this->db->update('prop_item_stock');
//
//            $this->db->select('*');
//            $this->db->from('prop_item_stock');
//            $this->db->where('prop_item_id', $postdata['prop_sub_item_return_item_id' . $i]);
//            $this->db->where('prop_godown_id', $postdata['prop_item_return_to_godown_id']);
//
//            $count = $this->db->count_all_results();
//            if ($count > 0) {
//
//                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['prop_sub_item_return_qty' . $i], false);
//                $this->db->where('prop_item_id', $postdata['prop_sub_item_return_item_id' . $i]);
//                $this->db->where('prop_godown_id', $postdata['prop_item_return_to_godown_id']);
//                $this->db->update('prop_item_stock');
//            } else {
//                
//                
//                $addtblValues = array(
//                'prop_item_id' => $postdata['prop_sub_item_return_item_id' . $i],
//                'prop_godown_id' => $postdata['prop_item_return_to_godown_id'],
//                'prop_item_stock_qty' => $postdata['prop_sub_item_return_qty' . $i],
//               
//            );
//            $this->db->insert('prop_item_stock', $addtblValues);
//            }

            
            //stock end
            
            
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_item_return($postdata)
    {   
        $data = array();
        $this->db->trans_begin();
         $mainValues = array(   
            'prop_item_return_date' => $this->mastermodel->convert_date_format($postdata['prop_item_return_date']),
            'prop_item_return_cat' => $postdata['prop_item_return_cat'],
            'prop_item_return_remarks' => $postdata['prop_item_return_remarks'],
            'prop_item_return_from_godown_id' => $postdata['prop_item_return_from_godown_id'],
            'prop_item_return_to_godown_id' => $postdata['prop_item_return_to_godown_id'],
            'prop_item_return_total' => $postdata['prop_item_return_total']
            );
        $this->db->where('prop_item_return_id',$postdata['prop_item_return_id']);
        $this->db->update('prop_item_return', $mainValues);
        
        $this->db->where('prop_item_return_item_return_id',$postdata['prop_item_return_id']);
        $this->db->delete('prop_sub_item_return');
        $i=1;
        while(isset($postdata['prop_sub_item_return_price'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
            
            
               $stock_detailes_prev = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['prop_sub_item_return_item_id'. $i],'prop_item_stock_id');
      
             $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['previus_qty'. $i], false);
                $this->db->where('prop_item_id', $stock_detailes_prev->prop_item_id);
              $this->db->where('price', $stock_detailes_prev->price);
                $this->db->where('prop_godown_id', $postdata['prop_item_return_from_godown_id']);
                $this->db->update('prop_item_stock');
                
                 $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['previus_qty'. $i], false);
                $this->db->where('prop_item_stock_id', $postdata['stock_id' . $i]);
                $this->db->update('prop_item_stock');
            
            
            
            
            
            
             $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['prop_sub_item_return_item_id'. $i],'prop_item_stock_id');
      
            
            
            
            //stock add
            
              $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['prop_sub_item_return_qty' . $i], false);
            $this->db->where('prop_item_stock_id', $postdata['prop_sub_item_return_item_id' . $i]);
            $this->db->update('prop_item_stock');

            $this->db->select('*');
            $this->db->from('prop_item_stock');
            $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
              $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['prop_item_return_to_godown_id']);

            $count = $this->db->count_all_results();
        
            if ($count > 0) {

                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['prop_sub_item_return_qty' . $i], false);
                $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['prop_item_return_date']));
             $this->db->set('total', 'prop_item_stock_qty * price', false);
             
                $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
              $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['prop_item_return_to_godown_id']);
                $this->db->update('prop_item_stock');
                $stock_master = $this->propertymodel->get_search_stockmaster($stock_detailes->prop_item_id,$postdata['prop_item_return_to_godown_id'],$stock_detailes->price);
   
                     

        if (!empty($stock_master))
        {

            $prop_item_stock_id = $stock_master->prop_item_stock_id;
            
        }
            } 
            else {
                
                
               $prop_item_stock_id = $this->mastermodel->insertmasterdata();
                    
                $addtblValues = array(
                       'prop_item_stock_id'=>$prop_item_stock_id,
                'prop_item_id' => $stock_detailes->prop_item_id,
                     'price' => $stock_detailes->price,
                       'total' => $stock_detailes->price * $postdata['prop_sub_item_return_qty' . $i],
                'prop_godown_id' => $postdata['prop_item_return_to_godown_id'],
                'prop_item_stock_qty' => $postdata['prop_sub_item_return_qty' . $i],
               'stock_date' => $this->mastermodel->convert_date_format($postdata['prop_item_return_date'])
            );
            $this->db->insert('prop_item_stock', $addtblValues);
//            $prop_item_stock_id =  $this->db->insert_id();
            }
             
             $sub_tblValues = array(
            'prop_sub_item_return_id' => $sub_masterid,
            'prop_item_return_item_return_id' => $postdata['prop_item_return_id'],
            'prop_sub_item_return_item_id' => $stock_detailes->prop_item_id,
            'prop_sub_item_return_from_godown_stock' => $postdata['prop_sub_item_return_from_godown_stock'. $i],
            'prop_sub_item_return_to_godown_stock' => $postdata['prop_sub_item_return_to_godown_stock'. $i],
            'prop_sub_item_returnm_make' => $postdata['prop_sub_item_returnm_make'. $i],
            'prop_sub_item_return_serial_no' => $postdata['prop_sub_item_return_serial_no'. $i],
            'prop_sub_item_return_qty' => $postdata['prop_sub_item_return_qty'. $i],
            'prop_sub_item_return_price' => $postdata['prop_sub_item_return_price'. $i],
            'prop_sub_item_return_amount' => $postdata['prop_sub_item_return_amount'. $i],
                 'stock_id' => $prop_item_stock_id
        );
            $this->db->insert('prop_sub_item_return', $sub_tblValues);
            
            
            
            
            
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    
    
     function search_item_return_cat()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_item_return_cat');
        $this->db->join('master', 'master.master_id=prop_item_return_cat.prop_item_return_cat_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_item_return_cat_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_item_return_cat($postdata)
    {   
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'prop_item_return_cat_id' => $masterid,
            'prop_item_return_cat_name' => $postdata['prop_item_return_cat_name'],
            'prop_item_return_cat_to_godown_id' => $postdata['prop_item_return_cat_to_godown_id'],
//            'prop_item_return_cat_acconting_option' => $postdata['prop_item_return_cat_acconting_option'],
//            'prop_item_return_cat_calculate_stock' => $postdata['prop_item_return_cat_calculate_stock']
            );
        $this->db->insert('prop_item_return_cat', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_item_return_cat($postdata)
    {    
        $data = array();
        $this->db->trans_begin();
       
         $tblValues = array(
            'prop_item_return_cat_name' => $postdata['prop_item_return_cat_name'],
            'prop_item_return_cat_to_godown_id' => $postdata['prop_item_return_cat_to_godown_id'],
//            'prop_item_return_cat_acconting_option' => $postdata['prop_item_return_cat_acconting_option'],
//            'prop_item_return_cat_calculate_stock' => $postdata['prop_item_return_cat_calculate_stock']
            );
        $this->db->where('prop_item_return_cat_id',$postdata['prop_item_return_cat_id']);
        $this->db->update('prop_item_return_cat', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
 
    function search_detail_entry($pagenum)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('detail_entry');
        $this->db->join('master', 'master.master_id=detail_entry.detail_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->join('ppty_dealing_type', 'ppty_dealing_type.dealing_type_id = detail_entry.dealing_type_id');
        $this->db->join('sub_category', 'sub_category.sub_category_id = detail_entry.sub_category_id');
        $this->db->join('main_category', 'main_category.main_category_id = sub_category.main_category_id');
        $this->db->join('agency', 'agency.agency_id = detail_entry.agency_id');
        $this->db->order_by('detail_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
      function insert_details_entry($postdata)
    { 
         $data = array();
        $this->db->trans_begin();
        /*detail_entry starts*/
        $detail_id = $this->mastermodel->insertmasterdata();
        if($postdata['rent_type'] == '')
        {
            $rent_type='Monthly';
        }
 else {
     $rent_type= $postdata['rent_type'];
 }
         $postdata['address']= preg_replace('/[0-9]{6,}+/', '', $postdata['address']);
                $b='image';
                $a='detail_images';
        $files = $_FILES;
       
                    
        $cpt = count($_FILES[$a]['name']); 

        
        
        
                    $cpt = count($files);
                    for($i=1; $i<=$cpt; $i++)
                    {
                        $_FILES[$a]['name']= $files[$a]['name'][$i];
                        $_FILES[$a]['type']= $files[$a]['type'][$i];
                        $_FILES[$a]['tmp_name']= $files[$a]['tmp_name'][$i];
                        $_FILES[$a]['error']= $files[$a]['error'][$i];
                        $_FILES[$a]['size']= $files[$a]['size'][$i];
                        $uploadPath = './assets/uploads/';
                        $config['upload_path'] = $uploadPath;
                           $config['max_size']             = 1024*20;
                        $config['allowed_types'] = 'gif|jpg|png|jpeg|xlsx|xls|pdf|csv|doc|docx|odt|txt';
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
               
                if($this->upload->do_upload($a.$i)){
                $fileData = $this->upload->data();
                $uploadData[$i]['file_name'] = $fileData['file_name'];
                $im[$i]=$uploadData[$i]['file_name'];
                }
                }
            $dtype =  $postdata['sub_excist']; 
            if ($postdata['dealing_type_id'] == 1) {
//                for rent
                if($dtype == 0)
                {
                    $price = $postdata['rent_price'];
                    $offerp = $postdata['rent_price_offer'];
                }else{
                    $price = $postdata['rent_price'];
                    $offerp = $postdata['rent_price_offer'];
                    $price_sub = $postdata['sell_price'];
                    $offerp_sub = $postdata['sell_price_offer'];
                }
                
            } else if($postdata['dealing_type_id'] == 2){
//                for sell
                if($dtype == 0)
                {
                    $price = $postdata['sell_price'];
                    $offerp = $postdata['sell_price_offer'];
                }else{
                    $price = $postdata['sell_price'];
                    $offerp = $postdata['sell_price_offer'];
                    $price_sub = $postdata['rent_price'];
                    $offerp_sub = $postdata['rent_price_offer'];
                }
            }
                $prop_owner_id='';
                foreach($postdata['prop_owner_id'] as $row)
                {
                     $prop_owner_id .= $row.',';
                }
                
        $tblValues = array(
            'detail_id'=>$detail_id,
            'detail_name' => $postdata['detail_name'],
            'location'=>$postdata['address'],
            'lat' => $postdata['latclicked'],
            'long' => $postdata['longclicked'],
            'agency_id' => $postdata['agency_id'],
            'prop_owner_id' =>$prop_owner_id,
            'description' => $postdata['description'],
            'dealing_type_id'=>$postdata['dealing_type_id'],
            'sub_category_id' => $postdata['sub_category_id'],
            'detail_name' => $postdata['detail_name'],
            'plot_area' => $postdata['plot_area'],
            'plot_area_unit' => $postdata['plot_area_unit'],
            'near_by_facility'=> implode(",", $postdata['near_by_facility']),
            'location_type' => $postdata['location_type'],
            'payment_mode' => $postdata['payment_mode'],
            'building_area' => $postdata['building_area'],
            'building_area_unit' => $postdata['building_area_unit'],
            'rooms' => $postdata['rooms'],
            'status' => $postdata['status'],
            'expected_date' => $this->mastermodel->convert_date_format($postdata['expected_date']),
            'rent_type' =>$rent_type,
            'rent_duration' => $postdata['rent_duration'],
            'family_property' => $postdata['family_property'],
            
            'sell_fprice' => $postdata['sell_fprice'],
            'sell_tprice' => $postdata['sell_tprice'],
            'rent_fprice' => $postdata['rent_fprice'],
            'rent_tprice' => $postdata['rent_tprice'],
            
            'sub_excist' => $dtype,
            'price' => $price,
            'offerp' => $offerp,
            'price_sub' => $price_sub,
            'offerp_sub' => $offerp_sub,
            
                
        );
        
         $upload_data = $this->mastermodel->upload_image('image');
        if (!empty($upload_data['file_name']))
        {
            $tblValues['image'] = $upload_data['file_name'];
        }
        
        $this->db->insert('detail_entry', $tblValues);
        /*detail_entry stop
        
         label entry start
        */
        $i=1;
          while(isset($postdata['label_id'. $i]))
        {
             if(isset($postdata['label_support_id'. $i])){
                 $postdata['value'. $i]="";
             }
          $search_details_id= $this->mastermodel->insertmasterdata();
             $addtblValues = array(
               
                  'search_details_id'=>$search_details_id,
                 'details_id'=>$detail_id,
                 'label_id'=>$postdata['label_id'. $i],
                 'value'=> $postdata['value'. $i],
                 );
              $this->db->insert('detail_entry_label', $addtblValues);
              /*
               label entry stop
               
                label entry support start
               */
              
              if(is_array($postdata['label_support_id'. $i])){
               for($j=0;$j<count($postdata['label_support_id'. $i]);$j++){
                         $search_support_id= $this->mastermodel->insertmasterdata();
             $addtblValues1 = array(
               
                  'search_support_id'=>$search_support_id,
                  'search_detail_id'=>$search_details_id,
                  'details_id'=>$detail_id,
                 'label_support_id'=>$postdata['label_support_id'. $i][$j],
                 );
              $this->db->insert('detail_entry_label_support', $addtblValues1);
                 }  
                  
              }
              else{
                
                      $search_support_id= $this->mastermodel->insertmasterdata();
             $addtblValues2 = array(
               
                  'search_support_id'=>$search_support_id,
                  'search_detail_id'=>$search_details_id,
                  'details_id'=>$detail_id,
                 'label_support_id'=>(int)$postdata['label_support_id'. $i],
                 );
              $this->db->insert('detail_entry_label_support', $addtblValues2);
              }
          
          $i++;
           
        }
        /*
         label entry support stop
         */
        
        
      
        for($i=1;$i<=count($im);$i++){
              $detail_images_id= $this->mastermodel->insertmasterdata();
            $tbl1Values = array(
                'detail_images_id' => $detail_images_id,
                'detail_id' => $detail_id,
                'detail_images' =>$im[$i],
             );
            $this->db->insert('detail_entry_images', $tbl1Values);
            }
            
            $i=1;
           while(!empty($postdata['detail_entry_videos'.$i]))
           {              
                $detail_videos_id= $this->mastermodel->insertmasterdata();
                $tbl1Values = array(
                    'detail_videos_id' =>$detail_videos_id,
                    'detail_id' =>$detail_id,
                    'detail_entry_videos' =>$postdata['detail_entry_videos'.$i],
                        );
                $this->db->insert('detail_entry_videos', $tbl1Values);
                $i++; 
            }
              $n=1;
             
           while(isset($postdata['detail_room_no'.$n]) && !empty($postdata['detail_room_no'.$n]))
           {
                $detail_entry_room_owner='';
                foreach($postdata['detail_entry_room_owner'.$n] as $row)
                {
                     $detail_entry_room_owner .= $row.',';
                }
                $detail_entry_dealing_details_id= $this->mastermodel->insertmasterdata();
                $tbl1Values = array(
                    'detail_entry_dealing_details_id' =>$detail_entry_dealing_details_id,
                    'detail_id' =>$detail_id,
                    'detail_floor' =>$postdata['detail_floor'.$n],
                    'detail_room_no' =>$postdata['detail_room_no'.$n],
                    
                    'detail_entry_building_area' =>$postdata['detail_entry_building_area'.$n],
                    'detail_entry_no_of_rooms' =>$postdata['detail_entry_no_of_rooms'.$n],
                    'details_sell_fprice' =>$postdata['details_sell_fprice'.$n],
                    'details_sell_tprice' =>$postdata['details_sell_tprice'.$n],
                    'details_rent_fprice' =>$postdata['details_rent_fprice'.$n],
                    'details_rent_tprice' =>$postdata['details_rent_tprice'.$n],
                    'detail_entry_description' =>$postdata['detail_entry_description'.$n],
                    'detail_entry_status' =>$postdata['detail_entry_status'.$n],
                    'detail_entry_type' =>$postdata['detail_entry_type'.$n],
                    'detail_entry_room_owner' =>$detail_entry_room_owner,
                        );
                $this->db->insert('detail_entry_dealing_details', $tbl1Values);
                $n++; 
            }
            
             
        $data['resfunction'] = 'search_detail_entry';
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error on adding record';
            return $data;
        }
        else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }
     function update_details_entry($postdata)
    {
         $data = array();
        $this->db->trans_begin();
        /*detail_entry starts*/
//        $detail_id = $this->mastermodel->insertmasterdata();
         $postdata['address']= preg_replace('/[0-9]{6,}+/', '', $postdata['address']);
                $b='image';
                $a='detail_images';
        $files = $_FILES;
       
                    
        $cpt = count($_FILES[$a]['name']); 

        
        
        
                   
               
                 if (isset($postdata['price_offer'])&&!empty($postdata['price_offer'])) {
                $actual_price = $postdata['price_offer'];
                $prev_price = $postdata['price'];
            } else {
                $actual_price = $postdata['price'];
                $prev_price = '';
            }
                 $prop_owner_id='';
    foreach($postdata['prop_owner_id'] as $item){
        $prop_owner_id .= $item.',';
    }
            $dtype =  $postdata['sub_excist']; 
            if ($postdata['dealing_type_id'] == 1) {
//                for rent
                if($dtype == 0)
                {
                    $price = $postdata['rent_price'];
                    $offerp = $postdata['rent_price_offer'];
                }else{
                    $price = $postdata['rent_price'];
                    $offerp = $postdata['rent_price_offer'];
                    $price_sub = $postdata['sell_price'];
                    $offerp_sub = $postdata['sell_price_offer'];
                }
                
            } else if($postdata['dealing_type_id'] == 2){
//                for sell
                if($dtype == 0)
                {
                    $price = $postdata['sell_price'];
                    $offerp = $postdata['sell_price_offer'];
                }else{
                    $price = $postdata['sell_price'];
                    $offerp = $postdata['sell_price_offer'];
                    $price_sub = $postdata['rent_price'];
                    $offerp_sub = $postdata['rent_price_offer'];
                }
            }
                
        $tblValues = array(
            'detail_name' => $postdata['detail_name'],
            'location'=>$postdata['address'],
            'lat' => $postdata['latclicked'],
            'long' => $postdata['longclicked'],
            'description' => $postdata['description'],
            'plot_area' => $postdata['plot_area'],
            'prop_owner_id' =>$prop_owner_id,
            'plot_area_unit' => $postdata['plot_area_unit'],
            'near_by_facility'=> implode(",", $postdata['near_by_facility']),
            'location_type' => $postdata['location_type'],
            'payment_mode' => $postdata['payment_mode'],
            'building_area' => $postdata['building_area'],
            'building_area_unit' => $postdata['building_area_unit'],
            'rooms' => $postdata['rooms'],
            'status' => $postdata['status'],
            'expected_date' => $this->mastermodel->convert_date_format($postdata['expected_date']),
            'rent_type' => $postdata['rent_type'],
            'rent_duration' => $postdata['rent_duration'],
            'family_property' => $postdata['family_property'],
            
            'sell_fprice' => $postdata['sell_fprice'],
            'sell_tprice' => $postdata['sell_tprice'],
            'rent_fprice' => $postdata['rent_fprice'],
            'rent_tprice' => $postdata['rent_tprice'],
            
            'price' => $price,
            'offerp' => $offerp,
            'price_sub' => $price_sub,
            'offerp_sub' => $offerp_sub,
                
        );
        
        $cpt_image = count($_FILES[$b]['name']); 
          if($cpt_image <= 0 ) {
              $images=$postdata['pre_image'];
              $tblValues['image'] = $postdata['pre_image'];
          }  
          else{
         $upload_data = $this->mastermodel->upload_image('image');
        if (!empty($upload_data['file_name']))
        {
            $tblValues['image'] = $upload_data['file_name'];
        }
          }
        $this->db->where('detail_entry.detail_id', $postdata['detail_id']);
        $this->db->update('detail_entry',$tblValues);
        /*detail_entry stop
        
         label entry start
        */
         $this->db->where_in('detail_entry_label_support.details_id',$postdata['detail_id']);
        $this->db->delete('detail_entry_label_support');
         
          $this->db->where('detail_entry_label.details_id',$postdata['detail_id']);
        $this->db->delete('detail_entry_label');
        
        $i=1;
          while(isset($postdata['label_id'. $i]))
        {
             if(isset($postdata['label_support_id'. $i])){
                 $postdata['value'. $i]="";
             }
          $search_details_id= $this->mastermodel->insertmasterdata();
             $addtblValues = array(
               
                  'search_details_id'=>$search_details_id,
                 'details_id'=>$postdata['detail_id'],
                 'label_id'=>$postdata['label_id'. $i],
                 'value'=> $postdata['value'. $i],
                 );
              $this->db->insert('detail_entry_label', $addtblValues);
              /*
               label entry stop
               
                label entry support start
               */
              
              if(is_array($postdata['label_support_id'. $i])){
               for($j=0;$j<count($postdata['label_support_id'. $i]);$j++){
                         $search_support_id= $this->mastermodel->insertmasterdata();
             $addtblValues1 = array(
               
                  'search_support_id'=>$search_support_id,
                  'search_detail_id'=>$search_details_id,
                  'details_id'=>$postdata['detail_id'],
                 'label_support_id'=>$postdata['label_support_id'. $i][$j],
                 );
              $this->db->insert('detail_entry_label_support', $addtblValues1);
                 }  
                  
              }
              else{
                
                      $search_support_id= $this->mastermodel->insertmasterdata();
             $addtblValues2 = array(
               
                  'search_support_id'=>$search_support_id,
                  'search_detail_id'=>$search_details_id,
                  'details_id'=>$postdata['detail_id'],
                 'label_support_id'=>(int)$postdata['label_support_id'. $i],
                 );
              $this->db->insert('detail_entry_label_support', $addtblValues2);
              }
          
          $i++;
           
        }
        /*
         label entry support stop
         */
         
        $files = $_FILES;

        $cpt = count($files)-$cpt_image;
                    for($i=1; $i<=$cpt; $i++)
                    {
                        $_FILES[$a]['name']= $files[$a]['name'][$i];
                        $_FILES[$a]['type']= $files[$a]['type'][$i];
                        $_FILES[$a]['tmp_name']= $files[$a]['tmp_name'][$i];
                        $_FILES[$a]['error']= $files[$a]['error'][$i];
                        $_FILES[$a]['size']= $files[$a]['size'][$i];
                        $uploadPath = './assets/uploads/';
                        $config['upload_path'] = $uploadPath;
                        $config['allowed_types'] = 'gif|jpg|png|jpeg|xlsx|xls|pdf|csv|doc|docx|odt|txt';
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
               
                if($this->upload->do_upload($a.$i)){
                $fileData = $this->upload->data();
                $uploadData[$i]['file_name'] = $fileData['file_name'];
                $im[$i]=$uploadData[$i]['file_name'];
                }
                }
        
      
        for($i=1;$i<=count($im);$i++){
              $detail_images_id= $this->mastermodel->insertmasterdata();
            $tbl1Values = array(
                'detail_images_id' => $detail_images_id,
                'detail_id' => $postdata['detail_id'],
                'detail_images' =>$im[$i],
             );
            $this->db->insert('detail_entry_images', $tbl1Values);
            }
            
            $i=1;
           while(!empty($postdata['detail_entry_videos'.$i]))
           {
                $detail_videos_id= $this->mastermodel->insertmasterdata();
                $tbl1Values = array(
                    'detail_videos_id' =>$detail_videos_id,
                    'detail_id' =>$postdata['detail_id'],
                    'detail_entry_videos' =>$postdata['detail_entry_videos'.$i],
                        );
                $this->db->insert('detail_entry_videos', $tbl1Values);
                $i++; 
            }
            $this->db->where('detail_id',$postdata['detail_id']);
            $this->db->delete('detail_entry_dealing_details');
              $n=1;
           while(isset($postdata['detail_room_no'.$n]) && !empty($postdata['detail_room_no'.$n]))
           {
                $detail_entry_room_owner='';
    foreach($postdata['detail_entry_room_owner'.$n] as $item){
        $detail_entry_room_owner .= $item.',';
    }
                $detail_entry_dealing_details_id= $this->mastermodel->insertmasterdata();
                $tbl1Values = array(
                    'detail_entry_dealing_details_id' =>$detail_entry_dealing_details_id,
                    'detail_id' =>$postdata['detail_id'],
                    'detail_floor' =>$postdata['detail_floor'.$n],
                    'detail_room_no' =>$postdata['detail_room_no'.$n],
                    
                    'detail_entry_building_area' =>$postdata['detail_entry_building_area'.$n],
                    'detail_entry_no_of_rooms' =>$postdata['detail_entry_no_of_rooms'.$n],
                    'detail_entry_description' =>$postdata['detail_entry_description'.$n],
                    'detail_entry_status' =>$postdata['detail_entry_status'.$n],
                    'detail_entry_type' =>$postdata['detail_entry_type'.$n],
                    'detail_entry_room_owner' =>$detail_entry_room_owner,
                    'details_sell_fprice' =>$postdata['details_sell_fprice'.$n],
                    'details_sell_tprice' =>$postdata['details_sell_tprice'.$n],
                    'details_rent_fprice' =>$postdata['details_rent_fprice'.$n],
                    'details_rent_tprice' =>$postdata['details_rent_tprice'.$n],
                        );
                $this->db->insert('detail_entry_dealing_details', $tbl1Values);
                $n++; 
            }
            
             
        $data['resfunction'] = 'search_detail_entry';
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error on adding record';
            return $data;
        }
        else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }
     function get_all_label_saved($id)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('label');
        $this->db->join('master', 'master.master_id=label.label_id');
        $this->db->join('html_entities', 'html_entities.html_entities_id = label.html_entity');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('label.sub_category_id',$id);
        $this->db->order_by('label_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
    function del_ppty_image($id)
    {    
       $this->db->trans_begin();
        $this->db->where('detail_images_id', $id);
        $output = $this->db->delete('detail_entry_images');

        $this->db->where('detail_images_id', $id);
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = "Unable to delete Record..!";
            return $data;
        } else {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = "Data Deleted Successfully..!";
            return $data;
        }
    }
    function del_ppty_video($id)
    {    
          $this->db->trans_begin();
        $this->db->where('detail_videos_id', $id);
        $output = $this->db->delete('detail_entry_videos');

        $this->db->where('detail_videos_id', $id);
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = "Unable to delete Record..!";
            return $data;
        } else {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = "Data Deleted Successfully..!";
            return $data;
        }
    }
    function detail_entry_label($id,$label_id)
    {
        $data = array();
        $this->db->select('detail_entry_label.value as detail_entry_label_value');
        $this->db->from('detail_entry_label');
//         $this->db->join('label', 'label.label_id = detail_entry_label.label_id');
//        $this->db->join('html_entities', 'html_entities.html_entities_id = label.html_entity');
        $this->db->join('master', 'master.master_id=detail_entry_label.search_details_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('detail_entry_label.details_id',$id);
           $this->db->where('detail_entry_label.label_id',$label_id);
        $this->db->order_by('search_details_id', 'desc');
        $data = $this->db->get()->row();
      
        return $data;
    }
    function search_item_damageEntry()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_item_damageEntry');
         $this->db->join('user','user.user_id = prop_item_damageEntry.prop_item_damageEntry_userId');
        $this->db->join('godown','godown.godown_id = prop_item_damageEntry.prop_item_damageEntry_godown_id');
        $this->db->join('master', 'master.master_id=prop_item_damageEntry.prop_item_damageEntry_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_item_damageEntry_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_item_damageEntry($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_item_damageEntry_id' => $masterid,
            'prop_item_damageEntry_date' => $this->mastermodel->convert_date_format($postdata['prop_item_damageEntry_date']),
            'prop_item_damageEntry_userId' => $postdata['prop_item_damageEntry_userId'],
            'prop_item_damageEntry_godown_id' => $postdata['prop_item_damageEntry_godown_id'],
            'prop_item_damageEntry_remarks' => $postdata['prop_item_damageEntry_remarks'],
            'prop_sub_item_damageEntry_grantTotal' => $postdata['prop_sub_item_damageEntry_grantTotal'],
            );
        $this->db->insert('prop_item_damageEntry', $tblValues);
        $i=1;
        while(isset($postdata['prop_sub_item_damageEntry_item_id'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
             $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['prop_sub_item_damageEntry_item_id' . $i],'prop_item_stock_id');
      
            
            $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['prop_sub_item_damageEntry_qty' . $i], false);
              $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['prop_item_damageEntry_date']));
            $this->db->where('prop_item_stock_id', $postdata['prop_sub_item_damageEntry_item_id' . $i]);
            $this->db->update('prop_item_stock');
            
            
              $tblValues = array(
            'prop_sub_item_damageEntry_id' => $sub_masterid,
            'prop_sub_item_damageEntry_damageEntry_id' => $masterid,
            'prop_sub_item_damageEntry_item_id' => $stock_detailes->prop_item_id,
            'prop_sub_item_damageEntry_stock' => $postdata['prop_sub_item_damageEntry_stock'. $i],
            'prop_sub_item_damageEntry_make' => $postdata['prop_sub_item_damageEntry_make'. $i],
            'prop_sub_item_damageEntry_serielNo' => $postdata['prop_sub_item_damageEntry_serielNo'. $i],
            'prop_sub_item_damageEntry_qty' => $postdata['prop_sub_item_damageEntry_qty'. $i],
            'prop_sub_item_damageEntry_price' => $postdata['prop_sub_item_damageEntry_price'. $i],
            'prop_sub_item_damageEntry_amount' => $postdata['prop_sub_item_damageEntry_amount'. $i],
            'prop_sub_item_damageEntry_reason' => $postdata['prop_sub_item_damageEntry_reason'. $i],
             'stock_id' => $postdata['prop_sub_item_damageEntry_item_id' . $i]
        );
            $this->db->insert('prop_sub_item_damageEntry', $tblValues);
            
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    
     public function update_item_damageEntry($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
       
        $tblValues = array(
            'prop_item_damageEntry_date' => $this->mastermodel->convert_date_format($postdata['prop_item_damageEntry_date']),
//            'prop_item_damageEntry_userId' => $postdata['prop_item_damageEntry_userId'],
            'prop_item_damageEntry_godown_id' => $postdata['prop_item_damageEntry_godown_id'],
            'prop_item_damageEntry_remarks' => $postdata['prop_item_damageEntry_remarks'],
            'prop_sub_item_damageEntry_grantTotal' => $postdata['prop_sub_item_damageEntry_grantTotal'],
            );
        $this->db->where('prop_item_damageEntry_id', $postdata['prop_item_damageEntry_id']);
        $this->db->update('prop_item_damageEntry',$tblValues);
        
        $this->db->where('prop_sub_item_damageEntry_damageEntry_id',$postdata['prop_item_damageEntry_id']);
        $this->db->delete('prop_sub_item_damageEntry');
        $i=1;
        while(isset($postdata['prop_sub_item_damageEntry_item_id'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
          $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['prop_sub_item_damageEntry_item_id' . $i],'prop_item_stock_id');
      
            
             $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['previus_qty' . $i], false);
              $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['prop_item_damageEntry_date']));
            $this->db->where('prop_item_stock_id', $postdata['prop_sub_item_damageEntry_item_id' . $i]);
            $this->db->update('prop_item_stock');
            
             $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['prop_sub_item_damageEntry_qty' . $i], false);
              $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['prop_item_damageEntry_date']));
            $this->db->where('prop_item_stock_id', $postdata['prop_sub_item_damageEntry_item_id' . $i]);
            $this->db->update('prop_item_stock');
            
            
            
            
            
              $tblValues = array(
            'prop_sub_item_damageEntry_id' => $sub_masterid,
            'prop_sub_item_damageEntry_damageEntry_id' => $postdata['prop_item_damageEntry_id'],
             'prop_sub_item_damageEntry_item_id' => $stock_detailes->prop_item_id,
            'prop_sub_item_damageEntry_stock' => $postdata['prop_sub_item_damageEntry_stock'. $i],
            'prop_sub_item_damageEntry_make' => $postdata['prop_sub_item_damageEntry_make'. $i],
            'prop_sub_item_damageEntry_serielNo' => $postdata['prop_sub_item_damageEntry_serielNo'. $i],
            'prop_sub_item_damageEntry_qty' => $postdata['prop_sub_item_damageEntry_qty'. $i],
            'prop_sub_item_damageEntry_price' => $postdata['prop_sub_item_damageEntry_price'. $i],
            'prop_sub_item_damageEntry_amount' => $postdata['prop_sub_item_damageEntry_amount'. $i],
            'prop_sub_item_damageEntry_reason' => $postdata['prop_sub_item_damageEntry_reason'. $i],
                    'stock_id' => $postdata['prop_sub_item_damageEntry_item_id' . $i]
        );
            $this->db->insert('prop_sub_item_damageEntry', $tblValues);
            
            
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    
    function search_item_request_ho()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_item_request_Ho');
         $this->db->join('user','user.user_id = prop_item_request_Ho.prop_item_request_Ho_user_id');
        $this->db->join('detail_entry','detail_entry.detail_id = prop_item_request_Ho.prop_item_request_Ho_detail_id');
    
        $this->db->join('master', 'master.master_id=prop_item_request_Ho.prop_item_request_Ho_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_item_request_Ho_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     function search_item_request_client()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_item_request_client');
        $this->db->join('user','user.user_id = prop_item_request_client.prop_item_request_client_user_id');
        $this->db->join('detail_entry','detail_entry.detail_id = prop_item_request_client.prop_item_request_client_detail_id');
    
        $this->db->join('master', 'master.master_id=prop_item_request_client.prop_item_request_client_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_item_request_client_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_item_request_ho($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_item_request_Ho_id' => $masterid,
            'prop_item_request_Ho_date' => $this->mastermodel->convert_date_format($postdata['prop_item_request_Ho_date']),
            'prop_item_request_Ho_user_id' => $postdata['prop_item_request_Ho_user_id'],
            'prop_item_request_Ho_detail_id' => $postdata['prop_item_request_Ho_detail_id'],
            'prop_item_request_Ho_remarks' => $postdata['prop_item_request_Ho_remarks'],
            'prop_item_request_Ho_grantTotal' => $postdata['prop_item_request_Ho_grantTotal'],
            );
        $this->db->insert('prop_item_request_Ho', $tblValues);
        $i=1;
        while(isset($postdata['prop_sub_item_request_Ho_item_id'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
            'prop_sub_item_request_Ho_id' => $sub_masterid,
            'prop_sub_item_request_Ho_request_Ho_id' => $masterid,
            'prop_sub_item_request_Ho_item_id' => $postdata['prop_sub_item_request_Ho_item_id'. $i],
            'prop_sub_item_request_Ho_qty' => $postdata['prop_sub_item_request_Ho_qty'. $i],
            'prop_sub_item_request_Ho_price' => $postdata['prop_sub_item_request_Ho_price'. $i],
            'prop_sub_item_request_Ho_amount' => $postdata['prop_sub_item_request_Ho_amount'. $i],
            'prop_sub_item_request_Ho_remarks' => $postdata['prop_sub_item_request_Ho_remarks'. $i],
        );
            $this->db->insert('prop_sub_item_request_Ho', $tblValues);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    
       public function insert_item_request_client($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_item_request_client_id' => $masterid,
            'prop_item_request_client_date' => $this->mastermodel->convert_date_format($postdata['prop_item_request_client_date']),
            'prop_item_request_client_user_id' => $postdata['prop_item_request_client_user_id'],
            'prop_item_request_client_detail_id' => $postdata['prop_item_request_client_detail_id'],
            'prop_item_request_client_remarks' => $postdata['prop_item_request_client_remarks'],
            'prop_item_request_client_dealing_details_id' => $postdata['prop_item_request_client_room_no'],
            );
        $this->db->insert('prop_item_request_client', $tblValues);
        $i=1;
        while(isset($postdata['prop_sub_item_request_client_item_id'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
            'prop_sub_item_request_client_id' => $sub_masterid,
            'prop_sub_item_request_client_request_client_id' => $masterid,
            'prop_sub_item_request_client_item_id' => $postdata['prop_sub_item_request_client_item_id'. $i],
            'prop_sub_item_request_client_qty' => $postdata['prop_sub_item_request_client_qty'. $i],
            'prop_sub_item_request_client_reason' => $postdata['prop_sub_item_request_client_reason'. $i],
        );
            $this->db->insert('prop_sub_item_request_client', $tblValues);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    
    public function update_item_request_ho($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
     
        $tblValues = array(
            'prop_item_request_Ho_date' => $this->mastermodel->convert_date_format($postdata['prop_item_request_Ho_date']),
            'prop_item_request_Ho_detail_id' => $postdata['prop_item_request_Ho_detail_id'],
            'prop_item_request_Ho_remarks' => $postdata['prop_item_request_Ho_remarks'],
            'prop_item_request_Ho_grantTotal' => $postdata['prop_item_request_Ho_grantTotal'],
            );
        $this->db->where('prop_item_request_Ho_id', $postdata['prop_item_request_Ho_id']);
        $this->db->update('prop_item_request_Ho',$tblValues);
        
        $this->db->where('prop_sub_item_request_Ho_request_Ho_id',$postdata['prop_item_request_Ho_id']);
        $this->db->delete('prop_sub_item_request_Ho');
        $i=1;
        while(isset($postdata['prop_sub_item_request_Ho_item_id'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
            'prop_sub_item_request_Ho_id' => $sub_masterid,
            'prop_sub_item_request_Ho_request_Ho_id' => $postdata['prop_item_request_Ho_id'],
            'prop_sub_item_request_Ho_item_id' => $postdata['prop_sub_item_request_Ho_item_id'. $i],
            'prop_sub_item_request_Ho_qty' => $postdata['prop_sub_item_request_Ho_qty'. $i],
            'prop_sub_item_request_Ho_price' => $postdata['prop_sub_item_request_Ho_price'. $i],
            'prop_sub_item_request_Ho_amount' => $postdata['prop_sub_item_request_Ho_amount'. $i],
            'prop_sub_item_request_Ho_remarks' => $postdata['prop_sub_item_request_Ho_remarks'. $i],
        );
            $this->db->insert('prop_sub_item_request_Ho', $tblValues);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    
       public function update_item_request_client($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
      
        $tblValues = array(
            'prop_item_request_client_date' => $this->mastermodel->convert_date_format($postdata['prop_item_request_client_date']),
         
            'prop_item_request_client_remarks' => $postdata['prop_item_request_client_remarks'],
            );
        $this->db->where('prop_item_request_client_id', $postdata['prop_item_request_client_id']);
        $this->db->update('prop_item_request_client',$tblValues);
        
        $this->db->where('prop_sub_item_request_client_request_client_id',$postdata['prop_item_request_client_id']);
        $this->db->delete('prop_sub_item_request_client');
        $i=1;
        
          while(isset($postdata['prop_sub_item_request_client_item_id'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
            'prop_sub_item_request_client_id' => $sub_masterid,
            'prop_sub_item_request_client_request_client_id' => $postdata['prop_item_request_client_id'],
            'prop_sub_item_request_client_item_id' => $postdata['prop_sub_item_request_client_item_id'. $i],
            'prop_sub_item_request_client_qty' => $postdata['prop_sub_item_request_client_qty'. $i],
            'prop_sub_item_request_client_reason' => $postdata['prop_sub_item_request_client_reason'. $i],
        );
            $this->db->insert('prop_sub_item_request_client', $tblValues);
            $i++;
        }
        
      
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function search_document_master()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_document_master');
        $this->db->join('prop_sub_document_master', 'prop_sub_document_master.prop_sub_document_master_document_master_id=prop_document_master.prop_document_master_id');
        
        $this->db->join('master', 'master.master_id=prop_document_master.prop_document_master_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_document_master_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_document_master($postdata)
    {  
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $main_tblValues = array(
            'prop_document_master_id' => $masterid,
            'prop_document_master_name' => $postdata['prop_document_master_name'],
            'prop_document_master_issuing_authority' => $postdata['prop_document_master_issuing_authority'],
//            'prop_document_master_processing_days' => $postdata['prop_document_master_processing_days']
            );
        $this->db->insert('prop_document_master', $main_tblValues);
        $i=1;
        while(isset($postdata['prop_document_master_main_category_id' .$i]))
        {
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $sub_tblValues = array(
                'prop_sub_document_master_id' => $sub_masterid,
                'prop_sub_document_master_document_master_id' => $masterid,
                'prop_document_master_dealing_type_id' => $postdata['prop_document_master_dealing_type_id' .$i],
                'prop_sub_document_master_main_cat_id' => $postdata['prop_document_master_main_category_id' .$i],
                'prop_sub_document_master_sub_cat_id' => $postdata['prop_document_master_sub_category_id' .$i],
                'prop_sub_document_master_no_of_copies' => $postdata['prop_document_master_no_of_copies' .$i]
            );
            
            $this->db->insert('prop_sub_document_master',$sub_tblValues);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_document_master($postdata)
    {   
        $data = array();
        $this->db->trans_begin();
       
         $tblValues = array(
            'prop_document_master_name' => $postdata['prop_document_master_name'],
            'prop_document_master_issuing_authority' => $postdata['prop_document_master_issuing_authority'],
            'prop_document_master_processing_days' => $postdata['prop_document_master_processing_days']
            );
        $this->db->where('prop_document_master_id',$postdata['prop_document_master_id']);
        $this->db->update('prop_document_master', $tblValues);
        
        $this->db->where('prop_sub_document_master_document_master_id',$postdata['prop_document_master_id']);        
        $this->db->delete('prop_sub_document_master');
       
            $sub_tblValues = array(
                'prop_sub_document_master_id' =>  $this->mastermodel->insertmasterdata(),
                'prop_sub_document_master_document_master_id' => $postdata['prop_document_master_id'],
                'prop_document_master_dealing_type_id' => $postdata['prop_document_master_dealing_type_id'],
                'prop_sub_document_master_main_cat_id' => $postdata['prop_sub_document_master_main_cat_id'],
                'prop_sub_document_master_sub_cat_id' => $postdata['prop_sub_document_master_sub_cat_id'],
                'prop_sub_document_master_no_of_copies' => $postdata['prop_sub_document_master_no_of_copies']
            );
            
            $this->db->insert('prop_sub_document_master',$sub_tblValues);
            
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_asset_entry()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_asset_entry');
        $this->db->join('master', 'master.master_id=prop_asset_entry.prop_asset_entry_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_asset_entry_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_asset_entry($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_asset_entry_id' => $masterid,
            'prop_asset_entry_date' => $this->mastermodel->convert_date_format($postdata['prop_asset_entry_date']),
            'prop_asset_entry_detail_id' => $postdata['prop_asset_entry_detail_id'],
            'prop_asset_entry_user_id' => $postdata['prop_asset_entry_user_id'],
            'prop_asset_entry_detail_entry_dealing_details_id' => $postdata['prop_asset_entry_room_no'],
            );
        $this->db->insert('prop_asset_entry', $tblValues);
        $i=1;
        while(isset($postdata['prop_sub_asset_entry_qty'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
            'prop_sub_asset_entry_id' => $sub_masterid,
            'prop_sub_asset_entry_asset_entry_id' => $masterid,
            'prop_sub_asset_entry_item_id' => $postdata['prop_sub_asset_entry_item_id'. $i],
            'prop_sub_asset_entry_qty' => $postdata['prop_sub_asset_entry_qty'. $i],
            'prop_sub_asset_entry_make' => $postdata['prop_sub_asset_entry_make'. $i],
            'prop_sub_asset_entry_serial_no' => $postdata['prop_sub_asset_entry_serial_no'. $i],
        );
            $this->db->insert('prop_sub_asset_entry', $tblValues);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_asset_entry($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'prop_asset_entry_date' => $this->mastermodel->convert_date_format($postdata['prop_asset_entry_date']),
            );
        $this->db->where('prop_asset_entry_id',$postdata['prop_asset_entry_id']);
        $this->db->update('prop_asset_entry', $tblValues);
        
        $this->db->where('prop_sub_asset_entry_asset_entry_id',$postdata['prop_asset_entry_id']);
        $this->db->delete('prop_sub_asset_entry');
        $i=1;
        while(isset($postdata['prop_sub_asset_entry_qty'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
            'prop_sub_asset_entry_id' => $sub_masterid,
            'prop_sub_asset_entry_asset_entry_id' => $postdata['prop_asset_entry_id'],
            'prop_sub_asset_entry_item_id' => $postdata['prop_sub_asset_entry_item_id'. $i],
            'prop_sub_asset_entry_qty' => $postdata['prop_sub_asset_entry_qty'. $i],
            'prop_sub_asset_entry_make' => $postdata['prop_sub_asset_entry_make'. $i],
            'prop_sub_asset_entry_serial_no' => $postdata['prop_sub_asset_entry_serial_no'. $i],
        );
            $this->db->insert('prop_sub_asset_entry', $tblValues);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_customer()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('contact');
        $this->db->join('master', 'master.master_id= contact.contact_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('contact_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    
    public function insert_customer($postdata)
    {   
        $data = array();
        $this->db->trans_begin();
        $main_masterid = $this->mastermodel->insertmasterdata();
        $profile_settings = $this->mastermodel->get_profile_settings();
         
        $role_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules', 'profile_id', $profile_settings->customer_profile_id);
        $modules_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules_permission', 'profile_id', $profile_settings->customer_profile_id);
       
        $set = $this->accountingmodel->get_account_settings('customer');
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_id' => $ledger_id,
            'account_group_id' => $set,
            'ledger_name' => $postdata['prop_customer_first_name']." ".$postdata['prop_customer_last_name'],
            'mailing_name' => $postdata['prop_customer_first_name']." ".$postdata['prop_customer_last_name'],
            'address' => $postdata['prop_customer_residential_address'],
            'phone' => $postdata['prop_customer_phone'],
            'mobile' => $postdata['prop_customer_mobile_1'],
            'email' => $postdata['prop_customer_email'],
            'is_party' => 1,
        );
        $output = $this->db->insert('account_ledger', $tblValues);
        
        
        $tblValues = array(
            'user_name' => $postdata['prop_customer_user_name'],
            'profile_id' => $profile_settings->customer_profile_id,
            'password' => md5($postdata['prop_customer_password']),
            'user_modules' => $role_permission,
            'modules_permission' => $modules_permission,
        );
    
        $this->db->insert('user', $tblValues);
        //echo $this->db->last_query();die();
        $user_id = $this->db->insert_id();
        $tblValues = array(
            'contact_id' => $main_masterid, 
            'contact_user_id'=> $user_id,
            'contact_owner' => $postdata['prop_customer_owner'],
            'contact_first_name' => $postdata['prop_customer_first_name'],
            'contact_last_name' => $postdata['prop_customer_last_name'],
            'contact_salutation_id' => $postdata['prop_customer_salutation_id'],
            'contact_mobile_1' => $postdata['prop_customer_mobile_1'],
            'contact_mobile_2' => $postdata['prop_customer_mobile_2'],
            'contact_phone' => $postdata['prop_customer_phone'],
            'contact_fax' => $postdata['prop_customer_fax'],
            'contact_email' => $postdata['prop_customer_email'],
            'contact_skype_id' => $postdata['prop_customer_skype_id'],
            'contact_website' => $postdata['prop_customer_website'],
            
            'contact_residential_address' => $postdata['prop_customer_residential_address'],
            'contact_residential_city' => $postdata['prop_customer_residential_city'],
            'contact_residential_zipcode' => $postdata['prop_customer_residential_zipcode'],
            'contact_residential_DOB' => $this->mastermodel->convert_date_format($postdata['prop_customer_residential_DOB']),
            'contact_residential_street' => $postdata['prop_customer_residential_street'],
            'contact_residential_state' => $postdata['prop_customer_residential_state'],
            'contact_residential_country' => $postdata['prop_customer_residential_country'],
            'contact_residential_phone' => $postdata['prop_customer_residential_phone'],
            
            'contact_official_location' => $postdata['prop_customer_official_address'],
            'contact_designation' => $postdata['prop_customer_official_occupation'],
            'contact_official_department' => $postdata['prop_customer_official_department'],
            'contact_official_city' => $postdata['prop_customer_official_city'],
            'contact_official_zipcode' => $postdata['prop_customer_official_zipcode'],
            'contact_official_street' => $postdata['prop_customer_official_street'],
            'contact_official_state' => $postdata['prop_customer_official_state'],
            'contact_official_phone' => $postdata['prop_customer_official_phone'],
            'contact_passport_no' => $postdata['prop_customer_passport_no'],
            'contact_country' => $postdata['prop_customer_country'],
            'contact_gender' => $postdata['prop_customer_gender'],
         
             'prop_contact_nationality' => $postdata['prop_contact_nationality'],
             'prop_customer_sponser_name' => $postdata['prop_customer_sponser_name'],
            
//            'contact_account_name' => $postdata['prop_customer_account_name '],
            'contact_description' => $postdata['prop_customer_description'],
            'contact_person' => $postdata['contact_person'],
              'ledger' => $ledger_id,
            );
        $upload_data = $this->mastermodel->upload_image('prop_customer_file');
        if (!empty($upload_data['file_name']))
        {
            $tblValues['contact_file'] = $upload_data['file_name'];
        }
        $this->db->insert('contact', $tblValues);
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_customer($postdata)
    {         
        $data = array();
        $this->db->trans_begin();
          $set = $this->accountingmodel->get_account_settings('customer');
        $tblValues = array(
            'account_group_id' => $set,
            'ledger_name' => $postdata['prop_customer_first_name']." ".$postdata['prop_customer_last_name'],
            'mailing_name' => $postdata['prop_customer_first_name']." ".$postdata['prop_customer_last_name'],
            'address' => $postdata['prop_customer_residential_address'],
            'phone' => $postdata['prop_customer_phone'],
            'mobile' => $postdata['prop_customer_mobile_1'],
            'email' => $postdata['prop_customer_email'],
            'is_party' => 1,
        );
       $this->db->where('ledger_id', $postdata['ledger_id']);
        $output = $this->db->update('account_ledger', $tblValues);
        
         $tblValues = array(   
            'contact_owner' => $postdata['prop_customer_owner'],
            'contact_first_name' => $postdata['prop_customer_first_name'],
            'contact_last_name' => $postdata['prop_customer_last_name'],
            'contact_salutation_id' => $postdata['prop_customer_salutation_id'],
            'contact_mobile_1' => $postdata['prop_customer_mobile_1'],
            'contact_mobile_2' => $postdata['prop_customer_mobile_2'],
            'contact_phone' => $postdata['prop_customer_phone'],
            'contact_fax' => $postdata['prop_customer_fax'],
            'contact_email' => $postdata['prop_customer_email'],
            'contact_skype_id' => $postdata['prop_customer_skype_id'],
            'contact_website' => $postdata['prop_customer_website'],
            
            'contact_residential_address' => $postdata['prop_customer_residential_address'],
            'contact_residential_city' => $postdata['prop_customer_residential_city'],
            'contact_residential_zipcode' => $postdata['prop_customer_residential_zipcode'],
            'contact_residential_DOB' => $this->mastermodel->convert_date_format($postdata['prop_customer_residential_DOB']),
            'contact_residential_street' => $postdata['prop_customer_residential_street'],
            'contact_residential_state' => $postdata['prop_customer_residential_state'],
            'contact_residential_country' => $postdata['prop_customer_residential_country'],
            'contact_residential_phone' => $postdata['prop_customer_residential_phone'],
            
            'contact_official_location' => $postdata['prop_customer_official_address'],
            'contact_designation' => $postdata['prop_customer_official_occupation'],
            'contact_official_department' => $postdata['prop_customer_official_department'],
            'contact_official_city' => $postdata['prop_customer_official_city'],
            'contact_official_zipcode' => $postdata['prop_customer_official_zipcode'],
            'contact_official_street' => $postdata['prop_customer_official_street'],
            'contact_official_state' => $postdata['prop_customer_official_state'],
            'contact_official_phone' => $postdata['prop_customer_official_phone'],
             'contact_passport_no' => $postdata['prop_customer_passport_no'],
            'contact_country' => $postdata['prop_customer_country'],
            'contact_gender' => $postdata['prop_customer_gender'],
            'prop_contact_nationality' => $postdata['prop_contact_nationality'],
             'prop_customer_sponser_name' => $postdata['prop_customer_sponser_name'],
            
//            'contact_account_name' => $postdata['prop_customer_account_name '],

            'contact_description' => $postdata['prop_customer_description'],
               'contact_person' => $postdata['contact_person'],
            );
         
         
        $upload_data = $this->mastermodel->upload_image('prop_customer_file');
        if (!empty($upload_data['file_name']))
        {
            $tblValues['contact_file'] = $upload_data['file_name'];
        }
      
         
        $this->db->where('contact_id',$postdata['prop_customer_id']);
        $this->db->update('contact', $tblValues);
        
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
     function search_service_category()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_service_category');
        $this->db->join('master', 'master.master_id=prop_service_category.prop_service_category_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_service_category_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
       public function insert_service_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'prop_service_category_id' => $masterid,
            'prop_service_category_name' => $postdata['prop_service_category_name'],
             'prop_service_category_description' => $postdata['prop_service_category_description'],
            
            );
        $this->db->insert('prop_service_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    
      public function update_service_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
       
        $tblValues = array(
           'prop_service_category_name' => $postdata['prop_service_category_name'],
             'prop_service_category_description' => $postdata['prop_service_category_description'],
            
            );
        
          $this->db->where('prop_service_category_id',$postdata['prop_service_category_id']);
        $this->db->update('prop_service_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_service_provider()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_service_provider');
        $this->db->join('master', 'master.master_id=prop_service_provider.prop_service_provider_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_service_provider_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_service_provider($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $service_provider_code = $this->mastermodel->get_ref('prop_service_provider_code', 'prop_service_provider', 'prop_service_provider_code');
        $tblValues = array(
            'prop_service_provider_id' => $masterid,
            'prop_service_provider_code' => $service_provider_code,
            'prop_service_provider_service_category_id' => $postdata['prop_service_provider_service_category_id'],
            'prop_service_provider_compny_name' => $postdata['prop_service_provider_compny_name'],
            'prop_service_provider_address' => $postdata['prop_service_provider_address'],
            'prop_service_provider_contact_person' => $postdata['prop_service_provider_contact_person'],
            'prop_service_provider_phone' => $postdata['prop_service_provider_phone'],
            'prop_service_provider_email' => $postdata['prop_service_provider_email'],
            'prop_service_provider_service_offered' => $postdata['prop_service_provider_service_offered'],
            );
        $this->db->insert('prop_service_provider', $tblValues);
        $i=1;
        while(isset($postdata['prop_servc_prvdr_contact_name'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
            'prop_servc_prvdr_contact_id' => $sub_masterid,
            'prop_servc_prvdr_contact_service_provider_id' => $masterid,
            'prop_servc_prvdr_contact_name' => $postdata['prop_servc_prvdr_contact_name'. $i],
            'prop_servc_prvdr_contact_designation' => $postdata['prop_servc_prvdr_contact_designation'. $i],
            'prop_servc_prvdr_contact_phon' => $postdata['prop_servc_prvdr_contact_phon'. $i],
            'prop_servc_prvdr_contact_mobile' => $postdata['prop_servc_prvdr_contact_mobile'. $i],
            'prop_servc_prvdr_contact_email' => $postdata['prop_servc_prvdr_contact_email'. $i],
        );
            $this->db->insert('prop_servc_prvdr_contact_details', $tblValues);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     public function update_service_provider($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'prop_service_provider_service_category_id' => $postdata['prop_service_provider_service_category_id'],
            'prop_service_provider_compny_name' => $postdata['prop_service_provider_compny_name'],
            'prop_service_provider_address' => $postdata['prop_service_provider_address'],
            'prop_service_provider_contact_person' => $postdata['prop_service_provider_contact_person'],
            'prop_service_provider_phone' => $postdata['prop_service_provider_phone'],
            'prop_service_provider_email' => $postdata['prop_service_provider_email'],
            'prop_service_provider_service_offered' => $postdata['prop_service_provider_service_offered'],
            );
        $this->db->where('prop_service_provider_id', $postdata['prop_service_provider_id']);
        $this->db->update('prop_service_provider', $tblValues);
        
        $this->db->where('prop_servc_prvdr_contact_service_provider_id',$postdata['prop_service_provider_id']);
        $this->db->delete('prop_servc_prvdr_contact_details');
        $i=1;
        while(isset($postdata['prop_servc_prvdr_contact_name'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
            'prop_servc_prvdr_contact_id' => $sub_masterid,
            'prop_servc_prvdr_contact_service_provider_id' => $postdata['prop_service_provider_id'],
            'prop_servc_prvdr_contact_name' => $postdata['prop_servc_prvdr_contact_name'. $i],
            'prop_servc_prvdr_contact_designation' => $postdata['prop_servc_prvdr_contact_designation'. $i],
            'prop_servc_prvdr_contact_phon' => $postdata['prop_servc_prvdr_contact_phon'. $i],
            'prop_servc_prvdr_contact_mobile' => $postdata['prop_servc_prvdr_contact_mobile'. $i],
            'prop_servc_prvdr_contact_email' => $postdata['prop_servc_prvdr_contact_email'. $i],
        );
            $this->db->insert('prop_servc_prvdr_contact_details', $tblValues);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
       function search_service_request()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_service_request');
        $this->db->join('master', 'master.master_id=prop_service_request.prop_service_request_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_service_request_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_service_request($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       $tblValues = array(
            'prop_service_request_id' => $masterid,
            'prop_service_request_date' => $this->mastermodel->convert_date_format($postdata['prop_service_request_date']),
            'prop_service_request_user_id' => $postdata['prop_service_request_user_id'],
            'prop_service_request_mobile' => $postdata['prop_service_request_mobile'],
            'prop_service_request_service' => $postdata['prop_service_request_service'],
            'prop_service_request_conv_date' => $this->mastermodel->convert_date_format($postdata['prop_service_request_conv_date']),
            'prop_service_request_conv_day' => $postdata['prop_service_request_conv_day'],
            'prop_service_request_conv_time' => $postdata['prop_service_request_conv_time'],
            );
        $this->db->insert('prop_service_request', $tblValues);
 
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
        public function update_service_request($postdata)
    {       
        $data = array();
        $this->db->trans_begin();$tblValues = array(
            'prop_service_request_date' => $this->mastermodel->convert_date_format($postdata['prop_service_request_date']),
            'prop_service_request_mobile' => $postdata['prop_service_request_mobile'],
            'prop_service_request_service' => $postdata['prop_service_request_service'],
            'prop_service_request_conv_date' => $this->mastermodel->convert_date_format($postdata['prop_service_request_conv_date']),
            'prop_service_request_conv_day' => $postdata['prop_service_request_conv_day'],
            'prop_service_request_conv_time' => $postdata['prop_service_request_conv_time'],
            );
        $this->db->where('prop_service_request_id', $postdata['prop_service_request_id']);
        $this->db->update('prop_service_request', $tblValues);
      
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_maintenance_contract()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('maintenance_contarct');
        $this->db->join('user','user.user_id = maintenance_contarct.maintenance_contarct_user_id');
        $this->db->join('prop_service_provider','prop_service_provider.prop_service_provider_id = maintenance_contarct.maintenance_contarct_service_provider_id');
        $this->db->join('master', 'master.master_id=maintenance_contarct.maintenance_contarct_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('maintenance_contarct_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
      public function insert_maintenance_contract($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            
            'maintenance_contarct_id' => $masterid,
            'maintenance_contarct_date' => $this->mastermodel->convert_date_format($postdata['maintenance_contarct_date']),
            'maintenance_contarct_details_id' => $postdata['maintenance_contarct_details_id'],
            'maintenance_contarct_dealing_details_id' => $postdata['maintenance_contarct_dealing_details_id'],
            'maintenance_contarct_user_id' => $postdata['maintenance_contarct_user_id'],
            'maintenance_contarct_service_provider_id' => $postdata['maintenance_contarct_service_provider_id'],
            'maintenance_contarct_start_date' => $this->mastermodel->convert_date_format($postdata['maintenance_contarct_start_date']),
            'maintenance_contarct_end_date' =>$this->mastermodel->convert_date_format($postdata['maintenance_contarct_end_date']),
            'maintenance_contarct_budget' => $postdata['maintenance_contarct_budget'],
            'maintenance_contarct_amount' => $postdata['maintenance_contarct_amount'],
            'maintenance_contarct_scope' => $postdata['maintenance_contarct_scope'],
            'maintenance_contarct_remarks' => $postdata['maintenance_contarct_remarks'],
              'maintenance_contarct_type' => $postdata['contract_type'],
            );
        $this->db->insert('maintenance_contarct', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     public function update_maintenance_contract($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
       
        $tblValues = array(
            'maintenance_contarct_date' => $this->mastermodel->convert_date_format($postdata['maintenance_contarct_date']),
            'maintenance_contarct_service_provider_id' => $postdata['maintenance_contarct_service_provider_id'],
            'maintenance_contarct_start_date' => $this->mastermodel->convert_date_format($postdata['maintenance_contarct_start_date']),
            'maintenance_contarct_end_date' =>$this->mastermodel->convert_date_format($postdata['maintenance_contarct_end_date']),
            'maintenance_contarct_budget' => $postdata['maintenance_contarct_budget'],
            'maintenance_contarct_amount' => $postdata['maintenance_contarct_amount'],
            'maintenance_contarct_scope' => $postdata['maintenance_contarct_scope'],
            'maintenance_contarct_remarks' => $postdata['maintenance_contarct_remarks'],
            );
        $this->db->where('maintenance_contarct_id',$postdata['maintenance_contarct_id']);
        $this->db->update('maintenance_contarct', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
     function search_service_entry()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_service_entry');
        $this->db->join('master', 'master.master_id=prop_service_entry.prop_service_entry_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_service_entry_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_service_entry($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            
            'prop_service_entry_id' => $masterid,
            'prop_service_entry_date' => $this->mastermodel->convert_date_format($postdata['prop_service_entry_date']),
            'prop_service_entry_detail_id' => $postdata['prop_service_entry_detail_id'],
            'prop_service_entry_user_id' => $postdata['prop_service_entry_user_id'],
            'prop_service_entry_service_request_id' => $postdata['prop_service_entry_service_request_id'],
            'prop_service_entry_service_provider_id' => $postdata['prop_service_entry_service_provider_id'],
            'prop_service_entry_start_date' => $this->mastermodel->convert_date_format($postdata['prop_service_entry_start_date']),
            'prop_service_entry_end_date' =>$this->mastermodel->convert_date_format($postdata['prop_service_entry_end_date']),
            'prop_service_entry_amount' => $postdata['prop_service_entry_amount'],
            'prop_service_entry_services_provided' => $postdata['prop_service_entry_services_provided'],
            'prop_service_entry_remarks' => $postdata['prop_service_entry_remarks'],
            'prop_service_entry_status' => $postdata['prop_service_entry_status']
            );
        $this->db->insert('prop_service_entry', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     public function update_service_entry($postdata)
    { 
        $data = array();
        $this->db->trans_begin();
      
        $tblValues = array(
            'prop_service_entry_date' => $this->mastermodel->convert_date_format($postdata['prop_service_entry_date']),
            'prop_service_entry_detail_id' => $postdata['prop_service_entry_detail_id'],
//            'prop_service_entry_user_id' => $postdata['prop_service_entry_user_id'],
            'prop_service_entry_service_request_id' => $postdata['prop_service_entry_service_request_id'],
            'prop_service_entry_service_provider_id' => $postdata['prop_service_entry_service_provider_id'],
            'prop_service_entry_start_date' => $this->mastermodel->convert_date_format($postdata['prop_service_entry_start_date']),
            'prop_service_entry_end_date' =>$this->mastermodel->convert_date_format($postdata['prop_service_entry_end_date']),
            'prop_service_entry_amount' => $postdata['prop_service_entry_amount'],
            'prop_service_entry_services_provided' => $postdata['prop_service_entry_services_provided'],
            'prop_service_entry_remarks' => $postdata['prop_service_entry_remarks'],
            'prop_service_entry_status' => $postdata['prop_service_entry_status']
            );
        $this->db->where('prop_service_entry_id', $postdata['prop_service_entry_id']);
        $this->db->update('prop_service_entry', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_lease_agreement()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_lease_agreement');
      //  $this->db->where('prop_lease_agreement.prop_lease_agreement_id not in ','(select lease.prop_lease_agreement_parent from prop_lease_agreement lease)',false);
        
        $this->db->join('master', 'master.master_id=prop_lease_agreement.prop_lease_agreement_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('prop_lease_agreement.prop_lease_agreement_termination',0);
        $this->db->order_by('prop_lease_agreement_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function search_lease_agreement_trminated()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_lease_agreement');
      //  $this->db->where('prop_lease_agreement.prop_lease_agreement_id not in ','(select lease.prop_lease_agreement_parent from prop_lease_agreement lease)',false);
        
        $this->db->join('master', 'master.master_id=prop_lease_agreement.prop_lease_agreement_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $this->db->where('prop_lease_agreement.prop_lease_agreement_termination',1);
        $this->db->order_by('prop_lease_agreement_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function lease_agreement()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_lease_agreement');
        $this->db->where('prop_lease_agreement.prop_lease_agreement_id not in ','(select lease.prop_lease_agreement_parent from prop_lease_agreement lease)',false);
        $this->db->where('prop_lease_agreement.prop_lease_agreement_id not in ','(select lease_termination.prop_lease_termination_lease_agrement_id from prop_lease_termination lease_termination)',false);
        
        $this->db->join('master', 'master.master_id=prop_lease_agreement.prop_lease_agreement_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        
         $this->db->where('prop_lease_agreement.prop_lease_agreement_termination',0);
        $this->db->order_by('prop_lease_agreement_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     function lease_agreement_by_customer($id)
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_lease_agreement');
        $this->db->where('prop_lease_agreement.prop_lease_agreement_id not in ','(select lease.prop_lease_agreement_parent from prop_lease_agreement lease)',false);
      
        $this->db->join('master', 'master.master_id=prop_lease_agreement.prop_lease_agreement_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        
         $this->db->where('prop_lease_agreement.prop_lease_agreement_termination',0);
          $this->db->where('prop_lease_agreement.prop_lease_agreement_customer_id',$id);
        $this->db->order_by('prop_lease_agreement_id', 'desc');
        $data['results'] = $this->db->get()->result();
      
        return $data;
    }
      function get_rooms($id)
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('detail_entry_dealing_details');
        $this->db->where('detail_entry_dealing_details.detail_id',$id);
         $this->db->where('detail_entry_dealing_details.detail_entry_type !=','Sell');
        $this->db->where('detail_entry_dealing_details.detail_entry_dealing_details_id not in ','(select lease.prop_lease_agreement_room_id from prop_lease_agreement lease)',false);
        
        $data= $this->db->get()->result();
        return $data;
    }
     function get_real_rooms($id)
    { 
        $data = array();
        $this->db->select('detail_id');
        $this->db->from('detail_entry_dealing_details');
//        $this->db->where('detail_entry_dealing_details.detail_entry_dealing_details_id not in ','(select lease.prop_lease_agreement_room_id from prop_lease_agreement lease)',false);
        
        $this->db->where('detail_entry_dealing_details.detail_id',$id);
        $this->db->where('detail_entry_dealing_details.detail_entry_type !=','Sell');
        $data= $this->db->get()->result();
        return $data;
    }
        function rent_amount($id)
    { 
        $data = array();
        $this->db->select('sum(prop_rent_collection_payment_details_paid_amt) as prop_rent_collection_payment_details_paid');
        $this->db->from('prop_rent_collection_payment_details');
        $this->db->where('prop_rent_collection_payment_details.prop_rent_collection_payment_details_lease_payment_details_id',$id);


        $data= $this->db->get()->row();
        if($data->prop_rent_collection_payment_details_paid == null)
        {
            $data->prop_rent_collection_payment_details_paid = 0;
        }
        return $data;
    }
     function rent_amount_service($id)
    { 
        $data = array();
        $this->db->select('sum(prop_rent_collection_service_details_paid_amt) as prop_rent_collection_service_details_paid');
        $this->db->from('prop_rent_collection_service_details');
        $this->db->where('prop_rent_collection_service_details.prop_rent_collection_service_details_lease_service_details_id',$id);


        $data= $this->db->get()->row();
         if($data->prop_rent_collection_service_details_paid == null)
        {
            $data->prop_rent_collection_service_details_paid = 0;
        }
        return $data;
    }
     function rent_amount_facilities($id)
    { 
        $data = array();
        $this->db->select('sum(prop_rent_collection_facilities_details_paid_amt) as prop_rent_collection_facilities_details_paid');
        $this->db->from('prop_rent_collection_facilities_details');
        $this->db->where('prop_rent_collection_facilities_details.prop_rent_collection_facilities_details_lease_facilit_details_id',$id);


        $data= $this->db->get()->row();
         if($data->prop_rent_collection_facilities_details_paid == null)
        {
            $data->prop_rent_collection_facilities_details_paid = 0;
        }
        return $data;
    }
    function insert_lease_agreement($postdata)
    { 
        $data = array();
       
        $this->db->trans_begin();
        $main_masterid = $this->mastermodel->insertmasterdata();
        if(empty($postdata['prop_lease_agreement_room_id'])){ $postdata['prop_lease_agreement_room_id'] =0; }
        $crm_lead_details_code = $this->mastermodel->get_ref('prop_lease_agreement_code', 'prop_lease_agreement', 'prop_lease_agreement_code');
        $tblValues = array(
            'prop_lease_agreement_id' => $main_masterid,
            'prop_lease_agreement_code'=>$crm_lead_details_code,
            'prop_lease_agreement_fdate' => $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_fdate']),
            'prop_lease_agreement_tdate' => $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_tdate']),
            'prop_lease_agreement_incharge' => $postdata['prop_lease_agreement_incharge'],
            'prop_lease_agreement_tenancy_number' => $postdata['prop_lease_agreement_tenancy_number'],
            'prop_lease_agreement_customer_id' => $postdata['prop_lease_agreement_customer_id'],
            'prop_lease_agreement_property_id' => $postdata['prop_lease_agreement_property_id'],
            'prop_lease_agreement_room_id' => $postdata['prop_lease_agreement_room_id'],
            'prop_lease_agreement_remarks' => $postdata['prop_lease_agreement_remarks'],
            'prop_lease_agreement_status' => $postdata['prop_lease_agreement_status'],
            'prop_lease_agreement_rent_amount' => $postdata['prop_lease_agreement_rent_amount'],
            'prop_lease_agreement_service_amount' => $postdata['prop_lease_agreement_service_amount'],
            'prop_lease_agreement_advance_rent_amount' => $postdata['prop_lease_agreement_advance_rent_amount'],
//             'prop_lease_agreement_due_amount' => $postdata['prop_lease_agreement_due_amount'],
            'prop_lease_agreement_advance_facilities_amount' => $postdata['prop_lease_agreement_advance_facilities_amount']
            );
        
        $this->db->insert('prop_lease_agreement', $tblValues);
        if(empty($postdata['prop_lease_agreement_room_id']))
        {
//        for udating property
            $this->db->set('buy_status', 3);
            $this->db->where('detail_id',$postdata['prop_lease_agreement_property_id']);
            $this->db->update('detail_entry');
        }else{
//        for editing property details
            $this->db->set('detail_entry_status','Rented');
            $this->db->where('detail_id',$postdata['prop_lease_agreement_property_id']);
            $this->db->where('detail_entry_dealing_details_id', $postdata['prop_lease_agreement_room_id']);
            $this->db->update('detail_entry_dealing_details');
        }
        $i=1;
        while(isset($postdata['prop_lease_agreement_reminder_subject'. $i]))
        { 
        
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $rem_tblValues = array(
            'prop_lease_agreement_reminder_id' => $sub_masterid,
            'prop_lease_agreement_reminder_lease_agreement_id' => $main_masterid,
            'prop_lease_agreement_reminder_date' =>  $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_reminder_date'. $i]),
            'prop_lease_agreement_reminder_before' => $postdata['prop_lease_agreement_reminder_before'. $i],
            'prop_lease_agreement_reminder_subject' => $postdata['prop_lease_agreement_reminder_subject'. $i],
            'prop_lease_agreement_reminder_description' => $postdata['prop_lease_agreement_reminder_description'. $i],
            );
            $this->db->insert('prop_lease_agreement_reminder', $rem_tblValues);
            $i++;
        }
      
        $i=1;
        while(isset($postdata['prop_lease_agreement_documents_document_id'. $i]))
        { 
            $document_id = $this->mastermodel->insertmasterdata();
            $doc_tblValues = array(
            'prop_lease_agreement_documents_id' => $document_id,
            'prop_lease_agreement_documents_lease_agreement_id' => $main_masterid,
            'prop_lease_agreement_documents_document_id' => $postdata['prop_lease_agreement_documents_document_id'. $i],
            );
            
            $upload_data = $this->mastermodel->upload_image('prop_lease_agreement_documents_filename'. $i);
            if (!empty($upload_data['file_name']))
            {
                $doc_tblValues['prop_lease_agreement_documents_filename'] = $upload_data['file_name'];
            }
            $this->db->insert('prop_lease_agreement_documents', $doc_tblValues);
            $i++;
        }
        
        $i=1;
        while(isset($postdata['prop_lease_payment_details_payment_mode'. $i]))
        { 
            $payment_id = $this->mastermodel->insertmasterdata();
            $pay_tblValues = array(
            'prop_lease_payment_details_id' => $payment_id,
            'prop_lease_payment_details_lease_agreement_id' => $main_masterid,
            'prop_lease_payment_details_payment_mode' => $postdata['prop_lease_payment_details_payment_mode'. $i],
            'prop_lease_payment_details_date' => $this->mastermodel->convert_date_format($postdata['prop_lease_payment_details_date'. $i]),
            'prop_lease_payment_details_amount' => $postdata['prop_lease_payment_details_amount'. $i],
            'prop_lease_payment_details_description' => $postdata['prop_lease_payment_details_description'. $i],
            );
            $this->db->insert('prop_lease_payment_details', $pay_tblValues);
            $i++;
        }
        
         $i=1;
        while(isset($postdata['facilities_payment_mode'. $i]))
        { 
            $payment_id = $this->mastermodel->insertmasterdata();
            $facilities_tblValues = array(
            'prop_lease_facilities_payment_id' => $payment_id,
            'prop_lease_facilities_payment_lease_agreement_id' => $main_masterid,
            'prop_lease_facilities_payment_payment_mode' => $postdata['facilities_payment_mode'. $i],
            'prop_lease_facilities_payment_date' => $this->mastermodel->convert_date_format($postdata['facilities_payment_date'. $i]),
            'prop_lease_facilities_payment_amount' => $postdata['facilities_payment_amount'. $i],
            'prop_lease_facilities_payment_description' => $postdata['facilities_payment_description'. $i],
            );
            $this->db->insert('prop_lease_facilities_payment', $facilities_tblValues);
            $i++;
        }
        
            $i=1;
        while(isset($postdata['service_payment_mode'. $i]))
        { 
            $payment_id = $this->mastermodel->insertmasterdata();
            $service_tblValues = array(
            'prop_lease_service_payment_id' => $payment_id,
            'prop_lease_service_payment_lease_agreement_id' => $main_masterid,
            'prop_lease_service_payment_payment_mode' => $postdata['service_payment_mode'. $i],
            'prop_lease_service_payment_date' => $this->mastermodel->convert_date_format($postdata['service_payment_date'. $i]),
            'prop_lease_service_payment_amount' => $postdata['service_payment_amount'. $i],
            'prop_lease_service_payment_description' => $postdata['service_payment_description'. $i],
            );
            $this->db->insert('prop_lease_service_payment', $service_tblValues);
            $i++;
        }
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     function update_lease_agreement($postdata)
    { 
        $data = array();
        $this->db->trans_begin();
       
        $crm_lead_details_code = $this->mastermodel->get_ref('prop_lease_agreement_code', 'prop_lease_agreement', 'prop_lease_agreement_code');
        $tblValues = array(
            'prop_lease_agreement_fdate' => $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_fdate']),
            'prop_lease_agreement_tdate' => $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_tdate']),
            'prop_lease_agreement_remarks' => $postdata['prop_lease_agreement_remarks'],
            'prop_lease_agreement_advance_rent_amount' => $postdata['prop_lease_agreement_advance_rent_amount'],
            'prop_lease_agreement_rent_amount' => $postdata['prop_lease_agreement_rent_amount'],
            'prop_lease_agreement_tenancy_number' => $postdata['prop_lease_agreement_tenancy_number'],
            'prop_lease_agreement_status' => $postdata['prop_lease_agreement_status'],
          
            'prop_lease_agreement_advance_facilities_amount' => $postdata['prop_lease_agreement_advance_facilities_amount'],
              'prop_lease_agreement_service_amount' => $postdata['prop_lease_agreement_service_amount'],
            );
        $this->db->where('prop_lease_agreement_id',$postdata['prop_lease_agreement_id']);
        $this->db->update('prop_lease_agreement', $tblValues);
//        echo $this->db->last_query();die();
        $this->db->where('prop_lease_agreement_reminder_lease_agreement_id',$postdata['prop_lease_agreement_id']);
        $this->db->delete('prop_lease_agreement_reminder');
        $i=1;
        while(isset($postdata['prop_lease_agreement_reminder_date'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $rem_tblValues = array(
            'prop_lease_agreement_reminder_id' => $sub_masterid,
            'prop_lease_agreement_reminder_lease_agreement_id' => $postdata['prop_lease_agreement_id'],
            'prop_lease_agreement_reminder_date' =>  $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_reminder_date'. $i]),
            'prop_lease_agreement_reminder_before' => $postdata['prop_lease_agreement_reminder_before'. $i],
            'prop_lease_agreement_reminder_subject' => $postdata['prop_lease_agreement_reminder_subject'. $i],
            'prop_lease_agreement_reminder_description' => $postdata['prop_lease_agreement_reminder_description'. $i],
            );
            $this->db->insert('prop_lease_agreement_reminder', $rem_tblValues);
            $i++;
        }
        $j=1;
        while(!empty($postdata['prop_lease_agreement_documents_filename'.$j]))
        {         
//            $document_id = $this->mastermodel->insertmasterdata();
//            $doc_tblValues = array(
////            'prop_lease_agreement_documents_id' => $document_id,
////            'prop_lease_agreement_documents_lease_agreement_id' => $postdata['prop_lease_agreement_id'],
////            'prop_lease_agreement_documents_document_id' => $postdata['prop_lease_agreement_documents_document_id'. $j],
//            );
            
            $upload_data = $this->mastermodel->upload_image('prop_lease_agreement_documents_filename'. $j);
            if (!empty($upload_data['file_name']))
            {
                $doc_tblValues['prop_lease_agreement_documents_filename'] = $upload_data['file_name'];
            }
//            $this->db->insert('prop_lease_agreement_documents', $doc_tblValues);
            
        $this->db->where('prop_lease_agreement_documents_id',$postdata['prop_lease_agreement_documents_id'. $j]);
        $this->db->update('prop_lease_agreement_documents', $doc_tblValues);
            $j++;
        }
        
         $this->db->where('prop_lease_payment_details_lease_agreement_id',$postdata['prop_lease_agreement_id']);
        $this->db->delete('prop_lease_payment_details');
        
            $this->db->where('prop_lease_facilities_payment_lease_agreement_id',$postdata['prop_lease_agreement_id']);
        $this->db->delete('prop_lease_facilities_payment');
        
            $this->db->where('prop_lease_service_payment_lease_agreement_id',$postdata['prop_lease_agreement_id']);
        $this->db->delete('prop_lease_service_payment');
        $k=1;
        while(isset($postdata['prop_lease_payment_details_payment_mode'. $k]))
        { 
            $payment_id = $this->mastermodel->insertmasterdata();
            $pay_tblValues = array(
            'prop_lease_payment_details_id' => $payment_id,
            'prop_lease_payment_details_lease_agreement_id' => $postdata['prop_lease_agreement_id'],
            'prop_lease_payment_details_payment_mode' => $postdata['prop_lease_payment_details_payment_mode'. $k],
            'prop_lease_payment_details_date' => $this->mastermodel->convert_date_format($postdata['prop_lease_payment_details_date'. $k]),
            'prop_lease_payment_details_amount' => $postdata['prop_lease_payment_details_amount'. $k],
            'prop_lease_payment_details_description' => $postdata['prop_lease_payment_details_description'. $k],
            );
            $this->db->insert('prop_lease_payment_details', $pay_tblValues);
            $k++;
        }
            $i=1;
        while(isset($postdata['facilities_payment_mode'. $i]))
        { 
            $payment_id = $this->mastermodel->insertmasterdata();
            $facilities_tblValues = array(
            'prop_lease_facilities_payment_id' => $payment_id,
            'prop_lease_facilities_payment_lease_agreement_id' => $postdata['prop_lease_agreement_id'],
            'prop_lease_facilities_payment_payment_mode' => $postdata['facilities_payment_mode'. $i],
            'prop_lease_facilities_payment_date' => $this->mastermodel->convert_date_format($postdata['facilities_payment_date'. $i]),
            'prop_lease_facilities_payment_amount' => $postdata['facilities_payment_amount'. $i],
            'prop_lease_facilities_payment_description' => $postdata['facilities_payment_description'. $i],
            );
            $this->db->insert('prop_lease_facilities_payment', $facilities_tblValues);
            $i++;
        }
        
            $i=1;
        while(isset($postdata['service_payment_mode'. $i]))
        { 
            $payment_id = $this->mastermodel->insertmasterdata();
            $service_tblValues = array(
            'prop_lease_service_payment_id' => $payment_id,
            'prop_lease_service_payment_lease_agreement_id' => $postdata['prop_lease_agreement_id'],
            'prop_lease_service_payment_payment_mode' => $postdata['service_payment_mode'. $i],
            'prop_lease_service_payment_date' => $this->mastermodel->convert_date_format($postdata['service_payment_date'. $i]),
            'prop_lease_service_payment_amount' => $postdata['service_payment_amount'. $i],
            'prop_lease_service_payment_description' => $postdata['service_payment_description'. $i],
            );
            $this->db->insert('prop_lease_service_payment', $service_tblValues);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function get_lease_data($id)
    {
        $this->db->select(array('sub_category_id','dealing_type_id'));
        $this->db->from('detail_entry');
        $this->db->join('master', 'master.master_id=detail_entry.detail_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where("detail_id",$id);
        $rst = $this->db->get()->result();
        return $rst;
    }
    function get_document($data)
    {
        $this->db->select(array('*'));
        $this->db->from('prop_sub_document_master');
        $this->db->where('prop_sub_document_master_sub_cat_id',$data[0]->sub_category_id);
        $this->db->where('prop_document_master_dealing_type_id',$data[0]->dealing_type_id);
        $this->db->join('prop_document_master', 'prop_document_master.prop_document_master_id = prop_sub_document_master.prop_sub_document_master_document_master_id');
        $this->db->join('master', 'master.master_id=prop_sub_document_master.prop_sub_document_master_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $rst = $this->db->get()->result();
        return $rst;
    }
    
      function search_circular()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_circular');
        
        $this->db->join('master', 'master.master_id=prop_circular.prop_circular_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_circular_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
      public function insert_circular($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_circular_id' => $masterid,
            'prop_circular_date' => $this->mastermodel->convert_date_format($postdata['prop_circular_date']),
            'prop_circular_detail_id' => $postdata['prop_circular_detail_id'],
            'prop_circular_user_id' => $postdata['prop_circular_user_id'],
            'prop_circular_remarks' => $postdata['prop_circular_remarks'],
            'prop_circular_content' => $postdata['prop_circular_content'],
            );
        $this->db->insert('prop_circular', $tblValues);
        
        $count_customer_id=  count($postdata['prop_sub_circular_customer_id']);
        if($count_customer_id != 0){
            for($i=0;$i < $count_customer_id;$i++){
                $sub_masterid = $this->mastermodel->insertmasterdata();
       
                $tblValues = array(
            'prop_sub_circular_id' => $sub_masterid,
            'prop_sub_circular_circular_id' => $masterid,
            'prop_sub_circular_customer_id' => $postdata['prop_sub_circular_customer_id'][$i], 
            );        
           $this->db->insert('prop_sub_circular', $tblValues);
            
        }
        }


        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    
        public function update_circular($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'prop_circular_date' => $this->mastermodel->convert_date_format($postdata['prop_circular_date']),
            'prop_circular_remarks' => $postdata['prop_circular_remarks'],
            'prop_circular_content' => $postdata['prop_circular_content'],
            );
          $this->db->where('prop_circular_id',$postdata['prop_circular_id']);
        $this->db->update('prop_circular', $tblValues);
       

        
        $this->db->where('prop_sub_circular_circular_id',$postdata['prop_circular_id']);
        $this->db->delete('prop_sub_circular');
        
        $count_customer_id=  count($postdata['prop_sub_circular_customer_id']);
        if($count_customer_id != 0){
            for($i=0;$i < $count_customer_id;$i++){
                $sub_masterid = $this->mastermodel->insertmasterdata();
       
                $tblValues = array(
            'prop_sub_circular_id' => $sub_masterid,
            'prop_sub_circular_circular_id' => $postdata['prop_circular_id'],
            'prop_sub_circular_customer_id' => $postdata['prop_sub_circular_customer_id'][$i], 
            );        
           $this->db->insert('prop_sub_circular', $tblValues);
            
        }
        }


        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    
     function search_lease_termination()
     {
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_lease_termination');
        
        $this->db->join('master', 'master.master_id=prop_lease_termination.prop_lease_termination_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_lease_termination_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
     }
     public function insert_lease_termination($postdata)
     {  
     
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_lease_termination_id' => $masterid,
            'prop_lease_termination_lease_agrement_id' => $postdata['prop_lease_termination_lease_agrement_id'],
            'prop_lease_termination_customer_id' => $postdata['prop_lease_termination_customer_id'],
            'prop_lease_termination_property_id' => $postdata['prop_lease_termination_property_id'],
            'prop_lease_termination_effective_date' => $this->mastermodel->convert_date_format($postdata['prop_lease_termination_effective_date']),
            'prop_lease_termination_status' => $postdata['prop_lease_termination_status'],
            'prop_lease_termination_deduction_amount' => $postdata['prop_lease_termination_deduction_amount']
            );
        $this->db->insert('prop_lease_termination', $tblValues);
        
        $tblValues = array(
            
            'prop_lease_agreement_termination' => 1,
            
            );

        
        $this->db->where('prop_lease_agreement_id',$postdata['prop_lease_termination_lease_agrement_id']);
        
          $this->db->update('prop_lease_agreement', $tblValues);
         
      
        
//        if($this->mastermodel->get_single_field_value('prop_lease_agreement','prop_lease_agreement_room_id','prop_lease_agreement_id',$postdata['prop_lease_termination_lease_agrement_id']) != 0)
//        {
//            $this->db->set('detail_entry_status','Available');
//            $this->db->where('detail_id',$postdata['prop_lease_termination_property_id']);
//            $this->db->where('detail_entry_dealing_details_id', $this->mastermodel->get_single_fieldelvalue('prop_lease_agreement','prop_lease_agreement_room_id','prop_lease_agreement_id',$postdata['prop_lease_termination_lease_agrement_id']));
//            $this->db->update('detail_entry_dealing_details');
//        } else{
//            
////          for udating property
//            $this->db->set('buy_status', 0);
//            $this->db->where('detail_id',$postdata['prop_lease_termination_property_id']);
//            $this->db->update('detail_entry');
//        }
//        edit code
        $j=1;
        while(!empty($postdata['asset'][$j])){
            
            
         

             $sbid = $this->mastermodel->insertmasterdata();
             $subvalues=array(
                 'prop_termination_asset_id' => $sbid,
                 'prop_termination_asset_lease_termination_id' => $masterid,
                 'prop_termination_item_id' => $postdata['asset'][$j],
                 'prop_termination_asset_remarks' => $postdata['prop_termination_asset_remarks'.$j],
             );
           
                 $this->db->insert('prop_termination_asset',$subvalues);
           
            
       $j++;
        }
      
       
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
     }
     public function update_lease_termination($postdata)
     {    
        $data = array();
        $this->db->trans_begin();
        
        $tblValues = array(
            'prop_lease_termination_lease_agrement_id' => $postdata['prop_lease_termination_lease_agrement_id'],
            'prop_lease_termination_customer_id' => $postdata['prop_lease_termination_customer_id'],
            'prop_lease_termination_property_id' => $postdata['prop_lease_termination_property_id'],
            'prop_lease_termination_effective_date' => $this->mastermodel->convert_date_format($postdata['prop_lease_termination_effective_date']),
            'prop_lease_termination_status' => $postdata['prop_lease_termination_status'],
            'prop_lease_termination_deduction_amount' => $postdata['prop_lease_termination_deduction_amount']
            );
        $this->db->where('prop_lease_termination_id',$postdata['prop_lease_termination_id']);
        $this->db->update('prop_lease_termination', $tblValues);
        
          $tblValues = array(
            
            'prop_lease_agreement_termination' => 1,
            
            );
          $this->db->where('prop_lease_agreement_id',$postdata['prop_lease_termination_lease_agrement_id']);
        $this->db->update('prop_lease_agreement', $tblValues);
        
        $j=1;
        $this->db->where('prop_termination_asset_lease_termination_id',$postdata['prop_lease_termination_id']);
        $this->db->delete('prop_termination_asset');
         while(!empty($postdata['prop_termination_item_id'][$j])){
             $sbid = $this->mastermodel->insertmasterdata();
             $subvalues=array(
                 'prop_termination_asset_id' => $sbid,
                 'prop_termination_asset_lease_termination_id' => $postdata['prop_lease_termination_id'],
                'prop_termination_item_id' => $postdata['prop_termination_item_id'][$j],
                 'prop_termination_asset_remarks' => $postdata['prop_termination_asset_remarks'.$j],
                );
                 $this->db->insert('prop_termination_asset',$subvalues);
                 $j++;
            }
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
     }
         function search_rent_collection()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_rent_collection');
        $this->db->join('master', 'master.master_id=prop_rent_collection.prop_rent_collection_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_rent_collection_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_rent_collection($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
//        var_dump($postdata);die();
        $tblValues = array(
            'prop_rent_collection_id' => $masterid,
            'prop_rent_collection_lease_agreement_id' => $postdata['prop_rent_collection_lease_agreement_id'],
            'prop_rent_collection_date' => $this->mastermodel->convert_date_format($postdata['prop_rent_collection_date']),
            
            'prop_rent_collection_customer_id' => $postdata['prop_rent_collection_customer_id'],
            'prop_rent_collection_details_id' => $postdata['prop_rent_collection_details_id'],
            );
        $this->db->insert('prop_rent_collection', $tblValues);
        $j=1;
         while(!empty($postdata['payment_mode'.$j])){
             $sbid = $this->mastermodel->insertmasterdata();
             $subvalues=array(
                 'prop_rent_collection_payment_details_id' => $sbid,
                 'prop_rent_collection_payment_details_rent_collection_id' => $masterid,
                 'prop_rent_collection_payment_details_lease_payment_details_id' => $postdata['prop_rent_collection_payment_details_lease_payment_details_id'.$j],
                'prop_rent_collection_payment_details_paid_amt' => $postdata['prop_rent_paid_amount'.$j],
                 'prop_rent_collection_payment_details_paid_date' => $this->mastermodel->convert_date_format($postdata['prop_rent_paid_date'.$j]),
                'prop_rent_collection_payment_details_paid_balance'=>$postdata['balance'.$j],
                 'prop_rent_collection_payment_details_remarks'=>$postdata['details_remarks'.$j],
                 'prop_rent_collection_payment_details_to_be_paid_amt'=>$postdata['details_amount'.$j],
                 );
                 $this->db->insert('prop_rent_collection_payment_details',$subvalues);
                 $j++;
            }
              $n=1;
         while(!empty($postdata['payment_mode_service'.$n])){
             $sbid_service = $this->mastermodel->insertmasterdata();
             $subvalues=array(
                 'prop_rent_collection_service_details_id' => $sbid_service,
                 'prop_rent_collection_service_details_rent_collection_id' => $masterid,
                 'prop_rent_collection_service_details_lease_service_details_id' => $postdata['prop_rent_collection_service_details_lease_service_details_id'.$n],
                'prop_rent_collection_service_details_paid_amt' => $postdata['prop_rent_paid_amount_service'.$n],
                 'prop_rent_collection_service_details_paid_date' => $this->mastermodel->convert_date_format($postdata['prop_rent_paid_date_service'.$n]),
               'prop_rent_collection_service_details_paid_balance'=>$postdata['balance_service'.$n],
                   'prop_rent_collection_service_details_remarks'=>$postdata['remarks_service'.$n],
                 'prop_rent_collection_service_details_to_be_paid_amt'=>$postdata['details_amount_service'.$n],
                     );
                 $this->db->insert('prop_rent_collection_service_details',$subvalues);
                 $n++;
            }
             $m=1;
         while(!empty($postdata['payment_mode_facilities'.$m])){
             $sbid_facilities = $this->mastermodel->insertmasterdata();
             $subvalues=array(
                 'prop_rent_collection_facilities_details_id' => $sbid_facilities,
                 'prop_rent_collection_facilities_details_rent_collection_id' => $masterid,
                 'prop_rent_collection_facilities_details_lease_facilit_details_id' => $postdata['prop_rent_collection_facilities_details_lease_facilit_details_id'.$m],
                'prop_rent_collection_facilities_details_paid_amt' => $postdata['prop_rent_paid_amount_facilities'.$m],
                 'prop_rent_collection_facilities_details_paid_date' => $this->mastermodel->convert_date_format($postdata['prop_rent_paid_date_facilities'.$m]),
                'prop_rent_collection_facilities_details_paid_balance'=>$postdata['balance_facilities'.$m],
                  'prop_rent_collection_facilities_details_remarks'=>$postdata['remarks_facilities'.$m],
                 'prop_rent_collection_facilities_details_to_be_paid_amt'=>$postdata['details_amount_facilities'.$m],
                 );
                 $this->db->insert('prop_rent_collection_facilities_details',$subvalues);
                 $m++;
            }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    public function update_rent_collection($postdata)
    {     
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'prop_rent_collection_date' => $this->mastermodel->convert_date_format($postdata['prop_rent_collection_date']),
        );
        
        $this->db->where('prop_rent_collection_id', $postdata['prop_rent_collection_id']);
        $this->db->update('prop_rent_collection', $tblValues);
        
        $j=1;
        while(!empty($postdata['prop_rent_collection_payment_details_id'.$j])){
            $subvalues=array(
                'prop_rent_collection_payment_details_paid_amt' => $postdata['prop_rent_paid_amount'.$j],
                'prop_rent_collection_payment_details_paid_balance'=>$postdata['balance'.$j],
                'prop_rent_collection_payment_details_to_be_paid_amt'=>$postdata['details_amount'.$j],
                'prop_rent_collection_payment_details_paid_date' => $this->mastermodel->convert_date_format($postdata['prop_rent_paid_date'.$j]),
                'prop_rent_collection_payment_details_remarks'=>$postdata['details_remarks'.$j],
                    );
               $this->db->where('prop_rent_collection_payment_details_id', $postdata['prop_rent_collection_payment_details_id'.$j]);
               $this->db->update('prop_rent_collection_payment_details', $subvalues);
                $j++;
           }
           $k=1;
        while(!empty($postdata['prop_rent_collection_service_details_id'.$k])){
            $subvalues=array(
                'prop_rent_collection_service_details_paid_amt' => $postdata['prop_rent_paid_amount_service'.$k],
                'prop_rent_collection_service_details_paid_balance'=>$postdata['balance_service'.$k],
                 'prop_rent_collection_service_details_to_be_paid_amt'=>$postdata['details_amount_service'.$k],
                'prop_rent_collection_service_details_paid_date' => $this->mastermodel->convert_date_format($postdata['prop_rent_paid_date_service'.$k]),
                'prop_rent_collection_service_details_remarks'=>$postdata['remarks_service'.$k],
                );
               $this->db->where('prop_rent_collection_service_details_id', $postdata['prop_rent_collection_service_details_id'.$k]);
               $this->db->update('prop_rent_collection_service_details', $subvalues);
                $k++;
           }
           $l=1;
        while(!empty($postdata['prop_rent_collection_facilities_details_id'.$l])){
            $subvalues=array(
                'prop_rent_collection_facilities_details_paid_amt' => $postdata['prop_rent_paid_amount_facilities'.$l],
                'prop_rent_collection_facilities_details_paid_balance'=>$postdata['balance_facilities'.$l],
                 'prop_rent_collection_facilities_details_to_be_paid_amt'=>$postdata['details_amount_facilities'.$l],
                'prop_rent_collection_facilities_details_paid_date' => $this->mastermodel->convert_date_format($postdata['prop_rent_paid_date_facilities'.$l]),
                'prop_rent_collection_facilities_details_remarks'=>$postdata['remarks_facilities'.$l],
                );
               $this->db->where('prop_rent_collection_facilities_details_id', $postdata['prop_rent_collection_facilities_details_id'.$l]);
               $this->db->update('prop_rent_collection_facilities_details', $subvalues);
                $l++;
           }
           
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_legal_notice()
     {
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_legal_notice');
        $this->db->join('master', 'master.master_id=prop_legal_notice.prop_legal_notice_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_legal_notice_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
     }
     public function insert_legal_notice($postdata)
     {  
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_legal_notice_id' => $masterid,
            'prop_legal_notice_date' => $this->mastermodel->convert_date_format($postdata['prop_legal_notice_date']),
            'prop_legal_notice_notice_name' => $postdata['prop_legal_notice_notice_name'],
            'prop_legal_notice_incharge' => $postdata['prop_legal_notice_incharge'],
            'prop_legal_notice_customer_id' => $postdata['prop_legal_notice_customer_id'],
            'prop_legal_notice_property_id' => $postdata['prop_legal_notice_property_id'],
            'prop_legal_notice_detail_entry_dealing_details_id' => $postdata['prop_legal_notice_detail_entry_dealing_details_id'],
            'prop_legal_notice_issued_by' => $postdata['prop_legal_notice_issued_by'],
            'prop_legal_notice_notice_no' => $postdata['prop_legal_notice_notice_no'],
            'prop_legal_notice_notes' => $postdata['prop_legal_notice_notes']
            );
        
        $upload_data = $this->mastermodel->upload_image('prop_legal_notice_file');
        if (!empty($upload_data['file_name']))
        {
            $tblValues['prop_legal_notice_file'] = $upload_data['file_name'];
        }
        $this->db->insert('prop_legal_notice', $tblValues);
        
        $j=1;
        while(!empty($postdata['prop_sub_legal_notice_email'.$j]))
        {
            $sbid = $this->mastermodel->insertmasterdata();
             $subvalues=array(
                'prop_sub_legal_notice_id' => $sbid,
                'prop_sub_legal_notice_legal_notice_id	' => $masterid,
                'prop_sub_legal_notice_email' => $postdata['prop_sub_legal_notice_email'.$j]
             );
           
                $this->db->insert('prop_sub_legal_notice',$subvalues);
                $j++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
     }
     public function update_legal_notice($postdata)
     {   
        $data = array();
        $this->db->trans_begin();
        
        $tblValues = array(
            'prop_legal_notice_date' => $this->mastermodel->convert_date_format($postdata['prop_legal_notice_date']),
            'prop_legal_notice_notice_name' => $postdata['prop_legal_notice_notice_name'],
            'prop_legal_notice_issued_by' => $postdata['prop_legal_notice_issued_by'],
            'prop_legal_notice_notice_no' => $postdata['prop_legal_notice_notice_no'],
            'prop_legal_notice_notes' => $postdata['prop_legal_notice_notes']
            );
        
        $upload_data = $this->mastermodel->upload_image('prop_legal_notice_file');
        if (!empty($upload_data['file_name']))
        {
            $tblValues['prop_legal_notice_file'] = $upload_data['file_name'];
        }
        
        $this->db->where('prop_legal_notice_id',$postdata['prop_legal_notice_id']);
        $this->db->update('prop_legal_notice', $tblValues);
        
        $this->db->where('prop_sub_legal_notice_legal_notice_id',$postdata['prop_legal_notice_id']);
        $this->db->delete('prop_sub_legal_notice');
        $j=1;
        while(!empty($postdata['prop_sub_legal_notice_email'.$j]))
        {
            $sbid = $this->mastermodel->insertmasterdata();
             $subvalues=array(
                'prop_sub_legal_notice_id' => $sbid,
                'prop_sub_legal_notice_legal_notice_id	' => $postdata['prop_legal_notice_id'],
                'prop_sub_legal_notice_email' => $postdata['prop_sub_legal_notice_email'.$j]
             );
           
                $this->db->insert('prop_sub_legal_notice',$subvalues);
                $j++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
     }
     function search_penalty()
     {
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_penalty');
        $this->db->join('master', 'master.master_id=prop_penalty.prop_penalty_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_penalty_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
     }  
      public function insert_penalty($postdata)
     {  
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_penalty_id' => $masterid,
            'prop_penalty_date' => $this->mastermodel->convert_date_format($postdata['prop_penalty_date']),
            'prop_penalty_name' => $postdata['prop_penalty_name'],
            'prop_penalty_user_id' => $postdata['prop_penalty_user_id'],
            'prop_penalty_customer' => $postdata['prop_penalty_customer'],
            'prop_penalty_details_id' => $postdata['prop_penalty_details_id'],
            'prop_penalty_dealing_details_id' => $postdata['prop_penalty_dealing_details_id'],
            'prop_penalty_dealing_amount' => $postdata['prop_penalty_dealing_amount'],
            'prop_penalty_type' => $postdata['prop_penalty_type'],
            'prop_penalty_note' => $postdata['prop_penalty_note']
            );
        
        $this->db->insert('prop_penalty', $tblValues);
        
        $j=1;
        while(!empty($postdata['prop_penalty_email_mail'.$j]))
        {
            $email_id = $this->mastermodel->insertmasterdata();
             $subvalues=array(
                'prop_penalty_email_id' => $email_id,
                'prop_penalty_email_penalty_id' => $masterid,
                'prop_penalty_email_mail' => $postdata['prop_penalty_email_mail'.$j]
             );
           
                $this->db->insert('prop_penalty_email',$subvalues);
                $j++;
        }
        $k=1;
        while(!empty($postdata['prop_penalty_payment_mode'.$k]))
        {
            $payment_id = $this->mastermodel->insertmasterdata();
             $subvalues=array(
                'prop_penalty_payment_id' => $payment_id,
                'prop_penalty_payment_penalty_id' => $masterid,
                'prop_penalty_payment_mode' => $postdata['prop_penalty_payment_mode'.$k],
                'prop_penalty_payment_date' => $this->mastermodel->convert_date_format($postdata['prop_penalty_payment_date'.$k]),
                'prop_penalty_payment_amount' => $postdata['prop_penalty_payment_amount'.$k],
                'prop_penalty_payment_description' => $postdata['prop_penalty_payment_description'.$k],
             );
           
                $this->db->insert('prop_penalty_payment',$subvalues);
                $k++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
     }
      public function update_penalty($postdata)
     {  
        $data = array();
        $this->db->trans_begin();
       
        $tblValues = array(
            'prop_penalty_date' => $this->mastermodel->convert_date_format($postdata['prop_penalty_date']),
            'prop_penalty_name' => $postdata['prop_penalty_name'],
            'prop_penalty_customer' => $postdata['prop_penalty_customer'],
            'prop_penalty_dealing_amount' => $postdata['prop_penalty_dealing_amount'],
            'prop_penalty_type' => $postdata['prop_penalty_type'],
            'prop_penalty_note' => $postdata['prop_penalty_note']
            );
        $this->db->where('prop_penalty_id',$postdata['prop_penalty_id']);
        $this->db->update('prop_penalty', $tblValues);
        
        $this->db->where('prop_penalty_email_penalty_id',$postdata['prop_penalty_id']);
        $this->db->delete('prop_penalty_email');
        
        $this->db->where('prop_penalty_payment_penalty_id',$postdata['prop_penalty_id']);
        $this->db->delete('prop_penalty_payment');
        $j=1;
        while(!empty($postdata['prop_penalty_email_mail'.$j]))
        {
            $email_id = $this->mastermodel->insertmasterdata();
             $subvalues=array(
                'prop_penalty_email_id' => $email_id,
                'prop_penalty_email_penalty_id' => $postdata['prop_penalty_id'],
                'prop_penalty_email_mail' => $postdata['prop_penalty_email_mail'.$j]
             );
           
                $this->db->insert('prop_penalty_email',$subvalues);
                $j++;
        }
        $k=1;
        while(!empty($postdata['prop_penalty_payment_mode'.$k]))
        {
            $payment_id = $this->mastermodel->insertmasterdata();
             $subvalues=array(
                'prop_penalty_payment_id' => $payment_id,
                'prop_penalty_payment_penalty_id' => $postdata['prop_penalty_id'],
                'prop_penalty_payment_mode' => $postdata['prop_penalty_payment_mode'.$k],
                'prop_penalty_payment_date' => $this->mastermodel->convert_date_format($postdata['prop_penalty_payment_date'.$k]),
                'prop_penalty_payment_amount' => $postdata['prop_penalty_payment_amount'.$k],
                'prop_penalty_payment_description' => $postdata['prop_penalty_payment_description'.$k],
             );
           
                $this->db->insert('prop_penalty_payment',$subvalues);
                $k++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
     }
      function search_renew_lease_agreement()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_lease_agreement');
        $this->db->where('prop_lease_agreement.prop_lease_agreement_id not in ','(select lease.prop_lease_agreement_parent from prop_lease_agreement lease)',false);
        $this->db->join('master', 'master.master_id=prop_lease_agreement.prop_lease_agreement_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_lease_agreement_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
      function update_renew_lease_agreement($postdata)
    { 
        $data = array();
        $this->db->trans_begin();
        $main_masterid = $this->mastermodel->insertmasterdata();
        if(empty($postdata['prop_lease_agreement_room_id'])){ $postdata['prop_lease_agreement_room_id'] =0; }
        $tblValues = array(
            'prop_lease_agreement_id' => $main_masterid,
            'prop_lease_agreement_code'=> $postdata['prop_lease_agreement_code'],
            'prop_lease_agreement_fdate' => $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_fdate']),
            'prop_lease_agreement_tdate' => $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_tdate']),
            'prop_lease_agreement_incharge' => $postdata['prop_lease_agreement_incharge'],
            'prop_lease_agreement_customer_id' => $postdata['prop_lease_agreement_customer_id'],
            'prop_lease_agreement_property_id' => $postdata['prop_lease_agreement_property_id'],
//            'prop_lease_agreement_room_id' => $postdata['prop_lease_agreement_room_id'],
            'prop_lease_agreement_remarks' => $postdata['prop_lease_agreement_remarks'],
            'prop_lease_agreement_status' => $postdata['prop_lease_agreement_status'],
            'prop_lease_agreement_count' => $postdata['prop_lease_agreement_count'],
            'prop_lease_agreement_parent' => $postdata['prop_lease_agreement_parent'],
            'prop_lease_agreement_rent_amount' => $postdata['prop_lease_agreement_rent_amount'],
            'prop_lease_agreement_service_amount' => $postdata['prop_lease_agreement_service_amount'],
            'prop_lease_agreement_advance_rent_amount' => $postdata['prop_lease_agreement_advance_rent_amount'],
            'prop_lease_agreement_tenancy_number' => $postdata['prop_lease_agreement_tenancy_number'],
            );
        
        $this->db->insert('prop_lease_agreement', $tblValues);
        $i=1;
        while(isset($postdata['prop_lease_agreement_reminder_date'. $i]))
        { 
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $rem_tblValues = array(
            'prop_lease_agreement_reminder_id' => $sub_masterid,
            'prop_lease_agreement_reminder_lease_agreement_id' => $main_masterid,
            'prop_lease_agreement_reminder_date' =>  $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_reminder_date'. $i]),
            'prop_lease_agreement_reminder_before' => $postdata['prop_lease_agreement_reminder_before'. $i],
            'prop_lease_agreement_reminder_subject' => $postdata['prop_lease_agreement_reminder_subject'. $i],
            'prop_lease_agreement_reminder_description' => $postdata['prop_lease_agreement_reminder_description'. $i],
            );
            $this->db->insert('prop_lease_agreement_reminder', $rem_tblValues);
            $i++;
        }
        
        $i=1;
        while(isset($postdata['prop_lease_agreement_documents_document_id'. $i]))
        {           
            $document_id = $this->mastermodel->insertmasterdata();
            $doc_tblValues = array(
            'prop_lease_agreement_documents_id' => $document_id,
            'prop_lease_agreement_documents_lease_agreement_id' => $main_masterid,
            'prop_lease_agreement_documents_document_id' => $postdata['prop_lease_agreement_documents_document_id'. $i],
            );
            
            $upload_data = $this->mastermodel->upload_image('prop_lease_agreement_documents_filename'. $i);
            if (!empty($upload_data['file_name']))
            {
                $doc_tblValues['prop_lease_agreement_documents_filename'] = $upload_data['file_name'];
            }
            else{
                $doc_tblValues['prop_lease_agreement_documents_filename'] = $postdata['prev_file_name'.$i];
            }
            $this->db->insert('prop_lease_agreement_documents', $doc_tblValues);
            $i++;
        }
        
        $i=1;
        while(isset($postdata['prop_lease_payment_details_payment_mode'. $i]))
        { 
            $payment_id = $this->mastermodel->insertmasterdata();
            $pay_tblValues = array(
            'prop_lease_payment_details_id' => $payment_id,
            'prop_lease_payment_details_lease_agreement_id' => $main_masterid,
            'prop_lease_payment_details_payment_mode' => $postdata['prop_lease_payment_details_payment_mode'. $i],
            'prop_lease_payment_details_date' => $this->mastermodel->convert_date_format($postdata['prop_lease_payment_details_date'. $i]),
            'prop_lease_payment_details_amount' => $postdata['prop_lease_payment_details_amount'. $i],
            'prop_lease_payment_details_description' => $postdata['prop_lease_payment_details_description'. $i],
            );
            $this->db->insert('prop_lease_payment_details', $pay_tblValues);
            $i++;
        }
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
     function update_new_renew_lease_agreement($postdata)
    { 
        $data = array();
       
        $this->db->trans_begin();
        $main_masterid = $this->mastermodel->insertmasterdata();
        if(empty($postdata['prop_lease_agreement_room_id'])){ $postdata['prop_lease_agreement_room_id'] =0; }
       
        $tblValues = array(
            'prop_lease_agreement_id' => $main_masterid,
             'prop_lease_agreement_code'=> $postdata['prop_lease_agreement_code'],
            'prop_lease_agreement_fdate' => $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_fdate']),
            'prop_lease_agreement_tdate' => $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_tdate']),
            'prop_lease_agreement_incharge' => $postdata['prop_lease_agreement_incharge'],
            'prop_lease_agreement_tenancy_number' => $postdata['prop_lease_agreement_tenancy_number'],
            'prop_lease_agreement_customer_id' => $postdata['prop_lease_agreement_customer_id'],
            'prop_lease_agreement_property_id' => $postdata['prop_lease_agreement_property_id'],
            'prop_lease_agreement_room_id' => $postdata['prop_lease_agreement_room_id'],
            'prop_lease_agreement_remarks' => $postdata['prop_lease_agreement_remarks'],
            'prop_lease_agreement_status' => $postdata['prop_lease_agreement_status'],
            'prop_lease_agreement_rent_amount' => $postdata['prop_lease_agreement_rent_amount'],
            'prop_lease_agreement_service_amount' => $postdata['prop_lease_agreement_service_amount'],
            'prop_lease_agreement_advance_rent_amount' => $postdata['prop_lease_agreement_advance_rent_amount'],
//             'prop_lease_agreement_due_amount' => $postdata['prop_lease_agreement_due_amount'],
            'prop_lease_agreement_advance_facilities_amount' => $postdata['prop_lease_agreement_advance_facilities_amount'],
            'prop_lease_agreement_count' => $postdata['prop_lease_agreement_count'],
            'prop_lease_agreement_parent' => $postdata['prop_lease_agreement_parent'],
            );
        
        $this->db->insert('prop_lease_agreement', $tblValues);
       
        $i=1;
        while(isset($postdata['prop_lease_agreement_reminder_subject'. $i]))
        { 
        
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $rem_tblValues = array(
            'prop_lease_agreement_reminder_id' => $sub_masterid,
            'prop_lease_agreement_reminder_lease_agreement_id' => $main_masterid,
            'prop_lease_agreement_reminder_date' =>  $this->mastermodel->convert_date_format($postdata['prop_lease_agreement_reminder_date'. $i]),
            'prop_lease_agreement_reminder_before' => $postdata['prop_lease_agreement_reminder_before'. $i],
            'prop_lease_agreement_reminder_subject' => $postdata['prop_lease_agreement_reminder_subject'. $i],
            'prop_lease_agreement_reminder_description' => $postdata['prop_lease_agreement_reminder_description'. $i],
            );
            $this->db->insert('prop_lease_agreement_reminder', $rem_tblValues);
            $i++;
        }
      
        $i=1;
        while(isset($postdata['prop_lease_agreement_documents_document_id'. $i]))
        { 
            $document_id = $this->mastermodel->insertmasterdata();
            $doc_tblValues = array(
            'prop_lease_agreement_documents_id' => $document_id,
            'prop_lease_agreement_documents_lease_agreement_id' => $main_masterid,
            'prop_lease_agreement_documents_document_id' => $postdata['prop_lease_agreement_documents_document_id'. $i],
            );
            
            $upload_data = $this->mastermodel->upload_image('prop_lease_agreement_documents_filename'. $i);
            if (!empty($upload_data['file_name']))
            {
                $doc_tblValues['prop_lease_agreement_documents_filename'] = $upload_data['file_name'];
            }
            $this->db->insert('prop_lease_agreement_documents', $doc_tblValues);
            $i++;
        }
        
        $i=1;
        while(isset($postdata['prop_lease_payment_details_payment_mode'. $i]))
        { 
            $payment_id = $this->mastermodel->insertmasterdata();
            $pay_tblValues = array(
            'prop_lease_payment_details_id' => $payment_id,
            'prop_lease_payment_details_lease_agreement_id' => $main_masterid,
            'prop_lease_payment_details_payment_mode' => $postdata['prop_lease_payment_details_payment_mode'. $i],
            'prop_lease_payment_details_date' => $this->mastermodel->convert_date_format($postdata['prop_lease_payment_details_date'. $i]),
            'prop_lease_payment_details_amount' => $postdata['prop_lease_payment_details_amount'. $i],
            'prop_lease_payment_details_description' => $postdata['prop_lease_payment_details_description'. $i],
            );
            $this->db->insert('prop_lease_payment_details', $pay_tblValues);
            $i++;
        }
        
         $i=1;
        while(isset($postdata['facilities_payment_mode'. $i]))
        { 
            $payment_id = $this->mastermodel->insertmasterdata();
            $facilities_tblValues = array(
            'prop_lease_facilities_payment_id' => $payment_id,
            'prop_lease_facilities_payment_lease_agreement_id' => $main_masterid,
            'prop_lease_facilities_payment_payment_mode' => $postdata['facilities_payment_mode'. $i],
            'prop_lease_facilities_payment_date' => $this->mastermodel->convert_date_format($postdata['facilities_payment_date'. $i]),
            'prop_lease_facilities_payment_amount' => $postdata['facilities_payment_amount'. $i],
            'prop_lease_facilities_payment_description' => $postdata['facilities_payment_description'. $i],
            );
            $this->db->insert('prop_lease_facilities_payment', $facilities_tblValues);
            $i++;
        }
        
            $i=1;
        while(isset($postdata['service_payment_mode'. $i]))
        { 
            $payment_id = $this->mastermodel->insertmasterdata();
            $service_tblValues = array(
            'prop_lease_service_payment_id' => $payment_id,
            'prop_lease_service_payment_lease_agreement_id' => $main_masterid,
            'prop_lease_service_payment_payment_mode' => $postdata['service_payment_mode'. $i],
            'prop_lease_service_payment_date' => $this->mastermodel->convert_date_format($postdata['service_payment_date'. $i]),
            'prop_lease_service_payment_amount' => $postdata['service_payment_amount'. $i],
            'prop_lease_service_payment_description' => $postdata['service_payment_description'. $i],
            );
            $this->db->insert('prop_lease_service_payment', $service_tblValues);
            $i++;
        }
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function search_item_stock()
    {
      $data = array();
        $this->db->select('*');
        $this->db->from('prop_item_stock');
        $this->db->join('item_master','item_master.item_master_id=prop_item_stock.prop_item_id');
        $this->db->join('godown','godown.godown_id=prop_item_stock.prop_godown_id');
        
        $this->db->join('master', 'master.master_id=prop_item_stock.prop_item_stock_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('prop_item_stock.prop_item_stock_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;  
    }
     function get_item($godown_id)
    {
      $data = array();
        $this->db->select('*');
        $this->db->from('prop_item_stock');
        $this->db->join('item_master','item_master.item_master_id=prop_item_stock.prop_item_id');
        $this->db->join('godown','godown.godown_id=prop_item_stock.prop_godown_id');
        $this->db->where('prop_item_stock.prop_godown_id',$godown_id);
        $this->db->order_by('prop_item_stock.prop_item_stock_id', 'desc');
        $data= $this->db->get()->result();
//        echo $this->db->last_query();die();
        return $data;  
    }
    function get_room_no($p_id,$c_id)
    {
        $this->db->select('*');
        $this->db->from('prop_lease_agreement');
        $this->db->where('prop_lease_agreement_property_id',$p_id);
        $this->db->where('prop_lease_agreement_customer_id',$c_id);
        $this->db->where('prop_lease_agreement.prop_lease_agreement_id not in ','(select lease.prop_lease_agreement_parent from prop_lease_agreement lease)',false);
        $this->db->join('detail_entry_dealing_details', 'detail_entry_dealing_details_id = prop_lease_agreement.prop_lease_agreement_room_id');
        $this->db->join('master', 'master.master_id=prop_lease_agreement.prop_lease_agreement_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $data = $this->db->get()->result();
        return $data;
    }
    function puchase_edit_stock($id,$quantity)
    {
        
          $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $quantity, false);
            $this->db->where('prop_item_stock_id', $id);
            $this->db->update('prop_item_stock');
    }
    function transfer_edit_stock($id,$quantity,$fromgodown,$togodown)
    {
       
          $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $quantity, false);
            $this->db->where('prop_item_id', $id);
            $this->db->where('prop_godown_id', $togodown);
            $this->db->update('prop_item_stock');
            
              $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $quantity, false);
            $this->db->where('prop_item_id', $id);
            $this->db->where('prop_godown_id', $fromgodown);
            $this->db->update('prop_item_stock');
    }
    function damage_edit_stock($id,$quantity,$godown)
    {
       
         
            
              $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $quantity, false);
            $this->db->where('prop_item_id', $id);
            $this->db->where('prop_godown_id', $godown);
            $this->db->update('prop_item_stock');
    }
    function get_item_datails($stock_id,$fg_id,$tg_id)
    {   
        $data['result'] = 0;
        $item_id = $this->mastermodel->get_single_field_value('prop_item_stock','prop_item_id','prop_item_stock_id',$stock_id);
       $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$stock_id,'prop_item_stock_id');
        if(!empty($item_id))
        {
            $this->db->select('item_parchasing_rate');
            $this->db->from('item_master');
            $this->db->where('item_master_id', $item_id);
            $data['item_price'] = $this->db->get()->row();
              $data['price'] = $stock_detailes->price;
            if(!empty($fg_id))
            {
                $this->db->select('prop_item_stock_qty');
                $this->db->from('prop_item_stock');
                $this->db->where('prop_item_stock_id', $stock_id);
                $data['fg_stock'] = $this->db->get()->row();
            }
            if(!empty($tg_id))
            {
                $this->db->select('prop_item_stock_qty');
                $this->db->from('prop_item_stock');
                $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
                 $this->db->where('prop_godown_id', $tg_id);
                  $this->db->where('price', $stock_detailes->price);
                $data['tg_stock'] =  $this->db->get()->row();
                
            }
        }
        return $data;
    }
     function get_item_datail($stock_id,$fg_id,$tg_id)
    {   
        $data['result'] = 0;
        $item_id = $this->mastermodel->get_single_field_value('prop_item_stock','prop_item_id','prop_item_stock_id',$stock_id);
       $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$stock_id,'prop_item_stock_id');
        if(!empty($item_id))
        {
            $this->db->select('item_parchasing_rate');
            $this->db->from('item_master');
            $this->db->where('item_master_id', $item_id);
            $data['item_price'] = $this->db->get()->row();
              $data['price'] = $stock_detailes->price;
            if(!empty($fg_id))
            {
                
                 $this->db->select('prop_item_stock_qty');
                $this->db->from('prop_item_stock');
                $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
                 $this->db->where('prop_godown_id', $fg_id);
                  $this->db->where('price', $stock_detailes->price);
                  $data['fg_stock'] = $this->db->get()->row();
                
               
            }
            if(!empty($tg_id))
            {
                 $this->db->select('prop_item_stock_qty');
                $this->db->from('prop_item_stock');
                $this->db->where('prop_item_stock_id', $stock_id);
              
               
                $data['tg_stock'] =  $this->db->get()->row();
                
            }
        }
        return $data;
    }
    function search_agency()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('agency');
        $this->db->join('master', 'master.master_id=agency.agency_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('agency_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_agency($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'agency_id' => $masterid, 
            'user_id' => $_SESSION['user_id'],
            'agency_name' => $postdata['agency_name'], 
            'agency_email' => $postdata['agency_email'],
            'agency_contact_no' => $postdata['agency_contact_no'], 
            'agency_address' => $postdata['agency_address'],
            'agency_website' => $postdata['agency_website'], 
            'agency_description' => $postdata['agency_description'],
                'contact_name' =>$postdata['contact_name']
                );
//        $upload_data = $this->mastermodel->upload_image('agency_logo');
//        if (!empty($upload_data['file_name'])) {
//            $tblValues['agency_logo'] = $upload_data['file_name'];
//        }
                
        $this->db->insert('agency', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     function update_agency($postdata)
    { 
        $data = array();
        $this->db->trans_begin();
        $tblValues = array( 
            //'user_id' => $_SESSION['user_id'],
            'agency_name' => $postdata['agency_name'], 
            'agency_email' => $postdata['agency_email'],
            'agency_contact_no' => $postdata['agency_contact_no'], 
            'agency_address' => $postdata['agency_address'],
            'agency_website' => $postdata['agency_website'], 
            'agency_description' => $postdata['agency_description'],
            'contact_name' =>$postdata['contact_name']
                );
        $this->db->where('agency_id',$postdata['agency_id']);
        $this->db->update('agency',$tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
     function delete_purchase_id($id)
    {  
         $this->db->trans_begin();
      
            $pid = $this->db->query("select ledger_book_details_id from ledger_book_details where ledger_book_id='$id'order by ledger_book_details_id desc");
            $result = $pid->result();
            if (!empty($result))
            {
                foreach ($result as $value)
                {
                    $pdetid = $value->ledger_book_details_id;
                    $this->db->where('ledger_book_reference.ledger_book_details', $pdetid);
                    $output = $this->db->delete('ledger_book_reference');
                }
            }
            $this->db->where('ledger_book_details.ledger_book_id', $id);
            $output = $this->db->delete('ledger_book_details');
            $q = $this->db->query("select prop_purchase_item_id,prop_purchase_item_godown_id from prop_purchase_item where po_ledger='$id'order by po_ledger desc limit 1");
            $result = $q->row();
            if (!empty($result))
            {
                $jno = $result->prop_purchase_item_id;
                $godown = $result->prop_purchase_item_godown_id;
            }
//            $pdet = $this->db->query("select po_details,quantity from con_purchase_details where con_purchase_id='$jno'order by con_purchase_details_id desc");
//            $result = $pdet->result();
//            if (!empty($result))
//            {
//                foreach ($result as $value)
//                {
//                    $pdetid = $value->po_details;
//
//                    $prev_qnt = $value->quantity;
//
//                    if (!empty($pdetid))
//                    {
//                        $output = $this->db->query("UPDATE con_po_details SET purchase_quantity = purchase_quantity -" . $prev_qnt . " WHERE con_po_details_id = " . $pdetid);
//                    }
//                }
//            }
            $purchase_stock=$this->mastermodel->selected_data_by_id('prop_sub_purchase_item',array('prop_sub_purchase_item_item_id','prop_sub_purchase_item_qty','stock_id'),'prop_sub_purchase_item_purchase_item_id',$jno);
            foreach ($purchase_stock as $value){
                $output = $this->db->query("UPDATE prop_item_stock SET prop_item_stock_qty = prop_item_stock_qty -" . $value->prop_sub_purchase_item_qty . " WHERE prop_item_stock_id = " . $value->stock_id);
                   
            }
            $this->db->where('prop_sub_purchase_item.prop_sub_purchase_item_purchase_item_id', $jno);
            $output = $this->db->delete('prop_sub_purchase_item');
            $this->db->where('prop_purchase_item.prop_purchase_item_id', $jno);
            $output = $this->db->delete('prop_purchase_item');
            $this->db->where('ledger_book.ledger_book_id', $id);
            $output = $this->db->delete('ledger_book');
           

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = "Unable to delete Record..!";
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = "Data Deleted Successfully..!";
            return $data;
        }
    }
       function get_accountledger_by_commodity($id)
    {
        $this->db->select('ledger_id,ledger_name');
        $this->db->from('account_ledger');
        $this->db->join('item_master', 'item_master.item_master_account=account_ledger.ledger_id');
        $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('item_master.item_master_id', $id);
        $data = $this->db->get()->row();
       
        return $data;
    }
      function get_category_by_commodity($id)
    {
        $this->db->select('item_category_id,item_category_name as category_name,item_master_tax');
        $this->db->from('item_master');
        $this->db->join('master', 'master.master_id=item_master.item_master_id');
        $this->db->join('item_category', 'item_category.item_category_id=item_master.item_master_category_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('item_master.item_master_id', $id);
        $this->db->order_by('item_master.item_master_id', 'desc');
        $data = $this->db->get()->row();
        return $data;
    }
    function search_owner()
    {
       $data = array();
        $this->db->select('*');
        $this->db->from('prop_owner');
        $this->db->join('master', 'master.master_id=prop_owner.prop_owner_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('prop_owner.prop_owner_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;  
    }
     function insert_owner($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'prop_owner_id' => $masterid, 
            'owner_name' => $postdata['owner_name'], 
               
            'owner_email' => $postdata['owner_email'],
            'owner_contact_no' => $postdata['owner_contact_no'],
            'owner_address' => $postdata['owner_address'],
            'owner_website' => $postdata['owner_website'],
            'owner_description' => $postdata['owner_description'],
           
                );

                
        $this->db->insert('prop_owner', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function update_owner($postdata)
    {
        $data = array();
        $this->db->trans_begin();
      
        $tblValues = array(
            
            'owner_name' => $postdata['owner_name'],
            'owner_email' => $postdata['owner_email'],
            'owner_contact_no' => $postdata['owner_contact_no'],
            'owner_address' => $postdata['owner_address'],
            'owner_website' => $postdata['owner_website'],
            'owner_description' => $postdata['owner_description'],
           
                );
          $this->db->where('prop_owner_id',$postdata['prop_owner_id']);
        $this->db->update('prop_owner',$tblValues);
                
      
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function search_nationality()
    {
         $data = array();
        $this->db->select('*');
        $this->db->from('nationality');
        $this->db->join('master', 'master.master_id=nationality.nationality_id');
       $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('nationality_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_nationality($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'nationality_id' => $masterid, 
            'nationality_name' => $postdata['nationality_name']
                );
                
        $this->db->insert('nationality', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     function update_nationality($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array( 
            'nationality_name' => $postdata['nationality_name']
                );
        $this->db->where('nationality_id',$postdata['nationality_id']);
        $this->db->update('nationality',$tblValues);
//        echo $this->db->last_query();die();
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function check_single($p_id)
    {
        $value = 1;
        $this->db->select('prop_lease_agreement_id');
        $this->db->from('prop_lease_agreement');
        $this->db->where('prop_lease_agreement_room_id', 0);
        $this->db->where('prop_lease_agreement_property_id', $p_id);
        $data = $this->db->get()->result();
        foreach($data as $item)
        {
            $this->db->select('prop_lease_termination_lease_agrement_id');
            $this->db->from('prop_lease_termination');
            $this->db->where('prop_lease_termination_lease_agrement_id', $item->prop_lease_agreement_id);
            if(!$this->db->get()->row())
            {
                $value = 0;
            }
        }
        return $value;
    }
    function get_property_by_dealing_type()
    {
           $data = array();
        $this->db->select('*');
         
           $this->db->join('master', "master.master_id=detail_entry.detail_id");
           $this->db->where('project_id', 2);
           $this->db->order_by('detail_id', 'desc');
            $Q = $this->db->get('detail_entry');

        $data = $Q->result();
        foreach($data as $item)
        {
          if($item->dealing_type_id == 2)  
          {
               $data1 = array();
        $this->db->select('*');
        $this->db->from('detail_entry_dealing_details');
        $this->db->where('detail_entry_dealing_details.detail_entry_type !=','Sell');
         $this->db->where('detail_entry_dealing_details.detail_id',$item->detail_id);
        $this->db->where('detail_entry_dealing_details.detail_entry_dealing_details_id not in ','(select lease.prop_lease_agreement_room_id from prop_lease_agreement lease)',false);
        
        $data1= $this->db->get()->result();
          }
        }
        return $data;
       
    }
}
?>
