<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Posreportmodel extends CI_Model
{

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
     function load_production_entry_report($postdata)
    {
        $data = array();
        $this->db->select('pos_production_entry.*, pos_production_order_acceptance.order_customer_id,pos_production_order_acceptance.order_code');
        $this->db->from('pos_production_entry');
        $this->db->join('master', 'master.master_id=pos_production_entry.pos_production_entry_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->join('pos_production_order_acceptance', 'pos_production_order_acceptance.order_id=pos_production_entry.pos_production_entry_work_order_id');
        
        
        if(!empty($postdata['to_date'])){
            $this->db->where('pos_production_entry_date <=',$this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['from_date'])){
            $this->db->where('pos_production_entry_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        }if(!empty($postdata['customer_id'])){
            $this->db->where('pos_production_order_acceptance.order_customer_id', $postdata['customer_id']);
        }
        if(!empty($postdata['order_id'])){
            $this->db->where('pos_production_order_acceptance.order_id', $postdata['order_id']);
        }
        $this->db->order_by('pos_production_order_acceptance.order_customer_id', 'asc');
        $data = $this->db->get()->result();
        return $data;
    }
    function get_customer_orders($c_id,$from_date,$to_date)
    {
        $this->db->select('pos_production_order_acceptance.order_code,pos_production_order_acceptance.order_id');
        $this->db->from('pos_production_order_acceptance');
        if(!empty($c_id)){
        $this->db->where('pos_production_order_acceptance.order_customer_id', $c_id);
        }
        if(!empty($to_date)){
            $this->db->where('pos_production_order_acceptance.order_date <=',$this->mastermodel->convert_date_format($to_date));
        }
        if(!empty($from_date)){
            $this->db->where('pos_production_order_acceptance.order_date >=',$this->mastermodel->convert_date_format($from_date));
        }
        $this->db->join('pos_production_order_acceptance_details', 'pos_production_order_acceptance.order_id=pos_production_order_acceptance_details.details_workorder_id', 'inner');
//        $this->db->where('pos_production_order_acceptance_details.details_item_qty > pos_production_order_acceptance_details.completed_qty');
        $this->db->group_by('pos_production_order_acceptance.order_id');
        $data = $this->db->get()->result();
        
        return $data;
    }
    function load_wow_bom_balance_report($postdata)
    {
        $data = array();
        $this->db->select('pos_item_master.product_name,pos_item_master.product_id');
        $this->db->from('pos_production_order_acceptance');
        if(!empty($postdata['order_id'])){
            $this->db->where('pos_production_order_acceptance.order_id', $postdata['order_id']);
        }
        $this->db->join('master', 'master.master_id=pos_production_order_acceptance.order_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->join('pos_production_order_acceptance_details', 'pos_production_order_acceptance_details.details_workorder_id=pos_production_order_acceptance.order_id');
        $this->db->join('pos_production_bom', 'pos_production_bom.bom_product_id=pos_production_order_acceptance_details.details_item_id');
        $this->db->join('pos_production_bom_details', 'pos_production_bom_details.bom_id=pos_production_bom.bom_id');
        $this->db->join('pos_item_master', 'pos_item_master.product_id=pos_production_bom_details.bom_material_id');
        
        if(!empty($postdata['to_date'])){
            $this->db->where('pos_production_order_acceptance.order_date <=',$this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['from_date'])){
            $this->db->where('pos_production_order_acceptance.order_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        }
        
        $this->db->order_by('pos_production_order_acceptance.order_id', 'asc');
        $data = $this->db->get()->result();
        $data['order_id'] = $postdata['order_id'];
        return $data;
    }
    function get_bom_total_qty($item_id, $order_id)
    {
        $this->db->select('sum(pos_production_entry_bom_details.pos_production_entry_bom_material_qty) as bom_qty');
        $this->db->from('pos_production_entry');
        $this->db->where('pos_production_entry.pos_production_entry_work_order_id', $order_id);
        $this->db->join('pos_production_entry_bom_details','pos_production_entry_bom_details.pos_production_entry_id=pos_production_entry.pos_production_entry_id');
        $this->db->where('pos_production_entry_bom_details.pos_production_entry_bom_material_id', $item_id);
        $data = $this->db->get()->row()->bom_qty;
        return $data;
    }
    function load_wow_purchase_production_report($postdata)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_production_entry');
        if(!empty($postdata['order_id'])){
            $this->db->where('pos_production_entry.pos_production_entry_work_order_id', $postdata['order_id']);
        }
        $this->db->join('master', 'master.master_id=pos_production_entry.pos_production_entry_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        
        if(!empty($postdata['to_date'])){
            $this->db->where('pos_production_entry.pos_production_entry_date <=',$this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['from_date'])){
            $this->db->where('pos_production_entry.pos_production_entry_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        }
        
        $this->db->order_by('pos_production_entry.pos_production_entry_item_id', 'asc');
        $data = $this->db->get()->result();
        return $data;
    }
    function get_vendor_orders($v_id,$from_date,$to_date)
    {
        $this->db->select('po_no, po_management_id');
        $this->db->from('pos_po');
        if(!empty($c_id)){
        $this->db->where('pos_po.order_customer_id', $c_id);
        }
        if(!empty($to_date)){
            $this->db->where('pos_po.po_date <=',$this->mastermodel->convert_date_format($to_date));
        }
        if(!empty($from_date)){
            $this->db->where('pos_po.po_date >=',$this->mastermodel->convert_date_format($from_date));
        }
//        $this->db->join('pos_po', 'pos_production_order_acceptance.order_id=pos_production_order_acceptance_details.details_workorder_id', 'inner');
//        $this->db->where('pos_production_order_acceptance_details.details_item_qty > pos_production_order_acceptance_details.completed_qty');
        $this->db->group_by('pos_po.po_management_id');
        $data = $this->db->get()->result();
        
        return $data;
    }
    function load_po_report($postdata)
    {
        $data = array();
        $this->db->select('pos_po.*');
        $this->db->from('pos_po');
        $this->db->join('master', 'master.master_id=pos_po.po_management_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        if(!empty($postdata['vendor_id'])){
            $this->db->where('pos_po.vendor', $postdata['vendor_id']);
        }
        if(!empty($postdata['order_id'])){
            $this->db->where('pos_po.po_management_id', $postdata['order_id']);
        }
        if(!empty($postdata['to_date'])){
            $this->db->where('pos_po.po_date <=',$this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['from_date'])){
            $this->db->where('pos_po.po_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        }
        
        $this->db->order_by('pos_po.po_management_id', 'asc');
        $data = $this->db->get()->result();
        
        return $data;
    }
    function load_purchase_report($postdata)
    {
        $data = array();
        $this->db->select('pos_purchase.purchase_no, pos_purchase.purchase_vendor, pos_purchase.purchase_date, pos_purchase_details.*');
        $this->db->from('pos_purchase');
        $this->db->join('master', 'master.master_id=pos_purchase.purchase_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->join('pos_purchase_details', 'pos_purchase_details.purchase_id=pos_purchase.purchase_id');
        if(!empty($postdata['vendor_id'])){
            $this->db->where('pos_purchase.purchase_vendor', $postdata['vendor_id']);
        }
        if(!empty($postdata['item_id'])){ 
            $this->db->where('pos_purchase_details.product_master', $postdata['item_id']);
        }
        if(!empty($postdata['to_date'])){
            $this->db->where('pos_purchase.purchase_date <=',$this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['from_date'])){
            $this->db->where('pos_purchase.purchase_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        }
        
        $this->db->order_by('pos_purchase.purchase_id', 'asc');
        $data = $this->db->get()->result();
        
        return $data;
    }
    function load_monthwise_purchase_report($postdata)
    {
        $start = new DateTime($this->mastermodel->convert_date_format($postdata['from_date']));
        $end   = new DateTime($this->mastermodel->convert_date_format($postdata['to_date']));
        $select='';
        $k=0;
        while($start <= $end) 
        {
            $select .= ", SUM( 
                        CASE WHEN month( m.purchase_date) = ".$start->format('m')." and
                                  year( m.purchase_date) = ".$start->format('Y')."
                        THEN s.quantity
                        ELSE 0 
                        END ) AS  `quantity".$k."`";
            $start->modify('+1 month');$k++;
        }
        $data = array();
        $this->db->select('m.purchase_vendor, s.product_master,m.purchase_date'.$select);
        $this->db->from('pos_purchase m');
        $this->db->join('master', 'master.master_id=m.purchase_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->join('pos_purchase_details s', 's.purchase_id=m.purchase_id');
        $this->db->group_by('s.product_master');
        $this->db->order_by('m.purchase_date', 'asc');
        $data1 = $this->db->get();
        
        if ($data1->num_rows() > 0)
        {
            $data['from_date'] = $this->mastermodel->convert_date_format($postdata['from_date']);
            $data['to_date'] = $this->mastermodel->convert_date_format($postdata['to_date']);
            foreach ($data1->result_array() as $row)
            {
                $data['data'][] = $row;
            }
        }
        
        return $data;
    }
    function load_stock_report($postdata)
    {
        $data = array();
        $this->db->select('pos_item_master.product_name,pos_item_master.product_code,pos_stock_register.qty,pos_stock_register.stock_type,pos_stock_register.price,pos_item_batch.batch_no,godown.godown_name');
        $this->db->from('pos_stock_register');
        $this->db->join('pos_item_master', 'pos_item_master.product_id=pos_stock_register.item_id');
        $this->db->join('godown', 'godown.godown_id=pos_stock_register.godown_id');
        $this->db->join('pos_item_batch', 'pos_item_batch.batch_id=pos_stock_register.batch_id');
        if(!empty($postdata['item_id'])){
            $this->db->where('pos_stock_register.item_id', $postdata['item_id']);
        }
        if(!empty($postdata['godown_id'])){ 
            $this->db->where('pos_stock_register.godown_id', $postdata['godown_id']);
        }
        
        $this->db->order_by('pos_stock_register.stock_register_id', 'asc');
        $data = $this->db->get()->result();
        
        return $data;
    }
//    (CASE WHEN s.trans_date <='.$this->mastermodel->convertdateformat($postdata['from_date']).' THEN SUM(qty*stock_type) ELSE qty*stock_type END)
    function load_datewise_item_stock_report($postdata)
    {
        $data = array();
        $this->db->select('item_id,( 
                        CASE WHEN (qty * stock_type) > 0
                        THEN (qty * stock_type)
                        ELSE 0 
                        END ) AS  `quantity`');
        $this->db->from('pos_stock_register');
        $this->db->where('pos_stock_register.trans_date <=', $this->mastermodel->convertdateformat($postdata['from_date']));
        $this->db->where('pos_stock_register.item_id', $postdata['product_id']);
        $val1 = $this->db->get()->row();
        
        $this->db->select('item_id,qty,stock_type,trans_date');
        $this->db->from('pos_stock_register');
        
        $this->db->join('pos_item_master', 'pos_item_master.product_id=pos_stock_register.item_id');
        
        if(!empty($postdata['from_date'])){
            $this->db->where('pos_stock_register.trans_date <=', $this->mastermodel->convertdateformat($postdata['from_date']));
        }
        if(!empty($postdata['to_date'])){ 
            $this->db->where('pos_stock_register.trans_date <=', $this->mastermodel->convertdateformat($postdata['to_date']));
        }
        if(!empty($postdata['product_id'])){ 
            $this->db->where('pos_stock_register.item_id', $postdata['product_id']);
        }
        
        $this->db->order_by('pos_stock_register.trans_date', 'asc');
        $val2 = $this->db->get()->result();
        $data[0] = $val1;
        foreach($val2 as $item){
            $data[] = $item;
        }
        
        return $data;
    }
    function load_item_wise_report($postdata)
    {
        $data = array();
        $this->db->select('pos_purchase_details.product_master');
        $this->db->from('pos_purchase_details');
        if(!empty($postdata['item_id'])){
            $this->db->where('pos_purchase_details.product_master', $postdata['item_id']);
        }
        $this->db->group_by('pos_purchase_details.product_master');
        $data = $this->db->get()->result();
        foreach($data as $key=>$item)
        {
            $this->db->select('pos_purchase.purchase_no,pos_purchase_details.product_master,pos_purchase.purchase_date,pos_purchase.purchase_vendor,pos_purchase_details.unit,pos_purchase_details.purchase_rate,pos_purchase_details.quantity,pos_purchase_details.discount,pos_purchase_details.tax_amount');
            $this->db->from('pos_purchase');
            $this->db->join('pos_purchase_details', 'pos_purchase_details.purchase_id=pos_purchase.purchase_id');
//            if(!empty($postdata['vendor_id'])){
//                $this->db->where('pos_purchase.purchase_vendor', $postdata['vendor_id']);
//            } 
            $this->db->where('pos_purchase_details.product_master', $item->product_master);
            if(!empty($postdata['to_date'])){
                $this->db->where('pos_purchase.purchase_date <=',$this->mastermodel->convert_date_format($postdata['to_date']));
            }
            if(!empty($postdata['from_date'])){
                $this->db->where('pos_purchase.purchase_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
            } 
            $this->db->order_by('pos_purchase.purchase_date', 'asc');
            $data[$key]->Item_details = $this->db->get()->result();
        }
//        
        
        
        return $data;
    }
    function load_vendorwise_item_report($postdata)
    {
        $data = array();
        $this->db->select('pos_purchase.purchase_vendor');
        $this->db->from('pos_purchase');
        if(!empty($postdata['vendor_id'])){
            $this->db->where('pos_purchase.purchase_vendor', $postdata['vendor_id']);
        }
        $this->db->group_by('pos_purchase.purchase_vendor');
        $data = $this->db->get()->result();
        foreach($data as $key=>$vendor)
        {
            $this->db->select('pos_purchase.purchase_no,pos_purchase_details.product_master,pos_purchase.purchase_date,pos_purchase.purchase_vendor,pos_purchase_details.unit,pos_purchase_details.purchase_rate,pos_purchase_details.quantity,pos_purchase_details.discount,pos_purchase_details.tax_amount');
            $this->db->from('pos_purchase');
//            if(!empty($postdata['item_id'])){
//                $this->db->where('pos_purchase_details.product_master', $postdata['item_id']);
//            } 
            $this->db->where('pos_purchase.purchase_vendor', $vendor->purchase_vendor);
            if(!empty($postdata['to_date'])){
                $this->db->where('pos_purchase.purchase_date <=',$this->mastermodel->convert_date_format($postdata['to_date']));
            }
            if(!empty($postdata['from_date'])){
                $this->db->where('pos_purchase.purchase_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
            } 
            $this->db->join('pos_purchase_details', 'pos_purchase_details.purchase_id=pos_purchase.purchase_id');
            $this->db->order_by('pos_purchase.purchase_date', 'asc');
            $data[$key]->Item_details = $this->db->get()->result();
        }
//        
        return $data;
    }
    function load_vat_sale_invoice_report($postdata)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_sale');
        if(!empty($postdata['from_date'])){
            $this->db->where('pos_sale.date  >=', $this->mastermodel->convert_date_format($postdata['from_date']));
        }
        if(!empty($postdata['to_date'])){
            $this->db->where('pos_sale.date  <=', $this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['customer_id'])){
            $this->db->where('pos_sale.customer_id', $postdata['customer_id']);
        }
        if(!empty($postdata['sale_id'])){
            $this->db->where('pos_sale.sale_id', $postdata['sale_id']);
        }
        $this->db->join('pos_sale_details', 'pos_sale_details.sale_id=pos_sale.sale_id');
        $this->db->group_by('pos_sale.sale_id');
        $data = $this->db->get()->result();
        return $data;
    }
    function bill_wise_sales_report($postdata)
    {
        $data = array();
        $this->db->select('sale_code, date, customer_id, payment_mode, sale_id, total_amount, discount, grand_total');
        $this->db->from('pos_sale');
        if(!empty($postdata['from_date'])){
            $this->db->where('pos_sale.date  >=', $this->mastermodel->convert_date_format($postdata['from_date']));
        }
        if(!empty($postdata['to_date'])){
            $this->db->where('pos_sale.date  <=', $this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['customer_id'])){
            $this->db->where('pos_sale.customer_id', $postdata['customer_id']);
        }
        if(!empty($postdata['sale_bill_category'])){
            $this->db->like('pos_sale.sale_bill_category', $postdata['sale_bill_category']);
        }
        if(!empty($postdata['payment_mode'])){
            $this->db->like('pos_sale.payment_mode', $postdata['payment_mode']);
        }
        $this->db->group_by('pos_sale.sale_id');
        $data = $this->db->get()->result();
        
        foreach($data as $key=>$item){
            $this->db->select('SUM(tax_amount) AS tax_amount');
            $this->db->from('pos_sale_details');
            $this->db->where('pos_sale_details.sale_id', $item->sale_id);
            $data[$key]->tax_amount = $this->db->get()->row()->tax_amount;
        } 
        
        return $data;
    }
    function item_wise_sales_report($postdata)
    {
        $data = array();
        $this->db->select('item_id');
        $this->db->from('pos_sale_details');
        if(!empty($postdata['item_id'])){
            $this->db->like('pos_sale_details.item_id', $postdata['item_id']);
        }
        $this->db->group_by('pos_sale_details.item_id');
        $data = $this->db->get()->result();
        
        foreach($data as $key=>$item){
            $this->db->select('sale_code, date, customer_id, payment_mode, item_qty, item_unit_id, sale_price, total, sub_total ,tax_amount, pos_sale_details.total_amount');
            $this->db->from('pos_sale');
        if(!empty($postdata['from_date'])){
            $this->db->where('pos_sale.date  >=', $this->mastermodel->convert_date_format($postdata['from_date']));
        }
        if(!empty($postdata['to_date'])){
            $this->db->where('pos_sale.date  <=', $this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['customer_id'])){
            $this->db->where('pos_sale.customer_id', $postdata['customer_id']);
        }
        if(!empty($postdata['sale_bill_category'])){
            $this->db->like('pos_sale.sale_bill_category', $postdata['sale_bill_category']);
        }
        if(!empty($postdata['payment_mode'])){
            $this->db->like('pos_sale.payment_mode', $postdata['payment_mode']);
        }
            $this->db->join('pos_sale_details', 'pos_sale_details.sale_id=pos_sale.sale_id AND pos_sale_details.item_id='.$item->item_id);
            $this->db->group_by('pos_sale.sale_id');
            $data[$key]->sub = $this->db->get()->result();
        } 
        
        return $data;
    }
    function tax_wise_sales_report($postdata)
    {
        $data = array();
        $this->db->select('tax_percentage');
        $this->db->from('pos_sale_details');
        $this->db->group_by('pos_sale_details.tax_percentage');
        $data = $this->db->get()->result();
        
        foreach($data as $key=>$item)
        {
            $this->db->select('sale_code, date, item_id, item_qty, sale_price, total, discount_amount, sub_total, tax_percentage, tax_amount, pos_sale_details.total_amount');
            $this->db->from('pos_sale');
            if(!empty($postdata['from_date'])){
                $this->db->where('pos_sale.date  >=', $this->mastermodel->convert_date_format($postdata['from_date']));
            }
            if(!empty($postdata['to_date'])){
                $this->db->where('pos_sale.date  <=', $this->mastermodel->convert_date_format($postdata['to_date']));
            }
            $this->db->join('pos_sale_details', 'pos_sale_details.sale_id=pos_sale.sale_id AND pos_sale_details.tax_percentage='.$item->tax_percentage);
            $this->db->order_by('pos_sale_details.sale_id');
            $data[$key]->sub = $this->db->get()->result();
        }
        
        return $data;
    }
}
?>