<?php


if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Clientreportmodel extends CI_Model
{

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
                $this->load->library('PHPExcel');

    }

    function search_report()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('report');
        $this->db->where('report_module_id', $_SESSION['current_menu']);
        $this->db->order_by('report_sort', 'asc');
        $data['results'] = $this->db->get();
        return $data;
    }
      function load_lead_report($postdata)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_lead_details');
        if(!empty($postdata['user_id'])){
        $this->db->where('crm_lead_details_user_id', $postdata['user_id']);
        }
         if(!empty($postdata['from_date'])){
        $this->db->where('crm_lead_details.crm_lead_details_date >=', $this->mastermodel->convert_date_format($postdata['from_date']));
        }
         if(!empty($postdata['to_date'])){
        $this->db->where('crm_lead_details.crm_lead_details_date <=', $this->mastermodel->convert_date_format($postdata['to_date']));
        }
        $this->db->order_by('crm_lead_details_id', 'asc');
        $data = $this->db->get()->result();
        foreach($data as $key => $item)
        {
            $this->db->select('*');
            $this->db->from('contact_sub');
            $this->db->where('contact_sub_contact_id', $item->crm_lead_contact_id);
            $data[$key]->sub_data = $this->db->get()->result();
        }
        return $data;
    }
       function load_deal_report($postdata)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_deal_details');
        if(!empty($postdata['user_id'])){
        $this->db->where('crm_deal_details_owner', $postdata['user_id']);
        }
         if(!empty($postdata['crm_deal_status_id'])){
        $this->db->where('crm_deal_details_status_id', $postdata['crm_deal_status_id']);
        }
        $this->db->order_by('crm_deal_details_id', 'asc');
        $data = $this->db->get()->result();
        return $data;
    }
      function load_deal_open_report($postdata)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_deal_details');
        if(!empty($postdata['user_id'])){
        $this->db->where('crm_deal_details_owner', $postdata['user_id']);
        }
        $this->db->where('crm_deal_details_date <',$this->mastermodel->convert_date_format($postdata['date_to']));
        $this->db->where('crm_deal_details_date >',$this->mastermodel->convert_date_format($postdata['date_from']));
        $this->db->join("crm_deal_status","crm_deal_status.crm_deal_status_id=crm_deal_details.crm_deal_details_status_id");
        $this->db->where('crm_deal_status_name !=', "closed");
        $this->db->order_by('crm_deal_details_id', 'asc');
        $data = $this->db->get()->result();
        return $data;
    }
      function load_lost_deal_report($postdata)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_deal_details');
        $this->db->where('crm_deal_details_status_id', 0);
        $this->db->order_by('crm_deal_details_id', 'asc');
        $data = $this->db->get()->result(); 
        return $data;
    }
     function load_deal_closing_this_month_report($postdata)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_deal_details');
        $this->db->where('MONTH(crm_deal_details_date)',  date("m") );
        $this->db->where('crm_deal_details_status','active');
        $data = $this->db->get()->result(); 
        return $data;
    }
    function load_contact_report($postdata)
    {
        $data = array();
        $this->db->select('master.created_time,contact.contact_id,contact.contact_first_name,contact.contact_last_name,contact.contact_owner,contact.crm_contact_industry,contact.contact_company_name,contact.contact_designation,contact.contact_description');
        $this->db->from('contact');
        $this->db->join('master', 'master.master_id=contact.contact_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
         $user_branch = $_SESSION['master_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";   
             if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
             }
        $this->db->where('contact.contact_status', 'active');
        $this->db->where('master.created_time <',$this->mastermodel->convert_date_format($postdata['to_date']));
        $this->db->where('master.created_time >',$this->mastermodel->convert_date_format($postdata['from_date']));
        if(!empty($postdata['user_id']))
        {
            $this->db->where('contact.contact_owner',  $postdata['user_id']);
        }
        if(!empty($postdata['industry_id']))
        {
            $this->db->where('contact.crm_contact_industry',  $postdata['industry_id']);
        }
        $this->db->group_by('contact.contact_id'); 
        $data = $this->db->get()->result(); 
        
        foreach($data as $key => $item)
        {
            $this->db->select('*');
            $this->db->from('contact_sub');
            $this->db->where('contact_sub_contact_id', $item->contact_id);
            $data[$key]->sub_data = $this->db->get()->result();
        }
        return $data;
    }
    public function load_contact_collected_report($postdata)
    {
        $data = array();
        $this->db->select('DATE(master.created_time) as interwell,COUNT(contact_sub.contact_sub_contact_id) as number,user.user_name,contact_owner');
        $this->db->from('contact');
        $this->db->join('master', 'master.master_id=contact.contact_id');
        $this->db->join('user', 'user.user_id=contact.contact_owner');
        if(!empty($postdata['owner_id']))
        {
            $this->db->where('contact_owner', $postdata['owner_id']);
        }
        
        $this->db->where('master.created_time <',$this->mastermodel->convert_date_format($postdata['to_date']));
        $this->db->where('master.created_time >',$this->mastermodel->convert_date_format($postdata['from_date']));
         $user_branch = $_SESSION['master_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";   
             if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
             }
        $this->db->join('contact_sub', 'contact_sub.contact_sub_contact_id=contact.contact_id');
        $this->db->group_by($postdata['interval'].'(master.created_time)');
        $this->db->group_by('contact.contact_owner');
        $data = $this->db->get()->result();
        
        $value['data'] = array();
        $value['data'][0][0] = 'Interval';
        
        foreach($data as $key=>$item)
        {
            if(!array_search($item->user_name ,$value['data'][0]))
            $value['data'][0][] = $item->user_name;
        }
        
        foreach($data as $key=>$item)
        {
            $k=0;
            while($k < count($value['data'][0]))
            {
                $index = array_search($item->user_name, $value['data'][0]);
                if($k != 0)
                {
                    if($value['data'][0][$k] == $item->user_name)
                    {  
                        $value['data'][$key+1][$index] = 1*$item->number;
                    }else{
                        $value['data'][$key+1][$k] = 0;
                    }
                }else{
                    switch ($postdata['interval']) {
                        case "MONTH":
                                $value['data'][$key+1][$k] = date('M-y', strtotime($item->interwell));
                            break;
                        case "YEAR":
                                $value['data'][$key+1][$k] = date('Y', strtotime($item->interwell));
                            break;
                        default:
                                $value['data'][$key+1][$k] = date('d-M-y', strtotime($item->interwell));
                    }
                }
                $k++;
            }
        }
        
        return $value;
    }
     function flow_lead_sub($postdata) {

        $data = array();
        $this->db->select('*');
        $this->db->from('crm_lead_details');
        
        if(!empty($postdata['from_date']))
        {
            $this->db->where('crm_lead_details.crm_lead_details_date >=',  $this->mastermodel->convert_date_format($postdata['from_date']));
        }
        if(!empty($postdata['to_date']))
        {
            $this->db->where('crm_lead_details.crm_lead_details_date <=',  $this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['id']))
        {
            $this->db->where('crm_lead_details.crm_lead_contact_id',  $postdata['id']);
        }
       
//         if($_SESSION['administrator_privilage'] == 'no'){
//        $this->db->where('crm_lead_details_user_id', $_SESSION['user_id']);
//        $this->db->or_where("FIND_IN_SET('$emplo',crm_lead_hr_employees_id) !=", 0);
//       
//  }

         $this->db->where('crm_lead_details_status', 'active');
           $this->db->join('master', 'master.master_id=crm_lead_details.crm_lead_details_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $user_branch = $_SESSION['master_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";   
             if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
             }
           
        $this->db->order_by('crm_lead_details_id', 'desc');
        $data['results'] = $this->db->get();
    
        return $data;
    }
    function flow_task_sub($postdata) {
        
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_task_details');
        
        if(!empty($postdata['from_date']))
        {
            $this->db->where('crm_task_details.crm_task_details_date >=',  $this->mastermodel->convert_date_format($postdata['from_date']));
        }
        if(!empty($postdata['to_date']))
        {
            $this->db->where('crm_task_details.crm_task_details_date <=',  $this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['id']))
        {
            $this->db->where('crm_task_details.crm_task_details_lead_id',  $postdata['id']);
        }
       
//         if($_SESSION['administrator_privilage'] == 'no'){
//        $this->db->where('crm_lead_details_user_id', $_SESSION['user_id']);
//        $this->db->or_where("FIND_IN_SET('$emplo',crm_lead_hr_employees_id) !=", 0);
//       
//  }

        $this->db->where('crm_task_details_status', 'active');
        $this->db->join('master', 'master.master_id=crm_task_details.crm_task_details_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $user_branch = $_SESSION['master_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";   
             if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
             }
           
        $this->db->order_by('crm_task_details_id', 'desc');
        $data['results'] = $this->db->get();
    
        return $data;
    }
    function flow_deal_task_sub($postdata) {
//         $emplo=$_SESSION['employee_id'];
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_task_details');
        
        if(!empty($postdata['from_date']))
        {
            $this->db->where('crm_task_details.crm_task_details_date >=',  $this->mastermodel->convert_date_format($postdata['from_date']));
        }
        if(!empty($postdata['to_date']))
        {
            $this->db->where('crm_task_details.crm_task_details_date <=',  $this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['id']))
        {
            $this->db->where('crm_task_details.crm_task_details_deal_id',  $postdata['id']);
        }
       
//         if($_SESSION['administrator_privilage'] == 'no'){
//        $this->db->where('crm_lead_details_user_id', $_SESSION['user_id']);
//        $this->db->or_where("FIND_IN_SET('$emplo',crm_lead_hr_employees_id) !=", 0);
//       
//  }

        $this->db->where('crm_task_details_status', 'active');
        $this->db->join('master', 'master.master_id=crm_task_details.crm_task_details_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $user_branch = $_SESSION['master_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";   
             if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
             }
           
        $this->db->order_by('crm_task_details_id', 'desc');
        $data['results'] = $this->db->get();
    
        return $data;
    }
    function flow_contact_task_sub($postdata) {
//         $emplo=$_SESSION['employee_id'];
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_task_details');
        
        if(!empty($postdata['from_date']))
        {
            $this->db->where('crm_task_details.crm_task_details_date >=',  $this->mastermodel->convert_date_format($postdata['from_date']));
        }
        if(!empty($postdata['to_date']))
        {
            $this->db->where('crm_task_details.crm_task_details_date <=',  $this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if(!empty($postdata['id']))
        {
            $this->db->where('crm_task_details.crm_task_details_contact_id',  $postdata['id']);
        }
       
//         if($_SESSION['administrator_privilage'] == 'no'){
//        $this->db->where('crm_lead_details_user_id', $_SESSION['user_id']);
//        $this->db->or_where("FIND_IN_SET('$emplo',crm_lead_hr_employees_id) !=", 0);
//       
//  }

        $this->db->where('crm_task_details_status', 'active');
        $this->db->join('master', 'master.master_id=crm_task_details.crm_task_details_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $user_branch = $_SESSION['master_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";   
             if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
             }
           
        $this->db->order_by('crm_task_details_id', 'desc');
        $data['results'] = $this->db->get();
    
        return $data;
    }
      function load_todeal_dwr_report($postdata)
    {
        $data = array();
        $this->db->select('crm_lead_details.crm_lead_details_id as lead_id');
        $this->db->from('crm_lead_details');
        
        if(!empty($postdata['from_date'])){
            $this->db->where('crm_lead_details.crm_lead_details_date >=', $this->mastermodel->convert_date_format($postdata['from_date']));
        }
        if(!empty($postdata['to_date'])){
            $this->db->where('crm_lead_details.crm_lead_details_date <=', $this->mastermodel->convert_date_format($postdata['to_date']));
        }
//        $this->db->join('crm_deal_details as deal1', 'deal1.crm_deal_buyer_lead_id=crm_lead_details.crm_lead_details_id');
        
        $this->db->group_by('crm_lead_details_id', 'asc');
        $data['leads'] = $this->db->get()->result();
        
//        $value[0] = array('Date','Deal Amount');
        foreach($data['leads'] as $key => $item)
        {
            $this->db->select('crm_deal_details.crm_deal_details_id,crm_deal_details.crm_deal_details_code,crm_deal_details.crm_deal_details_date as date,crm_deal_details.crm_deal_details_amount as amount');
            $this->db->from('crm_deal_details');
            $this->db->where('crm_deal_details_status','active');
            $this->db->where('crm_deal_details.crm_deal_buyer_lead_id', $item->lead_id);
            $deal = $this->db->get()->row();
            if(!empty($deal->crm_deal_details_id))
            {
                $value[] = array(date('d-M-Y', strtotime($deal->date)),1*$deal->amount,'Code: '.$deal->crm_deal_details_code.'/Amount:'.$deal->amount);
            }
            $this->db->select('crm_deal_details.crm_deal_details_id,crm_deal_details.crm_deal_details_code,crm_deal_details.crm_deal_details_date as date,crm_deal_details.crm_deal_details_amount as amount');
            $this->db->from('crm_deal_details');
            $this->db->where('crm_deal_details_status','active');
            $this->db->where('crm_deal_details.crm_deal_seller_lead_id', $item->lead_id);
            $deal = $this->db->get()->row();
            if(!empty($deal->crm_deal_details_id))
            {
                $value[] = array(date('d-M-Y', strtotime($deal->date)),1*$deal->amount,'Code: '.$deal->crm_deal_details_code.'/Amount:'.$deal->amount);
            }
        } 
        $data['graph'] = $value;
        
        return $data;
    }
     function creditors_report($postdata) {
        $data = array();
        $this->db->select('*');
        $this->db->from('contact');
             $this->db->where('contact.contact_id not in ','(select contacts.contact_parent_id from contact contacts)',false);
        //   if($_SESSION['administrator_privilage'] == 'no'){
        //      $this->db->where('contact_owner', $_SESSION['user_id']);
        //   }
           if(!empty($postdata['creditor_id'])){
      $this->db->where('contact_id',$postdata['creditor_id']);
           }
        $this->db->where('contact_status','active');
        $this->db->join('master', 'master.master_id=contact.contact_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
         $user_branch = $_SESSION['master_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";   
            //  if($_SESSION['master_branch']!=4906){
            //  $this->db->where($query);
            //  }
        $this->db->order_by('contact_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
     function ptp_list_report($postdata)
    {
             $data = array();
        $this->db->select('*');
        $this->db->from('ptp');
              $this->db->join('complaints','complaints.complaints_id=ptp.ptp_complaints_id','left');
        $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id','left');
         $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id','left');
  $this->db->join('hr_employees', 'hr_employees.hr_employees_id=complaints.complaints_assign_ids','left');
        $this->db->join('master', 'master.master_id=ptp.ptp_id');
        
        $this->db->where('master.project_id', $_SESSION['project_id']);
         $user_branch = $_SESSION['master_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";   
             if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
             }
          if(!empty($postdata['ptp_id'])){
          $this->db->where('ptp.ptp_id', $postdata['ptp_id']);
          }
        $this->db->order_by('ptp_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
     function ptp_pay_status($id)
    {
             $data = array();
        $this->db->select('(SUM(payment_plan_amount) - SUM(payment_plan_paid_amount)) as amount');
        $this->db->from('ptp_payment_plan');
        
        $this->db->where('ptp_payment_plan.payment_plan_ptp_id',$id);
      
        $this->db->order_by('payment_plan_ptp_id', 'desc');
        $data = $this->db->get()->row();
        return $data;
    }
  
    
    function get_ptp_payments($id)
    {
             $data = array();
        $this->db->select('payment_plan_ptp_id,payment_plan_paid_date,SUM(payment_plan_paid_amount) as total_paid_amount');
        $this->db->from('ptp_payment_plan');
        $this->db->where('ptp_payment_plan.payment_plan_ptp_id',$id);
         $this->db->where('ptp_payment_plan.payment_plan_paid_amount !=','0');
     
      $this->db->group_by('Month(payment_plan_paid_date)');
        $data = $this->db->get()->result();
        
      
        return $data;
    } 
     function employee_collection_report($postdata)
    {
             $data = array();
        $this->db->select('*');
        $this->db->from('ptp_payment_plan');
                $this->db->join('ptp','ptp.ptp_id=ptp_payment_plan.payment_plan_ptp_id','left');
       $this->db->join('complaints','complaints.complaints_id=ptp.ptp_complaints_id','left');
        $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id','left');
         $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id','left');
  $this->db->join('hr_employees', 'hr_employees.hr_employees_id=complaints.complaints_assign_ids','left');
        if(!empty($postdata['employee_id'])){
        $this->db->where('complaints.complaints_assign_ids',$postdata['employee_id']);
        
        }
         $this->db->where('ptp_payment_plan.payment_plan_paid_amount !=','0');
   
        $data = $this->db->get()->result();
        
      
        return $data;
    } 
    
       function pending_collection_report($postdata)
    {
             $data = array();
        $this->db->select('*');
        $this->db->from('ptp_payment_plan');
                $this->db->join('ptp','ptp.ptp_id=ptp_payment_plan.payment_plan_ptp_id','left');
       $this->db->join('complaints','complaints.complaints_id=ptp.ptp_complaints_id','left');
        $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id','left');
         $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id','left');
  $this->db->join('hr_employees', 'hr_employees.hr_employees_id=complaints.complaints_assign_ids','left');
       
         $this->db->where('ptp_payment_plan.payment_plan_paid_amount','0');
        if(!empty($postdata['to_date'])){
        $this->db->where('payment_plan_date <=',$this->mastermodel->convert_date_format($postdata['to_date']));
        }
        
        if(!empty($postdata['from_date'])){
        $this->db->where('payment_plan_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        }
        $data = $this->db->get()->result();
        
      
        return $data;
    } 
      function load_monthly_coll_report($postdata)
{
    $data = array();
     $branch = $this->mastermodel->select_data_by_id("regional_branches", 'branch_id', $_SESSION['master_branch'], 'id', 'id');
          $branches=[];
          foreach($branch as $br){
              $branches[]=$br->id;
          }
          
                $profile_settings = $this->mastermodel->get_profile_settings();
                
    $this->db->select("
        SUM(
        CASE 
            WHEN ptp_payment_history.payment_plan_ptp_id != 0 THEN payment_plan_amount
            ELSE 0
        END
    ) AS ptp_amount,
    SUM(
        CASE 
            WHEN ptp_payment_history.payment_plan_ptp_id = 0 THEN payment_plan_amount
            ELSE 0
        END
    ) AS amount
    ");
    $this->db->from('ptp_payment_history');
    $this->db->join('complaints', 'complaints.complaints_id = ptp_payment_history.complaint_id');
    $this->db->join('master', 'complaints.complaints_id = master.master_id');
        $user_branch = $_SESSION['master_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";     
             if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
             }
             
         if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_creditor_id', $credior_id_s);
        }
        if ($profile_settings->regional_profile_id == $_SESSION['profile_id']) {

            $this->db->where_in('complaints.regional_branch', $branches);
        }
        if ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_assign_ids', $_SESSION['employee_id']);
        }
         if ($profile_settings->agency_profile_id == $_SESSION['profile_id']) {

             $allowed_branches=explode(',',$this->mastermodel->get_single_field_value('user','sub_branch_id','user_id',$_SESSION['user_id']));

            $this->db->where_in('complaints.regional_branch', $allowed_branches);
        }    
             
    if (!empty($postdata['to_date'])) {
        $this->db->where('ptp_payment_history.payment_plan_date <=', $this->mastermodel->convert_date_format($postdata['to_date']));
    }
    if (!empty($postdata['from_date'])) {
        $this->db->where('ptp_payment_history.payment_plan_date >=', $this->mastermodel->convert_date_format($postdata['from_date']));
    }
    if (!empty($postdata['collector_select1']) && ($postdata['collector_select1'] != 'all')) {
        $this->db->where('complaints.complaints_assign_ids', $postdata['collector_select1']);
    }
    if (!empty($postdata['region_select1']) && ($postdata['region_select1'] != 'all')) {
        $this->db->where('master.master_branch_id', $postdata['region_select1']);
    }
    if (!empty($postdata['branch_select1']) && ($postdata['branch_select1'] != 'all')) {
        $this->db->where('complaints.regional_branch', $postdata['branch_select1']);
    }
    
    $data = $this->db->get()->result();
    return $data;
}

      function get_cases($id,$val = "",$field = "",$nationality = "",$branch,$region_branch)
    {
        $this->db->where('complaints_creditor_id', $id);
        $this->db->from('complaints');
                              $this->db->join('master', 'master.master_id=complaints.complaints_id');

        if($branch){
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $branch . "') != 0";      
             $query.=")";   
           //  if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
           //  }
             
        }
         if(!empty($val)){
        $this->db->where('crm_lead_type_name',$val);
         }
        $this->db->join('crm_lead_type','crm_lead_type.crm_lead_type_id=complaints.complaints_case_type','left');
          if($nationality){
            
             $this->db->join('debtor','debtor.crm_debtor_id=complaints.complaints_debtor_id','left'); 
              $this->db->join('nationality','nationality.nationality_id=debtor.crm_debtor_nationality'); 
               $this->db->where($field,$nationality);
        }
         if($region_branch){
          $this->db->where('regional_branch', $region_branch);
        
        }
        $Q = $this->db->get();
        $num = $Q->num_rows();
        return $num;
    }
       function get_cases_amount($id,$val = "",$field = "",$nationality = "",$branch="",$region_branch="")
    {
          $this->db->select('SUM(complaints_debtor_total_os) AS amount');
               $this->db->from('complaints');
               
                      $this->db->join('master', 'master.master_id=complaints.complaints_id');
        if($branch){
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $branch . "') != 0";      
             $query.=")";   
           //  if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
           //  }
             
        }
        $this->db->where('complaints_creditor_id', $id);
        if(!empty($val)){
        $this->db->where('crm_lead_type_name',$val);
        }
        
        if($region_branch){
          $this->db->where('complaints.regional_branch', $region_branch);
        
        }
        $this->db->join('crm_lead_type','crm_lead_type.crm_lead_type_id=complaints.complaints_case_type','left');
        
        if(!empty($nationality)){
            
             $this->db->join('debtor','debtor.crm_debtor_id=complaints.complaints_debtor_id','left'); 
              $this->db->join('nationality','nationality.nationality_id=debtor.crm_debtor_nationality'); 
               $this->db->where($field,$nationality);
        }
          $this->db->group_by('complaints_creditor_id');
    
       
         $data = $this->db->get()->row();
      // echo $this->db->last_query(); die();
        return round($data->amount,3);
    }
      function get_debtor($id,$val)
    {
          $this->db->select('*');
               $this->db->from('debtor');
      
     
          $this->db->join('complaints', 'debtor.crm_debtor_id=complaints.complaints_debtor_id','left');
             $this->db->join('crm_lead_type','crm_lead_type.crm_lead_type_id=complaints.complaints_case_type','left');
          $this->db->where('complaints_creditor_id', $id);
        $this->db->where('crm_lead_type_name',$val);
    $this->db->limit(1);
       
         $data = $this->db->get()->result();
        return $data;
    }
        function get_active_note($id,$val)
    {
          $this->db->select('complaints_note_note');
               $this->db->from('complaints_note');
          $this->db->where('complaints_note_complaints_id', $id);
        $this->db->order_by('complaints_note_id', 'desc');
    
        $this->db->limit(1);
         $data = $this->db->get()->row();
        return $data;
    }
         function load_lawyer_report($postdata)
    {
          $this->db->select('*');
               $this->db->from('complaints');
      
        $this->db->join('lawyer', 'lawyer.lawyer_id=complaints.complaints_lawyer_id');
         $this->db->join('legal', 'legal.legal_complaints_id=complaints.complaints_id');
              $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id','left');
         $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id','left');
         if(!empty($postdata['lawyer_id'])){
          $this->db->where('complaints_lawyer_id', $postdata['lawyer_id']);
         }
     
    
       
         $data = $this->db->get()->result();
        return $data;
    }
         function get_lawyer_note($id)
    {
               $profile_settings = $this->mastermodel->get_profile_settings();
          $this->db->select('*');
               $this->db->from('complaints_note');
      
        $this->db->join('user', 'user.user_id=complaints_note.complaints_note_user_id');
      
          $this->db->where('complaints_note.complaints_note_complaints_id', $id);
         
      $this->db->where_in('user.profile_id', array($profile_settings->legal_profile_id,$profile_settings->lawyer_profile_id));
    
       
         $data = $this->db->get()->result();
        return $data;
    }
 function load_implimentation_report($postdata)
    {
          $this->db->select('*');
               $this->db->from('complaints');
              $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id','left');
         $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id','left');

      if(!empty($postdata['complaints'])){
          $this->db->where('complaints.complaints_id', $postdata['complaints']);
      }
     
      //$this->db->group_by('complaints_creditor_id');
       
         $data = $this->db->get()->result();


        return $data;
    }
        function load_collector_report($postdata)
    {
          $this->db->select('*');
               $this->db->from('complaints');
              $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id','left');
         $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id','left');
           $this->db->join('hr_employees', 'hr_employees.hr_employees_id=complaints.complaints_assign_ids','left');
      
          $this->db->where('complaints_assign_ids', $postdata['employee_id']);
      
     
      $this->db->group_by('complaints_creditor_id');
       
         $data = $this->db->get()->result();
        return $data;
    }
    
    
    
           function load_user_login_report($postdata)
    {
        $data = array();
        $this->db->select('login_details.*,user.profile_id');
        $this->db->from('login_details');
        $this->db->join('user', 'login_details.user_id=user.user_id');

         if(!empty($postdata['from_date'])){
            $date2=$this->mastermodel->convert_date_format($postdata['from_date']).' 00:00:00';
            $this->db->where('login_time >=',$date2);
        }
        if(!empty($postdata['to_date'])){
             $date1=$this->mastermodel->convert_date_format($postdata['to_date']).' 00:00:00';
            $this->db->where('login_time <=',$date1);
        }
       
                if(!empty($postdata['user_id'])){

        $this->db->where('login_details.user_id',$postdata['user_id']);
                }
        $this->db->where('logout_time !=','');
        $this->db->where('profile_id',6638);
      //  $this->db->group_by('MONTHNAME(payment_plan_paid_date)');
        $data = $this->db->get()->result();
       
        return $data;
    }
    
    
    
  function load_branch_income_report($postdata)
{
        $profile_settings = $this->mastermodel->get_profile_settings();

    $this->db->select("
    regional_branches.id,
    regional_branches.name,
    branch.branch_name,
    SUM(payment_deduction_history.branch_income) AS bi,
    SUM(payment_deduction_history.branch_wallet) AS wallet,
    regional_branches.type,
    CASE 
        WHEN regional_branches.type = 1 THEN 'Own Branch'
        WHEN regional_branches.type = 2 THEN 'Investor'
        ELSE 'Unknown' 
    END AS branch_type
", false); // `false` ensures no automatic escaping

$this->db->from("payment_deduction_history");
$this->db->join("regional_branches", "payment_deduction_history.region_branch = regional_branches.id", "inner");
$this->db->join("branch", "branch.branch_id = regional_branches.branch_id", "inner");
if ($profile_settings->regional_profile_id == $_SESSION['profile_id'] || 
    $profile_settings->agency_profile_id == $_SESSION['profile_id']) {
   $allowed_branches=explode(',',$this->mastermodel->get_single_field_value('user','sub_branch_id','user_id',$_SESSION['user_id']));

            $this->db->where_in('payment_deduction_history.region_branch', $allowed_branches);
} elseif ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {
    $collector_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_id', 'user_id', $_SESSION['user_id']);
    $this->db->where('payment_deduction_history.assignee', $collector_id);
}
    
if(!empty($postdata['to_date'])){
        $this->db->where('payment_deduction_history.date <=',$this->mastermodel->convert_date_format($postdata['to_date']));
        }
        
        if(!empty($postdata['from_date'])){
        $this->db->where('payment_deduction_history.date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        }
        
         if(!empty($postdata['region_select1'])){
        $this->db->where('payment_deduction_history.region',$postdata['region_select1']);
        }
        
         if(!empty($postdata['branch_select1'])){
        $this->db->where('payment_deduction_history.region_branch',$postdata['branch_select1']);
        }
$this->db->group_by("payment_deduction_history.region_branch");
$this->db->order_by("payment_deduction_history.region");

    $data = $this->db->get()->result();
    return $data;
}
  
}    
    ?>
