<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Settings extends MY_Controller {

    public function  __construct()
    {
         parent::__construct();
         $this->load->model('settingsmodel');
         $this->load->model('mastermodel');

    }
    
    function get_post_values()
    {
        $data = array();
        foreach ($_POST as $key => $value)
        {
            if($key != "submit")
            {
                $data[$key] =  $this->input->post($key);
            }
        }
        return $data;
    }
    
    function viewinsettingssearch($modelfunction, $page)
    {
        $output = $this->settingsmodel->$modelfunction();
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('settings/' . $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1));
    }
    
    function addinsettings($modelfunction, $resfunction, $page)
    {
        $postdata = $this->get_post_values();
        $data = array();
        $data = $this->settingsmodel->$modelfunction($postdata);
  
        $json_msg=$this->load->view('message', $data,TRUE);
      
        $output = $this->settingsmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('settings/' . $page . '', $data,TRUE);

        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1,'json_msg'=>$json_msg));
    }

    function edit_page($id, $table, $field, $page)
    { 
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data=$this->load->view('settings/' . $page, $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1));
    }
    
    function single_page($id, $table, $field, $page)
    { 
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('settings/' . $page, $data);
    }


    function get_profile_permission($profile_id)
    {
        $data['profile_id']=$profile_id;
        $data['viewinfo'] = $this->settingsmodel->get_profile_permission($profile_id);
        $data['modules'] = $this->mastermodel->getmoduledata();
        $this->load->view('settings/permission_list_by_profile', $data);
    }
    
    function checkprofileset($employee_id)
    {
        echo $this->settingsmodel->checkprofileset($employee_id);
    }
    function get_sub_branch(){
        error_reporting(-1);ini_set('display_errors',1);
         $postdata = $this->get_post_values();
         $subBranches=$this->mastermodel->getSubBranches($postdata['branches']);
          echo json_encode($subBranches);
        
        
    }
    
}