<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Propertyreport extends MY_Controller 
{
    public function __construct() 
    {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('propertymodel');
        
        $this->load->helper('to_pdf');

    }

    function get_post_values()
    {
        $data = array();
        foreach ($_POST as $key => $value)
        {
            if($key != "submit")
            {
                $data[$key] =  $this->input->post($key);
            }
        }
        return $data;
    }
    function viewinreportsearch($modelfunction,$subfolder, $page)
    {
        $output = $this->propertyreportmodel->$modelfunction();
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('property/'.$subfolder.'/'. $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1));
    }
    
    function addinreport($modelfunction, $resfunction,$subfolder, $page)
    {
        $postdata = $this->get_post_values();
        $data = array();
        $data = $this->propertyreportmodel->$modelfunction($postdata);
        $json_msg=$this->load->view('message', $data,TRUE);
        $output = $this->propertyreportmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('property/'.$subfolder.'/' . $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1,'json_msg'=>$json_msg));
    }

  
     function edit_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('property/'.$subfolder.'/' .$page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }
    
    function single_page($id, $table, $field,$subfolder, $page)
    { 
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('property/'.$subfolder.'/' . $page, $data);
    }
   
    
  
     function decidetodownload($mainfolder,$subfolder,$page, $viewdata, $filename)
    {

        //var_dump($_POST['ispdf']);

        if (isset($_POST['ispdf']) && $_POST['ispdf'] == 1)
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
            pdf_create($html, $filename, false);
        } else if (isset($_POST['ispdf']) && $_POST['ispdf'] == 2)
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
            header("Content-type: application/octet-stream");
            header("Content-Disposition: attachment; filename=" . $filename . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
            exit;
        } else
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/'  . $page, $viewdata, true);
            echo $html;
        }
    }
    
        function load_customer_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        if (empty($postdata['customer_id']))
        {
         $viewdata['viewinfo'] = $this->mastermodel->select_data('contact','contact_id');
        }
        else
        {
        $viewdata['viewinfo'] = $this->mastermodel->select_data_by_id("contact","contact_id",$postdata['customer_id']);
        }
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Customer Report');
    }
          function load_inventory_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->mastermodel->get_data_dual_joined("item_master",$postdata['prop_item_id'],"item_master_id",$postdata['prop_item_category_id'],"item_master_category_id","item_master_category_id","item_category","item_category_id");
     
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Inventory Report');
    }
           function load_circular_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->mastermodel->get_data_joined("prop_circular","prop_sub_circular","prop_circular_id","prop_sub_circular_circular_id",$postdata['detail_id'],"prop_circular_detail_id");
       
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Circular Report');
    }
          function load_legal_notice_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->mastermodel->select_data_by_id("prop_legal_notice","prop_legal_notice_customer_id",$postdata['customer_id']);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Customer Report');
    }
           function load_item_purchase_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_item_purchase_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Purchase Report');
    }
             function load_item_damage_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_item_damage_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Damage Report');
    }
    function load_item_transfer_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_item_transfer_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Transfer Report');
    }
    function load_item_request_to_client_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_item_request_to_client_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Request To client Report' );
    }
   function   load_penalty_report($mainfolder,$subfolder,$page){
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_penalty_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Penalty Report');
   }
    function load_service_provider_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_service_provider_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Service Provider');
    }
    function load_service_request_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_service_request_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Service Provider');
    }
    function load_maintantace_contract_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_maintantace_contract_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Maintantance Contract');
    }
    function load_rent_collection_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_rent_collection_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Maintantance Contract');
    }
    function load_lease_agrement_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_lease_agrement_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Maintantance Contract');
    }
    function load_property_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_property_report($postdata);
     
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Property');
    }
    function load_property_detail_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_property_detail_report($postdata);
     
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Property');
    }
     function load_property_asset_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();

        $viewdata['viewinfo'] = $this->propertyreportmodel->load_property_asset_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Property Assert');
    }
    function load_service_entry_report($mainfolder,$subfolder,$page){
        $viewdata = array();
        $postdata = $this->get_post_values();

         $viewdata['viewinfo'] = $this->propertyreportmodel->load_service_entry_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Service Entry Report');
    }
}

/* End of file master.php */
/* Location: ./application/controllers/master.php */
