<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Property extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('propertymodel');
        
        $this->load->helper('to_pdf');
    }

    public function view($folder, $page) {
        $this->load->view($folder . '/' . $page);
    }

    function get_post_values() {
        $data = array();
        foreach ($_POST as $key => $value) {
            if ($key != "submit") {
                $data[$key] = $this->input->post($key);
            }
        }
        return $data;
    }

    function addformdisplay($page, $directory, $return_page = '') {
        $data = array();
        $data['return_page'] = $return_page;

        $json_data = $this->load->view('' . $directory . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function viewinpropertysearch($modelfunction,$subfolder, $page, $pagenum) {

        $output = $this->propertymodel->$modelfunction($pagenum);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('property/'.$subfolder.'/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function addinproperty($modelfunction, $resfunction,$subfolder, $page) {
        $postdata = $this->get_post_values();
        $data = $this->propertymodel->$modelfunction($postdata);
        $json_msg = $this->load->view('message', $data, TRUE);

        $output = $this->propertymodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('property/'.$subfolder.'/' .  $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
    }

    function edit_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('property/'.$subfolder.'/' .$page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function single_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('master/' . $page, $data);
    }

    function deletedata($table, $id, $field) {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->mastermodel->deletedata($table, $id, $field);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
    function delete_pageinpurchase($modelfunction, $id) {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->propertymodel->$modelfunction($id);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
    function get_saved_values($model, $main_id)
    {
        $data['viewinfo'] = $this->propertymodel->$model($main_id);
        echo json_encode($data);
    }
    function get_saved_values_sub($modelfunction,$page,$id)
    {
     $postdata['viewinfo'] = $this->propertymodel->$modelfunction($id);
     $data['label'] =$this->load->view('property/management/'.$page, $postdata, TRUE);  
     echo json_encode($data);
        
    }
     function get_rack()
    {
           $postdata = $this->get_post_values();
        $data['viewinfo']= $this->mastermodel->select_data_by_id('godown_rack','godown_rack_godown_id',$postdata['godown_id']);
        echo json_encode($data);
    }

      function get_dealing_type($id)
    {
     $data = $this->mastermodel->get_single_field_value('ppty_dealing_type','dealing_type_name','dealing_type_id',$id);
         echo json_encode($data);
    }
     function get_type($id)
    {
     $data = $this->mastermodel->get_single_field_value('sub_category','property_type','sub_category_id',$id);
         echo json_encode($data);
    }  
     public function load_map_page() {
        

        $this->load->view('property/management/map');

    }
      public function load_contact_map_page() {
        

        $this->load->view('property/management/contact_map');

    }
    public function load_ppty_mymap_page() {
        

        $this->load->view('property/management/ppty_map');

    }
     function get_sub_label_details($modelfunction,$id)
    {
     $data['label'] = $this->propertymodel->$modelfunction($id);
    echo $this->load->view('property/management/details_label', $data);  
    }
      public function delimage($id)
  {
      $this->propertymodel->del_ppty_image($id);
       echo '1';
  }
   public function dlte_video($id)
  {
        $this->propertymodel->del_ppty_video($id);
       echo '1';
  }
   public function edit_map_page() {
        $postdata = $this->get_post_values();
        $data['lat'] = $postdata['lat'];
        $data['long'] = $postdata['long'];
        $data['address'] = $postdata['address'];
//         $data['sub_category_id']=$postdata['sub_category_id'];
        $this->load->view('property/management/edit_property_map', $data);
    }
    function get_item_category($item_id){
        $data['godown_id'] = $this->mastermodel->get_single_field_value('prop_purchase_category','prop_purchase_category_godown_id','prop_purchase_category_id',$item_id);
         $data['godown_name'] = $this->mastermodel->get_single_field_value('godown','godown_name','godown_id',$data['godown_id']);
    
        echo json_encode($data);
    }
    function get_godown($cat_id)
    {
        $godown_id = $this->mastermodel->get_single_field_value('prop_item_tras_cat','prop_item_tras_cat_godown_id','prop_item_tras_cat_id',$cat_id);
        $data['godown'] = $this->mastermodel->get_data_srow('godown',$godown_id,'godown_id');
         $data['viewinfo'] = $this->propertymodel->get_item($godown_id);
        echo json_encode($data);
    }
    function get_godown_return($cat_id)
    {
        $godown_id = $this->mastermodel->get_single_field_value('prop_item_return_cat','prop_item_return_cat_to_godown_id','prop_item_return_cat_id',$cat_id);
        $godown['name'] = $this->mastermodel->get_single_field_value('godown','godown_name','godown_id',$godown_id);
        $godown['id'] = $this->mastermodel->get_single_field_value('godown','godown_id','godown_id',$godown_id);
          $godown['viewinfo'] = $this->propertymodel->get_item($godown['id']);
        echo json_encode($godown);
    }
     function get_godown_damage($godown_id)
    {
         $data['viewinfo'] = $this->propertymodel->get_item($godown_id);
        echo json_encode($data);
    }
    function get_ajax_values($model,$table,$field, $id)
    {
        $data['viewinfo'] = $this->mastermodel->$model($table,$field, $id);
        
        echo json_encode($data);
    }
     function get_ajax_values_joined($model,$table,$condition,$id,$field,$table1,$field1)
    {
        $data['viewinfo'] = $this->mastermodel->$model($table,$condition,$id,$field,$table1,$field1);
        
        echo json_encode($data);
    }
     function get_service_req_customer($model,$table,$field, $id)
    {
        $data['viewinfo'] = $this->mastermodel->$model($table, $field,$id);
        $data['customer'] =$this->mastermodel->get_single_field_value('user','user_name','user_id',$data['viewinfo']->prop_service_request_user_id);
        echo json_encode($data);
    }
    
    function get_document($id)
    {
        $customer = $this->mastermodel->get_data_srow('contact',$id,'contact_id');
        if(!empty($customer))
        {
            echo json_encode($customer);
        }
        else
        {
            echo 0; 
        }
    }   
    function get_property($id)
    {   
        $property['name'] = $this->mastermodel->get_single_field_value('detail_entry','location','detail_id',$id);
        $property['result'] = $this->propertymodel->get_rooms($id);
        $property['count'] = $this->propertymodel->get_real_rooms($id);
        $data = $this->propertymodel->get_lease_data($id);
        $property['viewinfo'] = $this->propertymodel->get_document($data);
          $property['detail'] = $this->mastermodel->get_data_srow('detail_entry',$id,'detail_id');
           $property['owner'] = $this->mastermodel->get_data_srow('prop_owner',$property['detail']->prop_owner_id,'prop_owner_id');
        echo json_encode($property);
    }
    
    //function to get data from lease aggrmnt for rent collection
    function get_lease_details($id)
    {
        $data['check_excist'] = $this->mastermodel->get_num_rows('prop_rent_collection','prop_rent_collection_lease_agreement_id',$id);
        $data['lease_details'] = $this->mastermodel->get_data_srow('prop_lease_agreement',$id,'prop_lease_agreement_id');
        $data['from_date']=$this->mastermodel->convertdatenormalformat($data['lease_details']->prop_lease_agreement_fdate);
        $data['to_date']=$this->mastermodel->convertdatenormalformat($data['lease_details']->prop_lease_agreement_tdate);
        $data['customer'] = $this->mastermodel->get_data_srow('contact',$data['lease_details']->prop_lease_agreement_customer_id,'contact_id');
        $data['property'] = $this->mastermodel->get_data_srow('detail_entry',$data['lease_details']->prop_lease_agreement_property_id,'detail_id');
        $data['ppty_room_details'] = $this->mastermodel->get_data_srow('detail_entry_dealing_details',$data['lease_details']->prop_lease_agreement_room_id,'detail_entry_dealing_details_id');
        $data['lease_pymnt_details'] = $this->mastermodel->select_data_by_id('prop_lease_payment_details','prop_lease_payment_details_lease_agreement_id',$data['lease_details']->prop_lease_agreement_id);
        $data['asset'] = $this->mastermodel->get_data_srow('prop_asset_entry',$data['lease_details']->prop_lease_agreement_property_id,'prop_asset_entry_detail_id');
        $data['item'] = $this->mastermodel->get_data_joined('prop_sub_asset_entry','item_master','prop_sub_asset_entry_item_id','item_master_id',$data['asset']->prop_asset_entry_id,'prop_sub_asset_entry_asset_entry_id');
        
        $rent_collection_id=$this->mastermodel->get_single_field_value('prop_rent_collection','prop_rent_collection_id','prop_rent_collection_lease_agreement_id',$id);
//       $data['rent_paryment_history']=$this->propertymodel->rent_amount($rent_collection_id);
//               $this->mastermodel->select_data_by_id('prop_rent_collection_payment_details','prop_rent_collection_payment_details_rent_collection_id',$rent_collection_id);
        $rent_paryment_history=$this->mastermodel->select_data_by_id('prop_rent_collection_payment_details','prop_rent_collection_payment_details_rent_collection_id',$rent_collection_id);
        $amount=0;
        foreach ($rent_paryment_history as $value){
         $amount=$amount+$value->prop_rent_collection_payment_details_paid_amt;
        
        }
   $j=0;
   $data['prev_amt'] = array();
         foreach ( $data['lease_pymnt_details'] as $row){
             
//         $amount=$amount+$value->prop_rent_collection_payment_details_paid_amt;
        $data['prev_amt'][]= $this->propertymodel->rent_amount($row->prop_lease_payment_details_id);
      $j++;  
    
      
         }
          $data['lease_pymnt_details_service'] = $this->mastermodel->select_data_by_id('prop_lease_service_payment','prop_lease_service_payment_lease_agreement_id',$data['lease_details']->prop_lease_agreement_id);
        $h=0;
   $data['prev_amt_service'] = array();
         foreach ( $data['lease_pymnt_details_service'] as $row){
             
//         $amount=$amount+$value->prop_rent_collection_payment_details_paid_amt;
        $data['prev_amt_service'][]= $this->propertymodel->rent_amount_service($row->prop_lease_service_payment_id);
      $h++;  
    
      
         }
         $data['lease_pymnt_details_facilities'] = $this->mastermodel->select_data_by_id('prop_lease_facilities_payment','prop_lease_facilities_payment_lease_agreement_id',$data['lease_details']->prop_lease_agreement_id);
        $k=0;
   $data['prev_amt_facilities'] = array();
         foreach ( $data['lease_pymnt_details_facilities'] as $row){
             
//         $amount=$amount+$value->prop_rent_collection_payment_details_paid_amt;
        $data['prev_amt_facilities'][]= $this->propertymodel->rent_amount_facilities($row->prop_lease_facilities_payment_id);
      $k++;  
    
      
         }
     
        
//        $data['prev_amt']=$amount;
//        var_dump($data);die();
        echo json_encode($data);
    }
     function get_lease($id)
    {
        $data= $this->propertymodel->lease_agreement_by_customer($id);

       
        echo json_encode($data);
    }
    function get_lease_item_detailes($id)
    {   
        $data['check_excist'] = $this->mastermodel->get_num_rows('prop_rent_collection','prop_rent_collection_lease_agreement_id',$id);
        $data['lease_details'] = $this->mastermodel->get_data_srow('prop_lease_agreement',$id,'prop_lease_agreement_id');
        $data['room'] =$this->mastermodel->get_single_field_value('detail_entry_dealing_details','detail_room_no','detail_entry_dealing_details_id',$data['lease_details']->prop_lease_agreement_room_id);
        $data['customer'] = $this->mastermodel->get_data_srow('contact',$data['lease_details']->prop_lease_agreement_customer_id,'contact_id');
        $data['property'] = $this->mastermodel->get_data_srow('detail_entry',$data['lease_details']->prop_lease_agreement_property_id,'detail_id');
        $data['asset'] = $this->mastermodel->get_data_srow('prop_asset_entry',$data['lease_details']->prop_lease_agreement_property_id,'prop_asset_entry_detail_id');
        $data['item'] = $this->mastermodel->get_data_joined('prop_sub_asset_entry','item_master','prop_sub_asset_entry_item_id','item_master_id',$data['asset']->prop_asset_entry_id,'prop_sub_asset_entry_asset_entry_id');
        
        echo json_encode($data);
    }
       function print_lease($id)
    {
        $data['viewinfo'] = $this->mastermodel->get_data_srow("prop_lease_agreement", $id, "prop_lease_agreement_id");
        $data['id'] = $id;
        $output = $this->load->view('property/management/print_lease_agreement', $data , TRUE);
//        pdf_create($output , $billing_code);
        pdf_create_print($output , 'Lease_'.$id);
        echo "1";
    }
      public function puchase_edit_stock($id,$qty)
  {
      $this->propertymodel->puchase_edit_stock($id,$qty);
       echo '1';
  }
   public function transfer_edit_stock($id,$quantity,$fromgodown,$togodown)
  {
      $this->propertymodel->transfer_edit_stock($id,$quantity,$fromgodown,$togodown);
       echo '1';
  }
    function get_room_no($p_id,$c_id)
    {
        $data['value'] = $this->propertymodel->get_room_no($p_id,$c_id);
        echo json_encode($data);        
    }
    public function damage_edit_stock($id,$quantity,$godown)
  {
      $this->propertymodel->damage_edit_stock($id,$quantity,$godown);
       echo '1';
  }
}
?>
