<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Hr extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
       
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
     $this->load->library('PHPExcel');
        
        $this->load->helper('to_pdf');
    }

    public function view($folder, $page) {
        $this->load->view($folder . '/' . $page);
    }

    function get_post_values() {
        $data = array();
        foreach ($_POST as $key => $value) {
            if ($key != "submit") {
                $data[$key] = $this->input->post($key);
            }
        }
        return $data;
    }

    function addformdisplay($page, $directory, $return_page = '') {
        $data = array();
        $data['return_page'] = $return_page;

        $json_data = $this->load->view('' . $directory . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function viewinhrsearch($modelfunction,$subfolder, $page, $pagenum) {

        $output = $this->hrmodel->$modelfunction($pagenum);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('hr/'.$subfolder.'/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function addinhrsearch($modelfunction, $resfunction,$subfolder, $page) {
        $postdata = $this->get_post_values();
        $data = $this->hrmodel->$modelfunction($postdata);
        $json_msg = $this->load->view('message', $data, TRUE);

        $output = $this->hrmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('hr/'.$subfolder.'/' .  $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
    }

    function edit_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('hr/'.$subfolder.'/' .$page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function single_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('master/' . $page, $data);
    }

    function deletedata($table, $id, $field) {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->mastermodel->deletedata($table, $id, $field);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
    function get_saved_values($model, $main_id)
    {
        $data['viewinfo'] = $this->hrmodel->$model($main_id);
        echo json_encode($data);
    }
    function addinhr($modelfunction, $resfunction,$subfolder, $page) {
        $postdata = $this->get_post_values();
        $data = $this->hrmodel->$modelfunction($postdata);
        $json_msg = $this->load->view('message', $data, TRUE);

        $output = $this->hrmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('hr/'.$subfolder.'/' .  $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
    }
     function leave_approval($leavid)
    {
       
        $output['status'] = $this->hrmodel->leave_approval($leavid);
        echo json_encode($output);
    }
    function leav_approval_test($modal_name)
    {
        $postdata = $this->get_post_values();
       
        $data = $this->hrmodel->$modal_name($postdata);
        echo json_encode($data);
    }
    function leav_reject($modal_name)
    {
        $postdata = $this->get_post_values();
       
        $data = $this->hrmodel->$modal_name($postdata);
        echo json_encode($data);
    }
    function leave_approval_higher($leavid)
    {
       
        $output['status'] = $this->hrmodel->leave_approval_higher($leavid);
        echo json_encode($output);
    }
      function salary_approval($id)
    {
       
        $output['status'] = $this->hrmodel->salary_approval($id);
        echo json_encode($output);
    }
    function claim_approval_higher($claim_id)
    {
       
        $output['status'] = $this->hrmodel->claim_approval_higher($claim_id);
        echo json_encode($output);
    }
    function claim_release($claim_id)
    {
       
        $output['status'] = $this->hrmodel->claim_release($claim_id);
        echo json_encode($output);
    }
      function popup_withid($page, $id)
    {
        $data = array();
        $data['id'] = $id;
        $this->load->view('hr/management/' . $page, $data);
    }
     public function holding_passport()
    {
       
        $postdata = $this->get_post_values();
        $data = $this->hrmodel->hold_passport($postdata);

        echo json_encode($data);
    }
    public function save_rejoin_data()
    {
        $postdata = $this->get_post_values();
        $data = $this->hrmodel->save_rejoin_data($postdata);var_dump($postdata);

        echo json_encode($data);
    }
     function load_all_employee_salary_payment()
    {
         $postdata = $this->get_post_values();
         $data['viewinfo']=$this->hrmodel->getemployeelist();
          
         $data['date']=$postdata['date'];
         $this->load->view('hr/management/add_multiple_employee_salary_payment',$data);
    }
      function checksalarymonth()
    {
        $data=array();
        $data['info']=$_POST;
             
        $salary_count = $this->hrmodel->count_data_salary('hr_employee_salary',$data['info']['id'],$data['info']['date']) ;
    
        if($salary_count == 0)
        {
            echo "salary_not_set";
        }
        else
        {
            $salary_exist= $this->hrmodel->check_salary_month($data['info']['id'],$data['info']['date']);
            if($salary_exist>0)
            echo "salary_exists";
        }
    } 
      function load_employees_salary($id,$date, $type = "")
    {
            $postdata = $this->get_post_values();
            if(!empty($postdata)){
              $id = $postdata['employee_id'];  
              $date = $postdata['salary_date']; 
              $type = $postdata['type']; 
            }
              $salary_exist= $this->hrmodel->check_salary_month($id,$date);
            if($salary_exist>0){
                 echo '<script type="text/javascript">alert(\'Employee Salary Exists\');</script>';
            }
            else{
        $employee_salary_id=$this->hrmodel->get_employee_salary_id($id,$date);
        if($employee_salary_id!="")
        {
            $data['viewinfo']=$this->mastermodel->get_data_srow('hr_employee_salary',$employee_salary_id,'hr_employee_salary_id');
            $data['salary_date']=$date;
            $data['form_type'] = $type;
            $data['emp_sal_id']=$employee_salary_id;
            $this->load->view('hr/management/add_single_employee_salary_payment',$data);
        }
        else
        {
            echo '<script type="text/javascript">alert(\'Employee Salary Not set\');</script>';
        }
    }
    }
     function autosuggestemployeesalarypayment($salary_date) {       
        $q = strtolower($_POST["q"]);
        if (!$q)
            return;
        $salary_month= date("m", strtotime($salary_date));
        $salary_year=date("Y", strtotime($salary_date));
        
        $employee_list = $this->hrmodel->getunpaidemployees($salary_month, $salary_year);
        foreach ($employee_list as $items) {
            $name = $items['hr_employees_name'];
            $emp_no = $items['hr_employees_code'];
            if (strpos(strtolower($name), $q) !== false) {
                echo '' . $name . '-' . $emp_no . '#' . $items['hr_employees_id'] . '#';
                echo "\n";
            } else if (strpos(strtolower($emp_no), $q) !== false) {
                echo '' . $name . '-' . $emp_no . '#' . $items['hr_employees_id'] . '#';
                echo "\n";
            }
        }
    }
    function check_before_gratuity()
    {
        $data = array();
        $employee_id = $_POST['employee_id'];

        $date = $_POST['joiningdate'];
        if ($this->mastermodel->get_num_rows('hr_employee_salary', 'hr_employee_salary_employee_id', $employee_id) == 0)
        {
            $data['status'] = false;
            $data['msg'] = "Pay structure not avalable";
        } else
        {
            $res = $this->hrmodel->gratuity_check($employee_id);
            if ($res > 0)
            {
                $gratuity = $this->hrmodel->gratuity_check_by_employee($employee_id, $date);
                if (!empty($gratuity))
                {

                    $data['status'] = true;
                    $data['joiningdate'] = $gratuity->hr_gratuity_pay_date;
                } else
                {
                    $data['status'] = true;
                    $data['joiningdate'] = $date;
                }
            } else
            {
                $data['status'] = true;
                $data['joiningdate'] = $date;
            }
        }
        echo json_encode($data);
    }
    public function gratuity_calculations()
    {

        $data = array();
        $postdata = $this->get_post_values();
        $sal = $this->hrmodel->get_pay_structure_by_employee($_POST['employee_id']);
        $netpay = $this->hrmodel->get_netpay_by_salaryid($sal->hr_employee_salary_id);
        $joinYear = date('Y', strtotime($_POST['joiningdate']));
        $firstYear = date('Y', strtotime($_POST['startdate']));
        $lastYear = date('Y', strtotime($_POST['paydate']));
        $amount = 0;
        $netamount = 0;
        for ($i = $firstYear; $i <= $lastYear; $i++)
        {
            $service = 0;
            $service = $i - $joinYear;

//            if ($service <= 2)
//            {
//                $amount = $netpay->netpay * 50 / 100;
//            } else
//            {
//                $amount = $netpay->netpay;
//            }
              if ($service <= 3)
            {
                $amount = ($sal->hr_employee_salary_basic_salary * 15 * $service)/26;
            } else
            {
                $amount = $sal->hr_employee_salary_basic_salary  * $service;
            }

            $data['viewinfo'][] = array(
                'employee_id' => $_POST['employee_id'],
                'year' => $i,
                'netpay' => $netpay->netpay,
                'service' => $service,
                'amount' => $amount,
                'basic_salary' => $sal->hr_employee_salary_basic_salary ,
            );
          
            
            $netamount = $netamount + $amount;
        }
        
        $res = $this->hrmodel->gratuity_check($_POST['employee_id']);
        if ($res > 0)
        {
            $gratuity = $this->hrmodel->gratuity_pending_by_employee($_POST['employee_id']);
            if (!empty($gratuity))
            {
                if ($gratuity->pending_amount != 0)
                {
                    $gamount = $gratuity->hr_gratuity_amount;
                    $netamount = $netamount - $gamount;
                }
            }
        }
        $data['employee_id'] = $_POST['employee_id'];
        $data['netpay'] = $netpay->netpay;
        $data['netamount'] = $netamount;
         $data['basic_salary'] = $sal->hr_employee_salary_basic_salary;
         $data['netamount'] = $netamount;
       
        $data['view'] = $this->load->view('hr/management/view_gratuity_table', $data, TRUE);
        echo json_encode($data);
    }
      public function save_calculatedamounts($modelfunction, $page)
    {
        $output = array();
        $postdata = $this->get_post_values();
        $data = $this->hrmodel->$modelfunction($postdata);
          $json_msg = $this->load->view('message', $data, TRUE);

    
        $json_data = $this->load->view('hr/management/' . $page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
       
       
    }
      public function load_det_page($modelfunction, $page, $id)
    {
        
        $data['viewinfo'] = $this->hrmodel->$modelfunction($id);
        $this->load->view('hr/management/'  . $page, $data);

    }
  function get_branchwise($table, $field,$branchfield,$primary_field, $id, $emp_id)
    {
        $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id', $emp_id);
       $data['viewinfo'] = $this->hrmodel->get_branchwise($table, $field, $id,$primary_field,$branchfield, $branch_id);
      echo json_encode($data);
    }
  public function attendance_file_upload()
    {
 
  
              $data = array();
      
        $postdata = $this->get_post_values();
      
       if(isset($_FILES["file"]["name"]))
       {
           $path=$_FILES["file"]["tmp_name"];
           $object = PHPExcel_IOFactory::load($path);
           $i=0;
           foreach ($object->getWorksheetIterator() as $worksheet)
           {
               $i++;
               $highestRow = $worksheet->getHighestRow();
               $highestColumn = $worksheet->getHighestColumn();
               for($row=4; $row<$highestRow; $row++)
               {
                  $emp_code =  $worksheet->getCellByColumnAndRow(0, $row)->getValue();
                  $emp_code='EMP'.$emp_code;
               //   $date =  $worksheet->getCellByColumnAndRow(3, 3)->getValue();
                 
                   // $in_time =  $worksheet->getCellByColumnAndRow(4, $row)->getValue();
                     //$out_time =  $worksheet->getCellByColumnAndRow(5, $row)->getValue();
                     
                  for($j=2; $j<60; $j++)
               {
                   
                   $date =  $worksheet->getCellByColumnAndRow($j, 3)->getValue();
                 // echo $date."<br>";
                   if($date==09){
                     //if(!empty($time)){
                         $time =  $worksheet->getCellByColumnAndRow($j, $row)->getValue();
                     echo $time;
                     $emp_data = $this->mastermodel->get_data_srow('hr_employees',$emp_code,'hr_employees_code');
                  if(!empty($emp_data)){
                     $masterid = $this->mastermodel->insertmasterdata();
                        $tblValues = array(
                            'hr_attendance_id' => $masterid,
                            'hr_department_id' => $emp_data->hr_employees_department_id,
                            'hr_attendance_date' => $date,
                            'hr_attendance_emp_id' => $emp_data->hr_employees_id,
                            'hr_attendance_start_time' => $in_time,
                            'hr_attendance_end_time' => $out_time,
                        );

                    //    $this->db->insert('hr_attendance', $tblValues);
                  }
                  //   }
                   }
                   
              }  
                   
                   
                   
            //       $device_id =  $worksheet->getCellByColumnAndRow(0, $row)->getValue();
                  
                  
            //       $date =  $worksheet->getCellByColumnAndRow(3, $row)->getValue();
            //         $in_time =  $worksheet->getCellByColumnAndRow(4, $row)->getValue();
            //          $out_time =  $worksheet->getCellByColumnAndRow(5, $row)->getValue();
            //          $note=  $worksheet->getCellByColumnAndRow(12, $row)->getValue();
            //          $device_id=intval($device_id);
                   
            //           if(!empty($in_time) || !empty($out_time)){
                         
            //          $emp_data = $this->mastermodel->get_data_srow('hr_employees',$device_id,'device_id');
            //       if(!empty($emp_data)){
            //          $masterid = $this->mastermodel->insertmasterdata();
            //             $tblValues = array(
            //                 'hr_attendance_id' => $masterid,
            //                 'hr_department_id' => $emp_data->hr_employees_department_id,
            //                 'hr_attendance_date' => $date,
            //                 'hr_attendance_emp_id' => $emp_data->hr_employees_id,
            //                 'hr_attendance_start_time' => $in_time,
            //                 'hr_attendance_end_time' => $out_time,
            //                 'hr_attendance_remarks' =>$note,
            //             );

            //             $this->db->insert('hr_attendance', $tblValues);
            //       }
                   
            //   }
              // }
                
           }
           }
                   
      die();       
        echo json_encode($data);
       }
      
  }
   public function get_shift_detailes($id)
    {
   $data=$this->mastermodel->get_data_srow('hr_shift_details',$id,'hr_shift_details_id');
      echo json_encode($data);
    } 
    public function get_employee_detailes($employee_id)
    {
   $data=$this->hrmodel->get_employee_details($employee_id);
  
      echo json_encode($data);
    }  
    public function get_eligble_amount()
    {
        $postdata = $this->get_post_values();
        
        $data= $this->hrmodel->get_claim_amount($postdata);
      
          echo json_encode($data);
    }
            function salary_print($val)
    {
            $Text = urldecode($val);
$Mixed = json_decode($Text);
  
          
//           $id,$date, $type = ""
            $id = $Mixed->employee_id;
            $date = $this->mastermodel->convertdatenormalformat($Mixed->salarydate);
         
        $employee_salary_id=$this->hrmodel->get_employee_salary_id($id,$date);
        
        if($employee_salary_id!="")
        {
            $data['viewinfo']=$this->mastermodel->get_data_srow('hr_employee_salary',$employee_salary_id,'hr_employee_salary_id');
            $data['salary_date']=$date;
            $data['form_type'] = $type;
            $data['emp_sal_id']=$employee_salary_id;
          
          $html =  $this->load->view('hr/management/add_single_employee_salary_payment',$data,true);
         
            pdf_create($html, 'Employee Salary', false);
        }
//            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
          
           
    }
    public function leave_approva_request($hr_leave_application_id)
            {

        $data = array();
        $postdata = $this->get_post_values();
       
         $data['leave_details'] =  $this->mastermodel->get_data_srow('hr_leave_application',$hr_leave_application_id,'hr_leave_application_id');
       $data['id']=$hr_leave_application_id;
        $data['view'] = $this->load->view('hr/management/leave_approval', $data, TRUE);
        echo json_encode($data);
    }
    public function leave_reject_request($hr_leave_application_id)
            {

        $data = array();
       
       
         $data['leave_details'] =  $this->mastermodel->get_data_srow('hr_leave_application',$hr_leave_application_id,'hr_leave_application_id');
       $data['id']=$hr_leave_application_id;
        $data['view'] = $this->load->view('hr/management/leave_reject', $data, TRUE);
        echo json_encode($data);
    }
      public function delimage($id)
  {
      $this->hrmodel->del_ppty_image($id);
       echo '1';
  }
      function payslip_pdf($mainfolder,$subfolder,$page,$id)
    {

                $this->load->library('Pdf');
   $data['payslip'] =  $this->mastermodel->get_data_srow('hr_employee_salary_slip',$id,'hr_employee_salary_slip_id');
   $employee_id =  $data['payslip']->hr_employee_salary_employee_id;
    $data['employee'] =  $this->mastermodel->get_data_srow('hr_employees',$employee_id,'hr_employees_id');
     $data['company'] =   $this->mastermodel->select_data_by_row('company','company.project_id',$_SESSION['project_id'],'company_id','company_id');
      
     $this->load->view($mainfolder.'/'.$subfolder.'/' . $page,$data);
         
        }
         function get_details()
    {
        $data['viewinfo'] = $this->mastermodel->selected_data_by_user('hr_employees',array('hr_employees_name','hr_employees.user_id','hr_employees_id'),'hr_employees_id');
        
        echo json_encode($data);
    }
      function get_circular_content($content_id)
    {
        $data = $this->mastermodel->get_single_field_value('hr_circular_type', 'hr_circular_type_content', 'hr_circular_type_id', $content_id);
      
      echo json_encode($data);
    }
    
     function get_total_leave_taken()
    {
         $data = 0;
        $postdata = $this->get_post_values();
       // print_r($postdata);die();
        $output['res'] = $this->hrmodel->get_total_leave_taken($postdata['id']);
        echo json_encode($output);
    }
}
