<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Clientreport extends MY_Controller 
{
    public function __construct() 
    {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('propertymodel');
        $this->load->library('PHPExcel');
        $this->load->helper('to_pdf');

    }

    function get_post_values()
    {
        $data = array();
        foreach ($_POST as $key => $value)
        {
            if($key != "submit")
            {
                $data[$key] =  $this->input->post($key);
            }
        }
        return $data;
    }
    
    function viewinreportsearch($modelfunction,$subfolder, $page)
    {
        $output = $this->clientreportmodel->$modelfunction();
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('client/'.$subfolder.'/'. $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1));
    }
    
    function addinreport($modelfunction, $resfunction,$subfolder, $page)
    {
        $postdata = $this->get_post_values();
        $data = array();
        $data = $this->clientreportmodel->$modelfunction($postdata);
        $json_msg=$this->load->view('message', $data,TRUE);
        $output = $this->clientreportmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('client/'.$subfolder.'/' . $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1,'json_msg'=>$json_msg));
    }

    function edit_page($id, $table, $field,$subfolder, $page)
    { 
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data=$this->load->view('client/' .$subfolder.'/'. $page, $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1));
    }
    
    function single_page($id, $table, $field,$subfolder, $page)
    { 
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('client/'.$subfolder.'/' . $page, $data);
    }
   
     function decidetodownload($mainfolder,$subfolder,$page, $viewdata, $filename)
    {

        //var_dump($_POST['ispdf']);

        if (isset($_POST['ispdf']) && $_POST['ispdf'] == 1)
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
            pdf_create($html, $filename, false);
        } else if (isset($_POST['ispdf']) && $_POST['ispdf'] == 2)
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
            header("Content-type: application/octet-stream");
            header("Content-Disposition: attachment; filename=" . $filename . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
            exit;
        } else
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/'  . $page, $viewdata, true);
            echo $html;
        }
    }
  
    //  function decidetodownload($mainfolder,$subfolder,$page, $viewdata, $filename)
    // {

    //     //var_dump($_POST['ispdf']);

    //     if (isset($_POST['ispdf']) && $_POST['ispdf'] == 1)
    //     {
    //         $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
    //         pdf_create($html, $filename, false);
    //     } else if (isset($_POST['ispdf']) && $_POST['ispdf'] == 2)
    //     {
            
    //          $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
    //         header("Content-type: application/octet-stream");
    //         header("Content-Disposition: attachment; filename=" . $filename . ".xls");
    //         header("Pragma: no-cache");
    //         header("Expires: 0");
    //         echo $html;
    //         exit;
    // //       $this->load->library('PHPExcel');
    // // $objPHPExcel = new PHPExcel();

    // // // Load the view content (assuming it generates an HTML table)
    // // $html = $this->load->view("$mainfolder/$subfolder/$page", $viewdata, true);

    // // // Parse HTML and populate Excel
    // // $dom = new DOMDocument();
    // // @$dom->loadHTML($html);
    // // $rows = $dom->getElementsByTagName('tr');
    // // $rowIndex = 1;

    // // foreach ($rows as $row) {
    // //     $columns = $row->getElementsByTagName('td');
    // //     $colIndex = 0; // PHPExcel columns start from 0

    // //     foreach ($columns as $column) {
    // //         $cellValue = $column->nodeValue;
    // //         $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($colIndex, $rowIndex, $cellValue);
    // //         $colIndex++;
    // //     }
    // //     $rowIndex++;
    // // }

    // // // Set the filename for download
    // // $filename = $filename . '.xlsx';

    // // // Send headers for file download
    // // header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    // // header('Content-Disposition: attachment;filename="' . $filename . '"');
    // // header('Cache-Control: max-age=0');

    // // // Create Writer and save to output
    // // $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    // // $writer->save('php://output');
    // // exit;
   
            
    //     } else
    //     {
    //         $html = $this->load->view($mainfolder.'/'.$subfolder.'/'  . $page, $viewdata, true);
    //         echo $html;
    //     }
    // }
        function load_lead_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->clientreportmodel->load_lead_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Lead Report');
    }
          function load_deal_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->clientreportmodel->load_deal_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Deal Report');
    }
            function load_deal_closing_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->mastermodel->select_data_by_id("crm_deal_details","crm_deal_details_closing_date",$this->mastermodel->convert_date_format($postdata['closing_date']));
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Deal Closing Report');
    }
          function load_deal_open_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->clientreportmodel->load_deal_open_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Deal Report');
    }
    function load_lost_deal_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->clientreportmodel->load_lost_deal_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Deal Report');
    }
    function load_deal_closing_this_month_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->clientreportmodel->load_deal_closing_this_month_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Deal Report');
    }
    function load_contact_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->clientreportmodel->load_contact_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Contact Report');
    }  
    function load_contact_collected_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->clientreportmodel->load_contact_collected_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Contact Collected Report');
    }  
    function load_crm_flow_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata['viewinfo'] = $this->get_post_values();
        
        if (isset($_POST['ispdf']) && $_POST['ispdf'] == 1)
        {
            $html = $_POST['content'];
            pdf_create($html, $filename, false);
        } else if (isset($_POST['ispdf']) && $_POST['ispdf'] == 2)
        {
            $html = $_POST['content'];
            header("Content-type: application/octet-stream");
            header("Content-Disposition: attachment; filename=" . $filename . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
            exit;
        } else
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/'  . $page, $postdata, true);
            echo $html;
        }
    }
   
    public function flow_lead_sub($id)
    {
        $data['from_date'] = $_REQUEST['from_date'];
        $data['to_date'] = $_REQUEST['to_date'];
        $data['id'] = $id;
      
       $output = $this->clientreportmodel->flow_lead_sub($data);
        $data['viewinfo'] = $output['results'];
     
        $data['view'] = $this->load->view('client/report/flow_lead', $data, TRUE);
        echo $data['view'];
    }
    public function flow_task_sub($id)
    {
        $data['frmdate'] = $_REQUEST['from_date'];
        $data['todate'] = $_REQUEST['to_date'];
        $data['id'] = $id;
        
        $output = $this->clientreportmodel->flow_task_sub($data);
        $data['viewinfo'] = $output['results'];
     
        $data['view'] = $this->load->view('client/report/flow_task', $data, TRUE);
        $data['view'] .= $this->load->view('client/report/flow_deal', $data['id'], TRUE);
        echo $data['view'];
    }
     public function flow_deal_task_sub($id)
    {
        $data['from_date'] = $_REQUEST['from_date'];
        $data['to_date'] = $_REQUEST['to_date'];
        $data['id'] = $id;
        
        $output = $this->clientreportmodel->flow_deal_task_sub($data);
        $data['viewinfo'] = $output['results'];
     
        $data['view'] = $this->load->view('client/report/flow_task', $data, TRUE);
        echo $data['view'];
    }
     public function flow_contact_task_sub($id)
    {
        $data['frmdate'] = $_REQUEST['from_date'];
        $data['todate'] = $_REQUEST['to_date'];
        $data['id'] = $id;
        
        $output = $this->clientreportmodel->flow_contact_task_sub($data);
        $data['viewinfo'] = $output['results'];
     
        $data['view'] = $this->load->view('client/report/flow_task', $data, TRUE);
        echo $data['view'];
    }
    function load_todeal_dwr_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->clientreportmodel->load_todeal_dwr_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Lead to Deal date wise report');
    }  
             function load_debtor_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->mastermodel->select_data_by_id("debtor","crm_debtor_id",$postdata['debtor_id']);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Debtors List Report');
    }
                function load_creditors_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        if($postdata['region']!=''){
          $viewdata['branch']=$postdata['region'];
        }
       if($postdata['branch_select']!=''){
          $viewdata['region_branch']=$postdata['branch_select'];
        }
        $viewdata['viewinfo'] = $this->clientreportmodel->creditors_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Creditors List Report');
    }
   
                  function load_ptp_list_report($mainfolder,$subfolder,$page)
    {
     
        $postdata = $this->get_post_values();
  
        $viewdata['viewinfo'] = $this->clientreportmodel->ptp_list_report($postdata);
      
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'PTP List Report');
    }
                  function load_employee_collection_report($mainfolder,$subfolder,$page)
    {
     
        $postdata = $this->get_post_values();
  
        $viewdata['viewinfo'] = $this->clientreportmodel->employee_collection_report($postdata);
      
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Employee Collection Report');
    }
                   function load_pending_collection_report($mainfolder,$subfolder,$page)
    {
     
        $postdata = $this->get_post_values();
  
        $viewdata['viewinfo'] = $this->clientreportmodel->pending_collection_report($postdata);
      
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Pending Collection Report');
    }
    function load_monthly_coll_report($mainfolder,$subfolder,$page)
    {
     
        $postdata = $this->get_post_values();
  
        // $viewdata['viewinfo'] = $this->clientreportmodel->load_monthly_coll_report($postdata);
        if(!empty($postdata['region_select1'])){
             $viewdata['branches']=$this->mastermodel->select_data_by_id('branch','branch_id',$postdata['region_select1']);
        }else{
                    $region = explode(',',$_SESSION['user_branch']);

                    $viewdata['branches']=$this->mastermodel->selected_data_branch_details('branch',$region);

        }
        $viewdata['frmdate'] = $postdata['from_date'];
        $viewdata['todate'] = $postdata['to_date'];
        $viewdata['regional_branch'] = $postdata['branch_select1'];
        $viewdata['collector_id'] = $postdata['collector_select1'];

        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Monthly Collection Report');
    }
  function load_implimentation_report($mainfolder,$subfolder,$page)
    {
     
        $postdata = $this->get_post_values();
  
        $viewdata['viewinfo'] = $this->clientreportmodel->load_implimentation_report($postdata);
      
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Implimentation Report');
    }
     function load_lawyer_report($mainfolder,$subfolder,$page)
    {
     
        $postdata = $this->get_post_values();
  
        $viewdata['viewinfo'] = $this->clientreportmodel->load_lawyer_report($postdata);
      
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Lawyer Report');
    }
      function load_collector_report($mainfolder,$subfolder,$page)
    {
     
        $postdata = $this->get_post_values();
  
        $viewdata['viewinfo'] = $this->clientreportmodel->load_collector_report($postdata);
      
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Collector Report');
    }
    
     function load_user_login_report($mainfolder,$subfolder,$page)
    {
     
        $postdata = $this->get_post_values();
  
        $viewdata['viewinfo'] = $this->clientreportmodel->load_user_login_report($postdata);
      
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'User Login Report');
    }
     function load_overall_commission_report5($mainfolder,$subfolder,$page)
    {
     
        $postdata = $this->get_post_values();
  
        $viewdata['viewinfo'] = $this->clientreportmodel->load_user_login_report($postdata);
      
       $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'User Login Report');
    }
    function load_overall_commission_report()
    { 
 $postdata = $this->get_post_values();

    ob_end_clean();
    error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('memory_limit', '3G');
set_time_limit(0);
$commision_settings = $this->mastermodel->get_commission_settings($postdata['creditor_id']);
$other_cost_1 = floatval($commision_settings->other_cost_1);
$other_cost_2 = floatval($commision_settings->other_cost_2);

if ($_SESSION['profile_id'] == 3708) {

$query = $this->db->query("
SELECT 
    contact.contact_company_name AS company_name,
    regional_branches.name AS branch,
    branch.branch_name AS region,
    hr_employees.hr_employees_name AS Collector,
    debtor.crm_debtor_agreement_no,
    complaints.complaints_code,
    debtor.crm_debtor_first_name,
    debtor.crm_debtor_mobile_1,
    crm_lead_type.crm_lead_type_name AS complaint_type,
    crm_lead_status.crm_lead_status_name AS complaint_status,
    complaints.complaints_debtor_principle_amnt AS principal,
    COALESCE(complaints.extra_amount_paid, 0) AS Paid_amount,
    COALESCE(complaints.adjustment_amount, 0) AS Adjustment,
    COALESCE(complaints.complaints_debtor_total_os, 0) AS Total_OS,
    COALESCE(complaints.agency_commsion, 0) AS `Agency Commission`,
    COALESCE(complaints.service_charge, 0) AS `Service Commission`,
    COALESCE(complaints.rm_commission, 0) AS `RM Commission`,
    COALESCE(complaints.br_commission, 0) AS `Branch Commission`,
    COALESCE(complaints.cl_commission, 0) AS `Collector Commission`,
    COALESCE(complaints.hq_commission, 0) AS `HQ Commission`,
    COALESCE(complaints.branch_income, 0) AS `Branch Income`,
    COALESCE(complaints.complaints_cost_amount, 0) AS Cost1,
    COALESCE(complaints.complaints_expense_amount, 0) AS Cost2,

    -- Total Income Calculation
    ROUND((
        COALESCE(complaints.agency_commsion, 0) +
        COALESCE(complaints.rm_commission, 0) +
        COALESCE(complaints.br_commission, 0) +
        COALESCE(complaints.cl_commission, 0) +
        COALESCE(complaints.hq_commission, 0) +
        COALESCE(complaints.complaints_cost_amount, 0) +
        COALESCE(complaints.complaints_expense_amount, 0)
    ), 3) AS Total_Income,

    -- KK Calculation
    ROUND((
        COALESCE(complaints.extra_amount_paid, 0) - (
            COALESCE(complaints.agency_commsion, 0) +
            COALESCE(complaints.rm_commission, 0) +
            COALESCE(complaints.br_commission, 0) +
            COALESCE(complaints.cl_commission, 0) +
            COALESCE(complaints.hq_commission, 0) +
            COALESCE(complaints.complaints_cost_amount, 0) +
            COALESCE(complaints.complaints_expense_amount, 0)
        )
    ), 3) AS KK,

    -- Total Calculation
    ROUND((
        COALESCE(complaints.extra_amount_paid, 0) - (
            COALESCE(complaints.agency_commsion, 0) +
            COALESCE(complaints.rm_commission, 0) +
            COALESCE(complaints.br_commission, 0) +
            COALESCE(complaints.cl_commission, 0) +
            COALESCE(complaints.hq_commission, 0) +
            COALESCE(complaints.complaints_cost_amount, 0) +
            COALESCE(complaints.complaints_expense_amount, 0)
        ) - COALESCE(complaints.branch_income, 0)
    ), 3) AS Total,

    COALESCE(complaints.adjusment_income, 0) AS `Adjustment Income`

FROM complaints
JOIN debtor ON debtor.crm_debtor_id = complaints.complaints_debtor_id
JOIN contact ON contact.contact_id = complaints.complaints_creditor_id
LEFT JOIN crm_lead_type ON complaints.complaints_case_type = crm_lead_type.crm_lead_type_id
LEFT JOIN master ON complaints.complaints_id = master.master_id
LEFT JOIN crm_lead_status ON crm_lead_status.crm_lead_status_id = complaints.complaints_status_id
JOIN branch ON master.master_branch_id = branch.branch_id
JOIN regional_branches ON regional_branches.id = complaints.regional_branch
LEFT JOIN hr_employees ON hr_employees.hr_employees_id = complaints.complaints_assign_ids
WHERE contact.contact_id = '".$postdata['creditor_id']."'
AND (complaints.extra_amount_paid + complaints.adjustment_amount) != 0
ORDER BY COALESCE(crm_lead_type.crm_lead_type_id, 0) ASC;

     ");
}
else{
   // Fetch regional branch IDs
$branches = [];
$branch_data = $this->mastermodel->select_data_by_id("regional_branches", 'branch_id', $_SESSION['user_branch'], 'id', 'id');
foreach ($branch_data as $br) {
    $branches[] = $br->id;
}

// Fetch profile settings
$profile_settings = $this->mastermodel->get_profile_settings();

// Initialize query
$this->db->select("
  SELECT 
    contact.contact_company_name AS company_name,
    regional_branches.name AS branch,
    branch.branch_name AS region,
    hr_employees.hr_employees_name AS Collector,
    debtor.crm_debtor_agreement_no,
    complaints.complaints_code,
    debtor.crm_debtor_first_name,
    debtor.crm_debtor_mobile_1,
    crm_lead_type.crm_lead_type_name AS complaint_type,
    crm_lead_status.crm_lead_status_name AS complaint_status,
    complaints.complaints_debtor_principle_amnt AS principal,
    COALESCE(complaints.extra_amount_paid, 0) AS Paid_amount,
    COALESCE(complaints.adjustment_amount, 0) AS Adjustment,
    COALESCE(complaints.complaints_debtor_total_os, 0) AS Total_OS,
    COALESCE(complaints.agency_commsion, 0) AS `Agency Commission`,
    COALESCE(complaints.service_charge, 0) AS `Service Commission`,
    COALESCE(complaints.rm_commission, 0) AS `RM Commission`,
    COALESCE(complaints.br_commission, 0) AS `Branch Commission`,
    COALESCE(complaints.cl_commission, 0) AS `Collector Commission`,
    COALESCE(complaints.hq_commission, 0) AS `HQ Commission`,
    COALESCE(complaints.branch_income, 0) AS `Branch Income`,
    COALESCE(complaints.complaints_cost_amount, 0) AS Cost1,
    COALESCE(complaints.complaints_expense_amount, 0) AS Cost2,

    -- Total Income Calculation
    ROUND((
        COALESCE(complaints.agency_commsion, 0) +
        COALESCE(complaints.rm_commission, 0) +
        COALESCE(complaints.br_commission, 0) +
        COALESCE(complaints.cl_commission, 0) +
        COALESCE(complaints.hq_commission, 0) +
        COALESCE(complaints.complaints_cost_amount, 0) +
        COALESCE(complaints.complaints_expense_amount, 0)
    ), 3) AS Total_Income,

    -- KK Calculation
    ROUND((
        COALESCE(complaints.extra_amount_paid, 0) - (
            COALESCE(complaints.agency_commsion, 0) +
            COALESCE(complaints.rm_commission, 0) +
            COALESCE(complaints.br_commission, 0) +
            COALESCE(complaints.cl_commission, 0) +
            COALESCE(complaints.hq_commission, 0) +
            COALESCE(complaints.complaints_cost_amount, 0) +
            COALESCE(complaints.complaints_expense_amount, 0)
        )
    ), 3) AS KK,

    -- Total Calculation
    ROUND((
        COALESCE(complaints.extra_amount_paid, 0) - (
            COALESCE(complaints.agency_commsion, 0) +
            COALESCE(complaints.rm_commission, 0) +
            COALESCE(complaints.br_commission, 0) +
            COALESCE(complaints.cl_commission, 0) +
            COALESCE(complaints.hq_commission, 0) +
            COALESCE(complaints.complaints_cost_amount, 0) +
            COALESCE(complaints.complaints_expense_amount, 0)
        ) - COALESCE(complaints.branch_income, 0)
    ), 3) AS Total,

    COALESCE(complaints.adjusment_income, 0) AS `Adjustment Income`
");
$this->db->from('complaints');
$this->db->where('contact.contact_id',$postdata['creditor_id']);
$this->db->where('(complaints.extra_amount_paid + complaints.adjustment_amount) !=','0');
$this->db->join('contact', 'contact.contact_id = complaints.complaints_creditor_id');
$this->db->join('debtor', 'debtor.crm_debtor_id = complaints.complaints_debtor_id');
$this->db->join('master', 'complaints.complaints_id = master.master_id', 'left');
$this->db->join('crm_lead_type', 'complaints.complaints_case_type = crm_lead_type.crm_lead_type_id', 'left');
$this->db->join('crm_lead_status', 'crm_lead_status.crm_lead_status_id = complaints.complaints_status_id', 'left');
$this->db->join('branch', 'master.master_branch_id = branch.branch_id');
$this->db->join('regional_branches', 'regional_branches.id = complaints.regional_branch');
$this->db->join('hr_employees', 'hr_employees.hr_employees_id = complaints.complaints_assign_ids', 'left');

// Apply filters based on user profile
if ($profile_settings->regional_profile_id == $_SESSION['profile_id'] || 
    $profile_settings->agency_profile_id == $_SESSION['profile_id']) {
   $allowed_branches=explode(',',$this->mastermodel->get_single_field_value('user','sub_branch_id','user_id',$_SESSION['user_id']));

            $this->db->where_in('complaints.regional_branch', $allowed_branches);
} elseif ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {
    $collector_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_id', 'user_id', $_SESSION['user_id']);
    $this->db->where('complaints.complaints_assign_ids', $collector_id);
}

// Execute the query
$this->db->order_by('crm_lead_type.crm_lead_type_id');
$query = $this->db->get();

// Fetch the results
// $results = $query->result();

}
    $data = $query->result_array();
    $this->load->library('PHPExcel');
    $objPHPExcel = new PHPExcel();
    $sheet = $objPHPExcel->setActiveSheetIndex(0);
    $headers = [
      'Creditor','Region','Branch','Collector','Agreement No','Complaint Code','Debtor Name','Mobile','Complaint Type',
      'Complaint status','Pricipal Amount','Paid Amount','Adjustment Amount',
      'O/S Amount','Agency Commission','Sevice Commission','RM Commission',
      'Branch Commission','Collector Commission','Hq Commission','Branch Income',
      'Cost1 '.$commision_settings->other_cost_1.'%','Cost2 '.($commision_settings->other_cost_2*365).'%','Total Income','KK','Total','Adjustment Income',
    ]; 
    
    //   $headers = [
    //   'Creditor','Region','Branch','Collector','Agreement No','Complaint Code','Debtor Name','Mobile','Complaint Type',
    //   'Complaint status','Pricipal Amount','Paid Amount','Adjustment Amount',
    //   'O/S Amount'
    // ];
    $col = 0;
    foreach ($headers as $header) {
        $sheet->setCellValueByColumnAndRow($col, 1, $header);
        $col++;
    }
    $row = 2;
    foreach ($data as $dataRow) {
        $col = 0;
        foreach ($dataRow as $cell) {
            $sheet->setCellValueByColumnAndRow($col, $row, $cell);
            $col++;
        }
        $row++;
    }
    $filename = 'overall_' . date('Y-m-d_H-i-s') . '.xlsx';
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
    header('Cache-Control: max-age=0');
    $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $writer->save('php://output');
    exit;
}

    function load_branch_income_report($mainfolder,$subfolder,$page)
    {
     
        $postdata = $this->get_post_values();
  
        $viewdata['viewinfo'] = $this->clientreportmodel->load_branch_income_report($postdata);
      $viewdata['frmdate'] = $postdata['from_date'];
                  $viewdata['todate'] = $postdata['to_date'];
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Branch Income Report');
    }
    

    
}

/* End of file master.php */
/* Location: ./application/controllers/master.php */
