<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Client extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('propertymodel');
//         $this->load->library('excel');
        $this->load->library('PHPExcel');
//              $this->load->library('PHPExcel');
        $this->load->helper('to_pdf');
        $CI = & get_instance();
        $CI->load->library('currencyConverter');
        $this->CurrencyConverter = new CurrencyConverter();
    }

    public function view($folder, $page) {
        $this->load->view($folder . '/' . $page);
    }

    function get_post_values() {
        $data = array();
        foreach ($_POST as $key => $value) {
            if ($key != "submit") {
                $data[$key] = $this->input->post($key);
            }
        }
        return $data;
    }

    function addformdisplay($page, $directory, $return_page = '') {
        $data = array();
        $data['return_page'] = $return_page;

        $json_data = $this->load->view('' . $directory . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function viewinclientsearch($modelfunction, $subfolder, $page, $pagenum) {

        $output = $this->clientmodel->$modelfunction($pagenum);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('client/' . $subfolder . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }
    
    public function viewinclientsearch_com() {
    $pagenum = $this->input->get('pagenum');
    $search = $this->input->get('search');
    $order = json_decode($this->input->get('order'), true);

    $data['current_page'] = $pagenum;
    $data['search'] = $search;
    $data['order'] = $order;

    $json_data = $this->load->view('client/management/view_complaints', $data, TRUE);
    echo json_encode(['json_data' => $json_data, 'json_perm' => 1]);
}


    function addinclient($modelfunction, $resfunction, $subfolder, $page) {
        $postdata = $this->get_post_values();

        $data = $this->clientmodel->$modelfunction($postdata);
        $json_msg = $this->load->view('message', $data, TRUE);

        $output = $this->clientmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('client/' . $subfolder . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
    }

    function addindebtor($modelfunction, $page, $id = "") {
        $postdata = $this->get_post_values();

        $postdata['debtor_id'] = $id;

        $data = $this->clientmodel->$modelfunction($postdata);

//        $json_msg = $this->load->view('message', $data, TRUE);

        if (empty($id)) {
            $id = $data['id'];
        }
        $output = $this->mastermodel->get_data_srow('debtor', $id, 'crm_debtor_id');
        $data['id'] = $id;
        $data['view'] = $output;
        $json_data = $this->load->view('client/management/' . $page . '', $data, TRUE);

        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_id' => $id, ''));
    }

    function edit_page($id, $table, $field, $subfolder, $page) {

//        var_dump($id);var_dump($table);var_dump($field);var_dump($subfolder);;var_dump($page);
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('client/' . $subfolder . '/' . $page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }
public function edit_page_com() {
    // Retrieve posted data
    $id = $this->input->post('id');
    $table = $this->input->post('table');
    $field = $this->input->post('field');
    $subfolder = $this->input->post('subfolder');
    $page = $this->input->post('page');
    $currentPage = $this->input->post('currentPage'); // Page Number
    $search = $this->input->post('search'); // Search Query
    $order = json_decode($this->input->post('order'), true); // Decode JSON string to array
 //   $inst = $this->input->post('inst'); // Decode the JSON string to an array
    $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
    $data['id'] = $id;
   // $data['page_instance'] = $inst; // Pass the instance (decoded from JSON) to the view
   
    $data['currentPage'] = $currentPage;
    $data['search'] = $search;
    $data['order'] = $order;
    $json_data = $this->load->view('client/' . $subfolder . '/' . $page, $data, TRUE);
    echo json_encode([
        'json_data' => $json_data,
        'json_perm' => 1,
        'currentPage' => $currentPage // Send back page info if needed
    ]);
}


    function single_page($id, $table, $field, $subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('client/' . $subfolder . '/' . $page, $data);
    }

    function deletedata($table, $id, $field) {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->mastermodel->deletedata($table, $id, $field);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }

    function get_document() {
        $postdata = $this->get_post_values();
        $data['viewinfo'] = $this->clientmodel->get_document($postdata);
        echo json_encode($data);
    }

    function get_lead_for_assigning() {
        $postdata = $this->get_post_values();
        $assigning['lead'] = $this->clientmodel->get_lead_for_assigning($postdata);
        $data['lead_for_assigning'] = $this->load->view('client/management/lead_for_assigning', $assigning, TRUE);
        echo json_encode($data);
    }

    function get_deal_document() {
        $postdata = $this->get_post_values();
        $postdata['crm_lead_category'] = $this->mastermodel->get_single_field_value('crm_lead_details', 'crm_lead_details_category_id', 'crm_lead_details_id', $postdata['crm_lead_details_id']);
        $postdata['crm_lead_type'] = $this->mastermodel->get_single_field_value('crm_lead_details', 'crm_lead_details_lead_type_id', 'crm_lead_details_id', $postdata['crm_lead_details_id']);
        $data['viewinfo'] = $this->clientmodel->get_document($postdata);
        $agency_id = $this->mastermodel->get_single_field_value('crm_lead_details', 'crm_lead_agency_id', 'crm_lead_details_id', $postdata['crm_lead_details_id']);

        $firstname = $this->mastermodel->get_single_field_value('crm_lead_details', 'crm_lead_details_firstname', 'crm_lead_details_id', $postdata['crm_lead_details_id']);
        $LastName = $this->mastermodel->get_single_field_value('crm_lead_details', 'crm_lead_details_LastName', 'crm_lead_details_id', $postdata['crm_lead_details_id']);
        $data['lead_name'] = $firstname . ' ' . $LastName;

        $data['agency'] = $this->mastermodel->get_data_srow('agency', $agency_id, 'agency_id');
        echo json_encode($data);
    }

    function get_contact_detail() {
        $postdata = $this->get_post_values();
        $data['viewinfo'] = $this->mastermodel->get_data_srow('contact', $postdata['contact_id'], 'contact_id');
        echo json_encode($data);
    }

    function get_contact_frm_lead() {

        $postdata = $this->get_post_values();
        $contact['lead_contact'] = $this->mastermodel->select_data_by_id('contact', 'contact_owner', $postdata['lead_owner']);
        $data['viewinfo'] = $this->load->view('client/management/contact_frm_lead', $contact, TRUE);
        echo json_encode($data);
    }

    function mail_content() {

        $postdata = $this->get_post_values();
        $data = $this->mastermodel->get_single_field_value('mail_template', 'template_content', 'template_id', $postdata['id']);

        echo json_encode($data);
    }

    function get_ajax_values($model, $table, $field, $id) {
        $data['viewinfo'] = $this->mastermodel->$model($table, $field, $id);

        echo json_encode($data);
    }

    public function load_contact_map_page() {


        $this->load->view('client/management/contact_map');
    }

    public function load_ppty_mymap_page() {


        $this->load->view('client/management/ppty_map');
    }

    function get_legal_frm_deal() {

        $postdata = $this->get_post_values();
        $contact['legal'] = $this->mastermodel->select_data_by_id('crm_deal_legal', 'crm_deal_legal_deal_details_id', $postdata['deal_id']);
        $data['viewinfo'] = $this->load->view('client/management/legal_for_task', $contact, TRUE);
        echo json_encode($data);
    }

    function get_rv_data($page, $deal_id) {
        $deal['deal_id'] = $deal_id;
        $data['viewinfo'] = $this->load->view('client/management/' . $page, $deal, TRUE);
        echo json_encode($data);
    }

    function load_mial_to_contact($id) {

        $contact['main_contact'] = $this->mastermodel->get_data_srow('contact', $id, 'contact_id');
        $contact['contact_details'] = $this->mastermodel->select_data_by_id('contact_sub', 'contact_sub_contact_id', $id);
        $data['viewinfo'] = $this->load->view('client/management/send_mail_contact', $contact, TRUE);

        echo json_encode($data);
    }
 function load_excel_export($id) {

       $postdata = $this->get_post_values();

        //$data = $this->clientmodel->$modal_name($postdata);
        echo json_encode($data);
    }
    function get_deal_payment_voucher_details($customer_type, $deal_id) {
        $deal['deal_id'] = $deal_id;
        if ($customer_type == 'buyer') {
            $data['viewinfo'] = $this->load->view('client/management/pv_buyer_deal_details', $deal, TRUE);
            echo json_encode($data);
        } else if ($customer_type == 'seller') {
            $data['viewinfo'] = $this->load->view('client/management/pv_seller_deal_details', $deal, TRUE);
            echo json_encode($data);
        }
//         $deal['deal_id']=$deal_id;
//         $data['viewinfo'] = $this->load->view('client/management/deal_pay_v_buyer_details', $deal, TRUE);
//         echo json_encode($data);
    }

    function print_billing($billing_id) {

        $data['reciept_voucher'] = $this->mastermodel->get_data_srow('crm_deal_reciept_voucher', $billing_id, 'crm_deal_rv_id');

        $output = $this->load->view('client/management/print_receipt_voucher', $data, TRUE);
//        pdf_create($output , $billing_code);
        pdf_create_print($output, 'Billing_' . $billing_id);
        echo "1";
    }

    function get_property($id) {
        $property['result'] = $this->mastermodel->select_data_by_id('detail_entry_dealing_details', 'detail_id', $id);
        echo json_encode($property);
    }

    function print_payment_billing($billing_id) {

        $data['payment_voucher'] = $this->mastermodel->get_data_srow('crm_deal_payment_voucher', $billing_id, 'crm_deal_pay_voucher_id');

        $output = $this->load->view('client/management/print_payment_voucher', $data, TRUE);
//        pdf_create($output , $billing_code);
        pdf_create_print($output, 'Billing_' . $billing_id);
        echo "1";
    }

    public function contact_import() {


        if ($this->input->post('importfile')) {
            $path = ROOT_UPLOAD_IMPORT_PATH;

            $config['upload_path'] = $path;
            $config['allowed_types'] = 'xlsx|xls|jpg|png';
            $config['remove_spaces'] = TRUE;
            $this->upload->initialize($config);
            $this->load->library('upload', $config);
            if (!$this->upload->do_upload('userfile')) {
                $error = array('error' => $this->upload->display_errors());
            } else {
                $data = array('upload_data' => $this->upload->data());
            }

            if (!empty($data['upload_data']['file_name'])) {
                $import_xls_file = $data['upload_data']['file_name'];
            } else {
                $import_xls_file = 0;
            }
            $inputFileName = $path . $import_xls_file;
            try {
                $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $objPHPExcel = $objReader->load($inputFileName);
            } catch (Exception $e) {
                die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME)
                        . '": ' . $e->getMessage());
            }
            $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);

            $arrayCount = count($allDataInSheet);
            $flag = 0;
            $createArray = array('First_Name', 'Last_Name', 'Email', 'DOB', 'Contact_NO');
            $makeArray = array('First_Name' => 'First_Name', 'Last_Name' => 'Last_Name', 'Email' => 'Email', 'DOB' => 'DOB', 'Contact_NO' => 'Contact_NO');
            $SheetDataKey = array();
            foreach ($allDataInSheet as $dataInSheet) {
                foreach ($dataInSheet as $key => $value) {
                    if (in_array(trim($value), $createArray)) {
                        $value = preg_replace('/\s+/', '', $value);
                        $SheetDataKey[trim($value)] = $key;
                    } else {
                        
                    }
                }
            }
            $data = array_diff_key($makeArray, $SheetDataKey);

            if (empty($data)) {
                $flag = 1;
            }
            if ($flag == 1) {
                for ($i = 2; $i <= $arrayCount; $i++) {
                    $addresses = array();
                    $firstName = $SheetDataKey['First_Name'];
                    $lastName = $SheetDataKey['Last_Name'];
                    $email = $SheetDataKey['Email'];
                    $dob = $SheetDataKey['DOB'];
                    $contactNo = $SheetDataKey['Contact_NO'];
                    $firstName = filter_var(trim($allDataInSheet[$i][$firstName]), FILTER_SANITIZE_STRING);
                    $lastName = filter_var(trim($allDataInSheet[$i][$lastName]), FILTER_SANITIZE_STRING);
                    $email = filter_var(trim($allDataInSheet[$i][$email]), FILTER_SANITIZE_EMAIL);
                    $dob = filter_var(trim($allDataInSheet[$i][$dob]), FILTER_SANITIZE_STRING);
                    $contactNo = filter_var(trim($allDataInSheet[$i][$contactNo]), FILTER_SANITIZE_STRING);
                    $fetchData[] = array('first_name' => $firstName, 'last_name' => $lastName, 'email' => $email, 'dob' => $dob, 'contact_no' => $contactNo);
                }
                $data['employeeInfo'] = $fetchData;
                $this->import->setBatchImport($fetchData);
                $this->import->importData();
            } else {
                echo "Please import correct file";
            }
        }
//        $this->load->view('import/display', $data);
    }

    function print_receipt_voucher($id, $mainfolder, $subfolder, $page) {
        $viewdata['viewinfo'] = $this->mastermodel->get_data_srow('crm_deal_receipt_voucher', $id, 'crm_deal_receipt_voucher_id');
        $code = $viewdata['viewinfo']->crm_deal_receipt_voucher_code;
        $filename = 'Receipt_voucher_' . $code;
        $html = $this->load->view($mainfolder . '/' . $subfolder . '/' . $page, $viewdata, true);
        pdf_create($html, $filename, false);
    }

    function send_contact_mail() {
        $postdata = $this->get_post_values();
        $data = $this->clientmodel->send_contact_mail($postdata);
        echo json_encode($data);
    }

    function send_quotation_mail() {
        $postdata = $this->get_post_values();
        $data = $this->clientmodel->send_quotation_mail($postdata);
        echo json_encode($data);
    }

    function change_status($table, $id, $field, $status_field) {
        $data = array();

        $data = $this->clientmodel->change_status($table, $id, $field, $status_field);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }

    function add_task_note($modal_name) {
        $postdata = $this->get_post_values();

        $data = $this->clientmodel->$modal_name($postdata);
        echo json_encode($data);
    }

    function add_complaints_note($modal_name) {
        $postdata = $this->get_post_values();
        $data = $this->clientmodel->$modal_name($postdata);
        echo json_encode($data);
    }

    function add_legal($modal_name) {
        $postdata = $this->get_post_values();
        $data = $this->clientmodel->$modal_name($postdata);
        echo json_encode($data);
    }

    function add_expense($modal_name) {
        $postdata = $this->get_post_values();
        $data = $this->clientmodel->$modal_name($postdata);
        echo json_encode($data);
    }

    function perform_on_modal() {
        $postdata = $this->get_post_values($postdata);
//        $contact['main_contact']=$this->mastermodel->get_data_srow('contact',$id,'contact_id');
        $data['viewinfo'] = $this->load->view('client/management/' . $postdata['page'], $postdata, TRUE);

        echo json_encode($data);
    }

    public function load_map_page() {


        $this->load->view('client/management/map');
    }

    public function edit_map_page() {
        $postdata = $this->get_post_values();
        $data['lat'] = $postdata['lat'];
        $data['long'] = $postdata['long'];
        $data['address'] = $postdata['address'];
//         $data['sub_category_id']=$postdata['sub_category_id'];
        $this->load->view('client/management/edit_property_map', $data);
    }

    function get_debtor_document() {
        $postdata = $this->get_post_values();
        $data['viewinfo'] = $this->mastermodel->select_data_by_id('complaints_file_details', 'complaints_file_details_complants_id', $postdata["complaints_id"]);

        echo json_encode($data);
    }

    function add_ptp_payment($modal_name) {
        $postdata = $this->get_post_values();

        $data = $this->clientmodel->$modal_name($postdata);
        echo json_encode($data);
    }
function  import_excel()
{

$postdata = $this->get_post_values();
        $data = $this->clientmodel->readExcelData($postdata);
        $json_msg = $this->load->view('message', $data, TRUE);
        $output = $this->clientmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('client/' . $subfolder . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
}


function  view_details($id)
{
 $html='';

$data=$this->clientmodel->get_debtor_excel_example($id);

$i=1;

foreach($data['results']->result_array() as $row){
$html.="<tr><td>".$i."</td><td>".$row['name']."</td><td>".$row['value']."</td></tr>";
$i++;
}
echo json_encode($html);
}




    public function convert($from, $to, $amount, $saveIntoDb = 1, $hourDifference = 1) {



        if ($from != $to) {

            $result = $this->mastermodel->convert1($from, $to, $amount, 0, 1);



            $data = number_format((float) $result, 3, '.', '');
            
        } else {
            $data = number_format((float) $amount, 3, '.', '');
        }
        echo json_encode($data);
    }


    function payment_plan_pdf($mainfolder, $subfolder, $page, $id) {
        $viewdata['viewinfo'] = $this->mastermodel->get_data_srow('ptp', $id, 'ptp_id');
        $code = $viewdata['viewinfo']->ptp_code;
        $filename = 'payment_plan' . $code . $id;
        $html = $this->load->view($mainfolder . '/' . $subfolder . '/' . $page, $viewdata, true);
        pdf_create($html, $filename, false);
//       echo   $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
    }

    function complaint_pdf($mainfolder, $subfolder, $page, $id) {
        $viewdata['viewinfo'] = $this->mastermodel->get_data_srow('complaints', $id, 'complaints_id');
        $code = $viewdata['viewinfo']->complaints_code;
        $filename = 'complaint' . $code;
        
              //  echo $filename; die();

        $html = $this->load->view($mainfolder . '/' . $subfolder . '/' . $page, $viewdata, true);
        echo $html; die();
        pdf_create($html, $filename, false);
    }
    
    
    function invoice_pdf_new($mainfolder, $subfolder, $page, $id) {
        $viewdata['viewinfo'] = $this->mastermodel->get_data_srow('agency_invoice', $id, 'invoice_id');
        $code = $viewdata['viewinfo']->invoice_no;
        $filename = 'Invoice_' . $code;
        $html = $this->load->view($mainfolder . '/' . $subfolder . '/' . $page, $viewdata, true);
echo $html;die();

        pdf_create($html, $filename, false);
    }
  function invoice_pdf_creditor($mainfolder, $subfolder, $page, $id) {
        $viewdata['viewinfo'] = $this->mastermodel->get_data_srow('agency_invoice', $id, 'invoice_id');
        $code = $viewdata['viewinfo']->invoice_no;
        $filename = 'Invoice_' . $code;
        $html = $this->load->view($mainfolder . '/' . $subfolder . '/' . $page, $viewdata, true);
echo $html;die();

        pdf_create($html, $filename, false);
    }

    function ptp_invoice_pdf($mainfolder, $subfolder, $page, $id) {
        $viewdata['viewinfo'] = $this->mastermodel->get_data_srow('ptp', $id, 'ptp_id');
        $code = $viewdata['viewinfo']->ptp_code;
        $filename = 'invoice';
        $html = $this->load->view($mainfolder . '/' . $subfolder . '/' . $page, $viewdata, true);
        pdf_create($html, $filename, false);
    }

    function ptp_invoice($mainfolder, $subfolder, $page, $id) {
        $viewdata['viewinfo'] = $this->mastermodel->get_data_srow('ptp', $id, 'ptp_id');


        $up = $this->clientmodel->update_invoice_status($id);
        $code = $viewdata['viewinfo']->ptp_code;
        $filename = 'Ptp_invoice' . $code . '.pdf';
        $html = $this->load->view($mainfolder . '/' . $subfolder . '/' . $page, $viewdata, true);
        pdf_email($html, $filename, false);
        $complaint = $this->mastermodel->get_data_srow('complaints', $viewdata['viewinfo']->ptp_complaints_id, 'complaints_id');
        $credtor = $this->mastermodel->get_data_srow('contact', $complaint->complaints_creditor_id, 'contact_id');
        $email['to'] = $credtor->contact_email;
//                $cc=$this->mastermodel->get_single_field_value('company','cc_customer','project_id',$_SESSION['project_id']);
//            $email['cc']= $cc;
        $email['attachment'] = 'assets/email_pdfs/' . $filename;
        $email['subject'] = "PTP INVOICE";
        $email['message'] = '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">PTV INVOICE<pre>';

        $status = $this->clientmodel->send_email_task($email);

        echo json_encode($status);
    }

    function ptp_approval($ptpid) {

        $output['status'] = $this->clientmodel->ptp_approval($ptpid);
        echo json_encode($output);
    }
    
     function ptp_plan_approval() {
        $postdata = $this->get_post_values();

        $output['status'] = $this->clientmodel->ptp_payment_by_status_approval($postdata['id']);
        echo json_encode($output);
    }

    function single_ptp_page($id, $table, $field, $subfolder, $page) {


        $data['viewinfo'] = $this->clientmodel->get_ptp($id);
        $data['id'] = $id;
        $json_data = $this->load->view('client/' . $subfolder . '/' . $page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function case_type($model, $modelfn) {
        $postdata = $this->get_post_values();
        $data['value'] = $this->$model->$modelfn($postdata);
        echo json_encode($data);
    }

    function get_complaint() {
        $postdata = $this->get_post_values();
        $data['viewinfo'] = $this->clientmodel->get_complaint($postdata);

        echo json_encode($data);
    }
    
 public function complaint_excel_download()
{
     $postdata = $this->get_post_values();

    ob_end_clean(); // Clean (erase) the output buffer

    
    error_reporting(E_ALL);
ini_set('display_errors', 1);

ini_set('memory_limit', '1G'); // Increase to 1GB or higher if needed
set_time_limit(0);
    // Query database
    if($_SESSION['profile_id']==3708){
    $query = $this->db->query("
        SELECT 
            complaints.complaints_id,
            complaints.complaints_code,
            debtor.crm_debtor_agreement_no,
            debtor.crm_debtor_company_name,
            debtor.crm_debtor_first_name,
            debtor.crm_debtor_mobile_1,
            crm_lead_type.crm_lead_type_name AS complaint_type,
            crm_lead_status.crm_lead_status_name AS complaint_status,
            complaints.complaints_debtor_principle_amnt AS principal,
            complaints.complaints_debtor_total_os AS Total_OS,
            complaints.extra_amount_paid AS Paid_amount,
            complaints.adjustment_amount AS Adjustment,
            
              complaints.complaints_csr_outlet_dealer_name AS Dealer,
                complaints.complaints_csr_agent_name AS CSRAgenet,
                  complaints.complaints_csr_code AS CSRCode,
                    complaints.complaints_csr_region_final AS CSRRegion,
                      complaints.complaints_csr_sales_channel_type AS CSRChannel,
            
            
            
            branch.branch_name AS region,
            regional_branches.name AS branch,
            hr_employees.hr_employees_name AS Collector
        FROM 
            complaints
        JOIN 
            debtor 
            ON debtor.crm_debtor_id = complaints.complaints_debtor_id
        LEFT JOIN 
            crm_lead_type 
            ON complaints.complaints_case_type = crm_lead_type.crm_lead_type_id
        LEFT JOIN 
            master 
            ON complaints.complaints_id = master.master_id
        LEFT JOIN 
            crm_lead_status 
            ON crm_lead_status.crm_lead_status_id = complaints.complaints_status_id
        JOIN 
            branch 
            ON master.master_branch_id = branch.branch_id
        JOIN 
            regional_branches 
            ON regional_branches.id = complaints.regional_branch
        LEFT JOIN 
            hr_employees 
            ON hr_employees.hr_employees_id = complaints.complaints_assign_ids
            WHERE complaints.complaints_creditor_id = '".$postdata['creditor_id']."'

        ORDER BY 
            crm_lead_type.crm_lead_type_id
    ");
}else{
   // Fetch regional branch IDs
$branches = [];
$branch_data = $this->mastermodel->select_data_by_id("regional_branches", 'branch_id', $_SESSION['user_branch'], 'id', 'id');
foreach ($branch_data as $br) {
    $branches[] = $br->id;
}

// Fetch profile settings
$profile_settings = $this->mastermodel->get_profile_settings();

// Initialize query
$this->db->select("
    complaints.complaints_id,
    complaints.complaints_code,
    debtor.crm_debtor_agreement_no,
    debtor.crm_debtor_company_name,
    debtor.crm_debtor_first_name,
    debtor.crm_debtor_mobile_1,
    crm_lead_type.crm_lead_type_name AS complaint_type,
    crm_lead_status.crm_lead_status_name AS complaint_status,
    complaints.complaints_debtor_principle_amnt AS principal,
    complaints.complaints_debtor_total_os AS Total_OS,
    complaints.extra_amount_paid AS Paid_amount,
    complaints.adjustment_amount AS Adjustment,
       complaints.complaints_csr_outlet_dealer_name AS Dealer,
                complaints.complaints_csr_agent_name AS CSRAgenet,
                  complaints.complaints_csr_code AS CSRCode,
                    complaints.complaints_csr_region_final AS CSRRegion,
                      complaints.complaints_csr_sales_channel_type AS CSRChannel,
    branch.branch_name AS region,
    regional_branches.name AS branch,
    hr_employees.hr_employees_name AS Collector
");
$this->db->from('complaints');
$this->db->join('debtor', 'debtor.crm_debtor_id = complaints.complaints_debtor_id');
$this->db->join('master', 'complaints.complaints_id = master.master_id', 'left');
$this->db->join('crm_lead_type', 'complaints.complaints_case_type = crm_lead_type.crm_lead_type_id', 'left');
$this->db->join('crm_lead_status', 'crm_lead_status.crm_lead_status_id = complaints.complaints_status_id', 'left');
$this->db->join('branch', 'master.master_branch_id = branch.branch_id');
$this->db->join('regional_branches', 'regional_branches.id = complaints.regional_branch');
$this->db->join('hr_employees', 'hr_employees.hr_employees_id = complaints.complaints_assign_ids', 'left');

// Apply filters based on user profile
if ($profile_settings->regional_profile_id == $_SESSION['profile_id'] || 
    $profile_settings->agency_profile_id == $_SESSION['profile_id']) {
   $allowed_branches=explode(',',$this->mastermodel->get_single_field_value('user','sub_branch_id','user_id',$_SESSION['user_id']));

            $this->db->where_in('complaints.regional_branch', $allowed_branches);
} elseif ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {
    $collector_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_id', 'user_id', $_SESSION['user_id']);
    $this->db->where('complaints.complaints_assign_ids', $collector_id);
}
$this->db->where('complaints.complaints_creditor_id',$postdata['creditor_id']);

// Execute the query
$this->db->order_by('crm_lead_type.crm_lead_type_id');
$query = $this->db->get();

// Fetch the results
// $results = $query->result();

}
    $data = $query->result_array();
    // Load PHPExcel library
    $this->load->library('PHPExcel');

    // Create new PHPExcel object
    $objPHPExcel = new PHPExcel();
    
    

    // Set active sheet
    $sheet = $objPHPExcel->setActiveSheetIndex(0);

    // Set Excel column headers
    $headers = [
        'Complaint ID', 'Complaint Code', 'Agreement No', 'Company Name',
        'First Name', 'Mobile', 'Complaint Type', 'Complaint Status','Pricipal Amount',
        'O/S Amount','Paid Amount','Adjustment','Dealer','CSRAgenet','CSRCode','CSRRegion','CSRChannel', 'Region', 'Branch', 'Collector'
    ];

    // Write headers to Excel
    $col = 0;
    foreach ($headers as $header) {
        $sheet->setCellValueByColumnAndRow($col, 1, $header);
        $col++;
    }

    // Write data to Excel
    $row = 2; // Start at second row
    foreach ($data as $dataRow) {
        $col = 0;
        foreach ($dataRow as $cell) {
            $sheet->setCellValueByColumnAndRow($col, $row, $cell);
            $col++;
        }
        $row++;
    }

    // Set filename
    $filename = 'complaints_export_' . date('Y-m-d_H-i-s') . '.xlsx';

    // Set headers for download
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
    header('Cache-Control: max-age=0');

    // Write file to output
    $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $writer->save('php://output');
    exit;
}

//     public function complaint_excel_download() {
//         $objPHPExcel = new PHPExcel();
//         $styleArray = array(
//             'font' => array(
//                 'color' => array('rgb' => 'FFFFFF')
//         ));
//         $countries = $this->mastermodel->selected_data_static('apps_countries', array('country_code', 'country_name'));

//         $j = 80;

//         foreach ($countries as $item) {
//             $objPHPExcel->getActiveSheet()->setCellValue('BZ' . $j, $item->country_name);
//             $objPHPExcel->getActiveSheet()->getStyle('BZ' . $j)->applyFromArray($styleArray);

//             $j++;
//         }
//         $objPHPExcel->getActiveSheet()->getColumnDimension('BZ')->setVisible(false);
// $countries_count = count($countries) + 80;
// $countries_form= '$BZ$80:$BZ$'.$countries_count;

//         $contact = $this->clientmodel->search_crm_contact();

//         $j = 80;
//         foreach ($contact['results']->result() as $item) {

//             $objPHPExcel->getActiveSheet()->setCellValue('CZ' . $j, $item->contact_id . '-' . $item->contact_company_name);
//             $objPHPExcel->getActiveSheet()->getStyle('CZ' . $j)->applyFromArray($styleArray);
//             $j++;
//         }
//         $objPHPExcel->getActiveSheet()->getColumnDimension('CZ')->setVisible(false);
        
//         $creditor_count = count($contact['results']->result()) + 80;
// $creditor_form= '$CZ$80:$CZ$'.$creditor_count;



//         $cases = $this->mastermodel->selected_data('crm_lead_type', array('crm_lead_type_id', 'crm_lead_type_name'));


//         $j = 80;

//         foreach ($cases as $item) {
//             $objPHPExcel->getActiveSheet()->setCellValue('DZ' . $j, $item->crm_lead_type_id . '-' . $item->crm_lead_type_name);
//             $objPHPExcel->getActiveSheet()->getStyle('DZ' . $j)->applyFromArray($styleArray);
//             $j++;
//         }
//         $objPHPExcel->getActiveSheet()->getColumnDimension('DZ')->setVisible(false);
      
//         $cases_count = count($cases) + 80;
// $cases_form= '$DZ$80:$DZ$'.$cases_count;
//         $statuses = $this->mastermodel->selected_data('crm_lead_status', array('crm_lead_status_id', 'crm_lead_status_name'));

//         $j = 80;

//         foreach ($statuses as $item) {
//             $objPHPExcel->getActiveSheet()->setCellValue('EZ' . $j, $item->crm_lead_status_id . '-' . $item->crm_lead_status_name);
//             $objPHPExcel->getActiveSheet()->getStyle('EZ' . $j)->applyFromArray($styleArray);
//             $j++;
//         }
//   $statuses_count = count($statuses) + 80;
// $statuses_form= '$EZ$80:$EZ$'.$statuses_count;
//         $objPHPExcel->getActiveSheet()->getColumnDimension('EZ')->setVisible(false);
//         $creditors = $this->hrreportmodel->selected_data_by_user('hr_employees', array('hr_employees_name', 'hr_employees.user_id', 'hr_employees_id'), 'hr_employees_id');

//         $j = 80;

//         foreach ($creditors as $item) {
//             $objPHPExcel->getActiveSheet()->setCellValue('FZ' . $j, $item->hr_employees_id . '-' . $item->hr_employees_name);
//             $objPHPExcel->getActiveSheet()->getStyle('FZ' . $j)->applyFromArray($styleArray);
//             $j++;
//         }
//         $objPHPExcel->getActiveSheet()->getColumnDimension('FZ')->setVisible(false);
        
//         $creditors_count = count($creditors) + 80;
// $creditors_form= '$FZ$80:$FZ$'.$creditors_count; 
        
//         $credit_type = $this->mastermodel->select_data_by_id("debtor_credit_type", 'project_id', $_SESSION['project_id'], 'credit_type_id', 'credit_type_id');

//         $j = 80;

//         foreach ($credit_type as $item) {
//             $objPHPExcel->getActiveSheet()->setCellValue('GZ' . $j, $item->credit_type_id . '-' . $item->credit_type_name);
//             $objPHPExcel->getActiveSheet()->getStyle('GZ' . $j)->applyFromArray($styleArray);
//             $j++;
//         }
//         $objPHPExcel->getActiveSheet()->getColumnDimension('GZ')->setVisible(false);
        
//          $credit_type_count = count($credit_type) + 80;
// $credit_type_form= '$GZ$80:$GZ$'.$credit_type_count;  
        
//         $nationality = $this->mastermodel->selected_data('nationality', array('nationality_id', 'nationality_name'));


//         $j = 80;

//         foreach ($nationality as $item) {
//             $objPHPExcel->getActiveSheet()->setCellValue('FF' . $j, $item->nationality_id . '-' . $item->nationality_name);
//             $objPHPExcel->getActiveSheet()->getStyle('FF' . $j)->applyFromArray($styleArray);
//             $j++;
//         }
//         $objPHPExcel->getActiveSheet()->getColumnDimension('FF')->setVisible(false);
//   $nationality_count = count($nationality) + 80;
// $nationality_form= '$FF$80:$FF$'.$nationality_count;  

//         $j = 80;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'AED-United Arab Emirates Dirham (AED)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'AFN-Afghan Afghani (AFN)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'ALL-Albanian Lek (ALL)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'AMD-Armenian Dram (AMD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'AOA-Angolan Kwanza (AOA)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'ARS-Argentine Peso (ARS)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'AUD-Australian Dollar (A$)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'AWG-Aruban Florin (AWG)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'AZN-Azerbaijani Manat (AZN)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BBD-Barbadian Dollar (BBD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BDT-Bangladeshi Taka (BDT)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BGN-Bulgarian Lev (BGN)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BHD-Bahraini Dinar (BHD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BIF-Burundian Franc (BIF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BMD-Bermudan Dollar (BMD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BND-Brunei Dollar (BND)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BOB-Bolivian Boliviano (BOB)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BRL-Brazilian Real (R$)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BSD-Bahamian Dollar (BSD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BTN-Bhutanese Ngultrum (BTN)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BWP-Botswanan Pula (BWP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BYR-Belarusian Ruble (BYR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'BZD-Belize Dollar (BZD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'CAD-Canadian Dollar (CA$)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'CDF-Congolese Franc (CDF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'CHF-Swiss Franc (CHF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'CLF-Chilean Unit of Account(CLF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'CLP-Chilean Peso (CLP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'CNH-CNH (CNH)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'CNY-Chinese Yuan (CN¥)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'COP-Colombian Peso (COP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'CRC-Costa Rican Colón (CRC)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'CUP-Cuban Peso (CUP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'CVE-Cape Verdean Escudo (CVE)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'CZK-Czech Republic Koruna (CZK)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'DEM-German Mark (DEM)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'DJF-Djiboutian Franc (DJF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'DKK-Danish Krone (DKK)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'DOP-Dominican Peso (DOP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'DZD-Algerian Dinar (DZD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'EGP-Egyptian Pound (EGP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'ERN-Eritrean Nakfa (ERN)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'ETB-Ethiopian Birr (ETB)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'EUR-Euro (€)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'FIM-Finnish Markka (FIM)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'FJD-Fijian Dollar (FJD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'FKP-Falkland Islands Pound (FKP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'FRF-French Franc (FRF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'GBP-British Pound Sterling (£)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'GEL-Georgian Lari (GEL)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'GHS-Ghanaian Cedi (GHS)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'GIP-Gibraltar Pound (GIP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'GMD-Gambian Dalasi (GMD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'GNF-Guinean Franc (GNF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'GTQ-Guatemalan Quetzal (GTQ)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'GYD-Guyanaese Dollar (GYD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'HKD-Hong Kong Dollar (HK$)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'HNL-Honduran Lempira (HNL)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'HRK-Croatian Kuna (HRK)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'HTG-Haitian Gourde (HTG)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'HUF-Hungarian Forint (HUF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'IDR-Indonesian Rupiah (IDR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'IEP-Irish Pound (IEP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'ILS-Israeli New Sheqel (?)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'INR-Indian Rupee (Rs.)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'IQD-Iraqi Dinar (IQD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'IRR-Iranian Rial (IRR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'ISK-Icelandic Króna (ISK)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'ITL-Italian Lira (ITL)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'JMD-Jamaican Dollar (JMD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'JOD-Jordanian Dinar (JOD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'JPY-Japanese Yen (¥)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'KES-Kenyan Shilling (KES)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'KGS-Kyrgystani Som (KGS)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'KHR-Cambodian Riel (KHR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'KMF-Comorian Franc (KMF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'KPW-North Korean Won (KPW)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'KRW-South Korean Won (?)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'KWD-Kuwaiti Dinar (KWD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'KYD-Cayman Islands Dollar (KYD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'KZT-Kazakhstani Tenge (KZT)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'LAK-Laotian Kip (LAK)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'LBP-Lebanese Pound (LBP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'LKR-Sri Lankan Rupee (LKR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'LRD-Liberian Dollar (LRD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'LSL-Lesotho Loti (LSL)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'LTL-Lithuanian Litas (LTL)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'LVL-Latvian Lats (LVL)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'LYD-Libyan Dinar (LYD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MAD-Moroccan Dirham (MAD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MDL-Moldovan Leu (MDL)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MGA-Malagasy Ariary (MGA)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MKD-Macedonian Denar (MKD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MMK-Myanmar Kyat (MMK)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MNT-Mongolian Tugrik (MNT)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MOP-Macanese Pataca (MOP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MRO-Mauritanian Ouguiya (MRO)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MUR-Mauritian Rupee (MUR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MVR-Maldivian Rufiyaa (MVR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MWK-Malawian Kwacha (MWK)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MXN-Mexican Peso (MX$)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MYR-Malaysian Ringgit (MYR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'MZN-Mozambican Metical (MZN)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'NAD-Namibian Dollar (NAD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'NGN-Nigerian Naira (NGN)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'NIO-Nicaraguan Córdoba (NIO)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'NOK-Norwegian Krone (NOK)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'NPR-Nepalese Rupee (NPR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'NZD-New Zealand Dollar (NZ$)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'OMR-Omani Rial (OMR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'PAB-Panamanian Balboa (PAB)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'PEN-Peruvian Nuevo Sol (PEN)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'PGK-Papua New Guinean Kina (PGK)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'PHP-Philippine Peso (Php)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'PKG-PKG (PKG)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'PKR-Pakistani Rupee (PKR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'PLN-Polish Zloty (PLN)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'PYG-Paraguayan Guarani (PYG)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'QAR-Qatari Rial (QAR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'RON-Romanian Leu (RON)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'RSD-Serbian Dinar (RSD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'RUB-Russian Ruble (RUB)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'RWF-Rwandan Franc (RWF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SAR-Saudi Riyal (SAR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SBD-Solomon Islands Dollar (SBD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SCR-Seychellois Rupee (SCR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SDG-Sudanese Pound (SDG)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SEK-Swedish Krona (SEK)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SGD-Singapore Dollar (SGD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SHP-Saint Helena Pound (SHP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SLL-Sierra Leonean Leone (SLL)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SOS-Somali Shilling (SOS)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SRD-Surinamese Dollar (SRD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'STD-São Tomé and Príncipe Dobra (STD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SVC-Salvadoran Colón (SVC)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SYP-Syrian Pound (SYP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'SZL-Swazi Lilangeni (SZL)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'THB-Thai Baht (?)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'TJS-Tajikistani Somoni (TJS)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'TMT-Turkmenistani Manat (TMT)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'TND-Tunisian Dinar (TND)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'TOP-Tongan Pa?anga (TOP)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'TRY-Turkish Lira (TRY)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'TTD-Trinidad and Tobago Dollar (TTD)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'TWD-New Taiwan Dollar (NT$)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'TZS-Tanzanian Shilling (TZS)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'UAH-Ukrainian Hryvnia (UAH)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'UGX-Ugandan Shilling (UGX)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'USD-US Dollar ($)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'UYU-Uruguayan Peso (UYU)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'UZS-Uzbekistan Som (UZS)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'VEF-Venezuelan Bolívar (VEF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'VND-Vietnamese Dong (?)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'VUV-Vanuatu Vatu (VUV)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'WST-Samoan Tala (WST)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'XAF-CFA Franc BEAC (FCFA)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'XCD-East Caribbean Dollar (EC$)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'XDR-Special Drawing Rights (XDR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'XOF-CFA Franc BCEAO (CFA)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'XPF-CFP Franc (CFPF)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'YER-Yemeni Rial (YER)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'ZAR-South African Rand (ZAR)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'ZMK-Zambian Kwacha (1968–2012) (ZMK)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'ZMW-Zambian Kwacha (ZMW)');
//         $j++;
//         $objPHPExcel->getActiveSheet()->setCellValue('HZ' . $j, 'ZWL-Zimbabwean Dollar (2009) (ZWL)');
//         $j++;
//  $currency_count = $j + 80;
// $currency_form= '$HZ$80:$HZ$'.$currency_count;  
//         for ($m = 1; $m < 1000; $m++) {

//             $objPHPExcel->getActiveSheet()->getStyle('HZ' . $m)->applyFromArray($styleArray);
//         }
//         $objPHPExcel->getActiveSheet()->getColumnDimension('HZ')->setVisible(false);
//         $cell = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'AA', 'AB', 'AC', 'AD', 'AE', 'AF', 'AG', 'AH', 'AI', 'AJ', 'AK', 'AL', 'AM', 'AN', 'AO', 'AP', 'AQ', 'AR', 'AS', 'AT', 'AU', 'AV', 'AW', 'AX', 'AY', 'AZ');
//         $row = 0;
//         $col = 0;

//         for ($k = 0; $k < count($cell); $k++) {
//             $objPHPExcel->getActiveSheet()->getColumnDimension($cell[$k])
//                     ->setWidth(30);
//         }
//         $row++;
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[$col] . $row, 'Creditor Name');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Debtor First Name');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Debtor Middle Name ');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, ' Debtor Last Name');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Gender');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Company Name');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Date Of Birth');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Country');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Nationality');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Mobile 1');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Mobile 2');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Phone');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Fax');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Skype ID');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Email');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Address');
//         // set Row
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Street');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'City');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'State');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Zipcode');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Country');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, 'Complaint Date');
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "Case Type");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "Status ");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "Assigned To");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "Description");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "AGREEMENT ID");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "AGREEMENT NO");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "RELATIONSHIP NO ");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "PRINCIPAL AMOUNT");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "TOTAL O/s.");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "VINTAGE");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "DPD");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "DPD-R");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "Creditor Type");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "AMTFIN");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "LAST PMT DATE");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "LAST_AMOUNT_RECD");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "In Currency 1");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "Amount");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "In Currency 2");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "Amount");
//         $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "Other Details ");


//         while ($row < 50) {
//             $col = 0;
//             $row++;
// //               $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col].$row, 'Creditor Name');
//             $objValidation = $objPHPExcel->getActiveSheet()->getCell($cell[$col] . $row)->getDataValidation();
//             $objValidation->setType(PHPExcel_Cell_DataValidation::TYPE_LIST);
//             $objValidation->setErrorStyle(PHPExcel_Cell_DataValidation::STYLE_INFORMATION);
//             $objValidation->setAllowBlank(false);
//             $objValidation->setShowInputMessage(true);
//             $objValidation->setShowErrorMessage(true);
//             $objValidation->setShowDropDown(true);
//             $objValidation->setErrorTitle('Input error');
//             $objValidation->setError('Value is not in list.');
//             $objValidation->setPromptTitle('Pick from list');
//             $objValidation->setPrompt('Please pick a value from the drop-down list.');
//             $objValidation->setFormula1($creditor_form);


//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, ' ');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
// //        $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col].$row, '');
//             $this->drop_down($objPHPExcel, $cell[++$col] . $row, 'male,female');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');

//             $objValidation = $objPHPExcel->getActiveSheet()->getCell($cell[++$col] . $row)->getDataValidation();
//             $objValidation->setType(PHPExcel_Cell_DataValidation::TYPE_LIST);
//             $objValidation->setErrorStyle(PHPExcel_Cell_DataValidation::STYLE_INFORMATION);
//             $objValidation->setAllowBlank(false);
//             $objValidation->setShowInputMessage(true);
//             $objValidation->setShowErrorMessage(true);
//             $objValidation->setShowDropDown(true);
//             $objValidation->setErrorTitle('Input error');
//             $objValidation->setError('Value is not in list.');
//             $objValidation->setPromptTitle('Pick from list');
//             $objValidation->setPrompt('Please pick a value from the drop-down list.');
//             $objValidation->setFormula1($countries_form);

//             $objValidation = $objPHPExcel->getActiveSheet()->getCell($cell[++$col] . $row)->getDataValidation();
//             $objValidation->setType(PHPExcel_Cell_DataValidation::TYPE_LIST);
//             $objValidation->setErrorStyle(PHPExcel_Cell_DataValidation::STYLE_INFORMATION);
//             $objValidation->setAllowBlank(false);
//             $objValidation->setShowInputMessage(true);
//             $objValidation->setShowErrorMessage(true);
//             $objValidation->setShowDropDown(true);
//             $objValidation->setErrorTitle('Input error');
//             $objValidation->setError('Value is not in list.');
//             $objValidation->setPromptTitle('Pick from list');
//             $objValidation->setPrompt('Please pick a value from the drop-down list.');
//             $objValidation->setFormula1($nationality_form);

//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             // set Row
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');

//             $objValidation = $objPHPExcel->getActiveSheet()->getCell($cell[++$col] . $row)->getDataValidation();
//             $objValidation->setType(PHPExcel_Cell_DataValidation::TYPE_LIST);
//             $objValidation->setErrorStyle(PHPExcel_Cell_DataValidation::STYLE_INFORMATION);
//             $objValidation->setAllowBlank(false);
//             $objValidation->setShowInputMessage(true);
//             $objValidation->setShowErrorMessage(true);
//             $objValidation->setShowDropDown(true);
//             $objValidation->setErrorTitle('Input error');
//             $objValidation->setError('Value is not in list.');
//             $objValidation->setPromptTitle('Pick from list');
//             $objValidation->setPrompt('Please pick a value from the drop-down list.');
//             $objValidation->setFormula1($countries_form);


// //        $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col].$row, "Case Type");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, '');
//             $objValidation = $objPHPExcel->getActiveSheet()->getCell($cell[++$col] . $row)->getDataValidation();
//             $objValidation->setType(PHPExcel_Cell_DataValidation::TYPE_LIST);
//             $objValidation->setErrorStyle(PHPExcel_Cell_DataValidation::STYLE_INFORMATION);
//             $objValidation->setAllowBlank(false);
//             $objValidation->setShowInputMessage(true);
//             $objValidation->setShowErrorMessage(true);
//             $objValidation->setShowDropDown(true);
//             $objValidation->setErrorTitle('Input error');
//             $objValidation->setError('Value is not in list.');
//             $objValidation->setPromptTitle('Pick from list');
//             $objValidation->setPrompt('Please pick a value from the drop-down list.');
//             $objValidation->setFormula1($cases_form);

// //        $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col].$row, "Status ");

//             $objValidation = $objPHPExcel->getActiveSheet()->getCell($cell[++$col] . $row)->getDataValidation();
//             $objValidation->setType(PHPExcel_Cell_DataValidation::TYPE_LIST);
//             $objValidation->setErrorStyle(PHPExcel_Cell_DataValidation::STYLE_INFORMATION);
//             $objValidation->setAllowBlank(false);
//             $objValidation->setShowInputMessage(true);
//             $objValidation->setShowErrorMessage(true);
//             $objValidation->setShowDropDown(true);
//             $objValidation->setErrorTitle('Input error');
//             $objValidation->setError('Value is not in list.');
//             $objValidation->setPromptTitle('Pick from list');
//             $objValidation->setPrompt('Please pick a value from the drop-down list.');
//             $objValidation->setFormula1($statuses_form);

//             $objValidation = $objPHPExcel->getActiveSheet()->getCell($cell[++$col] . $row)->getDataValidation();
//             $objValidation->setType(PHPExcel_Cell_DataValidation::TYPE_LIST);
//             $objValidation->setErrorStyle(PHPExcel_Cell_DataValidation::STYLE_INFORMATION);
//             $objValidation->setAllowBlank(false);
//             $objValidation->setShowInputMessage(true);
//             $objValidation->setShowErrorMessage(true);
//             $objValidation->setShowDropDown(true);
//             $objValidation->setErrorTitle('Input error');
//             $objValidation->setError('Value is not in list.');
//             $objValidation->setPromptTitle('Pick from list');
//             $objValidation->setPrompt('Please pick a value from the drop-down list.');
//             $objValidation->setFormula1($creditors_form);

//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");

//             $objValidation = $objPHPExcel->getActiveSheet()->getCell($cell[++$col] . $row)->getDataValidation();
//             $objValidation->setType(PHPExcel_Cell_DataValidation::TYPE_LIST);
//             $objValidation->setErrorStyle(PHPExcel_Cell_DataValidation::STYLE_INFORMATION);
//             $objValidation->setAllowBlank(false);
//             $objValidation->setShowInputMessage(true);
//             $objValidation->setShowErrorMessage(true);
//             $objValidation->setShowDropDown(true);
//             $objValidation->setErrorTitle('Input error');
//             $objValidation->setError('Value is not in list.');
//             $objValidation->setPromptTitle('Pick from list');
//             $objValidation->setPrompt('Please pick a value from the drop-down list.');
//             $objValidation->setFormula1($credit_type_form);


//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");



//             $objValidation = $objPHPExcel->getActiveSheet()->getCell($cell[++$col] . $row)->getDataValidation();
//             $objValidation->setType(PHPExcel_Cell_DataValidation::TYPE_LIST);
//             $objValidation->setErrorStyle(PHPExcel_Cell_DataValidation::STYLE_INFORMATION);
//             $objValidation->setAllowBlank(false);
//             $objValidation->setShowInputMessage(true);
//             $objValidation->setShowErrorMessage(true);
//             $objValidation->setShowDropDown(true);
//             $objValidation->setErrorTitle('Input error');
//             $objValidation->setError('Value is not in list.');
//             $objValidation->setPromptTitle('Pick from list');
//             $objValidation->setPrompt('Please pick a value from the drop-down list.');
//             $objValidation->setFormula1($currency_form);

//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");


//             $objValidation = $objPHPExcel->getActiveSheet()->getCell($cell[++$col] . $row)->getDataValidation();
//             $objValidation->setType(PHPExcel_Cell_DataValidation::TYPE_LIST);
//             $objValidation->setErrorStyle(PHPExcel_Cell_DataValidation::STYLE_INFORMATION);
//             $objValidation->setAllowBlank(false);
//             $objValidation->setShowInputMessage(true);
//             $objValidation->setShowErrorMessage(true);
//             $objValidation->setShowDropDown(true);
//             $objValidation->setErrorTitle('Input error');
//             $objValidation->setError('Value is not in list.');
//             $objValidation->setPromptTitle('Pick from list');
//             $objValidation->setPrompt('Please pick a value from the drop-down list.');
//             $objValidation->setFormula1($currency_form);


//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, "");
//             $objPHPExcel->getActiveSheet()->setCellValue($cell[++$col] . $row, " ");
//         }
//         $objPHPExcel->setActiveSheetIndex(0);
//         header('Content-Type: application/vnd.ms-excel'); //mime type
//         header('Content-Disposition: attachment;filename="complaints.xls"'); //tell browser what's the file name
//         header('Cache-Control: max-age=0'); //no cache
//         //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
//         //if you want to save it as .XLSX Excel 2007 format
//         $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
//         //force user to download the Excel file without writing it to server's HD
//         $objWriter->save('php://output');
//         //
//         exit();
//     }

    function fill_drop_down($table, $fields) {
        $data = $this->mastermodel->selected_data($table, $fields);

        $table = '';
        foreach ($data as $item) {
            $table .= ($item->$fields[0] . '-' . $item->$fields[1] . ', ');
        }
        return $table;
    }

    function fill_drop_down_static($table, $fields) {
        $data = $this->mastermodel->selected_data_static($table, $fields);

        $table = '';
        foreach ($data as $item) {
            $table .= ($item->$fields[0] . ', ');
        }

        return $table;
    }

    function drop_down($objPHPExcel, $location, $configs) {
        $objValidation = $objPHPExcel->getActiveSheet()->getCell($location)->getDataValidation();
        $objValidation->setType(PHPExcel_Cell_DataValidation::TYPE_LIST);
        $objValidation->setErrorStyle(PHPExcel_Cell_DataValidation::STYLE_INFORMATION);
        $objValidation->setAllowBlank(false);
        $objValidation->setShowInputMessage(true);
        $objValidation->setShowErrorMessage(true);
        $objValidation->setShowDropDown(true);
        $objValidation->setErrorTitle('Input error');
        $objValidation->setError('Value is not in list.');
        $objValidation->setPromptTitle('Pick from list');
        $objValidation->setPrompt('Please pick a value from the drop-down list.');
        $objValidation->setFormula1('"' . $configs . '"');
        return $objValidation;
    }

    public function debitor_excel_download() {
        $objPHPExcel = new PHPExcel();



        // set Header
        $objPHPExcel->getActiveSheet()->setCellValue('A1', 'First Name');
        $objPHPExcel->getActiveSheet()->setCellValue('B1', 'Middle Name ');
        $objPHPExcel->getActiveSheet()->setCellValue('C1', 'Last Name');
        $objPHPExcel->getActiveSheet()->setCellValue('D1', 'Gender');
        $objPHPExcel->getActiveSheet()->setCellValue('E1', 'Company Name');
        $objPHPExcel->getActiveSheet()->setCellValue('F1', 'Date Of Birth');
        $objPHPExcel->getActiveSheet()->setCellValue('G1', 'Country');
        $objPHPExcel->getActiveSheet()->setCellValue('H1', 'Nationality');
        $objPHPExcel->getActiveSheet()->setCellValue('I1', 'Mobile 1');
        $objPHPExcel->getActiveSheet()->setCellValue('J1', 'Mobile 2');
        $objPHPExcel->getActiveSheet()->setCellValue('K1', 'Phone');
        $objPHPExcel->getActiveSheet()->setCellValue('L1', 'Fax');
        $objPHPExcel->getActiveSheet()->setCellValue('M1', 'Skype ID');
        $objPHPExcel->getActiveSheet()->setCellValue('N1', 'Email');
        $objPHPExcel->getActiveSheet()->setCellValue('O1', 'Address');
        // set Row
        $objPHPExcel->getActiveSheet()->setCellValue('P1', 'Street');
        $objPHPExcel->getActiveSheet()->setCellValue('Q1', 'City');
        $objPHPExcel->getActiveSheet()->setCellValue('R1', 'State');
        $objPHPExcel->getActiveSheet()->setCellValue('S1', 'Zipcode');
        $objPHPExcel->getActiveSheet()->setCellValue('T1', 'Country');
//         $rowCount = 2;
//        
//       while($rowCount < 11)
//        {
//           
//            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, '');
//            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, '');
//            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, '');
//            $this->drop_down($objPHPExcel,'D' . $rowCount,'male,female');
//            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount,'' );
//            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, '');
//            
//             $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, '');
//             
//     $objPHPExcel->getActiveSheet()->setCellValue('G' . $rowCount, "select");
//        $this->drop_down($objPHPExcel,'G' . $rowCount,$this->fill_drop_down_static('apps_countries',array('country_code','country_name')));
//        
//            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, '');
//            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount,'' );
//            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, '');
//            
//             $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, '');
//            $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, '');
//            $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, '');
//            $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount,'' );
//            $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, '');
//              $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, '');
//            $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, '');
//            $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, '');
//            $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount,'' );
//            
//             $objPHPExcel->getActiveSheet()->setCellValue('T' . $rowCount, "select");
//        $this->drop_down($objPHPExcel,'T' . $rowCount,$this->fill_drop_down_static('apps_countries',array('country_code','country_name')));
//            $rowCount++;
//        }

        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="debtors.xls"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache
        //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
        //if you want to save it as .XLSX Excel 2007 format
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        //force user to download the Excel file without writing it to server's HD
        $objWriter->save('php://output');
        //
        exit();
    }

    public function submit_file_upload() {


        $data = array();

        $postdata = $this->get_post_values();

        if (isset($_FILES["file"]["name"])) {
            $path = $_FILES["file"]["tmp_name"];
//           $object = PHPExcel_IOFactory::load($path);
//           foreach ($object->getWorksheetIterator() as $worksheet)
//           {
            $phpexcel_filename = $path;
            $phpexcel_filetype = PHPExcel_IOFactory::identify($phpexcel_filename);
            $phpexcel_objReader = PHPExcel_IOFactory::createReader($phpexcel_filetype);
            $phpexcel_objPHPExcel = $phpexcel_objReader->load($phpexcel_filename);
            $phpexcel_sheet = $phpexcel_objPHPExcel->getSheet(0);
            $phpexcel_highestRow = $phpexcel_sheet->getHighestRow();
            $phpexcel_highestColumn = $phpexcel_sheet->getHighestColumn();
            $phpexcel_array = $phpexcel_sheet->toArray();
            $highestRow = $phpexcel_highestRow;
            $highestColumn = $phpexcel_highestColumn;

            $worksheet = $phpexcel_sheet;
            for ($row = 2; $row <= $highestRow; $row++) {
                if (!empty($worksheet->getCellByColumnAndRow(0, $row)->getValue())) {


                    $creditor_name1 = $worksheet->getCellByColumnAndRow(0, $row)->getValue();

                    $creditor_name = strstr($creditor_name1, '-', true);
                    $debtor_first_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
                    $debtor_middle_name = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
                    $debtor_last_name = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
                    $gender = $worksheet->getCellByColumnAndRow(4, $row)->getValue();

                    $company_name = $worksheet->getCellByColumnAndRow(5, $row)->getValue();


                    $dob = date('Y-m-d', PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(6, $row)->getValue()));


                    $country = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
                    $nationality1 = $worksheet->getCellByColumnAndRow(8, $row)->getValue();
                    $nationality = strstr($nationality1, '-', true);
                    $mobile_1 = $worksheet->getCellByColumnAndRow(9, $row)->getValue();
                    $mobile_2 = $worksheet->getCellByColumnAndRow(10, $row)->getValue();
                    $phone = $worksheet->getCellByColumnAndRow(11, $row)->getValue();
                    $fax = $worksheet->getCellByColumnAndRow(12, $row)->getValue();
                    $skype_id = $worksheet->getCellByColumnAndRow(13, $row)->getValue();
                    $email = $worksheet->getCellByColumnAndRow(14, $row)->getValue();
                    $address = $worksheet->getCellByColumnAndRow(15, $row)->getValue();

                    $street = $worksheet->getCellByColumnAndRow(16, $row)->getValue();
                    $city = $worksheet->getCellByColumnAndRow(17, $row)->getValue();
                    $state = $worksheet->getCellByColumnAndRow(18, $row)->getValue();
                    $zipcode = $worksheet->getCellByColumnAndRow(19, $row)->getValue();
                    $country_1 = $worksheet->getCellByColumnAndRow(20, $row)->getValue();



                    $complaint_date = date('Y-m-d', PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(21, $row)->getValue()));

                    $case_type1 = $worksheet->getCellByColumnAndRow(22, $row)->getValue();
                    $case_type = strstr($case_type1, '-', true);
                    $case_status1 = $worksheet->getCellByColumnAndRow(23, $row)->getValue();
                    $case_status = strstr($case_status1, '-', true);
                    $assigned1 = $worksheet->getCellByColumnAndRow(24, $row)->getValue();
                    $assigned = strstr($assigned1, '-', true);
                    $description = $worksheet->getCellByColumnAndRow(25, $row)->getValue();
                    $agreement_id = $worksheet->getCellByColumnAndRow(26, $row)->getValue();
                    $agreement_no = $worksheet->getCellByColumnAndRow(27, $row)->getValue();
                    $relationship_no = $worksheet->getCellByColumnAndRow(28, $row)->getValue();
                    $principal_amt = $worksheet->getCellByColumnAndRow(29, $row)->getValue();
                    $total_os = $worksheet->getCellByColumnAndRow(30, $row)->getValue();
                    $vintage = $worksheet->getCellByColumnAndRow(31, $row)->getValue();
                    $dbd = $worksheet->getCellByColumnAndRow(32, $row)->getValue();
                    $dbd_r = $worksheet->getCellByColumnAndRow(33, $row)->getValue();
                    $creditor_type1 = $worksheet->getCellByColumnAndRow(34, $row)->getValue();
                    $creditor_type = strstr($creditor_type1, '-', true);
                    $amtfin = $worksheet->getCellByColumnAndRow(35, $row)->getValue();

                    $last_paid_date = date('Y-m-d', PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(36, $row)->getValue()));

                    $last_amt_recv = $worksheet->getCellByColumnAndRow(37, $row)->getValue();
                    $currency11 = $worksheet->getCellByColumnAndRow(38, $row)->getValue();
                    $currency1 = strstr($currency11, '-', true);
                    $amount1 = $worksheet->getCellByColumnAndRow(39, $row)->getValue();
                    $currency21 = $worksheet->getCellByColumnAndRow(40, $row)->getValue();
                    $currency2 = strstr($currency21, '-', true);
                    $amount2 = $worksheet->getCellByColumnAndRow(41, $row)->getValue();
                    $other_details = $worksheet->getCellByColumnAndRow(42, $row)->getValue();

                    $masterid = $this->mastermodel->insertmasterdata();
                    $crm_debtor_id = $this->mastermodel->insertmasterdata();
                    $crm_debtor_code = $this->mastermodel->get_ref('crm_debtor_code', 'debtor', 'crm_debtor_code');

                    $data_debtor[] = array(
                        'crm_debtor_id' => $crm_debtor_id,
                        'crm_debtor_code' => $crm_debtor_code,
                        'debtor_contact_id' => $creditor_name,
                        'crm_debtor_owner' => $_SESSION['user_id'],
                        'crm_debtor_first_name' => $debtor_first_name,
                        'crm_debtor_middle_name' => $debtor_middle_name,
                        'crm_debtor_last_name' => $debtor_last_name,
                        'crm_debtor_gender' => $gender,
                        'crm_debtor_company_name' => $company_name,
                        'crm_debtor_dob' => $dob,
                        'crm_debtor_country' => $country,
                        'crm_debtor_nationality' => $nationality,
                        'crm_debtor_mobile_1' => $mobile_1,
                        'crm_debtor_mobile_2' => $mobile_2,
                        'crm_debtor_phone' => $phone,
                        'crm_debtor_fax' => $fax,
                        'crm_debtor_skype_id' => $skype_id,
                        'crm_debtor_email' => $email,
                        'crm_debtor_residential_address' => $address,
                        'crm_debtor_residential_street' => $street,
                        'crm_debtor_residential_city' => $city,
                        'crm_debtor_residential_state' => $state,
                        'crm_debtor_residential_zipcode' => $zipcode,
                        'crm_debtor_residential_country' => $country_1,
                    );

                    $master_id = $this->mastermodel->insertmasterdata();
                    $code = $this->mastermodel->get_ref('complaints_code', 'complaints', 'complaints_code');



                    $data_complaint[] = array(
                        'complaints_id' => $master_id,
                        'complaints_code' => $code,
                        'complaints_date' => $complaint_date,
                        'complaints_owner' => $_SESSION['user_id'],
                        'complaints_case_type' => $case_type,
                        'complaints_status_id' => $case_status,
                        'complaints_assign_ids' => $assigned,
                        'complaints_description' => $description,
                        'complaints_creditor_id' => $creditor_name,
                        'complaints_debtor_id' => $crm_debtor_id,
                        'complaints_debtor_agreement_id' => $agreement_id,
                        'complaints_debtor_agreement_no' => $agreement_no,
                        'complaints_debtor_relationship_no' => $relationship_no,
                        'complaints_debtor_principle_amnt' => $principal_amt,
                        'complaints_debtor_total_os' => $total_os,
                        'complaints_debtor_vintage' => $vintage,
                        'complaints_debtor_dpd' => $dbd,
                        'complaints_debtor_dpd_r' => $dbd_r,
                        'complaints_debtor_product' => $creditor_type,
                        'complaints_debtor_last_pmt_rcvd_date' => $last_paid_date,
                        'complaints_debtor_last_amount_rcvd' => $last_amt_recv,
                        'complaints_debtor_amtfin' => $amtfin,
                        'complaints_debt_currency1' => $currency1,
                        'complaints_debt_amount1' => $amount1,
                        'complaints_debt_currency2' => $currency2,
                        'complaints_debt_amount2' => $amount2,
                        'complaints_debt_other_details' => $other_details,
                    );


                    $complaints_status_id = $this->mastermodel->insertmasterdata();

                    $data_complaint_status[] = array(
                        'complaints_status_id' => $complaints_status_id,
                        'status_complaints_id' => $master_id,
                        'case_type' => $case_type,
                        'status_id' => $case_status,
                        'user_id' => $_SESSION['user_id'],
                        'date' => date('Y-m-d'),
                    );
                }
            }

            $data1['viewinfo'] = $this->clientmodel->excel_insert($data_debtor, $data_complaint, $data_complaint_status);

            echo json_encode($data1);
        }
    }
 function terms() {
        
        $postdata = $this->get_post_values();
        $data= $this->mastermodel->get_single_field_value('crm_terms_condition','crm_terms_condition_name','crm_terms_condition_id',$postdata['id']);
   
        echo json_encode($data);
    }
    
    
     function add_payment_extra($modal_name) {
        $postdata = $this->get_post_values();
        $data = $this->clientmodel->$modal_name($postdata);
        echo json_encode($data);
    }
    
    
  public function creditorList(){
     
     // POST data
     $postData = $this->input->post();

     // Get data
     $data = $this->clientmodel->search_crm_debtor_paginate($postData);

     echo json_encode($data);
  }
  
   public function complaintList(){
     
     // POST data
     $postData = $this->input->post();

     // Get data
     $data = $this->clientmodel->search_complaints_paginate($postData);

     echo json_encode($data);
  }
     public function bulkpaymentList(){
    $postData = $this->input->post();
     $data = $this->clientmodel->search_bulk_paymenmt_paginate($postData);
     echo json_encode($data);
  }
 function get_inv_details($modelfunction,$page,$id,$type)
    {
     $postdata['viewinfo'] = $this->clientmodel->$modelfunction($id,urldecode($type));
     $data['label'] =$this->load->view('client/management/'.$page, $postdata, TRUE);  
     echo json_encode($data);
        
    }
    
    public function getRegionData()
{
    $region_id = $this->input->post('region_id');
    $data = $this->clientmodel->get_region_creditor_data($region_id);
    echo json_encode($data); 
}


public function service_invoice_excel_download()
{
    ob_end_clean(); 
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    ini_set('memory_limit', '3G');
    set_time_limit(0);
    
     $postdata = $this->get_post_values();
$from_date=$this->mastermodel->convert_date_format($postdata['from_date']);
$to_date=$this->mastermodel->convert_date_format($postdata['to_date']);
$this->db->select("
    agency.agency_name,
    agency_commissions.type,
    agency_commissions.date,
    agency_commissions.invoice_status,
    complaints.complaints_code,
    complaints.complaints_debtor_agreement_no,
    agency_commissions.commission_amount,
    agency_commissions.commission_per,
    agency_commissions.paid_amount,
    (CASE 
        WHEN agency_commissions.invoice_status = 1 THEN 'Invoiced' 
        ELSE 'Pending' 
    END) AS invoice_status_label", false); // `false` prevents escaping of SQL
$this->db->from("agency_commissions");
$this->db->join("complaints", "agency_commissions.complaint_id = complaints.complaints_id");
$this->db->join("agency", "agency.agency_id = agency_commissions.agency_id", "left");
$this->db->where("agency_commissions.invoice_status", $postdata['invoiced']);
$this->db->where("agency_commissions.type", $postdata['type']);

// Apply branch filter **only if branch_select1 is not empty**
if (!empty($postdata['branch_select1'])) {
    $this->db->where("agency_commissions.agency_id", $postdata['branch_select1']);
}

$this->db->where("agency_commissions.date >=", $from_date);
$this->db->where("agency_commissions.date <=", $to_date);
$this->db->order_by("agency_commissions.date", "ASC");

$query = $this->db->get();


    $data = $query->result_array();
    $this->load->library('PHPExcel');
    $objPHPExcel = new PHPExcel();
    $sheet = $objPHPExcel->setActiveSheetIndex(0);
    $headers = [
        'Agency name','Commision type', 'Date','Status','Complaint', 'Agreement No',
        'Amount','Commision Persentage','Paid Amount'];
    $col = 0;
    foreach ($headers as $header) {
        $sheet->setCellValueByColumnAndRow($col, 1, $header);
        $col++;
    }

    // Write data to Excel
    $row = 2; // Start at second row
    foreach ($data as $dataRow) {
        $col = 0;
        foreach ($dataRow as $cell) {
            $sheet->setCellValueByColumnAndRow($col, $row, $cell);
            $col++;
        }
        $row++;
    }

    // Set filename
    $filename = 'service_commison' . date('Y-m-d_H-i-s') . '.xlsx';

    // Set headers for download
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
    header('Cache-Control: max-age=0');

    // Write file to output
    $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $writer->save('php://output');
    exit;
}
public function commision_invoice_excel_download()
{
    ob_end_clean(); 
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    ini_set('memory_limit', '1G');
    set_time_limit(0);
    $query = $this->db->query("
        SELECT 
            agency.agency_name,agency_commissions.type,agency_commissions.date,complaints.complaints_code,complaints.complaints_debtor_agreement_no,agency_commissions.commission_amount,agency_commissions.commission_per,agency_commissions.paid_amount
        FROM 
            agency_commissions
        JOIN 
            complaints 
            ON agency_commissions.complaint_id = complaints.complaints_id
           LEFT JOIN 
            agency 
            ON agency.agency_id = agency_commissions.agency_id
            WHERE agency_commissions.invoice_status='0' AND agency_commissions.type='Commission'
        ORDER BY 
            agency_commissions.date
    ");
    $data = $query->result_array();
    $this->load->library('PHPExcel');
    $objPHPExcel = new PHPExcel();
    $sheet = $objPHPExcel->setActiveSheetIndex(0);
    $headers = [
        'Agency name','Commision type', 'Date', 'Complaint', 'Agreement No',
        'Amount','Commision Persentage','Paid Amount'];
    $col = 0;
    foreach ($headers as $header) {
        $sheet->setCellValueByColumnAndRow($col, 1, $header);
        $col++;
    }

    // Write data to Excel
    $row = 2; // Start at second row
    foreach ($data as $dataRow) {
        $col = 0;
        foreach ($dataRow as $cell) {
            $sheet->setCellValueByColumnAndRow($col, $row, $cell);
            $col++;
        }
        $row++;
    }

    // Set filename
    $filename = 'commison' . date('Y-m-d_H-i-s') . '.xlsx';

    // Set headers for download
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
    header('Cache-Control: max-age=0');

    // Write file to output
    $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $writer->save('php://output');
    exit;
}
 public function getRegionWiseComplaintData() {
        $data = $this->mastermodel->get_region_wise_case_type_complaint_count();
        echo json_encode($data);
    }
    
        public function bulkPayment_excel_download()
{
    ob_end_clean(); 
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    ini_set('memory_limit', '3G');
    set_time_limit(0);
    $profile_settings = $this->mastermodel->get_profile_settings();
    $postdata = $this->get_post_values();
$from_date=$this->mastermodel->convert_date_format($postdata['from_date']);
$to_date=$this->mastermodel->convert_date_format($postdata['to_date']);
  $this->db->select('
        contact.contact_company_name AS Creditor,
        debtor.crm_debtor_first_name AS Debtor,
        branch.branch_name AS Region,
        regional_branches.name AS Branch,
        hr_employees.hr_employees_name AS Collector,
        c.complaints_debtor_agreement_no AS Agreement_No,
        c.complaints_code AS Complaint,
        ac.date AS Date,
        c.complaints_debtor_principle_amnt AS complaints_debtor_principle_amnt,
        c.complaints_debtor_total_os AS complaints_debtor_total_os,
        ac.previous_amount AS previous_amount,
        ac.deduction AS Amount,
        ac.notes AS Type,
    ');
    $this->db->from('payment_deduction_history ac');
    $this->db->join('complaints c', 'ac.complaint_id = c.complaints_id', 'inner');
    $this->db->join('contact', 'contact.contact_id = c.complaints_creditor_id', 'left'); 
    $this->db->join('debtor', 'debtor.crm_debtor_id = c.complaints_debtor_id', 'left'); 
    $this->db->join('branch', 'branch.branch_id = ac.region', 'left'); 
    $this->db->join('regional_branches', 'regional_branches.id = ac.region_branch', 'left'); 
    $this->db->join('hr_employees', 'hr_employees.hr_employees_id = ac.assignee', 'left'); 
    $this->db->where('ac.date >=', $from_date);
    $this->db->where('ac.date <=', $to_date);
    
    // Apply filters based on user profile
if ($profile_settings->regional_profile_id == $_SESSION['profile_id'] || 
    $profile_settings->agency_profile_id == $_SESSION['profile_id']) {
   $allowed_branches=explode(',',$this->mastermodel->get_single_field_value('user','sub_branch_id','user_id',$_SESSION['user_id']));

            $this->db->where_in('ac.region_branch', $allowed_branches);
} elseif ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {
    $collector_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_id', 'user_id', $_SESSION['user_id']);
    $this->db->where('ac.assignee', $collector_id);
}
    
     if(!empty($postdata['region_select1'])){
        $this->db->where('ac.region', $postdata['region_select1']);
        }
          if(!empty($postdata['branch_select1'])){
        $this->db->where('ac.region_branch', $postdata['branch_select1']);
        }
     if(!empty($postdata['collector_select1'])){
        $this->db->where('ac.assignee', $postdata['collector_select1']);
        }
    $this->db->order_by('ac.date', 'ASC');

    $query = $this->db->get();
    $data = $query->result_array();
    $this->load->library('PHPExcel');
    $objPHPExcel = new PHPExcel();
    $sheet = $objPHPExcel->setActiveSheetIndex(0);
    $headers = [
        'Creditor','Debtor','Region','Branch','Collector', 'Agreement No', 'Complaint', 'Date','Principal','Total Balance','Previous Balance',
        'Paid Amount','Type'];
    $col = 0;
    foreach ($headers as $header) {
        $sheet->setCellValueByColumnAndRow($col, 1, $header);
        $col++;
    }

    // Write data to Excel
    $row = 2; // Start at second row
    foreach ($data as $dataRow) {
        $col = 0;
        foreach ($dataRow as $cell) {
            $sheet->setCellValueByColumnAndRow($col, $row, $cell);
            $col++;
        }
        $row++;
    }

    // Set filename
    $filename = 'bulk_payment_report.xlsx';

    // Set headers for download
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
    header('Cache-Control: max-age=0');

    // Write file to output
    $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $writer->save('php://output');
    exit;
}
}
/* End of file master.php */
/* Location: ./application/controllers/master.php */
