<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Accountingreport extends MY_Controller 
{
    public function __construct() 
    {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('propertymodel');
        
        $this->load->helper('to_pdf');

    }

    function get_post_values()
    {
        $data = array();
        foreach ($_POST as $key => $value)
        {
            if($key != "submit")
            {
                $data[$key] =  $this->input->post($key);
            }
        }
        return $data;
    }
    function viewinreportsearch($modelfunction,$subfolder, $page)
    {
        $output = $this->accountingreportmodel->$modelfunction();
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('accounting/'.$subfolder.'/'. $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1));
    }
    
    function addinreport($modelfunction, $resfunction,$subfolder, $page)
    {
        $postdata = $this->get_post_values();
        $data = array();
        $data = $this->accountingreportmodel->$modelfunction($postdata);
        $json_msg=$this->load->view('message', $data,TRUE);
        $output = $this->accountingreportmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('accounting/'.$subfolder.'/' . $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1,'json_msg'=>$json_msg));
    }

  
     function edit_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('accounting/'.$subfolder.'/' .$page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }
    
    function single_page($id, $table, $field,$subfolder, $page)
    { 
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('accounting/'.$subfolder.'/' . $page, $data);
    }
     public function load_ledger_page($modelfunction,$page,$id,$frmdate,$todate)
    {
        $data['viewinfo'] = $this->accountingreportmodel->$modelfunction($id,$frmdate,$todate);
        $data['view'] = $this->load->view('accounting/report/'  . $page,  $data, TRUE);
        echo $data['view'];
    }
    
  
     function decidetodownload($mainfolder,$subfolder,$page, $viewdata, $filename)
    {

        //var_dump($_POST['ispdf']);

        if (isset($_POST['ispdf']) && $_POST['ispdf'] == 1)
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
            pdf_create($html, $filename, false);
        } else if (isset($_POST['ispdf']) && $_POST['ispdf'] == 2)
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
            header("Content-type: application/octet-stream");
            header("Content-Disposition: attachment; filename=" . $filename . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
            exit;
        } else
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/'  . $page, $viewdata, true);
            echo $html;
        }
    }
        function load_journal_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->accountingreportmodel->load_journal_report($postdata);
         $viewdata['frmdate'] = $postdata['from_date'];
                  $viewdata['todate'] = $postdata['to_date'];
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Journal Report');
    }
         function load_daybook_report($mainfolder,$subfolder,$page)
    {
        $data = array();
        $postdata = $this->get_post_values();
//             $ledgerid = $this->input->post('acc_ledger');
//        $account_group_id = $this->mastermodel->get_single_field_value('account_ledger', 'account_group_id', 'ledger_id', $ledgerid);
//        $data['account_head_id'] = $this->mastermodel->get_single_field_value('account_group', 'group_under', 'account_group_id', $account_group_id);
//        $data['ledgername'] = $this->mastermodel->get_single_field_value('account_ledger', 'ledger_name', 'ledger_id', $ledgerid);
        
        $data['viewinfo'] = $this->accountingreportmodel->daybook_report($postdata['from_date'],$postdata['to_date'],$postdata['branch']);
   
        
        $data['open_bal'] = $this->accountingreportmodel->open_deb_cred();
         $data['frmdate'] = $postdata['from_date'];
                  $data['todate'] = $postdata['to_date'];
                   $data['branch'] = $postdata['branch'];
                      if ((isset($_POST['ispdf']) && $_POST['ispdf'] == 1)||(isset($_POST['ispdf']) && $_POST['ispdf'] == 2) )
        {
                     $page = $page."_pdf";   
                    }
        $this->decidetodownload($mainfolder,$subfolder,$page, $data, 'Daybook Report');
    }
         function load_costcentre_leadger_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
 
        $viewdata['viewinfo'] = $this->accountingreportmodel->load_costcentre_leadger_report($postdata);
         $viewdata['frmdate'] = $postdata['from_date'];
                  $viewdata['todate'] = $postdata['to_date'];
                    if ((isset($_POST['ispdf']) && $_POST['ispdf'] == 1)||(isset($_POST['ispdf']) && $_POST['ispdf'] == 2) )
        {
                     $page = $page."_pdf";   
                    }
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Cost Centre Leadger Report');
    }
        function load_ledger_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['frmdate'] = $postdata['from_date'];
        $viewdata['todate'] = $postdata['to_date'];
        $ledgerid =$postdata['ledger_id'];
        $account_group_id = $this->mastermodel->get_single_field_value('account_ledger', 'account_group_id', 'ledger_id', $ledgerid);
        $viewdata['account_head_id'] = $this->mastermodel->get_single_field_value('account_group', 'group_under', 'account_group_id', $account_group_id);
        $viewdata['ledgername'] = $this->mastermodel->get_single_field_value('account_ledger', 'ledger_name', 'ledger_id', $ledgerid);
       
        $viewdata['viewinfo'] = $this->accountingreportmodel->load_ledger_report($postdata);
     
         $viewdata['open_bal'] = $this->accountingreportmodel->open_deb_cred($postdata);
         $viewdata['frmdate'] = $postdata['from_date'];
         
                  $viewdata['todate'] = $postdata['to_date'];
                    if ((isset($_POST['ispdf']) && $_POST['ispdf'] == 1)||(isset($_POST['ispdf']) && $_POST['ispdf'] == 2) )
        {
                     $page = $page."_pdf";   
                    }
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Leadger Report');
    }
       function get_voucher_details($ledger_book_id)
    {
       
        $data['voucher_detail'] = $this->accountingreportmodel->voucher_detail($ledger_book_id);
        $output = $this->load->view('accounting/report/single_voucher_details', $data, TRUE);
        echo json_encode($output);
    }
        function load_trial_balance_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
  $data['frmdate'] = $postdata['from_date'];
        $data['todate'] =$postdata['to_date'];
        $data['branch'] =$postdata['branch'];
        $viewdata['viewinfo'] = $this->accountingreportmodel->load_trial_balance_report($postdata);
         $viewdata['frmdate'] = $postdata['from_date'];
          $viewdata['levels'] = 1;
                  $viewdata['todate'] = $postdata['to_date'];
                   $viewdata['branch'] = $postdata['branch'];
                    if ((isset($_POST['ispdf']) && $_POST['ispdf'] == 1)||(isset($_POST['ispdf']) && $_POST['ispdf'] == 2) )
        {
                     $page = $page."_pdf";   
                    }
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Trial Balance Report');
    }
      public function load_ledger_list_and_sub($modelfunction, $page, $id)
    {
        $data['frmdate'] = $_REQUEST['from_date'];
        $data['todate'] = $_REQUEST['to_date'];
         $data['branch'] =$_REQUEST['branch'];
        $data['id'] = $id;
      
        $data['viewinfo'] = $this->accountingreportmodel->$modelfunction($data);
        
        $data['subinfo'] = $this->accountingreportmodel->get_account_group_list_by_parent($data);
        
        $data['subgroupinfo'] = $this->accountingreportmodel->list_account_group_by_parent($id);
     
        $data['view'] = $this->load->view('accounting/report/' . $page, $data, TRUE);
        echo $data['view'];
    }
       function open_deb_cred_balance_by_ledger($data)
    {
        $frmdate = $data['frmdate'];

        $acc = $data['id'];
        $this->db->select('sum(ledger_book_details.debit) as open_debit,sum(ledger_book_details.credit) as open_credit,account_ledger.opening_balance,account_ledger.ledger_name as name');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->where('ledger_book.is_posted', '1');
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<', $frmdate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convertdateformat($frmdate));
        $this->db->where('account_ledger.ledger_id', $acc);
//        $this->db->order_by('ledger_id', 'desc');
        $res = $this->db->get();
        return $res->row();
    }
      public function load_ledger_report_page($page, $id)
    {
        $data['prev'] = $_REQUEST['prev'];
        $data['frmdate'] = $_REQUEST['from_date'];
        $data['todate'] = $_REQUEST['to_date'];
        $data['branch'] = $_REQUEST['branch'];
        $data['id'] = $id;
        $data['view'] = $this->load->view('accounting/report/' . $page, $data, TRUE);
        echo $data['view'];
    }
      public function load_ledger_amount_page($modelfunction, $page, $id)
    {
        $data['frmdate'] = $_REQUEST['from_date'];
        $data['todate'] = $_REQUEST['to_date'];
        $data['id'] = $id;
        $data['viewinfo'] = $this->accountingreportmodel->$modelfunction($data);
        $data['view'] = $this->load->view('accounting/report/' . $page, $data, TRUE);
        echo $data['view'];
    }
      public function load_prev_page($page)
    {
        $data['frmdate'] = $_REQUEST['from_date'];
        $data['todate'] = $_REQUEST['to_date'];
        $directory = $_SESSION['project_folder'];
        $data['view'] = $this->load->view('accounting/report/' . $page, $data, TRUE);
        echo $data['view'];
    }
      function load_balance_sheet_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        $data['frmdate'] = $postdata['from_date'];
        $data['todate'] =$postdata['to_date'];
           $data['branch'] =$postdata['branch'];
         if($_SESSION['project_id']==4){
                   $data['viewinfo'] = $this->accountingreportmodel->balance_sheet($data);

         }
         else{
         $data['capitalid'] = $this->accountingreportmodel->get_report_account_settings('capital_account');
        $data['loanid'] = $this->accountingreportmodel->get_report_account_settings('loans');
        $data['currentid'] = $this->accountingreportmodel->get_report_account_settings('current_liabilities');
        $data['branchdivisionid'] = $this->accountingreportmodel->get_report_account_settings('branch_division');
        $data['suspenceacid'] = $this->accountingreportmodel->get_report_account_settings('suspence_ac');
        $data['capital_account'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('capital_account', $data['frmdate'], $data['todate'],$data['branch']);
        $data['loans'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('loans', $data['frmdate'], $data['todate'],$data['branch']);
        $data['current_liabilities'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('current_liabilities', $data['frmdate'], $data['todate'],$data['branch']);
        $data['branch_division'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('branch_division', $data['frmdate'], $data['todate'],$data['branch']);
        $data['suspence_ac'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('suspence_ac', $data['frmdate'], $data['todate'],$data['branch']);
        
        /* Asset side*/
        $data['fixedassetid'] = $this->accountingreportmodel->get_report_account_settings('fixed_assets');
        $data['current_assetsid'] = $this->accountingreportmodel->get_report_account_settings('current_assets');
        $data['investmentsid'] = $this->accountingreportmodel->get_report_account_settings('investments');
        $data['fixed_assets'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('fixed_assets', $data['frmdate'], $data['todate'],$data['branch']);
        $data['current_assets'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('current_assets', $data['frmdate'], $data['todate'],$data['branch']);
        $data['investments'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('investments', $data['frmdate'], $data['todate'],$data['branch']);
         }
        $data['frmdate'] = $postdata['from_date'];
          $data['levels'] = 1;
                  $data['todate'] = $postdata['to_date'];
                   $data['branch'] = $postdata['branch'];
                    if ((isset($_POST['ispdf']) && $_POST['ispdf'] == 1)||(isset($_POST['ispdf']) && $_POST['ispdf'] == 2) )
        {
                     $page = $page."_pdf";   
                    }
        $this->decidetodownload($mainfolder,$subfolder,$page, $data, 'Balance Sheet Report');
    }
     public function ledger_list_and_sub($modelfunction, $page, $id)
    {
        
        $data['frmdate'] = $_REQUEST['from_date'];
        $data['todate'] = $_REQUEST['to_date'];
           $data['branch'] = $_REQUEST['branch'];
 
          
        $data['id'] = $id;
        $data['viewinfo'] = $this->accountingreportmodel->$modelfunction($data);
        $data['subinfo'] = $this->accountingreportmodel->get_balancesheet_account_group_list_by_parent($data);
        $data['subgroupinfo'] = $this->accountingreportmodel->list_account_group_by_parent($id);
        $data['view'] = $this->load->view('accounting/report/' . $page, $data, TRUE);
   
        echo $data['view'];
    }
     function load_profit_loss_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        $data['frmdate'] = $postdata['from_date'];
        $data['todate'] =$postdata['to_date'];
            $data['branch'] =$postdata['branch'];
         $data['purchase'] = $this->accountingreportmodel->get_accountgroup_amount_by_settings_id('purchase_account', $this->input->post('from_date'), $this->input->post('to_date'), $data['branch']);
        $data['direct_expense'] = $this->accountingreportmodel->get_accountgroup_amount_by_settings_id('direct_expense', $this->input->post('from_date'), $this->input->post('to_date'), $data['branch']);
        $data['indirect_expense'] = $this->accountingreportmodel->get_accountgroup_amount_by_settings_id('indirect_expense', $this->input->post('from_date'), $this->input->post('to_date'), $data['branch']);
        $data['sales_account'] = $this->accountingreportmodel->get_accountgroup_amount_by_settings_id('sales_account', $this->input->post('from_date'), $this->input->post('to_date'), $data['branch']);
        $data['direct_incomes'] = $this->accountingreportmodel->get_accountgroup_amount_by_settings_id('direct_incomes', $this->input->post('from_date'), $this->input->post('to_date'), $data['branch']);
        $data['other_incomes'] = $this->accountingreportmodel->get_accountgroup_amount_by_settings_id('other_incomes', $this->input->post('from_date'), $this->input->post('to_date'), $data['branch']);
        $data['open_bal'] = $this->accountingreportmodel->open_deb_cred();
        
         $data['frmdate'] = $postdata['from_date'];
          $data['levels'] = 1;
                  $data['todate'] = $postdata['to_date'];
                    if ((isset($_POST['ispdf']) && $_POST['ispdf'] == 1)||(isset($_POST['ispdf']) && $_POST['ispdf'] == 2) )
        {
                     $page = $page."_pdf";   
                    }
        $this->decidetodownload($mainfolder,$subfolder,$page, $data, 'Profit Loss Report');
    }
      public function liability_balancesheet_parents($modelfunction, $page, $id)
    {
        $data['frmdate'] = $_REQUEST['from_date'];
        $data['todate'] = $_REQUEST['to_date'];
        $directory = $_SESSION['project_folder'];
        $data['id'] = $id;
          $data['branch'] = $_REQUEST['branch'];
        $data['viewinfo'] = $this->accountingreportmodel->$modelfunction($data);
        $capitalid = $this->accountingreportmodel->get_report_account_settings('capital_account');
        $loanid = $this->accountingreportmodel->get_report_account_settings('loans');
        $currentid = $this->accountingreportmodel->get_report_account_settings('current_liabilities');
        $data['capital_account'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('capital_account', $data['frmdate'], $data['todate'],$data['branch']);
        $data['loans'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('loans', $data['frmdate'], $data['todate'],$data['branch']);
        $data['current_liabilities'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('current_liabilities', $data['frmdate'], $data['todate'],$data['branch']);
        $data['branch_division'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('branch_division', $data['frmdate'], $data['todate'],$data['branch']);
        $data['suspence_ac'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('suspence_ac', $data['frmdate'], $data['todate'],$data['branch']);
        $data['view'] =$this->load->view('accounting/report/' . $page, $data, TRUE);
        echo $data['view'];
    }
     public function asset_balancesheet_parents($modelfunction, $page, $id)
    {
        $data['frmdate'] = $_REQUEST['from_date'];
        $data['todate'] = $_REQUEST['to_date'];
         $data['branch'] = $_REQUEST['branch'];
        $directory = $_SESSION['project_folder'];
        $data['id'] = $id;
        $data['viewinfo'] = $this->accountingreportmodel->$modelfunction($data);
        $data['fixedassetid'] = $this->accountingreportmodel->get_report_account_settings('fixed_assets');
        $data['current_assetsid'] = $this->accountingreportmodel->get_report_account_settings('current_assets');
        $data['investmentsid'] = $this->accountingreportmodel->get_report_account_settings('investments');
        $data['fixed_assets'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('fixed_assets', $data['frmdate'], $data['todate'],$data['branch']);
        $data['current_assets'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('current_assets', $data['frmdate'], $data['todate'],$data['branch']);
        $data['investments'] = $this->accountingreportmodel->get_close_accountgroup_amount_by_settings_id('investments', $data['frmdate'], $data['todate'],$data['branch']);
        $data['view'] = $this->load->view('accounting/report/' . $page, $data, TRUE);
        echo $data['view'];
    }
       public function load_ledger_narration($modelfunction, $page, $id)
    {
        $directory = $_SESSION['project_folder'];
        $data['id'] = $id;
        $data['viewinfo'] = $this->accountingreportmodel->$modelfunction($id);
        $data['view'] = $this->load->view('accounting/report/' . $page, $data, TRUE);
        echo $data['view'];
    }
       function load_reconcile_bank($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['frmdate'] = $postdata['from_date'];
        $viewdata['todate'] = $postdata['to_date'];
        $ledgerid =$postdata['ledger_id'];
        $account_group_id = $this->mastermodel->get_single_field_value('account_ledger', 'account_group_id', 'ledger_id', $ledgerid);
        $viewdata['account_head_id'] = $this->mastermodel->get_single_field_value('account_group', 'group_under', 'account_group_id', $account_group_id);
        $viewdata['ledgername'] = $this->mastermodel->get_single_field_value('account_ledger', 'ledger_name', 'ledger_id', $ledgerid);
       
        $viewdata['viewinfo'] = $this->accountingreportmodel->load_ledger_report($postdata);
     
         $viewdata['open_bal'] = $this->accountingreportmodel->open_deb_cred($postdata);
         $viewdata['frmdate'] = $postdata['from_date'];
         
                  $viewdata['todate'] = $postdata['to_date'];
                    if ((isset($_POST['ispdf']) && $_POST['ispdf'] == 1)||(isset($_POST['ispdf']) && $_POST['ispdf'] == 2) )
        {
                     $page = $page."_pdf";   
                    }
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Reconcile Bank Report');
    }
          function load_receivable_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['frmdate'] = $postdata['from_date'];
        $viewdata['todate'] = $postdata['to_date'];
    
        $viewdata['viewinfo'] = $this->accountingreportmodel->recievable_report_function($postdata['from_date'],$postdata['branch']);
         $viewdata['frmdate'] = $postdata['from_date'];
         
                  $viewdata['todate'] = $postdata['to_date'];
                    if ((isset($_POST['ispdf']) && $_POST['ispdf'] == 1)||(isset($_POST['ispdf']) && $_POST['ispdf'] == 2) )
        {
                     $page = $page."_pdf";   
                    }
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Receivable Report');
    }
        function load_payable_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['frmdate'] = $postdata['from_date'];
        $viewdata['todate'] = $postdata['to_date'];
    
        $viewdata['viewinfo'] = $this->accountingreportmodel->payable_report_function($postdata['from_date'],$postdata['branch']);
         $viewdata['frmdate'] = $postdata['from_date'];
         
                  $viewdata['todate'] = $postdata['to_date'];
                    if ((isset($_POST['ispdf']) && $_POST['ispdf'] == 1)||(isset($_POST['ispdf']) && $_POST['ispdf'] == 2) )
        {
                     $page = $page."_pdf";   
                    }
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Payable Report');
    }
}
