<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Accounting extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('propertymodel');
        $this->load->model('posmodel');
        $this->load->model('salesmodel');
        
        $this->load->helper('to_pdf');
    }

    public function view($folder, $page) {
        $this->load->view($folder . '/' . $page);
    }

    function get_post_values() {
        $data = array();
        foreach ($_POST as $key => $value) {
            if ($key != "submit") {
                $data[$key] = $this->input->post($key);
            }
        }
        return $data;
    }

    function addformdisplay($page, $directory, $return_page = '') {
        $data = array();
        $data['return_page'] = $return_page;

        $json_data = $this->load->view('' . $directory . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function viewinaccountingsearch($modelfunction,$subfolder, $page, $pagenum) {
        $output = $this->accountingmodel->$modelfunction($pagenum);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('accounting/'.$subfolder.'/' .$page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }
      function viewinaccountingsearch_trans($modelfunction,$subfolder, $page, $pagenum,$type,$posted) {
       
               
        $output = $this->accountingmodel->$modelfunction($pagenum,$type,$posted);
        $data['viewinfo'] = $output['results'];
        $data['posted'] = $posted;
        $json_data = $this->load->view('accounting/'.$subfolder.'/' .$page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function addinaccounting($modelfunction, $resfunction,$subfolder, $page) {
        $postdata = $this->get_post_values();
        $data = $this->accountingmodel->$modelfunction($postdata);
       
        $json_msg = $this->load->view('message', $data, TRUE);
        $output = $this->accountingmodel->$resfunction($_SESSION['pagenum']);
     
        $data['viewinfo'] = $output['results'];
        
        $json_data = $this->load->view('accounting/'.$subfolder.'/'  . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
    }
      function addinaccounting_trans($modelfunction, $resfunction,$subfolder,$page,$type,$posted) {
        $postdata = $this->get_post_values();
        $data = $this->accountingmodel->$modelfunction($postdata);
        $json_msg = $this->load->view('message', $data, TRUE);
        $output = $this->accountingmodel->$resfunction($_SESSION['pagenum'],$type,$posted);
     
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('accounting/'.$subfolder.'/'  . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
    }
    function edit_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('accounting/'.$subfolder.'/' . $page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function single_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('accounting/'.$subfolder.'/'. $page, $data);
    }

    function deletedata($table, $id, $field) {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->mastermodel->deletedata($table, $id, $field);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
     function delete_journal($modelfunction, $id) {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->accountingmodel->$modelfunction($id);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
    public function ajax()
	{

//		$from = $this->input->post('from');
//        $to = $this->input->post('to');

        
//        if($from!='' && $to!='')
//        {
//            $from = date('Y-m-d',strtotime($from));
//            $to = date('Y-m-d',strtotime($to));
//        }

        $posts = $this->accountingmodel->get_datatables(); 
      
        $data = array();
        $no = $this->input->post('start');
        foreach ($posts as $post) 
        {
         $table = 0;
         $field = 0;
            $edit = "onclick = editformdata('accounting','edit_page','".$post->account_group_id."','account_group','account_group_id','master','edit_account_groups')";
         
             $check1 = $this->mastermodel->get_single_field_value('account_group','parent','parent',$row->account_group_id);
                               $check2 = $this->mastermodel->get_single_field_value('account_ledger','account_group_id','account_group_id',$row->account_group_id);
                       
                               if(empty($check1) && empty($check2))
                               {
            $delete = "onclick = deletedata('account_group','".$post->account_group_id."','account_group_id','accounting','viewinaccountingsearch','search_account_groups','master','view_account_groups','".$table."','".$field."')";
            }
                               else{
                                $delete = "";
                               }
                               $no++;
            $row = array();
            $row[] = $no;
            $row[] = $post->account_group_code;
              $row[] = $post->account_group_name;
              $row[] = $post->group_under;
                $row[] = $post->narration;
              $row[] = '<a class="edit" href="#" title="Edit" "'.$edit.'"><i class="fa fa-edit" ></i></a>
               <a class="delete" title="Delete" href="#" "'.$delete.'"><i class="fa fa-trash"></i></a>';
              
              
            $data[] = $row;
        }
        
        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->accountingmodel->count_all(),
            "recordsFiltered" => $this->accountingmodel->count_filtered(),
            "data" => $data,
        );
        //output to json format
        echo json_encode($output);
	}
        function change_status($table, $id, $field) {
        $data = array();
      
        $data = $this->accountingmodel->change_status($table, $id, $field);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
      function load_reconcile_bank($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['frmdate'] = $postdata['from_date'];
        $viewdata['todate'] = $postdata['to_date'];
        $ledgerid =$postdata['ledger_id'];
        $account_group_id = $this->mastermodel->get_single_field_value('account_ledger', 'account_group_id', 'ledger_id', $ledgerid);
        $viewdata['account_head_id'] = $this->mastermodel->get_single_field_value('account_group', 'group_under', 'account_group_id', $account_group_id);
        $viewdata['ledgername'] = $this->mastermodel->get_single_field_value('account_ledger', 'ledger_name', 'ledger_id', $ledgerid);
       
        $viewdata['viewinfo'] = $this->accountingreportmodel->load_ledger_report($postdata);
     
         $viewdata['open_bal'] = $this->accountingreportmodel->open_deb_cred($postdata);
         $viewdata['frmdate'] = $postdata['from_date'];
         
                  $viewdata['todate'] = $postdata['to_date'];
         $html = $this->load->view($mainfolder.'/'.$subfolder.'/'  . $page, $viewdata, true);
            echo $html;
    }
    
    
}