<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Clientmodel extends CI_Model {

    function __construct() {
        // Call the Model constructor   664c84de60fddddb7c8e24069dbdb93e
        parent::__construct();
    }

    function search_document() {
        $data = array();
        $this->db->select('*');
        $this->db->from('document');
        $this->db->join('sub_document', 'sub_document.sub_document_document_id=document.document_id');
        $this->db->join('master', 'master.master_id=document.document_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('document.document_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function get_id_details() {
        $data = array();
        $this->db->select('*');
        $this->db->from('document');
        $this->db->join('sub_document', 'sub_document.sub_document_document_id=document.document_id');
        $this->db->join('master', 'master.master_id=document.document_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('document.document_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_document($postdata) {
        $data = array();
        $this->db->trans_begin();
        $document_id = $this->mastermodel->insertmasterdata();
        $document_code = $this->mastermodel->get_ref('document_code', 'document', 'document_code');
        $tblValues = array(
            'document_code' => $document_code,
            'document_id' => $document_id,
            'document_name' => $postdata['document_name'],
            'document_issuing_authority' => $postdata['document_issuing_authority'],
            'document_processing_days' => $postdata['document_processing_days'],
        );
        $this->db->insert('document', $tblValues);
        $i = 1;
        while (isset($postdata['sub_document_crm_lead_type_id' . $i])) {
            $sub_document_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'sub_document_id' => $sub_document_id,
                'sub_document_document_id' => $document_id,
                'sub_document_crm_category_id' => $postdata['sub_document_crm_category_id' . $i],
                'sub_document_crm_lead_type_id' => $postdata['sub_document_crm_lead_type_id' . $i],
                'sub_document_copies' => $postdata['sub_document_copies' . $i],
            );
            $i++;
            $output = $this->db->insert('sub_document', $tblValues_sub_document);
        }
        $output = $this->mastermodel->save_user_activities('Add Document', $document_id, 'document');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function update_document($postdata) {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'document_name' => $postdata['document_name'],
            'document_issuing_authority' => $postdata['document_issuing_authority'],
            'document_processing_days' => $postdata['document_processing_days'],
        );
        $this->db->where('document_id', $postdata['document_id']);
        $this->db->update('document', $tblValues);


        $tblValues = array(
            'sub_document_crm_category_id' => $postdata['sub_document_crm_category_id'],
            'sub_document_crm_lead_type_id' => $postdata['sub_document_crm_lead_type_id'],
            'sub_document_copies' => $postdata['sub_document_copies'],
        );
        $this->db->where('sub_document_id', $postdata['sub_document_id']);
        $this->db->update('sub_document', $tblValues);

        $output = $this->mastermodel->save_user_activities('Update Document', $postdata['document_id'], 'document');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_complaints() {
        $credior_id=$this->mastermodel->get_single_field_value('contact','contact_id','user_id',$_SESSION['user_id']);

        $profile_settings = $this->mastermodel->get_profile_settings();
        $data = array();
        $this->db->select('*');
        $this->db->from('complaints');
         $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id');
        // $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id');
        $this->db->order_by('complaints_id', 'desc');
        
        
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {
            $this->db->where('complaints.complaints_creditor_id', $credior_id);
        }
        if ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_assign_ids', $_SESSION['employee_id']);
        }
        if (($profile_settings->legal_profile_id == $_SESSION['profile_id']) || ($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('complaints.complaints_lawyer_id', $this->mastermodel->get_single_field_value('lawyer', 'lawyer_id', 'user_id', $_SESSION['user_id']));
        }

       
        $data['results'] = $this->db->get();
        
      //  echo $this->db->last_query(); die();
        return $data;
    }

    function search_ptp_complaints() {

        $data = array();
        $this->db->select('*');
        $this->db->from('complaints');
        $this->db->order_by('complaints_id', 'desc');

        $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id');
        $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id');
        $this->db->where('complaints_is_settled', '1');
        $this->db->where('complaints_is_settled_direct', '0');
        $data['results'] = $this->db->get();
        return $data;
    }
    
    
      function search_ptp_complaints_counts() {


         $profile_settings = $this->mastermodel->get_profile_settings();
      
      $lawyer= $this->mastermodel->get_single_field_value('lawyer', 'lawyer_id', 'user_id', $_SESSION['user_id']);
    
        $data = array();
        $this->db->select('*');
        $this->db->from('complaints');
        $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id');
                $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id');

        $this->db->order_by('complaints_id', 'desc');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_creditor_id', $credior_id_s);
        }
        if ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_assign_ids', $_SESSION['employee_id']);
        }
        if (($profile_settings->legal_profile_id == $_SESSION['profile_id']) || ($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('complaints.complaints_lawyer_id', $lawyer);
        }
        $this->db->where('complaints.complaints_status_id', '6158');
        $query = $this->db->get();
        $data['num_rows'] = $query->num_rows(); 
        return $data;
    }
    
    
      function update_complaints_excel($filename){
      //  $filename = "/home/matrixdebtc/public_html/erp/assets/uploads/c14314.csv";
        //$filename = "/home/matrixdebtc/public_html/erp/assets/uploads/c114299.csv";
              //  $filename = "/home/matrixdebtc/public_html/erp/assets/uploads/c114309.csv";

        $filename = "/home/matrixdebtc/public_html/erp/assets/uploads/cmp22_10.csv";

        $file = fopen($filename, "r");
        $row=1;
        while (($emapData = fgetcsv($file, 10000, ",")) !== FALSE) {
         
           if($row>1){
            {
            $num=(int) filter_var($emapData[3], FILTER_SANITIZE_NUMBER_INT);
            $emapData[3]="EMP".$num;
            
            
            if($emapData[9]==''){
                $emapData[9]=0;
            }
            else{
                $emapData[9]=(float)$emapData[9];
            }
             if($emapData[20]==''){
                 $emapData[20]=0;
            }
             else{
                $emapData[20]=(float)$emapData[20];
            }
             if($emapData[14]==''){
                 $emapData[14]=0;
            }
             else{
                $emapData[14]=(float)$emapData[14];
            }
            
            if($emapData[21]==''){
                 $emapData[21]=0;
            }
             else{
                $emapData[21]=(float)$emapData[21];
            }
            
            if($emapData[16]==''){
                 $emapData[16]=0;
            }
             else{
                $emapData[16]=(float)$emapData[16];
            }
            
            
            if($emapData[18]==''){
                 $emapData[18]=0;
            }
             else{
                $emapData[18]=(float)$emapData[18];
            }
            
                
                $postdata = array(
                 
    'complaints_date' => date('d/m/Y'),
    'complaints_owner' => 7002,
    'complaints_case_type' => $emapData[1],
    'complaints_status_id' => $emapData[2],
    'complaints_assign_ids' => $this->mastermodel->get_single_field_value('hr_employees','hr_employees_id','hr_employees_code',$emapData[3]),
    'complaints_description' => $emapData[4],
    'complaints_debtor_id' => $emapData[6],
    'firstname' => $this->mastermodel->get_single_field_value('debtor','crm_debtor_first_name','crm_debtor_id',$emapData[6]),
    'lastname' =>$this->mastermodel->get_single_field_value('debtor','crm_debtor_last_name','crm_debtor_id',$emapData[6]),
    'address' =>$this->mastermodel->get_single_field_value('debtor','crm_debtor_residential_address','crm_debtor_id',$emapData[6]), 
    'complaints_debtor_agreement_no' => $emapData[7],
    'complaints_debtor_relationship_no' => $emapData[8],
    'complaints_debtor_principle_amnt' => $emapData[9],
    'complaints_debtor_total_os' =>$emapData[10],
    'complaints_debtor_vintage' => $emapData[11],
    'complaints_debtor_product' => $emapData[12],
    'complaints_debtor_over_due_amount' => $emapData[20],
    'complaints_debtor_last_pmt_rcvd_date' => $emapData[13],
    'complaints_debtor_last_amount_rcvd' =>$emapData[14] ,
    'complaints_settled_amount' =>$emapData[21] ,
    'complaints_debt_currency1' => $emapData[15],
    'complaints_debt_amount1' => $emapData[16],
    'complaints_debt_currency2' => $emapData[17],
    'complaints_debt_amount2' =>$emapData[18],
    'complaints_debt_other_details' => $emapData[19],
    'complaints_creditor_id' => $emapData[5],
             );
                
              // print_r($postdata);
                  $this->insert_complaints($postdata);
               
            }
           
        }
         $row++;
        }
    } 

    public function insert_complaints($postdata) {
        $data = array();
        $this->db->trans_begin();
        $master_id = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('complaints_code', 'complaints', 'complaints_code');

        $settled_document = $this->mastermodel->upload_image('complaints_settled_document');
        if (!empty($settled_document)) {
            $settled_document = $settled_document['file_name'];
        } else {
            $settled_document = '';
        }

        $tblValues = array(
            'complaints_id' => $master_id,
            'complaints_code' => $code,
            'complaints_date' => $this->mastermodel->convert_date_format($postdata['complaints_date']),
            'complaints_owner' => $postdata['complaints_owner'],
            'complaints_case_type' => $postdata['complaints_case_type'],
            'complaints_status_id' => $postdata['complaints_status_id'],
//            'complaints_title' => $postdata['complaints_title'],
            'complaints_assign_ids' => $postdata['complaints_assign_ids'],
            'complaints_description' => $postdata['complaints_description'],
            'complaints_creditor_id' => $postdata['complaints_creditor_id'],
            'complaints_debtor_id' => $postdata['complaints_debtor_id'],
            //   'complaints_debtor_agreement_id' => $postdata['complaints_debtor_agreement_id'],
            'complaints_debtor_agreement_no' => $postdata['complaints_debtor_agreement_no'],
            'complaints_debtor_relationship_no' => $postdata['complaints_debtor_relationship_no'],
            'complaints_debtor_principle_amnt' => $postdata['complaints_debtor_principle_amnt'],
            'complaints_debtor_total_os' => $postdata['complaints_debtor_total_os'],
            'complaints_debtor_vintage' => $postdata['complaints_debtor_vintage'],
            //'complaints_debtor_dpd' => $postdata['complaints_debtor_dpd'],
            //'complaints_debtor_dpd_r' => $postdata['complaints_debtor_dpd_r'],
            'complaints_debtor_product' => $postdata['complaints_debtor_product'],
            'complaints_debtor_last_pmt_rcvd_date' => $postdata['complaints_debtor_last_pmt_rcvd_date'],
            'complaints_debtor_last_amount_rcvd' => $postdata['complaints_debtor_last_amount_rcvd'],
            // 'complaints_debtor_amtfin' => $postdata['complaints_debtor_amtfin'],
            'complaints_debt_currency1' => $postdata['complaints_debt_currency1'],
            'complaints_debt_amount1' => $postdata['complaints_debt_amount1'],
            'complaints_debt_currency2' => $postdata['complaints_debt_currency2'],
            'complaints_debt_amount2' => $postdata['complaints_debt_amount2'],
//            'complaints_debt_account_no' => $postdata['complaints_debt_account_no'],
//            'complaints_debt_account_name' => $postdata['complaints_debt_account_name'],
            'complaints_debt_other_details' => $postdata['complaints_debt_other_details'],
            'complaints_debtor_over_due_amount' => $postdata['complaints_debtor_over_due_amount'],
            'complaints_settled_amount' => $postdata['complaints_settled_amount'],
            'complaints_settled_document' => $settled_document,
        );
        if (isset($postdata['complaints_is_settled'])) {
            $tblValues['complaints_is_settled'] = $postdata['complaints_is_settled'];
        }
        $this->db->insert('complaints', $tblValues);
        $complaints_status_id = $this->mastermodel->insertmasterdata();
        $tblValues1 = array(
            'complaints_status_id' => $complaints_status_id,
            'status_complaints_id' => $master_id,
            'case_type' => $postdata['complaints_case_type'],
            'status_id' => $postdata['complaints_status_id'],
            'user_id' => $_SESSION['user_id'],
            'date' => date('Y-m-d'),
        );

        $this->db->insert('complaints_status', $tblValues1);
        $i = 0;
        while (!empty($_FILES['complaints_file_details_file_name' . ++$i])) {
            $file = $this->mastermodel->upload_image('complaints_file_details_file_name' . $i);

            $tblValues = array(
                'complaints_file_details_id' => $this->mastermodel->insertmasterdata(),
                'complaints_file_details_complants_id' => $master_id,
                'complaints_file_details_file_name' => $file['file_name'],
                'complaints_file_note' => $postdata['complaints_file_note' . $i]
            );

            $this->db->insert('complaints_file_details', $tblValues);
        }

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_case_type($postdata) {

        $complaints_status_id = $this->mastermodel->insertmasterdata();
        $tblValues1 = array(
            'complaints_status_id' => $complaints_status_id,
            'status_complaints_id' => $postdata['complaints_id'],
            'case_type' => $postdata['case_type'],
            'status_id' => $postdata['status_id'],
            'user_id' => $_SESSION['user_id'],
            'date' => date('Y-m-d'),
        );

        $this->db->insert('complaints_status', $tblValues1);

        $tblValues = array(
            'complaints_case_type' => $postdata['case_type'],
            'complaints_status_id' => $postdata['status_id'],
        );

        $this->db->where('complaints_id', $postdata['complaints_id']);
        $this->db->update('complaints', $tblValues);
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_task_status($postdata) {

        $status_id = $this->mastermodel->insertmasterdata();
        $tblValues1 = array(
            'task_status_id' => $status_id,
            'task_status_task_id' => $postdata['task_id'],
            'task_status_status_id' => $postdata['status_id'],
            'task_user_id' => $_SESSION['user_id'],
            'task_date' => date('Y-m-d'),
        );

        $this->db->insert('task_status', $tblValues1);

        $tblValues = array(
            'task_status_id' => $postdata['status_id']
        );

        $this->db->where('task_id', $postdata['task_id']);
        $this->db->update('task', $tblValues);

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_complaints($postdata) {
    //    echo $postdata['complaints_debtor_total_os'];die();
      //  print_r($postdata);die();
        $data = array();
        $this->db->trans_begin();
        $master_id = $this->mastermodel->insertmasterdata();

        $settled_document = $this->mastermodel->upload_image('complaints_settled_document');
        if (!empty($settled_document)) {
            $settled_document = $settled_document['file_name'];
        } else {
            $settled_document = $postdata['complaints_settled_document'];
        }
        $tblValues = array(
//            'complaints_id' => $master_id,
//            'complaints_code' => $code,
            'complaints_date' => $this->mastermodel->convert_date_format($postdata['complaints_date']),
//            'complaints_owner' => $postdata['complaints_owner'],
            'complaints_case_type' => $postdata['complaints_case_type'],
            'complaints_status_id' => $postdata['complaints_status_id'],
//            'complaints_title' => $postdata['complaints_title'],
            'complaints_assign_ids' => $postdata['complaints_assign_ids'],
            'complaints_description' => $postdata['complaints_description'],
            //  'complaints_creditor_id' => $postdata['complaints_creditor_id'],
            'complaints_debtor_id' => $postdata['complaints_debtor_id'],
            'complaints_debtor_agreement_id' => $postdata['complaints_debtor_agreement_id'],
            'complaints_debtor_agreement_no' => $postdata['complaints_debtor_agreement_no'],
            'complaints_debtor_relationship_no' => $postdata['complaints_debtor_relationship_no'],
            'complaints_debtor_principle_amnt' => $postdata['complaints_debtor_principle_amnt'],
            'complaints_debtor_total_os'=>$postdata['complaints_debtor_total_os'],
            'complaints_debtor_vintage' => $postdata['complaints_debtor_vintage'],
            //   'complaints_debtor_dpd' => $postdata['complaints_debtor_dpd'],
            //   'complaints_debtor_dpd_r' => $postdata['complaints_debtor_dpd_r'],
            'complaints_debtor_product' => $postdata['complaints_debtor_product'],
            'complaints_debtor_last_pmt_rcvd_date' => $this->mastermodel->convert_date_format($postdata['complaints_debtor_last_pmt_rcvd_date']),
            'complaints_debtor_last_amount_rcvd' => $postdata['complaints_debtor_last_amount_rcvd'],
            // 'complaints_debtor_amtfin' => $postdata['complaints_debtor_amtfin'],
            // 'complaints_is_settled_direct'=$postdata['complaints_is_settled_direct'],
            'complaints_debt_currency1' => $postdata['complaints_debt_currency1'],
            'complaints_debt_amount1' => $postdata['complaints_debt_amount1'],
            'complaints_debt_currency2' => $postdata['complaints_debt_currency2'],
            'complaints_debt_amount2' => $postdata['complaints_debt_amount2'],
//            'complaints_debt_account_no' => $postdata['complaints_debt_account_no'],
//            'complaints_debt_account_name' => $postdata['complaints_debt_account_name'],
            'complaints_debt_other_details' => $postdata['complaints_debt_other_details'],
            'complaints_settled_amount' => $postdata['complaints_settled_amount'],
            'complaints_debtor_over_due_amount' => $postdata['complaints_debtor_over_due_amount'],
            'complaints_settled_document' => $settled_document,
        );
        if (isset($postdata['complaints_is_settled'])) {
            $tblValues['complaints_is_settled'] = $postdata['complaints_is_settled'];
        }

        if (isset($postdata['complaints_is_settled_direct'])) {

            if ($this->mastermodel->get_num_rows('ptp', 'ptp_complaints_id', $postdata['complaints_id']) <= 0) {
                $tblValues['complaints_is_settled_direct'] = $postdata['complaints_is_settled_direct'];
                $master_id_ptp = $this->mastermodel->insertmasterdata();
                $code = $this->mastermodel->get_ref('ptp_code', 'ptp', 'ptp_code');

                $tblValues2 = array(
                    'ptp_id' => $master_id_ptp,
                    'ptp_code' => $code,
                    'ptp_date' => $this->mastermodel->convert_date_format($postdata['complaints_date']),
                    'ptp_amount' => $postdata['complaints_settled_amount'],
                    'ptp_installments' => 0,
                    'ptp_frequency' => 0,
                    'ptp_start_date' => $this->mastermodel->convert_date_format($postdata['complaints_date']),
                    'ptp_due_date' => $this->mastermodel->convert_date_format($postdata['complaints_date']),
                    'ptp_complaints_id' => $postdata['complaints_id'],
                    'ptp_note' => "direct_note",
                    'ptp_approve' => 1
                );

                $this->db->insert('ptp', $tblValues2);
                $ptp_payment_plan_id = $this->mastermodel->insertmasterdata();
                $tblValues1 = array(
                    'ptp_payment_plan_id' => $ptp_payment_plan_id,
                    'payment_plan_ptp_id' => $master_id_ptp,
                    'payment_plan_amount' => $postdata['complaints_settled_amount'],
                    'payment_plan_date' => $this->mastermodel->convert_date_format($postdata['complaints_date']),
                );

                $this->db->insert('ptp_payment_plan', $tblValues1);
            }
        }
        $this->db->where('complaints_id', $postdata['complaints_id']);
        $this->db->update('complaints', $tblValues);

        $this->db->where('complaints_file_details_complants_id', $postdata['complaints_id']);
        $this->db->delete('complaints_file_details');
        $i = 0;
        while (!empty($_FILES['complaints_file_details_file_name' . ++$i]) || !empty($postdata['complaints_file_details_file_name_prev' . $i])) {
            $file = $this->mastermodel->upload_image('complaints_file_details_file_name' . $i)['file_name'];
            if (empty($file)) {
                $file = $postdata['complaints_file_details_file_name_prev' . $i];
            }
            $tblValues = array(
                'complaints_file_details_id' => $this->mastermodel->insertmasterdata(),
                'complaints_file_details_complants_id' => $postdata['complaints_id'],
                'complaints_file_details_file_name' => $file,
                'complaints_file_note' => $postdata['complaints_file_note' . $i]
            );

            $this->db->insert('complaints_file_details', $tblValues);
        }

        if (isset($postdata['complaints_is_settled']) && ($postdata['complaints_is_settled'] == "1")) {
            $credtor = $this->mastermodel->get_data_srow('contact', $postdata['complaints_creditor_id'], 'contact_id');
            $debtor = $this->mastermodel->get_data_srow('debtor', $postdata['complaints_debtor_id'], 'crm_debtor_id');
            $employees = $this->mastermodel->get_data_srow('hr_employees', $postdata['complaints_assign_ids'], 'hr_employees_id');
            $complaints_settled_amount = $postdata["complaints_settled_amount"];
            $email['to'] = $credtor->contact_email;
            $email['attachment'] = 'assets/uploads/' . $settled_document;
            $email['subject'] = "Complaint Settlement";
            $email['message'] = '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">Debitor Name :' . $debtor->crm_debtor_first_name . '  ' . $debtor->crm_debtor_last_name . ' <pre> '
                    . ' <pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">Debitor Address :' . $debtor->crm_debtor_residential_address . '</pre> '
                    . ' <pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">Collector Name :' . $employees->hr_employees_name . '</pre> '
                    . ' <pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">Settled Amount:' . $complaints_settled_amount . '<pre>';

            $status = $this->clientmodel->send_email_task($email);
        }
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function search_task() {
        $profile_settings = $this->mastermodel->get_profile_settings();
        $data = array();
        $this->db->select('*');
        $this->db->from('task');
        $this->db->order_by('task_id', 'desc');
        $this->db->join('complaints', 'complaints.complaints_id=task.task_complaint_id', 'left');
        $this->db->join('debtor', 'debtor.crm_debtor_id=task.task_debtor_id', 'left');
        $this->db->join('contact', 'contact.contact_id=task.task_creditor_id', 'left');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('contact.user_id', $_SESSION['user_id']);
        }
        if ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_assign_ids', $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_id', 'user_id', $_SESSION['user_id']));
        }
        if (($profile_settings->legal_profile_id == $_SESSION['profile_id']) || ($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('complaints.complaints_lawyer_id', $this->mastermodel->get_single_field_value('lawyer', 'lawyer_id', 'user_id', $_SESSION['user_id']));
        }
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_task($postdata) {
        $data = array();
        $this->db->trans_begin();
        $master_id = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('task_code', 'task', 'task_code');

        $tblValues = array(
            'task_id' => $master_id,
            'task_code' => $code,
            'task_entered_id' => $postdata['task_entered_id'],
            'task_debtor_id' => $postdata['task_debtor_id'],
            'task_creditor_id' => $postdata['task_creditor_id'],
            'task_complaint_id' => $postdata['task_complaint_id'],
            'task_task_date' => $this->mastermodel->convert_date_format($postdata['task_task_date']),
            'task_title' => $postdata['task_title'],
            'task_priority_id' => $postdata['task_priority_id'],
            'task_due_date' => $this->mastermodel->convert_date_format($postdata['task_due_date']),
            'task_assigned_id' => $postdata['task_assigned_id'],
            'task_remind_before' => $this->mastermodel->convert_date_format($postdata['task_remind_before']),
            'task_status_id' => $postdata['task_status_id'],
            'task_description' => $postdata['task_description']
        );

        $this->db->insert('task', $tblValues);

        $i = 0;
        while (!empty($_FILES['task_file_file' . ++$i])) {
            $file = $this->mastermodel->upload_image('task_file_file' . $i);

            $tblValues = array(
                'task_file_id' => $this->mastermodel->insertmasterdata(),
                'task_file_task_id' => $master_id,
                'task_file_file' => $file['file_name']
            );
            $this->db->insert('task_file', $tblValues);
        }

        $i = 0;
        while (!empty($postdata['task_comments_date' . ++$i])) {
            $tblValues = array(
                'task_comments_id' => $this->mastermodel->insertmasterdata(),
                'task_comments_task_id' => $master_id,
                'task_comments_user_id' => $_SESSION['user_id'],
                'task_comments_date' => $this->mastermodel->convert_date_format($postdata['task_comments_date' . $i]),
                'task_comments_comments' => $postdata['task_comments_comments' . $i]
            );
            $this->db->insert('task_comments', $tblValues);
        }

        $i = 0;
        while (!empty($postdata['task_comments_date' . ++$i])) {
            $tblValues = array(
                'note_id' => $this->mastermodel->insertmasterdata(),
                'note_task_id' => $master_id,
                'note_user_id' => $_SESSION['user_id'],
                'note_time' => $this->mastermodel->convert_date_format($postdata['task_comments_date' . $i]),
                'note' => $postdata['task_comments_comments' . $i]
            );
            $this->db->insert('task_note', $tblValues);
        }

        $i = 0;
        while (!empty($postdata['task_reminder_subject' . ++$i])) {
            $file = $this->mastermodel->upload_image('task_file_file' . $i);

            $tblValues = array(
                'task_reminder_id' => $this->mastermodel->insertmasterdata(),
                'task_reminder_task_id' => $master_id,
                'task_reminder_subject' => $postdata['task_reminder_subject' . $i],
                'task_reminder_date' => $this->mastermodel->convert_date_format($postdata['task_reminder_date' . $i]),
                'task_reminder_descirption' => $postdata['task_reminder_descirption' . $i],
                'task_reminder_remind_before_date' => $this->mastermodel->convert_date_format($postdata['task_reminder_remind_before_date' . $i]),
            );
            $this->db->insert('task_reminder', $tblValues);
        }


        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_task($postdata) {
        $data = array();
        $this->db->trans_begin();

        $tblValues = array(
//            'task_debtor_id' => $postdata['task_debtor_id'],
//            'task_creditor_id' => $postdata['task_creditor_id'],
//            'task_complaint_id' => $postdata['task_complaint_id'],
//            'task_task_date' => $this->mastermodel->convert_date_format($postdata['task_task_date']),
            'task_title' => $postdata['task_title'],
            'task_priority_id' => $postdata['task_priority_id'],
            'task_due_date' => $this->mastermodel->convert_date_format($postdata['task_due_date']),
            'task_assigned_id' => $postdata['task_assigned_id'],
            'task_remind_before' => $this->mastermodel->convert_date_format($postdata['task_remind_before']),
            'task_status_id' => $postdata['task_status_id'],
            'task_description' => $postdata['task_description']
        );

        $this->db->where('task_id', $postdata['task_id']);
        $this->db->update('task', $tblValues);

        $this->db->where('task_file_task_id', $postdata['task_id']);
        $this->db->delete('task_file');

        $i = 0;
        while (!empty($_FILES['task_file_file' . ++$i]) || !empty($postdata['task_file_file_prev' . $i])) {
            $file = $this->mastermodel->upload_image('task_file_file' . $i);
            if (!empty($file['file_name'])) {
                $file = $file['file_name'];
            } else {
                $file = $postdata['task_file_file_prev' . $i];
            }
            $tblValues = array(
                'task_file_id' => $this->mastermodel->insertmasterdata(),
                'task_file_task_id' => $postdata['task_id'],
                'task_file_file' => $file
            );
            $this->db->insert('task_file', $tblValues);
        }

        $this->db->where('task_comments_task_id', $postdata['task_id']);
        $this->db->delete('task_comments');

        $i = 0;
        while (!empty($postdata['task_comments_date' . ++$i])) {
            $tblValues = array(
                'task_comments_id' => $this->mastermodel->insertmasterdata(),
                'task_comments_task_id' => $postdata['task_id'],
                'task_comments_user_id' => $_SESSION['user_id'],
                'task_comments_date' => $this->mastermodel->convert_date_format($postdata['task_comments_date' . $i]),
                'task_comments_comments' => $postdata['task_comments_comments' . $i]
            );
            $this->db->insert('task_comments', $tblValues);
        }

        $this->db->where('task_reminder_task_id', $postdata['task_id']);
        $this->db->delete('task_reminder');

        $i = 0;
        while (!empty($postdata['task_comments_date' . ++$i])) {
            $tblValues = array(
                'note_time' => $this->mastermodel->convert_date_format($postdata['task_comments_date' . $i]),
                'note' => $postdata['task_comments_comments' . $i]
            );
            $this->db->update('task_note', $tblValues);
        }
//        $this->db->where('note_task_id', $postdata['note_id']);
//        $this->db->delete('task_note');

        $i = 0;
        while (!empty($postdata['task_reminder_subject' . ++$i])) {
            $file = $this->mastermodel->upload_image('task_file_file' . $i);

            $tblValues = array(
                'task_reminder_id' => $this->mastermodel->insertmasterdata(),
                'task_reminder_task_id' => $postdata['task_id'],
                'task_reminder_subject' => $postdata['task_reminder_subject' . $i],
                'task_reminder_date' => $this->mastermodel->convert_date_format($postdata['task_reminder_date' . $i]),
                'task_reminder_descirption' => $postdata['task_reminder_descirption' . $i],
                'task_reminder_remind_before_date' => $this->mastermodel->convert_date_format($postdata['task_reminder_remind_before_date' . $i]),
            );
            $this->db->insert('task_reminder', $tblValues);
        }

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function search_crm_contact_creditor() {
        $data = array();
        $this->db->select('*');
        $this->db->from('contact');
        //$this->db->join('sub_document','sub_document.document_id=document.document_id');
        $this->db->where('contact.contact_id not in ', '(select contacts.contact_parent_id from contact contacts)', false);
        if ($_SESSION['administrator_privilage'] == 'no') {
            $this->db->where('contact_owner', $_SESSION['user_id']);
        }
        $this->db->where('contact_status', 'active');
        $this->db->where('crm_contact_type', '2');
        $this->db->join('master', 'master.master_id=contact.contact_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('contact_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    
    
     function search_crm_contact_creditor_report() {
        $data = array();
        $this->db->select('*');
        $this->db->from('contact');
        //$this->db->join('sub_document','sub_document.document_id=document.document_id');
       // $this->db->where('contact.contact_id not in ', '(select contacts.contact_parent_id from contact contacts)', false);
        // if ($_SESSION['administrator_privilage'] == 'no') {
        //     $this->db->where('contact_owner', $_SESSION['user_id']);
        // }
        $this->db->where('contact_status', 'active');
      //  $this->db->where('crm_contact_type', '2');
    //    $this->db->join('master', 'master.master_id=contact.contact_id');
       // $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('contact_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function search_crm_contact() {
        $data = array();
        $profile_settings = $this->mastermodel->get_profile_settings();
        $this->db->select('*');
        $this->db->from('contact');
        //$this->db->join('sub_document','sub_document.document_id=document.document_id');
        $this->db->where('contact.contact_id not in ', '(select contacts.contact_parent_id from contact contacts)', false);
//           if($_SESSION['administrator_privilage'] == 'no'){
//             $this->db->where('contact_owner', $_SESSION['user_id']);
//           }



        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('contact.user_id', $_SESSION['user_id']);
        }


        $this->db->where('contact_status', 'active');
        $this->db->join('master', 'master.master_id=contact.contact_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('contact_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function search_crm_debtor() {
     
        $profile_settings = $this->mastermodel->get_profile_settings();
        $user_id = $_SESSION['user_id'];
        $data = array();
        $this->db->select('*');
        $this->db->from('debtor');
        //$this->db->join('sub_document','sub_document.document_id=document.document_id');
//             $this->db->where('debitor.crm_debtor_id not in ','(select debitors.contact_parent_id from debitor debitors)',false);
//           if($_SESSION['administrator_privilage'] == 'no'){
//             $this->db->where('contact_owner', $_SESSION['user_id']);
//           }
//      $this->db->where('contact_status','active');
//       $this->db->where('crm_contact_type','1');
        $this->db->join('contact', 'contact.contact_id=debtor.debtor_contact_id', 'left');
        $this->db->join('master', 'master.master_id=debtor.crm_debtor_id');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('contact.user_id', $_SESSION['user_id']);
        }
        if (($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('debtor.crm_debtor_id not in ', '(select complaints.complaints_debtor_id from complaints where complaints_lawyer_id = ' . $user_id . ' )', false);
        }
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('crm_debtor_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_crm_contact($postdata) {
        $data = array();
        $this->db->trans_begin();
        $contact_id = $this->mastermodel->insertmasterdata();
        $contact_code = $this->mastermodel->get_ref('contact_code', 'contact', 'contact_code');
        $set = $this->accountingmodel->get_account_settings('customer');
        $ledger_id = $this->mastermodel->insertmasterdata();


        $profile_settings = $this->mastermodel->get_profile_settings();
        $role_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules', 'profile_id', $profile_settings->creditor_profile_id);
        $modules_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules_permission', 'profile_id', $profile_settings->creditor_profile_id);
        $username = trim($postdata['crm_contact_company_name']);

        $user_id = $this->mastermodel->insertmasterdata();

        $tblValues = array(
            'user_id' => $user_id,
            'user_name' => $username,
            'phone' => $postdata['crm_contact_mobile_1'],
            'email' => $postdata['crm_contact_email'],
            'password' => md5($postdata['crm_contact_company_name']),
            'profile_id' => $profile_settings->creditor_profile_id,
            'user_modules' => $role_permission,
            'modules_permission' => $modules_permission,
//            'home_page' => $postdata['role_home_page'],
            'manager_approve' => 0,
            'gm_approve' => 0,
            'contact_id' => $contact_id,
            'branch_id' => $_SESSION['master_branch']
        );
        $this->db->insert('user', $tblValues);


        $tblValues = array(
            'ledger_id' => $ledger_id,
            'account_group_id' => $set,
            'ledger_name' => $postdata['crm_contact_company_name'],
            'mailing_name' => $postdata['crm_contact_company_name'],
            'address' => $postdata['address'],
            'phone' => $postdata['crm_contact_mobile_1'],
            'mobile' => $postdata['crm_contact_mobile_1'],
            'email' => $postdata['crm_contact_email'],
            'is_party' => 1,
        );
        $output = $this->db->insert('account_ledger', $tblValues);
        $tblValues = array(
            'contact_id' => $contact_id,
            'contact_original_id' => $contact_id,
            'contact_status' => 'active',
            'contact_code' => $contact_code,
            'contact_owner' => $postdata['crm_contact_owner'],
            'contact_company_name' => $postdata['crm_contact_company_name'],
            'crm_cr_number' => $postdata['crm_cr_number'],
            'crm_po_box' => $postdata['crm_po_box'],
            'crm_establishment_date' => $this->mastermodel->convert_date_format($postdata['crm_establishment_date']),
            'crm_id_card_no' => $postdata['crm_id_card_no'],
            'contact_mobile_1' => $postdata['crm_contact_mobile_1'],
            'contact_mobile_2' => $postdata['crm_contact_mobile_2'],
            'contact_phone' => $postdata['crm_contact_phone'],
            'contact_fax' => $postdata['crm_contact_fax'],
            'contact_email' => $postdata['crm_contact_email'],
            'contact_skype_id' => $postdata['crm_contact_skype_id'],
            'contact_website' => $postdata['crm_contact_website'],
            'contact_official_location' => $postdata['address'],
            'contact_official_lat' => $postdata['latclicked'],
            'contact_official_long' => $postdata['longclicked'],
            'contact_description' => $postdata['crm_contact_description'],
            'ledger' => $ledger_id,
            'crm_contact_nationality' => $postdata['crm_contact_nationality'],
            'crm_contact_type' => $postdata['crm_contact_type'],
            'commission_per' => $postdata['commission_per'],
            'user_id' => $user_id,
        );
        $this->db->insert('contact', $tblValues);
        $k = 1;
        while (isset($postdata['crm_more_contact_name' . $k]) && !empty($postdata['crm_more_contact_name' . $k])) {
            $more_contact_id = $this->mastermodel->insertmasterdata();
            $tblValues_more_contact = array(
                'contact_sub_id' => $more_contact_id,
                'contact_sub_contact_id' => $contact_id,
                'contact_sub_name' => $postdata['crm_more_contact_name' . $k],
                'crm_more_contact_designation' => $postdata['crm_more_contact_designation' . $k],
                'crm_more_contact_idcardno' => $postdata['crm_more_contact_idcardno' . $k],
                'contact_sub_mobile' => $postdata['crm_more_contact_mobile' . $k],
                'contact_sub_phone' => $postdata['crm_more_contact_phone' . $k],
                'contact_sub_email' => $postdata['crm_more_contact_email' . $k],
            );
            $this->db->insert('contact_sub', $tblValues_more_contact);
            $k++;
        }
        $i = 1;
        while (isset($_FILES['crm_contact_file_file' . $i]) && !empty($_FILES['crm_contact_file_file' . $i])) {
            $contact_file_id = $this->mastermodel->insertmasterdata();
            $contact_file_values = array(
                'contact_file_id' => $contact_file_id,
                'contact_file_contact_id' => $contact_id,
            );
            $upload_data = $this->mastermodel->upload_image('crm_contact_file_file' . $i);
            if (!empty($upload_data['file_name'])) {
                $contact_file_values['contact_file_file'] = $upload_data['file_name'];
            }
            $this->db->insert('contact_file', $contact_file_values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add crm contact', $contact_id, 'contact');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_crm_contact($postdata) {
        $data = array();
        $this->db->trans_begin();
        //code for contact history 

        if (empty($postdata['user_id'])) {

            $profile_settings = $this->mastermodel->get_profile_settings();
            $role_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules', 'profile_id', $profile_settings->creditor_profile_id);
            $modules_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules_permission', 'profile_id', $profile_settings->creditor_profile_id);
            $username = trim($postdata['crm_contact_company_name']);

            $user_id = $this->mastermodel->insertmasterdata();

            $tblValues = array(
                'user_id' => $user_id,
                'user_name' => $username,
                'phone' => $postdata['crm_contact_mobile_1'],
                'email' => $postdata['crm_contact_email'],
                'password' => md5($postdata['crm_contact_company_name']),
                'profile_id' => $profile_settings->creditor_profile_id,
                'user_modules' => $role_permission,
                'modules_permission' => $modules_permission,
//            'home_page' => $postdata['role_home_page'],
                'manager_approve' => 0,
                'gm_approve' => 0,
                'contact_id' => $contact_id,
                'branch_id' => $_SESSION['master_branch']
            );
            $this->db->insert('user', $tblValues);
        } else {
            $user_id = $postdata['user_id'];
        }


        $contact_details = $this->mastermodel->get_data_srow('contact', $postdata['crm_contact_id'], 'contact_id');
        $contact_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'contact_id' => $contact_id,
            'contact_original_id' => $contact_details->contact_original_id,
            'contact_status' => 'history',
            'contact_code' => $contact_details->contact_code,
            'contact_owner' => $contact_details->contact_owner,
            'contact_company_name' => $contact_details->contact_company_name,
            'crm_cr_number' => $contact_details->crm_cr_number,
            'crm_po_box' => $contact_details->crm_po_box,
            'crm_establishment_date' => $contact_details->crm_establishment_date,
            'crm_id_card_no' => $contact_details->crm_id_card_no,
            'contact_address' => $contact_details->contact_address,
            'contact_mobile_1' => $contact_details->contact_mobile_1,
            'contact_mobile_2' => $contact_details->contact_mobile_2,
            'contact_phone' => $contact_details->contact_phone,
            'contact_fax' => $contact_details->contact_fax,
            'contact_email' => $contact_details->contact_email,
            'contact_skype_id' => $contact_details->contact_skype_id,
            'contact_website' => $contact_details->contact_website,
            'contact_official_location' => $contact_details->contact_official_location,
            'contact_official_lat' => $contact_details->contact_official_lat,
            'contact_official_long' => $contact_details->contact_official_long,
            'contact_description' => $contact_details->contact_description,
            'ledger' => $contact_details->ledger,
            'crm_contact_nationality' => $postdata['crm_contact_nationality'],
            'crm_contact_type' => $postdata['crm_contact_type'],
            'user_id' => $user_id,
            'commission_per' => $postdata['commission_per'],
        );
        $this->db->insert('contact', $tblValues);

        $contact_sub_details = $this->mastermodel->select_data_by_id('contact_sub', 'contact_sub_contact_id', $postdata['crm_contact_id']);
        foreach ($contact_sub_details as $contact_sub_details) {
            $more_contact_id = $this->mastermodel->insertmasterdata();
            $tblValues_more_contact = array(
                'contact_sub_id' => $more_contact_id,
                'contact_sub_contact_id' => $contact_id,
                'contact_sub_name' => $contact_sub_details->contact_sub_name,
                'crm_more_contact_designation' => $contact_sub_details->crm_more_contact_designation,
                'crm_more_contact_idcardno' => $contact_sub_details->crm_more_contact_idcardno,
                'contact_sub_mobile' => $contact_sub_details->contact_sub_mobile,
                'contact_sub_phone' => $contact_sub_details->contact_sub_phone,
                'contact_sub_email' => $contact_sub_details->contact_sub_email,
            );
            $this->db->insert('contact_sub', $tblValues_more_contact);
        }

        $contact_file_details = $this->mastermodel->select_data_by_id('contact_file', 'contact_file_contact_id', $postdata['crm_contact_id']);
        foreach ($contact_file_details as $contact_file_details) {
            $file_contact_id = $this->mastermodel->insertmasterdata();
            $tblValues_more_contact = array(
                'contact_file_id' => $file_contact_id,
                'contact_file_contact_id' => $contact_id,
                'contact_file_file' => $contact_file_details->contact_file_file,
                'contact_file_name' => $contact_file_details->contact_file_name,
            );
            $this->db->insert('contact_file', $tblValues_more_contact);
        }

        $contact_file_details = $this->mastermodel->select_data_by_id('contact_file', 'contact_file_contact_id', $postdata['crm_contact_id']);
        foreach ($contact_file_details as $contact_file_details) {
            $file_contact_id = $this->mastermodel->insertmasterdata();
            $tblValues_more_contact = array(
                'contact_file_id' => $file_contact_id,
                'contact_file_contact_id' => $contact_id,
                'contact_file_file' => $contact_file_details->contact_file_file,
                'contact_file_name' => $contact_file_details->contact_file_name,
            );
            $this->db->insert('contact_file', $tblValues_more_contact);
        }

        //code for updating contact
        $set = $this->accountingmodel->get_account_settings('customer');
        $tblValues = array(
            'account_group_id' => $set,
            'ledger_name' => $postdata['crm_contact_company_name'],
            'mailing_name' => $postdata['crm_contact_company_name'],
            'address' => $postdata['address'],
            'phone' => $postdata['crm_contact_phone'],
            'mobile' => $postdata['crm_contact_mobile_1'],
            'email' => $postdata['crm_contact_email'],
            'is_party' => 1,
        );
        $this->db->where('ledger_id', $postdata['ledger_id']);
        $output = $this->db->update('account_ledger', $tblValues);
        $tblValues = array(
            'contact_company_name' => $postdata['crm_contact_company_name'],
            'contact_address' => $postdata['crm_contact_address'],
            'contact_mobile_1' => $postdata['crm_contact_mobile_1'],
            'contact_mobile_2' => $postdata['crm_contact_mobile_2'],
            'contact_phone' => $postdata['crm_contact_phone'],
            'contact_fax' => $postdata['crm_contact_fax'],
            'contact_email' => $postdata['crm_contact_email'],
            'contact_skype_id' => $postdata['crm_contact_skype_id'],
            'contact_website' => $postdata['crm_contact_website'],
            'contact_official_location' => $postdata['address'],
            'contact_official_lat' => $postdata['latclicked'],
            'contact_official_long' => $postdata['longclicked'],
            'crm_cr_number' => $postdata['crm_cr_number'],
            'crm_po_box' => $postdata['crm_po_box'],
            'crm_establishment_date' => $this->mastermodel->convert_date_format($postdata['crm_establishment_date']),
            'crm_id_card_no' => $postdata['crm_id_card_no'],
            'contact_description' => $postdata['crm_contact_description'],
            'crm_contact_nationality' => $postdata['crm_contact_nationality'],
            'crm_contact_type' => $postdata['crm_contact_type'],
            'user_id' => $user_id,
            'commission_per' => $postdata['commission_per'],
        );
        $this->db->where('contact_id', $postdata['crm_contact_id']);
        $this->db->update('contact', $tblValues);

        $this->db->where('contact_sub_contact_id', $postdata['crm_contact_id']);
        $this->db->delete('contact_sub');

        $k = 1;
        while (isset($postdata['crm_more_contact_name' . $k]) && !empty($postdata['crm_more_contact_name' . $k])) {
            $more_contact_id = $this->mastermodel->insertmasterdata();
            $tblValues_more_contact = array(
                'contact_sub_id' => $more_contact_id,
                'contact_sub_contact_id' => $postdata['crm_contact_id'],
                'contact_sub_name' => $postdata['crm_more_contact_name' . $k],
                'contact_sub_mobile' => $postdata['crm_more_contact_mobile' . $k],
                'contact_sub_phone' => $postdata['crm_more_contact_phone' . $k],
                'contact_sub_email' => $postdata['crm_more_contact_email' . $k],
                'crm_more_contact_designation' => $postdata['crm_more_contact_designation' . $k],
                'crm_more_contact_idcardno' => $postdata['crm_more_contact_idcardno' . $k],
            );
            $this->db->insert('contact_sub', $tblValues_more_contact);
            $k++;
        }

        $this->db->where('contact_file_contact_id', $postdata['crm_contact_id']);
        $this->db->delete('contact_file');

        $i = 1;
        while (isset($_FILES['crm_contact_file_file' . $i])) {
            $contact_file_id = $this->mastermodel->insertmasterdata();
            $contact_file_values = array(
                'contact_file_id' => $contact_file_id,
                'contact_file_contact_id' => $postdata['crm_contact_id'],
//                'crm_task_photo_name' =>
            );
            $upload_data = $this->mastermodel->upload_image('crm_contact_file_file' . $i);
            if (!empty($upload_data['file_name'])) {
                $contact_file_values['contact_file_file'] = $upload_data['file_name'];
            }
            $this->db->insert('contact_file', $contact_file_values);
            $i++;
        }
        $i = 1;
        while (isset($postdata['crm_contact_file_file_prev' . $i]) && !empty($postdata['crm_contact_file_file_prev' . $i])) {
            $contact_file_id = $this->mastermodel->insertmasterdata();
            $contact_file_values = array(
                'contact_file_id' => $contact_file_id,
                'contact_file_contact_id' => $postdata['crm_contact_id'],
                'contact_file_file' => $postdata['crm_contact_file_file_prev' . $i]
//                'crm_task_photo_name' =>
            );
            $this->db->insert('contact_file', $contact_file_values);
            $i++;
        }


        $output = $this->mastermodel->save_user_activities('Update crm contact', $postdata['crm_contact_id'], 'contact');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    public function insert_debtor($postdata) {

        $data = array();
        $this->db->trans_begin();
        $crm_debtor_id = $this->mastermodel->insertmasterdata();
        $crm_debtor_code = $this->mastermodel->get_ref('crm_debtor_code', 'debtor', 'crm_debtor_code');
        $tblValues = array(
            'crm_debtor_owner' => $postdata['crm_debtor_owner'],
            'crm_debtor_salutation_id' => $postdata['crm_debtor_salutation_id'],
            'crm_debtor_first_name' => $postdata['crm_debtor_first_name'],
            'crm_debtor_middle_name' => $postdata['crm_debtor_middle_name'],
            'crm_debtor_last_name' => $postdata['crm_debtor_last_name'],
            'crm_debtor_gender' => $postdata['crm_debtor_gender'],
            'crm_debtor_company_name' => $postdata['crm_debtor_company_name'],
            'crm_debtor_dob' => $this->mastermodel->convert_date_format($postdata['crm_debtor_dob']),
            'crm_debtor_country' => $postdata['crm_debtor_country'],
            'crm_debtor_nationality' => $postdata['crm_debtor_nationality'],
            'crm_debtor_mobile_1' => $postdata['crm_debtor_mobile_1'],
            'crm_debtor_mobile_2' => $postdata['crm_debtor_mobile_2'],
            'crm_debtor_phone' => $postdata['crm_debtor_phone'],
            'crm_debtor_branch' => $postdata['crm_debtor_branch'],
            'crm_debtor_id_number' => $postdata['crm_debtor_id_number'],
            'crm_debtor_cr_number' => $postdata['crm_debtor_cr_number'],
            'crm_debtor_gid_number' => $postdata['crm_debtor_gid_number'],
            'crm_debtor_g2id_number' => $postdata['crm_debtor_g2id_number'],
            'crm_debtor_contract_year1' => $postdata['crm_debtor_contract_year1'],
            'crm_debtor_fax' => $postdata['crm_debtor_fax'],
            'crm_debtor_skype_id' => $postdata['crm_debtor_skype_id'],
            'crm_debtor_email' => $postdata['crm_debtor_email'],
            'crm_debtor_residential_address' => $postdata['crm_debtor_residential_address'],
            'crm_debtor_residential_street' => $postdata['crm_debtor_residential_street'],
            'crm_debtor_residential_city' => $postdata['crm_debtor_residential_city'],
            'crm_debtor_residential_state' => $postdata['crm_debtor_residential_state'],
            'crm_debtor_residential_zipcode' => $postdata['crm_debtor_residential_zipcode'],
            'crm_debtor_residential_country' => $postdata['crm_debtor_residential_country'],
            'crm_debtor_id' => $crm_debtor_id,
            'crm_debtor_code' => $crm_debtor_code,
            'debtor_contact_id' => $postdata['debtor_contact_id'],
            'crm_debtor_curr_empname' => $postdata['crm_debtor_curr_empname'],
            'crm_debtor_curr_empaddress' => $postdata['crm_debtor_curr_empaddress'],
            'crm_debtor_curr_empdesignation' => $postdata['crm_debtor_curr_empdesignation'],
            'crm_debtor_curr_empyear' => $postdata['crm_debtor_curr_empyear'],
            'crm_debtor_curr_empdetails' => $postdata['crm_debtor_curr_empdetails'],
            'crm_debtor_part_empname' => $postdata['crm_debtor_part_empname'],
            'crm_debtor_part_empaddress' => $postdata['crm_debtor_part_empaddress'],
            'crm_debtor_part_empdesignation' => $postdata['crm_debtor_part_empdesignation'],
            'crm_debtor_part_empdetails' => $postdata['crm_debtor_part_empdetails'],
            'crm_debtor_part_empyear' => $postdata['crm_debtor_part_empyear'],
            'debtor_selfincome_totalamount' => $postdata['debtor_selfincome_totalamount'],
            'debtor_partincome_totalamount' => $postdata['debtor_partincome_totalamount'],
            
           //  'debtor_partincome_totalamount' => $postdata['debtor_partincome_totalamount'],
        );
        $this->db->insert('debtor', $tblValues);
/////////////////////////////////////////////////////////////////////////////////////
        $crm_debtor_id = $this->mastermodel->insertmasterdata();

        /////////////////////////////////////////////////////////////

        $crm_debtor_id = $this->mastermodel->insertmasterdata();
    }

    public function insert_personal_details($postdata) {

        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'crm_debtor_owner' => $postdata['crm_debtor_owner'],
            'crm_debtor_salutation_id' => $postdata['crm_debtor_salutation_id'],
            'crm_debtor_first_name' => $postdata['crm_debtor_first_name'],
            'crm_debtor_middle_name' => $postdata['crm_debtor_middle_name'],
            'crm_debtor_last_name' => $postdata['crm_debtor_last_name'],
            'crm_debtor_gender' => $postdata['crm_debtor_gender'],
            'crm_debtor_company_name' => $postdata['crm_debtor_company_name'],
            'crm_debtor_dob' => $this->mastermodel->convert_date_format($postdata['crm_debtor_dob']),
            'crm_debtor_country' => $postdata['crm_debtor_country'],
            'crm_debtor_nationality' => $postdata['crm_debtor_nationality'],
            'crm_debtor_mobile_1' => $postdata['crm_debtor_mobile_1'],
            'crm_debtor_mobile_2' => $postdata['crm_debtor_mobile_2'],
            'crm_debtor_phone' => $postdata['crm_debtor_phone'],
            'crm_debtor_branch' => $postdata['crm_debtor_branch'],
            'crm_debtor_id_number' => $postdata['crm_debtor_id_number'],
            'crm_debtor_cr_number' => $postdata['crm_debtor_cr_number'],
            'crm_debtor_gid_number' => $postdata['crm_debtor_gid_number'],
            'crm_debtor_g2id_number' => $postdata['crm_debtor_g2id_number'],
            'crm_debtor_contract_year1' => $postdata['crm_debtor_contract_year1'],
            'crm_debtor_fax' => $postdata['crm_debtor_fax'],
            'crm_debtor_skype_id' => $postdata['crm_debtor_skype_id'],
            'crm_debtor_email' => $postdata['crm_debtor_email'],
            'crm_debtor_residential_address' => $postdata['crm_debtor_residential_address'],
            'crm_debtor_residential_street' => $postdata['crm_debtor_residential_street'],
            'crm_debtor_residential_city' => $postdata['crm_debtor_residential_city'],
            'crm_debtor_residential_state' => $postdata['crm_debtor_residential_state'],
            'crm_debtor_residential_zipcode' => $postdata['crm_debtor_residential_zipcode'],
            'crm_debtor_residential_country' => $postdata['crm_debtor_residential_country'],
        );


        $upload_data = $this->mastermodel->upload_images('crm_debtor_photo');
        if (!empty($upload_data['file_name'])) {
            $tblValues['crm_debtor_photo'] = $upload_data['file_name'];
        }
        if (empty($postdata['debtor_id'])) {
            $crm_debtor_id = $this->mastermodel->insertmasterdata();
            $crm_debtor_code = $this->mastermodel->get_ref('crm_debtor_code', 'debtor', 'crm_debtor_code');
            $tblValues['crm_debtor_id'] = $crm_debtor_id;
            $tblValues['crm_debtor_code'] = $crm_debtor_code;
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $this->db->insert('debtor', $tblValues);
            $id = $crm_debtor_id;
        } else {
            if (empty($postdata['crm_debtor_code'])) {
                $crm_debtor_code = $this->mastermodel->get_ref('crm_debtor_code', 'debtor', 'crm_debtor_code');
                $tblValues['crm_debtor_code'] = $crm_debtor_code;
                $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            }
            $this->db->where('crm_debtor_id', $postdata['debtor_id']);
            $output = $this->db->update('debtor', $tblValues);
            $id = $postdata['debtor_id'];
        }


// $output = $this->mastermodel->save_user_activities('Add crm debtor personal details',$id, 'debtor');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            $data['id'] = $id;
            return $data;
        }
    }

    public function insert_employment($postdata) {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'crm_debtor_curr_empname' => $postdata['crm_debtor_curr_empname'],
            'crm_debtor_curr_empaddress' => $postdata['crm_debtor_curr_empaddress'],
            'crm_debtor_curr_empdesignation' => $postdata['crm_debtor_curr_empdesignation'],
            'crm_debtor_curr_empyear' => $postdata['crm_debtor_curr_empyear'],
            'crm_debtor_curr_empdetails' => $postdata['crm_debtor_curr_empdetails'],
            'crm_debtor_part_empname' => $postdata['crm_debtor_part_empname'],
            'crm_debtor_part_empaddress' => $postdata['crm_debtor_part_empaddress'],
            'crm_debtor_part_empdesignation' => $postdata['crm_debtor_part_empdesignation'],
            'crm_debtor_part_empdetails' => $postdata['crm_debtor_part_empdetails'],
            'crm_debtor_part_empyear' => $postdata['crm_debtor_part_empyear'],
        );



        if (empty($postdata['debtor_id'])) {
            $crm_debtor_id = $this->mastermodel->insertmasterdata();
            $tblValues['crm_debtor_id'] = $crm_debtor_id;
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $this->db->insert('debtor', $tblValues);
            $id = $crm_debtor_id;
        } else {
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $this->db->where('crm_debtor_id', $postdata['debtor_id']);
            $output = $this->db->update('debtor', $tblValues);
            $id = $postdata['debtor_id'];
        }


// $output = $this->mastermodel->save_user_activities('Add crm debtor personal details',$id, 'debtor');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            $data['id'] = $id;
            return $data;
        }
    }

    public function insert_debtor_income($postdata) {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'debtor_selfincome_totalamount' => $postdata['debtor_selfincome_totalamount'],
            'debtor_partincome_totalamount' => $postdata['debtor_partincome_totalamount'],
        );



        if (empty($postdata['debtor_id'])) {
            $crm_debtor_id = $this->mastermodel->insertmasterdata();
            $tblValues['crm_debtor_id'] = $crm_debtor_id;
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $this->db->insert('debtor', $tblValues);
            $id = $crm_debtor_id;
        } else {
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $this->db->where('crm_debtor_id', $postdata['debtor_id']);
            $output = $this->db->update('debtor', $tblValues);
            $id = $postdata['debtor_id'];
        }

        $this->db->where('debtor_id', $id);
        $this->db->delete('debtor_selfincome');

        $this->db->where('debtor_id', $id);
        $this->db->delete('debtor_partincome');
        $i = 1;
        while (isset($postdata['debtor_selfincome_amount' . $i]) && !empty($postdata['debtor_selfincome_amount' . $i])) {
            $debtor_selfincome_id = $this->mastermodel->insertmasterdata();
            $debtor_selfincome = array(
                'debtor_selfincome_id' => $debtor_selfincome_id,
                'debtor_id' => $id,
                'debtor_selfincome_desc' => $postdata['debtor_selfincome_desc' . $i],
                'debtor_selfincome_amount' => $postdata['debtor_selfincome_amount' . $i],
            );
            $this->db->insert('debtor_selfincome', $debtor_selfincome);
            $i++;
        }

        $i = 1;
        while (isset($postdata['debtor_partincome_amount' . $i]) && !empty($postdata['debtor_partincome_amount' . $i])) {
            $debtor_partincome_id = $this->mastermodel->insertmasterdata();
            $debtor_selfincome = array(
                'debtor_partincome_id' => $debtor_partincome_id,
                'debtor_id' => $id,
                'debtor_partincome_desc' => $postdata['debtor_partincome_desc' . $i],
                'debtor_partincome_amount' => $postdata['debtor_partincome_amount' . $i],
            );
            $this->db->insert('debtor_partincome', $debtor_selfincome);
            $i++;
        }
// $output = $this->mastermodel->save_user_activities('Add crm debtor personal details',$id, 'debtor');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            $data['id'] = $id;
            return $data;
        }
    }

    public function insert_debtor_expenditure($postdata) {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'debtor_recexp_totalamount' => $postdata['debtor_recexp_totalamount'],
            'debtor_loans_totalamount' => $postdata['debtor_loans_totalamount'],
            'debtor_insurance_totalamount' => $postdata['debtor_insurance_totalamount'],
            'debtor_otherexp_totalamount' => $postdata['debtor_otherexp_totalamount'],
        );



        if (empty($postdata['debtor_id'])) {
            $crm_debtor_id = $this->mastermodel->insertmasterdata();
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $tblValues['crm_debtor_id'] = $crm_debtor_id;

            $this->db->insert('debtor', $tblValues);
            $id = $crm_debtor_id;
        } else {
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $this->db->where('crm_debtor_id', $postdata['debtor_id']);
            $output = $this->db->update('debtor', $tblValues);
            $id = $postdata['debtor_id'];
        }

        $this->db->where('debtor_id', $id);
        $this->db->delete('debtor_recexp');

        $this->db->where('debtor_id', $id);
        $this->db->delete('debtor_loans');

        $this->db->where('debtor_id', $id);
        $this->db->delete('debtor_insurance');

        $this->db->where('debtor_id', $id);
        $this->db->delete('debtor_otherexp');
        $i = 1;
        while (isset($postdata['debtor_recexp_amount' . $i]) && !empty($postdata['debtor_recexp_amount' . $i])) {
            $debtor_recexp_id = $this->mastermodel->insertmasterdata();
            $debtor_selfincome = array(
                'debtor_recexp_id' => $debtor_recexp_id,
                'debtor_id' => $id,
                'debtor_recexp_desc' => $postdata['debtor_recexp_desc' . $i],
                'debtor_recexp_amount' => $postdata['debtor_recexp_amount' . $i],
            );
            $this->db->insert('debtor_recexp', $debtor_selfincome);
            $i++;
        }

        $i = 1;
        while (isset($postdata['debtor_loans_amount' . $i]) && !empty($postdata['debtor_loans_amount' . $i])) {
            $debtor_loans_id = $this->mastermodel->insertmasterdata();
            $debtor_loans = array(
                'debtor_loans_id' => $debtor_loans_id,
                'debtor_id' => $id,
                'debtor_loans_desc' => $postdata['debtor_loans_desc' . $i],
                'debtor_loans_amount' => $postdata['debtor_loans_amount' . $i],
            );
            $this->db->insert('debtor_loans', $debtor_loans);
            $i++;
        }

        $i = 1;
        while (isset($postdata['debtor_insurance_amount' . $i]) && !empty($postdata['debtor_insurance_amount' . $i])) {
            $debtor_insurance_id = $this->mastermodel->insertmasterdata();
            $debtor_insurance = array(
                'debtor_insurance_id' => $debtor_insurance_id,
                'debtor_id' => $id,
                'debtor_insurance_desc' => $postdata['debtor_insurance_desc' . $i],
                'debtor_insurance_amount' => $postdata['debtor_insurance_amount' . $i],
            );
            $this->db->insert('debtor_insurance', $debtor_insurance);
            $i++;
        }

        $i = 1;
        while (isset($postdata['debtor_otherexp_amount' . $i]) && !empty($postdata['debtor_otherexp_amount' . $i])) {
            $debtor_otherexp_id = $this->mastermodel->insertmasterdata();
            $debtor_otherexp = array(
                'debtor_otherexp_id' => $debtor_otherexp_id,
                'debtor_id' => $id,
                'debtor_otherexp_desc' => $postdata['debtor_otherexp_desc' . $i],
                'debtor_otherexp_amount' => $postdata['debtor_otherexp_amount' . $i],
            );
            $this->db->insert('debtor_otherexp', $debtor_otherexp);
            $i++;
        }
// $output = $this->mastermodel->save_user_activities('Add crm debtor personal details',$id, 'debtor');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            $data['id'] = $id;
            return $data;
        }
    }

    public function insert_debtor_assets($postdata) {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'crm_debtor_home_owner' => $postdata['crm_debtor_home_owner'],
            'crm_debtor_home_detailes' => $postdata['crm_debtor_home_detailes'],
            'crm_debtor_home_value' => $postdata['crm_debtor_home_value'],
            'crm_debtor_home_loan' => $postdata['crm_debtor_home_loan'],
            'crm_debtor_home_othdetails' => $postdata['crm_debtor_home_othdetails'],
        );



        if (empty($postdata['debtor_id'])) {
            $crm_debtor_id = $this->mastermodel->insertmasterdata();
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $tblValues['crm_debtor_id'] = $crm_debtor_id;

            $this->db->insert('debtor', $tblValues);
            $id = $crm_debtor_id;
        } else {
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $this->db->where('crm_debtor_id', $postdata['debtor_id']);
            $output = $this->db->update('debtor', $tblValues);
            $id = $postdata['debtor_id'];
        }

        $this->db->where('debtor_id', $id);
        $this->db->delete('debtor_property_details');

        $i = 1;
        while (isset($postdata['debtor_property_type' . $i]) && !empty($postdata['debtor_property_type' . $i])) {
            $property_details_id = $this->mastermodel->insertmasterdata();
            $debtor_selfincome = array(
                'property_details_id' => $property_details_id,
                'debtor_id' => $id,
                'debtor_property_type' => $postdata['debtor_property_type' . $i],
                'property_details_desc' => $postdata['debtor_property_details' . $i],
                'debtor_ownership_type' => $postdata['debtor_property_ownership' . $i],
                'property_details_value' => $postdata['debtor_property_value' . $i],
                'property_details_loanval' => $postdata['debtor_property_loanvalue' . $i],
            );
            $this->db->insert('debtor_property_details', $debtor_selfincome);
            $i++;
        }

// $output = $this->mastermodel->save_user_activities('Add crm debtor personal details',$id, 'debtor');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            $data['id'] = $id;
            return $data;
        }
    }

    public function insert_debtor_associated_creditors($postdata) {
        $data = array();
        $this->db->trans_begin();




        if (empty($postdata['debtor_id'])) {
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $crm_debtor_id = $this->mastermodel->insertmasterdata();
            $tblValues['crm_debtor_id'] = $crm_debtor_id;

            $this->db->insert('debtor', $tblValues);
            $id = $crm_debtor_id;
        } else {
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
//               $this->db->where('crm_debtor_id', $postdata['debtor_id']);
//        $output = $this->db->update('debtor', $tblValues);
            $id = $postdata['debtor_id'];
        }

        $this->db->where('debtor_id', $id);
        $this->db->delete('debtor_associated_credit');

        $i = 1;
        while (isset($postdata['associated_credit_name' . $i]) && !empty($postdata['associated_credit_name' . $i])) {
            $associated_credit_id = $this->mastermodel->insertmasterdata();
            $associated_credit = array(
                'associated_credit_id' => $associated_credit_id,
                'debtor_id' => $id,
                'associated_credit_name' => $postdata['associated_credit_name' . $i],
                'associated_credit_type' => $postdata['associated_credit_type' . $i],
                'associated_credit_accref' => $postdata['associated_credit_accref' . $i],
                'associatedcre_credit_amnt' => $postdata['associatedcre_credit_amnt' . $i],
                'associated_credit_balamnt' => $postdata['associated_credit_balamnt' . $i],
                'associated_credit_status' => $postdata['associated_credit_status' . $i],
                'associated_credit_remarks' => $postdata['associated_credit_remarks' . $i],
            );
            $this->db->insert('debtor_associated_credit', $associated_credit);
            $i++;
        }

// $output = $this->mastermodel->save_user_activities('Add crm debtor personal details',$id, 'debtor');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            $data['id'] = $id;
            return $data;
        }
    }

    public function insert_debtor_notes($postdata) {
        $data = array();
        $this->db->trans_begin();




        if (empty($postdata['debtor_id'])) {
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $crm_debtor_id = $this->mastermodel->insertmasterdata();
            $tblValues['crm_debtor_id'] = $crm_debtor_id;

            $this->db->insert('debtor', $tblValues);
            $id = $crm_debtor_id;
        } else {
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
//               $this->db->where('crm_debtor_id', $postdata['debtor_id']);
//        $output = $this->db->update('debtor', $tblValues);
            $id = $postdata['debtor_id'];
        }

        $this->db->where('debtor_id', $id);
        $this->db->delete('debtor_notes');

        $i = 1;
        while (isset($postdata['debtor_notes_title' . $i]) && !empty($postdata['debtor_notes_title' . $i])) {
            $debtor_notes_id = $this->mastermodel->insertmasterdata();
            $debtor_notes = array(
                'debtor_notes_id' => $debtor_notes_id,
                'debtor_id' => $id,
                'debtor_notes_title' => $postdata['debtor_notes_title' . $i],
                'debtor_notes_date' => $this->mastermodel->convert_date_format($postdata['debtor_notes_date' . $i]),
                'debtor_notes_ref' => $postdata['debtor_notes_ref' . $i],
                'debtor_notes_desc' => $postdata['debtor_notes_desc' . $i],
            );
            $upload_data = $this->mastermodel->upload_image('debtor_notes_attachment' . $i);
            if (!empty($upload_data['file_name'])) {
                $debtor_notes['debtor_notes_attachment'] = $upload_data['file_name'];
            } else {
                if (!empty($postdata['debtor_notes_attachment_old' . $i])) {
                    $debtor_notes['debtor_notes_attachment'] = $postdata['debtor_notes_attachment_old' . $i];
                }
            }
            $this->db->insert('debtor_notes', $debtor_notes);
            $i++;
        }

// $output = $this->mastermodel->save_user_activities('Add crm debtor personal details',$id, 'debtor');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            $data['id'] = $id;
            return $data;
        }
    }

    public function insert_debtor_documents($postdata) {
        $data = array();
        $this->db->trans_begin();




        if (empty($postdata['debtor_id'])) {
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $crm_debtor_id = $this->mastermodel->insertmasterdata();
            $tblValues['crm_debtor_id'] = $crm_debtor_id;

            $this->db->insert('debtor', $tblValues);
            $id = $crm_debtor_id;
        } else {
//               $this->db->where('crm_debtor_id', $postdata['debtor_id']);
//        $output = $this->db->update('debtor', $tblValues);
            $id = $postdata['debtor_id'];
        }

        $this->db->where('debtor_id', $id);
        $this->db->delete('debtor_doc');

        $i = 1;
        while (isset($postdata['debtor_doc_title' . $i]) && !empty($postdata['debtor_doc_title' . $i])) {
            $debtor_doc_id = $this->mastermodel->insertmasterdata();
            $debtor_notes = array(
                'debtor_doc_id' => $debtor_doc_id,
                'debtor_id' => $id,
                'debtor_doc_title' => $postdata['debtor_doc_title' . $i],
                'debtor_doc_date' => $this->mastermodel->convert_date_format($postdata['debtor_doc_date' . $i]),
                'debtor_doc_desc' => $postdata['debtor_doc_desc' . $i],
            );
            $upload_data = $this->mastermodel->upload_image('debtor_doc_attachment' . $i);
            if (!empty($upload_data['file_name'])) {
                $debtor_notes['debtor_doc_attachment'] = $upload_data['file_name'];
            } else {
                if (!empty($postdata['debtor_doc_attachment_old' . $i])) {
                    $debtor_notes['debtor_doc_attachment'] = $postdata['debtor_doc_attachment_old' . $i];
                }
            }
            $this->db->insert('debtor_doc', $debtor_notes);
            $i++;
        }

// $output = $this->mastermodel->save_user_activities('Add crm debtor personal details',$id, 'debtor');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            $data['id'] = $id;
            return $data;
        }
    }

    public function insert_debtor_other_contact($postdata) {
        $data = array();
        $this->db->trans_begin();




        if (empty($postdata['debtor_id'])) {
            $tblValues['debtor_contact_id'] = $postdata['debtor_contact_id'];
            $crm_debtor_id = $this->mastermodel->insertmasterdata();
            $tblValues['crm_debtor_id'] = $crm_debtor_id;

            $this->db->insert('debtor', $tblValues);
            $id = $crm_debtor_id;
        } else {
//               $this->db->where('crm_debtor_id', $postdata['debtor_id']);
//        $output = $this->db->update('debtor', $tblValues);
            $id = $postdata['debtor_id'];
        }

        $this->db->where('debtor_id', $id);
        $this->db->delete('debtor_other_contact');

        $i = 1;
        while (isset($postdata['other_contact_name' . $i]) && !empty($postdata['other_contact_name' . $i])) {
            $other_contact_id = $this->mastermodel->insertmasterdata();
            $other_contact = array(
                'other_contact_id' => $other_contact_id,
                'debtor_id' => $id,
                'other_contact_name' => $postdata['other_contact_name' . $i],
                'other_contact_mobile' => $postdata['other_contact_mobile' . $i],
                'other_contact_phone' => $postdata['other_contact_phone' . $i],
                'other_contact_email' => $postdata['other_contact_email' . $i],
            );

            $this->db->insert('debtor_other_contact', $other_contact);
            $i++;
        }

// $output = $this->mastermodel->save_user_activities('Add crm debtor personal details',$id, 'debtor');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            $data['id'] = $id;
            return $data;
        }
    }

    function get_document($postdata) {
        $data = array();
        $this->db->select('*');
        $this->db->from('document');
        $this->db->join('sub_document', 'sub_document.sub_document_document_id=document.document_id');
        $this->db->where('sub_document_crm_category_id', $postdata['crm_lead_category']);
        $this->db->where('sub_document_crm_lead_type_id', $postdata['crm_lead_type']);
        $this->db->order_by('document_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function search_task_details() {

        $emplo = $_SESSION['employee_id'];
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_task_details');
        $this->db->where('crm_task_details.crm_completed_status', 0);
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('crm_task_details_status', 'active');


        if ($_SESSION['administrator_privilage'] == 'no') {
            $query = "(";
            $query .= " `crm_task_details_owner` = " . $_SESSION['user_id'];
            $query .= " OR FIND_IN_SET('" . $emplo . "',crm_task_details_assigned_to_id) != 0";


//        $this->db->where('crm_task_details_owner', $_SESSION['user_id']);
//        $this->db->or_where("FIND_IN_SET('$emplo',crm_task_details_assigned_to_id) !=", 0);
            $query .= ")";
            $this->db->where($query);
        }

        $this->db->join('master', 'master.master_id=crm_task_details.crm_task_details_id');

        $this->db->order_by('crm_task_details_id', 'desc');
        $data['results'] = $this->db->get();

        return $data;
    }

    function search_task_details_completed() {

        $emplo = $_SESSION['employee_id'];
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_task_details');
        $this->db->where('crm_task_details.crm_completed_status', 1);
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('crm_task_details_status', 'active');


        if ($_SESSION['administrator_privilage'] == 'no') {
            $query = "(";
            $query .= " `crm_task_details_owner` = " . $_SESSION['user_id'];
            $query .= " OR FIND_IN_SET('" . $emplo . "',crm_task_details_assigned_to_id) != 0";


//        $this->db->where('crm_task_details_owner', $_SESSION['user_id']);
//        $this->db->or_where("FIND_IN_SET('$emplo',crm_task_details_assigned_to_id) !=", 0);
            $query .= ")";
            $this->db->where($query);
        }

        $this->db->join('master', 'master.master_id=crm_task_details.crm_task_details_id');

        $this->db->order_by('crm_task_details_id', 'desc');
        $data['results'] = $this->db->get();

        return $data;
    }

    public function insert_task_details($postdata) {

        $data = array();
        $this->db->trans_begin();
        $crm_task_details_id = $this->mastermodel->insertmasterdata();
        $crm_task_details_code = $this->mastermodel->get_ref('crm_task_details_code', 'crm_task_details', 'crm_task_details_code');

        $crm_task_details_assigned_to_id = '';
        foreach ($postdata['crm_task_details_assigned_to_id'] as $item) {
            $email['message'] = '<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- [if !mso]> <!-->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- <![endif] -->
    <meta name="format-detection" content="telephone=no">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>MAIL TEMPLATE</title>
<style>
table{
	width: 100%;
	max-width: 600px;
	border: 1px solid #848f99;
	border-radius: 6px;
	text-align: center;
	vertical-align: middle;
	margin-left: auto;
	margin-right: auto;
}
th{
	padding: 4% 11%;
}
.odd {
	text-align: left;
	color: #9ca6af;
	width: 30%;
	padding: 2% 11%;
}
.even {
	text-align: left;
	width: 80%;
	padding: 2% 0%;
}
#header
{
    color: #008ce3;
    max-width: 600px;
    font-size: 26px;
    margin-left: auto;
    margin-right: auto;
}
</style>
</head>
	<body align="center">
                <div style="color: #008ce3;max-width: 600px;font-size: 26px;margin-left: auto;margin-right: auto;">
                    ' . $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_name', 'hr_employees_id', $item) . ', You got a new task "' . $postdata["crm_task_details_title"] . '".<br>Details as follows...
		</div>
		<table>
		  <tr>
	  	    <th colspan="2" style="color: #9ca6af;text-align: left;font-size: 30px;"><u>Task Details</u</th>
		  </tr>
		  <tr>
		    <td class="odd">Code: </td>
		    <td class="even">' . $crm_task_details_code . '</td>
		  </tr>
		  <tr>
		    <td class="odd">Date: </td>
		    <td class="even">' . $postdata["crm_task_details_date"] . '</td>
		  </tr>
		  <tr>
		    <td class="odd">Title: </td>
		    <td class="even">' . $postdata["crm_task_details_title"] . '</td>
		  </tr>
		  <tr>
		    <td class="odd">Subject: </td>
		    <td class="even">' . $this->mastermodel->get_single_field_value("crm_task_subject", "crm_task_subject_name", "crm_task_subject_id", $postdata["crm_task_details_subject_id"]) . '</td>
		  </tr>
		  <!--<tr>
		    <td class="odd">Status: </td>
		    <td class="even">' . $this->mastermodel->get_single_field_value("crm_task_status", "crm_task_status_name", "crm_task_status_id", $postdata["crm_task_details_status_id"]) . '</td>
		  </tr>-->
                   <tr>
		    <td class="odd">Task Owner : </td>
		    <td class="even">' . $this->mastermodel->get_single_field_value("user", "user_name", "user_id", $postdata["crm_task_details_owner"]) . '</td>
		  </tr>
		  <tr>
		    <td class="odd">Due Date: </td>
		    <td class="even">' . $postdata["crm_task_details_due_date"] . '</td>
		  </tr>
		  <tr>
		    <td class="odd">Priority: </td>
		    <td class="even">' . $this->mastermodel->get_single_field_value("crm_priority", "crm_priority_name", "crm_priority_id", $postdata["crm_task_details_priority_id"]) . '</td>
		  </tr>
		  <tr>
		    <td class="odd">Description: </td>
		    <td class="even">' . $postdata["crm_task_details_description"] . '</td>
		  </tr>
		</table>
                <a href="' . site_url() . '">View Task in ERP</a>
    	</body>
</html>
  
  
</body>
</html>';
            $email['to'] = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_email', 'hr_employees_id', $item);
            $cc = $this->mastermodel->get_single_field_value('company', 'cc_other', 'project_id', $_SESSION['project_id']);
            $email['cc'] = $cc;
            $email['subject'] = 'Assigned A New Task';
            $this->send_email_task($email);
            $crm_task_details_assigned_to_id .= $item . ',';
        }
        $tblValues = array(
            'crm_task_details_id' => $crm_task_details_id,
            'crm_task_details_code' => $crm_task_details_code,
            'crm_task_details_original_id' => $crm_task_details_id,
            'crm_task_details_status' => 'active',
            'crm_task_details_date' => $this->mastermodel->convert_date_format($postdata['crm_task_details_date']),
            'crm_task_details_owner' => $postdata['crm_task_details_owner'],
            'crm_task_details_title' => $postdata['crm_task_details_title'],
            'crm_task_details_subject_id' => $postdata['crm_task_details_subject_id'],
            'crm_task_details_due_date' => $this->mastermodel->convertdatetimenormalformat($postdata['crm_task_details_due_date']),
            'crm_task_details_reminder_date' => $this->mastermodel->convertdatetimenormalformat($postdata['crm_task_details_reminder_date']),
            'crm_task_details_status_id' => $postdata['crm_task_details_status_id'],
            'crm_task_details_priority_id' => $postdata['crm_task_details_priority_id'],
            'crm_task_details_assigned_to_id' => $crm_task_details_assigned_to_id,
            'crm_task_details_description' => $postdata['crm_task_details_description'],
            'crm_task_details_lead_id' => $postdata['crm_task_details_lead_id'],
            'crm_task_details_deal_id' => $postdata['crm_task_details_deal_id'],
            'crm_task_details_contact_id' => $postdata['crm_task_details_contact_id'],
        );
        $this->db->insert('crm_task_details', $tblValues);
        $i = 1;
        while (isset($_FILES['crm_task_photo_photo' . $i]) && !empty($_FILES['crm_task_photo_photo' . $i])) {
            $crm_task_photo_id = $this->mastermodel->insertmasterdata();
            $task_photo_values = array(
                'crm_task_photo_id' => $crm_task_photo_id,
                'crm_task_photo_task_id' => $crm_task_details_id,
            );
            $upload_data = $this->mastermodel->upload_image('crm_task_photo_photo' . $i);
            if (!empty($upload_data['file_name'])) {
                $task_photo_values['crm_task_photo_photo'] = $upload_data['file_name'];
            }
            $this->db->insert('crm_task_photo', $task_photo_values);
            $i++;
        }

        $i = 1;
        while (isset($postdata['task_comment_name' . $i]) && !empty($postdata['task_comment_name' . $i])) {
            $comments_id = $this->mastermodel->insertmasterdata();
            $task_comments = array(
                'comments_id' => $comments_id,
                'task_details_id' => $crm_task_details_id,
                'task_comment_name' => $postdata['task_comment_name' . $i],
                'task_comment_date' => $this->mastermodel->convertdatetimenormalformat($postdata['task_comment_date' . $i])
            );
            $this->db->insert('crm_task_comments', $task_comments);
            $i++;
        }

        $i = 1;
        while (isset($postdata['crm_task_reminder_subject' . $i]) && !empty($postdata['crm_task_reminder_subject' . $i])) {
            $crm_task_reminder_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_task_reminder_id' => $crm_task_reminder_id,
                'crm_task_reminder_task_details_id' => $crm_task_details_id,
                'crm_task_reminder_subject' => $postdata['crm_task_reminder_subject' . $i],
                'crm_task_reminder_date' => $this->mastermodel->convertdatetimenormalformat($postdata['crm_task_reminder_date' . $i]),
                'crm_task_reminder_description' => $postdata['crm_task_reminder_description' . $i],
                'crm_task_reminder_before' => $this->mastermodel->convertdatetimenormalformat($postdata['crm_task_reminder_before' . $i]),
            );
            $output = $this->db->insert('crm_task_reminder', $tblValues_sub_document);
            $i++;
        }

        for ($j = 0; $j < count($postdata['crm_task_legal_deal_legal_id']); $j++) {
            $task_legal_id = $this->mastermodel->insertmasterdata();
            $tblValues_crm_task_legal = array(
                'crm_task_legal_id' => $task_legal_id,
                'crm_task_legal_task_details_id' => $crm_task_details_id,
                'crm_task_legal_deal_legal_id' => $postdata['crm_task_legal_deal_legal_id'][$j],
            );
            $this->db->insert('crm_task_legal', $tblValues_crm_task_legal);
        }
        $output = $this->mastermodel->save_user_activities('Add crm task', $crm_task_details_id, 'crm_task_details');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_task_details($postdata) {
        $data = array();
        $this->db->trans_begin();
        //code for task history  
        $task_details = $this->mastermodel->get_data_srow('crm_task_details', $postdata['crm_task_details_id'], 'crm_task_details_id');
        $crm_task_details_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'crm_task_details_id' => $crm_task_details_id,
            'crm_task_details_code' => $task_details->crm_task_details_code,
            'crm_task_details_original_id' => $task_details->crm_task_details_original_id,
            'crm_task_details_status' => 'history',
            'crm_task_details_date' => $task_details->crm_task_details_date,
            'crm_task_details_owner' => $task_details->crm_task_details_owner,
            'crm_task_details_title' => $task_details->crm_task_details_title,
            'crm_task_details_subject_id' => $task_details->crm_task_details_subject_id,
            'crm_task_details_due_date' => $task_details->crm_task_details_due_date,
            'crm_task_details_reminder_date' => $task_details->crm_task_details_reminder_date,
            'crm_task_details_status_id' => $task_details->crm_task_details_status_id,
            'crm_task_details_priority_id' => $task_details->crm_task_details_priority_id,
            'crm_task_details_assigned_to_id' => $task_details->crm_task_details_assigned_to_id,
            'crm_task_details_description' => $task_details->crm_task_details_description,
            'crm_task_details_lead_id' => $task_details->crm_task_details_lead_id,
            'crm_task_details_deal_id' => $task_details->crm_task_details_deal_id,
            'crm_task_details_contact_id' => $task_details->crm_task_details_contact_id,
        );
        $this->db->insert('crm_task_details', $tblValues);

        $task_photo_details = $this->mastermodel->select_data_by_id('crm_task_photo', 'crm_task_photo_task_id', $postdata['crm_task_details_id']);
        foreach ($task_photo_details as $task_photo_details) {
            $task_photo_id = $this->mastermodel->insertmasterdata();
            $task_photo_values = array(
                'crm_task_photo_id' => $task_photo_id,
                'crm_task_photo_task_id' => $crm_task_details_id,
                'crm_task_photo_photo' => $task_photo_details->crm_task_photo_photo,
                'crm_task_photo_name' => $task_photo_details->crm_task_photo_name,
            );
            $this->db->insert('crm_task_photo', $task_photo_values);
        }

        $task_remainder_details = $this->mastermodel->select_data_by_id('crm_task_reminder', 'crm_task_reminder_task_details_id', $postdata['crm_task_details_id']);
        foreach ($task_remainder_details as $task_remainder_details) {
            $task_remainder_id = $this->mastermodel->insertmasterdata();
            $task_remainder_values = array(
                'crm_task_reminder_id' => $task_remainder_id,
                'crm_task_reminder_task_details_id' => $crm_task_details_id,
                'crm_task_reminder_date' => $task_remainder_details->crm_task_reminder_date,
                'crm_task_reminder_before' => $task_remainder_details->crm_task_reminder_before,
                'crm_task_reminder_subject' => $task_remainder_details->crm_task_reminder_subject,
                'crm_task_reminder_description' => $task_remainder_details->crm_task_reminder_description,
            );
            $this->db->insert('crm_task_reminder', $task_remainder_values);
        }
        $task_comments_details = $this->mastermodel->select_data_by_id('crm_task_comments', 'task_details_id', $postdata['crm_task_details_id']);
        $i = 1;
        foreach ($task_comments_details as $task_comments_details) {
            $comments_id = $this->mastermodel->insertmasterdata();
            $task_comments = array(
                'comments_id' => $comments_id,
                'task_details_id' => $crm_task_details_id,
                'task_comment_name' => $task_comments_details->task_comment_name,
                'task_comment_date' => $task_comments_details->task_comment_date
            );
            $this->db->insert('crm_task_comments', $task_comments);
            $i++;
        }

        $task_legal_details = $this->mastermodel->select_data_by_id('crm_task_legal', 'crm_task_legal_task_details_id', $postdata['crm_task_details_id']);
        foreach ($task_legal_details as $task_legal_details) {
            $task_leagal_id = $this->mastermodel->insertmasterdata();
            $task_legal_values = array(
                'crm_task_legal_id' => $task_leagal_id,
                'crm_task_legal_task_details_id' => $crm_task_details_id,
                'crm_task_legal_deal_legal_id' => $task_legal_details->crm_task_legal_deal_legal_id,
            );
            $this->db->insert('crm_task_legal', $task_legal_values);
        }

        // code for task updation  
        $crm_task_details_assigned_to_id = '';
        foreach ($postdata['crm_task_details_assigned_to_id'] as $item) {
            $crm_task_details_assigned_to_id .= $item . ',';
        }
        $tblValues = array(
            'crm_task_details_date' => $this->mastermodel->convert_date_format($postdata['crm_task_details_date']),
            'crm_task_details_title' => $postdata['crm_task_details_title'],
            'crm_task_details_subject_id' => $postdata['crm_task_details_subject_id'],
            'crm_task_details_due_date' => $this->mastermodel->convertdatetimenormalformat($postdata['crm_task_details_due_date']),
            'crm_task_details_reminder_date' => $this->mastermodel->convertdatetimenormalformat($postdata['crm_task_details_reminder_date']),
//             'crm_task_details_status_id' => $postdata['crm_task_details_status_id'],
            'crm_task_details_priority_id' => $postdata['crm_task_details_priority_id'],
            'crm_task_details_assigned_to_id' => $crm_task_details_assigned_to_id,
            'crm_task_details_description' => $postdata['crm_task_details_description'],
//            'crm_task_details_lead_id' => $postdata['crm_task_details_lead_id'],
//            'crm_task_details_deal_id' => $postdata['crm_task_details_deal_id'],
//            'crm_task_details_contact_id' => $postdata['crm_task_details_contact_id'],
        );
        $this->db->where('crm_task_details_id', $postdata['crm_task_details_id']);
        $this->db->update('crm_task_details', $tblValues);

        $this->db->where('crm_task_photo_task_id', $postdata['crm_task_details_id']);
        $this->db->delete('crm_task_photo');

        $i = 1;
        while (isset($_FILES['crm_task_photo_photo' . $i]) && !empty($_FILES['crm_task_photo_photo' . $i])) {
            $crm_task_photo_id = $this->mastermodel->insertmasterdata();
            $task_photo_values = array(
                'crm_task_photo_id' => $crm_task_photo_id,
                'crm_task_photo_task_id' => $postdata['crm_task_details_id'],
            );
            $upload_data = $this->mastermodel->upload_image('crm_task_photo_photo' . $i);
            if (!empty($upload_data['file_name'])) {
                $task_photo_values['crm_task_photo_photo'] = $upload_data['file_name'];
            }
            $this->db->insert('crm_task_photo', $task_photo_values);
            $i++;
        }
        $this->db->where('task_details_id', $postdata['crm_task_details_id']);
        $this->db->delete('crm_task_comments');
        $i = 1;
        while (isset($postdata['task_comment_name' . $i]) && !empty($postdata['task_comment_name' . $i])) {
            $comments_id = $this->mastermodel->insertmasterdata();
            $task_comments = array(
                'comments_id' => $comments_id,
                'task_details_id' => $postdata['crm_task_details_id'],
                'task_comment_name' => $postdata['task_comment_name' . $i],
                'task_comment_date' => $this->mastermodel->convertdatetimenormalformat($postdata['task_comment_date' . $i])
            );
            $this->db->insert('crm_task_comments', $task_comments);
            $i++;
        }
//        
        $j = 1;
        while (isset($postdata['crm_task_photo_photo_prev' . $j]) && !empty($postdata['crm_task_photo_photo_prev' . $j])) {
            $crm_task_photo_id = $this->mastermodel->insertmasterdata();
            $task_photo_values = array(
                'crm_task_photo_id' => $crm_task_photo_id,
                'crm_task_photo_task_id' => $postdata['crm_task_details_id'],
                'crm_task_photo_photo' => $postdata['crm_task_photo_photo_prev' . $j]
            );

            $this->db->insert('crm_task_photo', $task_photo_values);
            $j++;
        }

        $this->db->where('crm_task_reminder_task_details_id', $postdata['crm_task_details_id']);
        $this->db->delete('crm_task_reminder');
        $k = 1;
        while (isset($postdata['crm_task_reminder_subject' . $k]) && !empty($postdata['crm_task_reminder_subject' . $k])) {
            $crm_task_reminder_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_task_reminder_id' => $crm_task_reminder_id,
                'crm_task_reminder_task_details_id' => $postdata['crm_task_details_id'],
                'crm_task_reminder_subject' => $postdata['crm_task_reminder_subject' . $k],
                'crm_task_reminder_date' => $this->mastermodel->convertdatetimenormalformat($postdata['crm_task_reminder_date' . $k]),
                'crm_task_reminder_description' => $postdata['crm_task_reminder_description' . $k],
                'crm_task_reminder_before' => $this->mastermodel->convertdatetimenormalformat($postdata['crm_task_reminder_before' . $k]),
            );
            $output = $this->db->insert('crm_task_reminder', $tblValues_sub_document);
            $k++;
        }

        $this->db->where('crm_task_legal_task_details_id', $postdata['crm_task_details_id']);
        $this->db->delete('crm_task_legal');
        for ($j = 0; $j < count($postdata['crm_task_legal_deal_legal_id']); $j++) {
            $task_legal_id = $this->mastermodel->insertmasterdata();
            $tblValues_crm_task_legal = array(
                'crm_task_legal_id' => $task_legal_id,
                'crm_task_legal_task_details_id' => $postdata['crm_task_details_id'],
                'crm_task_legal_deal_legal_id' => $postdata['crm_task_legal_deal_legal_id'][$j],
            );
            $this->db->insert('crm_task_legal', $tblValues_crm_task_legal);
        }

        $output = $this->mastermodel->save_user_activities('Update crm task', $postdata['crm_task_details_id'], 'crm_task_details');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function update_lead_details($postdata) {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'crm_terms_condition_name' => $postdata['crm_terms_condition_name']
        );
        $this->db->where('crm_terms_condition_id', $postdata['crm_terms_condition_id']);
        $this->db->update('crm_terms_condition', $tblValues);
//        echo $this->db->last_query();die();
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_crm_deal() {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_deal_details');
        $this->db->where('crm_deal_details.crm_deal_details_id not in ', '(select deal.crm_deal_details_parent_id from crm_deal_details deal)', false);
        if ($_SESSION['administrator_privilage'] == 'no') {
            $this->db->where('crm_deal_details_owner', $_SESSION['user_id']);
        }
        $this->db->where('crm_deal_details_status', 'active');
        $this->db->where('crm_deal_details.deal_completed_status', 0);
        $this->db->join('master', 'master.master_id=crm_deal_details.crm_deal_details_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('crm_deal_details_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function search_crm_deal_completed() {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_deal_details');
        $this->db->where('crm_deal_details.crm_deal_details_id not in ', '(select deal.crm_deal_details_parent_id from crm_deal_details deal)', false);
        if ($_SESSION['administrator_privilage'] == 'no') {
            $this->db->where('crm_deal_details_owner', $_SESSION['user_id']);
        }
        $this->db->where('crm_deal_details_status', 'active');
        $this->db->where('crm_deal_details.deal_completed_status', 1);
        $this->db->join('master', 'master.master_id=crm_deal_details.crm_deal_details_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('crm_deal_details_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_deal($postdata) {
        $data = array();
        $this->db->trans_begin();
        $crm_deal_details_id = $this->mastermodel->insertmasterdata();
        $crm_deal_ledger_id = $this->mastermodel->insertmasterdata();
        $crm_deal_details_code = $this->mastermodel->get_ref('crm_deal_details_code', 'crm_deal_details', 'crm_deal_details_code');

        $lead_buyer_account = $this->accountingmodel->get_account_name($postdata['crm_deal_buyer_lead_id']);
        $deal_revenue_buyer_account_details = $this->mastermodel->get_data_srow('crm_revenue_category', $postdata['crm_deal_buyer_type_of_revenue_id'], 'crm_revenue_category_id');
        $lead_buyer_agency_account = $this->mastermodel->get_single_field_value('agency', 'ledger_id', 'agency_id', $postdata['crm_deal_buyer_agent_id']);

        $lead_seller_account = $this->accountingmodel->get_account_name($postdata['crm_deal_seller_lead_id']);
        $deal_revenue_seller_account_details = $this->mastermodel->get_data_srow('crm_revenue_category', $postdata['crm_deal_seller_type_of_revenue_id'], 'crm_revenue_category_id');
        $lead_seller_agency_account = $this->mastermodel->get_single_field_value('agency', 'ledger_id', 'agency_id', $postdata['crm_deal_seller_agent_id']);


        //account transaction deal buyer and seller

        $tblValues = array(
            'ledger_book_id' => $crm_deal_ledger_id,
            'voucher_no' => $crm_deal_details_code,
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_details_date']),
        );
        $output = $this->db->insert('ledger_book', $tblValues);


        //account transaction deal buyer
        $tblValues_led = array(
            'ledger_book_id' => $crm_deal_ledger_id,
            'account_ledger_id' => $lead_buyer_account,
            'debit' => $postdata['crm_deal_buyer_expected_revenue'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id1 = $this->db->insert_id();

        $tblValues_led = array(
            'ledger_book_id' => $crm_deal_ledger_id,
            'account_ledger_id' => $deal_revenue_buyer_account_details->crm_revenue_expected_account,
            'credit' => $postdata['crm_deal_buyer_expected_revenue'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id2 = $this->db->insert_id();


        $tblValues_led = array(
            'ledger_book_id' => $crm_deal_ledger_id,
            'account_ledger_id' => $deal_revenue_buyer_account_details->crm_agent_commission_account,
            'debit' => $postdata['crm_deal_buyer_agent_com'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id3 = $this->db->insert_id();

        $tblValues_led = array(
            'ledger_book_id' => $crm_deal_ledger_id,
            'account_ledger_id' => $lead_buyer_agency_account,
            'credit' => $postdata['crm_deal_buyer_agent_com'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id4 = $this->db->insert_id();

        //account transaction deal seller
        $tblValues_led = array(
            'ledger_book_id' => $crm_deal_ledger_id,
            'account_ledger_id' => $lead_seller_account,
            'debit' => $postdata['crm_deal_seller_expected_revenue'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id1 = $this->db->insert_id();

        $tblValues_led = array(
            'ledger_book_id' => $crm_deal_ledger_id,
            'account_ledger_id' => $deal_revenue_seller_account_details->crm_revenue_expected_account,
            'credit' => $postdata['crm_deal_seller_expected_revenue'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id2 = $this->db->insert_id();


        $tblValues_led = array(
            'ledger_book_id' => $crm_deal_ledger_id,
            'account_ledger_id' => $deal_revenue_seller_account_details->crm_agent_commission_account,
            'debit' => $postdata['crm_deal_seller_agent_com'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id3 = $this->db->insert_id();

        $tblValues_led = array(
            'ledger_book_id' => $crm_deal_ledger_id,
            'account_ledger_id' => $lead_seller_agency_account,
            'credit' => $postdata['crm_deal_seller_agent_com'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id4 = $this->db->insert_id();



        //deal entry
        $tblValues = array(
            'crm_deal_details_id' => $crm_deal_details_id,
            'crm_deal_details_code' => $crm_deal_details_code,
            'crm_deal_details_original_id' => $crm_deal_details_id,
            'crm_deal_details_status' => 'active',
            'crm_deal_details_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_details_date']),
            'crm_deal_details_owner' => $postdata['crm_deal_details_owner'],
            'crm_deal_details_title' => $postdata['crm_deal_details_title'],
            'crm_deal_details_amount' => $postdata['crm_deal_details_amount'],
            'crm_deal_details_closing_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_details_closing_date']),
            'crm_deal_details_status_id' => $postdata['crm_deal_details_status_id'],
            'crm_deal_details_description' => $postdata['crm_deal_details_description'],
            'crm_deal_details_probability' => $postdata['crm_deal_details_probability'],
            'crm_deal_details_next_step' => $postdata['crm_deal_details_next_step'],
            'crm_deal_buyer_agent_id' => $postdata['crm_deal_buyer_agent_id'],
            'crm_deal_buyer_expected_revenue' => $postdata['crm_deal_buyer_expected_revenue'],
            'crm_deal_buyer_contact_id' => $postdata['crm_deal_buyer_contact_id'],
            'crm_deal_buyer_type_of_revenue_id' => $postdata['crm_deal_buyer_type_of_revenue_id'],
            'crm_deal_buyer_lead_revenue' => $postdata['crm_deal_buyer_lead_revenue'],
            'crm_deal_buyer_remarks' => $postdata['crm_deal_buyer_remarks'],
            'crm_deal_buyer_agent_com' => $postdata['crm_deal_buyer_agent_com'],
            'crm_deal_buyer_lead_id' => $postdata['crm_deal_buyer_lead_id'],
            'crm_deal_seller_contact_id' => $postdata['crm_deal_seller_contact_id'],
            'crm_deal_seller_agent_id' => $postdata['crm_deal_seller_agent_id'],
            'crm_deal_seller_expected_revenue' => $postdata['crm_deal_seller_expected_revenue'],
            'crm_deal_seller_type_of_revenue_id' => $postdata['crm_deal_seller_type_of_revenue_id'],
            'crm_deal_seller_lead_revenue' => $postdata['crm_deal_seller_lead_revenue'],
            'crm_deal_seller_remarks' => $postdata['crm_deal_seller_remarks'],
            'crm_deal_seller_agent_com' => $postdata['crm_deal_seller_agent_com'],
            'crm_deal_seller_lead_id' => $postdata['crm_deal_seller_lead_id'],
            'deal_ledger_id' => $crm_deal_ledger_id
        );

//        $upload_data = $this->mastermodel->upload_image('crm_deal_details_file_name');
//        if (!empty($upload_data['file_name'])) {
//            $tblValues['crm_deal_details_file_name'] = $upload_data['file_name'];
//        }
        $this->db->insert('crm_deal_details', $tblValues);

        $i = 1;
        while (isset($postdata['crm_deal_reminder_subject' . $i]) && !empty($postdata['crm_deal_reminder_subject' . $i])) {
            $crm_task_reminder_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_deal_reminder_id' => $crm_task_reminder_id,
                'crm_deal_reminder_deal_details_id' => $crm_deal_details_id,
                'crm_deal_reminder_subject' => $postdata['crm_deal_reminder_subject' . $i],
                'crm_deal_reminder_date' => $this->mastermodel->convertdatetimenormalformat($postdata['crm_deal_reminder_date' . $i]),
                'crm_deal_reminder_description' => $postdata['crm_deal_reminder_description' . $i],
                'crm_deal_reminder_before' => $postdata['crm_deal_reminder_before' . $i],
            );
            $output = $this->db->insert('crm_deal_reminder', $tblValues_sub_document);
            $i++;
        }
        $i = 1;
        while (isset($_FILES['crm_deal_details_file_name' . $i]) && !empty($_FILES['crm_deal_details_file_name' . $i])) {

            $tbl_sub_document = array(
                'deal_details_id' => $crm_deal_details_id,
            );
            $upload_data = $this->mastermodel->upload_image('crm_deal_details_file_name' . $i);
            if (!empty($upload_data['file_name'])) {
                $tbl_sub_document['document'] = $upload_data['file_name'];
            }
            $output = $this->db->insert('crm_additional_doc', $tblValues_sub_document);
            $i++;
        }
        $i = 1;
        while (isset($postdata['sub_crm_deal_buyer_documents_id' . $i]) && !empty($postdata['sub_crm_deal_buyer_documents_id' . $i])) {
            $sub_crm_deal_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_deal_documents_id' => $sub_crm_deal_id,
                'crm_deal_documents_deal_details_id' => $crm_deal_details_id,
                'crm_deal_documents_document_id' => $postdata['sub_crm_deal_buyer_documents_id' . $i],
                'crm_deal_documents_lead_id' => $postdata['crm_deal_buyer_lead_id']
            );

            $upload_data = $this->mastermodel->upload_image('sub_crm_deal_buyer_documents_filename' . $i);
            if (!empty($upload_data['file_name'])) {
                $tblValues_sub_document['crm_deal_documents_filename'] = $upload_data['file_name'];
            }
            $i++;
            $this->db->insert('crm_deal_documents', $tblValues_sub_document);
        }

        $i = 1;
        while (isset($postdata['sub_crm_deal_seller_documents_id' . $i]) && !empty($postdata['sub_crm_deal_seller_documents_id' . $i])) {
            $sub_crm_deal_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_deal_documents_id' => $sub_crm_deal_id,
                'crm_deal_documents_deal_details_id' => $crm_deal_details_id,
                'crm_deal_documents_document_id' => $postdata['sub_crm_deal_seller_documents_id' . $i],
                'crm_deal_documents_lead_id' => $postdata['crm_deal_seller_lead_id']
            );

            $upload_data = $this->mastermodel->upload_image('sub_crm_deal_seller_documents_filename' . $i);
            if (!empty($upload_data['file_name'])) {
                $tblValues_sub_document['crm_deal_documents_filename'] = $upload_data['file_name'];
            }
            $i++;
            $this->db->insert('crm_deal_documents', $tblValues_sub_document);
        }

        $i = 1;
        while (isset($postdata['crm_deal_legal_subject' . $i]) && !empty($postdata['crm_deal_legal_subject' . $i])) {
            $sub_crm_legal_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_deal_legal_id' => $sub_crm_legal_id,
                'crm_deal_legal_deal_details_id' => $crm_deal_details_id,
                'crm_deal_legal_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_legal_date' . $i]),
                'crm_deal_legal_before' => $postdata['crm_deal_legal_before' . $i],
                'crm_deal_legal_subject' => $postdata['crm_deal_legal_subject' . $i],
                'crm_deal_legal_description' => $postdata['crm_deal_legal_description' . $i],
                'crm_deal_legal_court' => $postdata['crm_deal_legal_court' . $i]
            );

            $upload_data = $this->mastermodel->upload_image('crm_deal_legal_file_name' . $i);
            if (!empty($upload_data['file_name'])) {
                $tblValues_sub_document['crm_deal_legal_file_name'] = $upload_data['file_name'];
            }
            $i++;
            $this->db->insert('crm_deal_legal', $tblValues_sub_document);
        }
        $output = $this->mastermodel->save_user_activities('Insert Deal', $crm_deal_details_id, 'crm_deal_details');  //ss

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_deal($postdata) {
        $data = array();
        $this->db->trans_begin();

        //code for insertin deal during updation
        $deal_details = $this->mastermodel->get_data_srow('crm_deal_details', $postdata['crm_deal_details_id'], 'crm_deal_details_id');

        $crm_deal_details_id = $this->mastermodel->insertmasterdata();




        $tblValues = array(
            'crm_deal_details_id' => $crm_deal_details_id,
            'crm_deal_details_original_id' => $deal_details->crm_deal_details_original_id,
            'crm_deal_details_status' => 'history',
            'crm_deal_details_code' => $deal_details->crm_deal_details_code,
            'crm_deal_details_date' => $deal_details->crm_deal_details_date,
            'crm_deal_details_owner' => $deal_details->crm_deal_details_owner,
            'crm_deal_details_title' => $deal_details->crm_deal_details_title,
            'crm_deal_details_amount' => $deal_details->crm_deal_details_amount,
            'crm_deal_details_closing_date' => $deal_details->crm_deal_details_closing_date,
            'crm_deal_details_status_id' => $deal_details->crm_deal_details_status_id,
            'crm_deal_details_description' => $deal_details->crm_deal_details_description,
            'crm_deal_details_probability' => $deal_details->crm_deal_details_probability,
            'crm_deal_details_next_step' => $deal_details->crm_deal_details_next_step,
            'crm_deal_buyer_agent_id' => $deal_details->crm_deal_buyer_agent_id,
            'crm_deal_buyer_expected_revenue' => $deal_details->crm_deal_buyer_expected_revenue,
//            'crm_deal_buyer_contact_id' => $postdata['crm_deal_buyer_contact_id,
            'crm_deal_buyer_type_of_revenue_id' => $deal_details->crm_deal_buyer_type_of_revenue_id,
            'crm_deal_buyer_lead_revenue' => $deal_details->crm_deal_buyer_lead_revenue,
            'crm_deal_buyer_remarks' => $deal_details->crm_deal_buyer_remarks,
            'crm_deal_buyer_agent_com' => $deal_details->crm_deal_buyer_agent_com,
            'crm_deal_buyer_lead_id' => $deal_details->crm_deal_buyer_lead_id,
//            'crm_deal_seller_contact_id' => $postdata['crm_deal_seller_contact_id,
            'crm_deal_seller_agent_id' => $deal_details->crm_deal_seller_agent_id,
            'crm_deal_seller_expected_revenue' => $deal_details->crm_deal_seller_expected_revenue,
            'crm_deal_seller_type_of_revenue_id' => $deal_details->crm_deal_seller_type_of_revenue_id,
            'crm_deal_seller_lead_revenue' => $deal_details->crm_deal_seller_lead_revenue,
            'crm_deal_seller_remarks' => $deal_details->crm_deal_seller_remarks,
            'crm_deal_seller_agent_com' => $deal_details->crm_deal_seller_agent_com,
            'crm_deal_seller_lead_id' => $deal_details->crm_deal_seller_lead_id,
                );


//             $tblValues['crm_deal_details_file_name'] = $deal_details->crm_deal_details_file_name;

        $this->db->insert('crm_deal_details', $tblValues);

        $reminder_deal_details = $this->mastermodel->select_data_by_id('crm_deal_reminder', 'crm_deal_reminder_deal_details_id', $postdata['crm_deal_details_id']);

        foreach ($reminder_deal_details as $reminder_deal_details) {


            $crm_task_reminder_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_deal_reminder_id' => $crm_task_reminder_id,
                'crm_deal_reminder_deal_details_id' => $crm_deal_details_id,
                'crm_deal_reminder_subject' => $reminder_deal_details->crm_deal_reminder_subject,
                'crm_deal_reminder_date' => $reminder_deal_details->crm_deal_reminder_date,
                'crm_deal_reminder_description' => $reminder_deal_details->crm_deal_reminder_description,
                'crm_deal_reminder_before' => $reminder_deal_details->crm_deal_reminder_before,
            );
            $output = $this->db->insert('crm_deal_reminder', $tblValues_sub_document);
        }

        $buyer_deal_details = $this->mastermodel->select_data_by_id('crm_deal_documents', 'crm_deal_documents_deal_details_id', $postdata['crm_deal_details_id']);

        foreach ($buyer_deal_details as $buyer_deal_details) {
            $sub_crm_deal_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_deal_documents_id' => $sub_crm_deal_id,
                'crm_deal_documents_deal_details_id' => $crm_deal_details_id,
                'crm_deal_documents_document_id' => $buyer_deal_details->crm_deal_documents_document_id,
                'crm_deal_documents_lead_id' => $buyer_deal_details->crm_deal_documents_lead_id
            );


            $tblValues_sub_document['crm_deal_documents_filename'] = $buyer_deal_details->crm_deal_documents_filename;


            $this->db->insert('crm_deal_documents', $tblValues_sub_document);
        }




        $legal_deal_details = $this->mastermodel->select_data_by_id('crm_deal_legal', 'crm_deal_legal_deal_details_id', $postdata['crm_deal_details_id']);

        foreach ($legal_deal_details as $legal_deal_details) {
            $sub_crm_legal_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_deal_legal_id' => $sub_crm_legal_id,
                'crm_deal_legal_deal_details_id' => $crm_deal_details_id,
                'crm_deal_legal_date' => $legal_deal_details->crm_deal_legal_date,
                'crm_deal_legal_before' => $legal_deal_details->crm_deal_legal_before,
                'crm_deal_legal_subject' => $legal_deal_details->crm_deal_legal_subject,
                'crm_deal_legal_description' => $legal_deal_details->crm_deal_legal_description,
                'crm_deal_legal_court' => $legal_deal_details->crm_deal_legal_court
            );

            $tblValues_sub_document['crm_deal_legal_file_name'] = $legal_deal_details->crm_deal_legal_file_name;
            $this->db->insert('crm_deal_legal', $tblValues_sub_document);
        }

        $file_name = $this->mastermodel->select_data_by_id('crm_additional_doc', 'deal_details_id', $postdata['crm_deal_details_id']);

        foreach ($file_name as $file_name) {

            $tbl_sub_document = array(
                'deal_details_id' => $crm_deal_details_id,
            );

            $tbl_sub_document['document'] = $file_name->document;

            $output = $this->db->insert('crm_additional_doc', $tbl_sub_document);
        }
        $this->db->where('ledger_book_id', $postdata['deal_ledger_id']);
        $this->db->delete('ledger_book_details');


        $lead_buyer_account = $this->accountingmodel->get_account_name($postdata['crm_deal_buyer_lead_id']);
        $deal_revenue_buyer_account_details = $this->mastermodel->get_data_srow('crm_revenue_category', $postdata['crm_deal_buyer_type_of_revenue_id'], 'crm_revenue_category_id');
        $lead_buyer_agency_account = $this->mastermodel->get_single_field_value('agency', 'ledger_id', 'agency_id', $postdata['crm_deal_buyer_agent_id']);

        $lead_seller_account = $this->accountingmodel->get_account_name($postdata['crm_deal_seller_lead_id']);
        $deal_revenue_seller_account_details = $this->mastermodel->get_data_srow('crm_revenue_category', $postdata['crm_deal_seller_type_of_revenue_id'], 'crm_revenue_category_id');
        $lead_seller_agency_account = $this->mastermodel->get_single_field_value('agency', 'ledger_id', 'agency_id', $postdata['crm_deal_seller_agent_id']);


        //account transaction deal buyer and seller
        //account transaction deal buyer
        $tblValues_led = array(
            'ledger_book_id' => $postdata['deal_ledger_id'],
            'account_ledger_id' => $lead_buyer_account,
            'debit' => $postdata['crm_deal_buyer_expected_revenue'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id1 = $this->db->insert_id();

        $tblValues_led = array(
            'ledger_book_id' => $postdata['deal_ledger_id'],
            'account_ledger_id' => $deal_revenue_buyer_account_details->crm_revenue_expected_account,
            'credit' => $postdata['crm_deal_buyer_expected_revenue'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id2 = $this->db->insert_id();


        $tblValues_led = array(
            'ledger_book_id' => $postdata['deal_ledger_id'],
            'account_ledger_id' => $deal_revenue_buyer_account_details->crm_agent_commission_account,
            'debit' => $postdata['crm_deal_buyer_agent_com'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id3 = $this->db->insert_id();

        $tblValues_led = array(
            'ledger_book_id' => $postdata['deal_ledger_id'],
            'account_ledger_id' => $lead_buyer_agency_account,
            'credit' => $postdata['crm_deal_buyer_agent_com'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id4 = $this->db->insert_id();

        //account transaction deal seller
        $tblValues_led = array(
            'ledger_book_id' => $postdata['deal_ledger_id'],
            'account_ledger_id' => $lead_seller_account,
            'debit' => $postdata['crm_deal_seller_expected_revenue'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id1 = $this->db->insert_id();

        $tblValues_led = array(
            'ledger_book_id' => $postdata['deal_ledger_id'],
            'account_ledger_id' => $deal_revenue_seller_account_details->crm_revenue_expected_account,
            'credit' => $postdata['crm_deal_seller_expected_revenue'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id2 = $this->db->insert_id();


        $tblValues_led = array(
            'ledger_book_id' => $postdata['deal_ledger_id'],
            'account_ledger_id' => $deal_revenue_seller_account_details->crm_agent_commission_account,
            'debit' => $postdata['crm_deal_seller_agent_com'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id3 = $this->db->insert_id();

        $tblValues_led = array(
            'ledger_book_id' => $postdata['deal_ledger_id'],
            'account_ledger_id' => $lead_seller_agency_account,
            'credit' => $postdata['crm_deal_seller_agent_com'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $deal_id4 = $this->db->insert_id();




        $tblValues = array(
            'crm_deal_details_original_id' => $postdata['crm_deal_details_original_id'],
            'crm_deal_details_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_details_date']),
            'crm_deal_details_title' => $postdata['crm_deal_details_title'],
            'crm_deal_details_amount' => $postdata['crm_deal_details_amount'],
            'crm_deal_details_closing_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_details_closing_date']),
            'crm_deal_details_status_id' => $postdata['crm_deal_details_status_id'],
            'crm_deal_details_description' => $postdata['crm_deal_details_description'],
            'crm_deal_details_probability' => $postdata['crm_deal_details_probability'],
            'crm_deal_details_next_step' => $postdata['crm_deal_details_next_step'],
            'crm_deal_buyer_expected_revenue' => $postdata['crm_deal_buyer_expected_revenue'],
//            'crm_deal_buyer_contact_id' => $postdata['crm_deal_buyer_contact_id'],
            'crm_deal_buyer_type_of_revenue_id' => $postdata['crm_deal_buyer_type_of_revenue_id'],
            'crm_deal_buyer_lead_revenue' => $postdata['crm_deal_buyer_lead_revenue'],
            'crm_deal_buyer_remarks' => $postdata['crm_deal_buyer_remarks'],
            'crm_deal_buyer_agent_com' => $postdata['crm_deal_buyer_agent_com'],
//            'crm_deal_buyer_lead_id' => $postdata['crm_deal_buyer_lead_id'],
//            'crm_deal_seller_contact_id' => $postdata['crm_deal_seller_contact_id'],
//            'crm_deal_seller_agent_id' => $postdata['crm_deal_seller_agent_id'],
            'crm_deal_seller_expected_revenue' => $postdata['crm_deal_seller_expected_revenue'],
            'crm_deal_seller_type_of_revenue_id' => $postdata['crm_deal_seller_type_of_revenue_id'],
            'crm_deal_seller_lead_revenue' => $postdata['crm_deal_seller_lead_revenue'],
            'crm_deal_seller_remarks' => $postdata['crm_deal_seller_remarks'],
            'crm_deal_seller_agent_com' => $postdata['crm_deal_seller_agent_com'],
//            'crm_deal_seller_lead_id' => $postdata['crm_deal_seller_lead_id'],
        );
//        $upload_data = $this->mastermodel->upload_image('crm_deal_details_file_name');
//        if (!empty($upload_data['file_name'])) {
//            $tblValues['crm_deal_details_file_name'] = $upload_data['file_name'];
//        }
//        else{
//             $tblValues['crm_deal_details_file_name'] = $postdata['crm_deal_details_file_name_prev'];
//        }
        $this->db->where('crm_deal_details_id', $postdata['crm_deal_details_id']);
        $this->db->update('crm_deal_details', $tblValues);

        $this->db->where('crm_deal_reminder_deal_details_id', $postdata['crm_deal_details_id']);
        $this->db->delete('crm_deal_reminder');

        $i = 1;
        while (isset($postdata['crm_deal_reminder_subject' . $i]) && !empty($postdata['crm_deal_reminder_subject' . $i])) {
            $crm_task_reminder_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_deal_reminder_id' => $crm_task_reminder_id,
                'crm_deal_reminder_deal_details_id' => $postdata['crm_deal_details_id'],
                'crm_deal_reminder_subject' => $postdata['crm_deal_reminder_subject' . $i],
                'crm_deal_reminder_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_reminder_date' . $i]),
                'crm_deal_reminder_description' => $postdata['crm_deal_reminder_description' . $i],
                'crm_deal_reminder_before' => $postdata['crm_deal_reminder_before' . $i],
            );
            $output = $this->db->insert('crm_deal_reminder', $tblValues_sub_document);
            $i++;
        }
        $this->db->where('deal_details_id', $postdata['crm_deal_details_id']);
        $this->db->delete('crm_additional_doc');
        $i = 1;
        while (!empty($_FILES['crm_deal_details_file_name' . $i]) && !empty($_FILES['crm_deal_details_file_name' . $i])) {

            $tbl_sub_document = array(
                'deal_details_id' => $postdata['crm_deal_details_id'],
            );
            $upload_data = $this->mastermodel->upload_image('crm_deal_details_file_name' . $i);
            if (!empty($upload_data['file_name'])) {
                $tbl_sub_document['document'] = $upload_data['file_name'];
            }
            $output = $this->db->insert('crm_additional_doc', $tbl_sub_document);
            $i++;
        }
        $this->db->where('crm_deal_documents_deal_details_id', $postdata['crm_deal_details_id']);
        $this->db->delete('crm_deal_documents');
        $j = 1;
        while (isset($postdata['crm_deal_documents_buyer_document_id' . $j]) && !empty($postdata['crm_deal_documents_buyer_document_id' . $j])) {
            $sub_crm_deal_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_deal_documents_id' => $sub_crm_deal_id,
                'crm_deal_documents_deal_details_id' => $postdata['crm_deal_details_id'],
                'crm_deal_documents_document_id' => $postdata['crm_deal_documents_buyer_document_id' . $j],
                'crm_deal_documents_lead_id' => $postdata['crm_deal_buyer_lead_id']
            );

            $upload_data = $this->mastermodel->upload_image('crm_deal_documents_buyer_filename' . $j);
            if (!empty($upload_data['file_name'])) {
                $tblValues_sub_document['crm_deal_documents_filename'] = $upload_data['file_name'];
            } else {
                $tblValues_sub_document['crm_deal_documents_filename'] = $postdata['crm_deal_documents_buyer_filename_prev' . $j];
            }
            $j++;
            $this->db->insert('crm_deal_documents', $tblValues_sub_document);
        }


        $k = 1;
        while (isset($postdata['crm_deal_documents_seller_document_id' . $k]) && !empty($postdata['crm_deal_documents_seller_document_id' . $k])) {
            $sub_crm_deal_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_deal_documents_id' => $sub_crm_deal_id,
                'crm_deal_documents_deal_details_id' => $postdata['crm_deal_details_id'],
                'crm_deal_documents_document_id' => $postdata['crm_deal_documents_seller_document_id' . $k],
                'crm_deal_documents_lead_id' => $postdata['crm_deal_seller_lead_id']
            );

            $upload_data = $this->mastermodel->upload_image('crm_deal_documents_seller_filename' . $k);
            if (!empty($upload_data['file_name'])) {
                $tblValues_sub_document['crm_deal_documents_filename'] = $upload_data['file_name'];
            } else {
                $tblValues_sub_document['crm_deal_documents_filename'] = $postdata['crm_deal_documents_seller_filename_prev' . $k];
            }
            $k++;
            $this->db->insert('crm_deal_documents', $tblValues_sub_document);
        }

        $this->db->where('crm_deal_legal_deal_details_id', $postdata['crm_deal_details_id']);
        $this->db->delete('crm_deal_legal');
        $l = 1;
        while (isset($postdata['crm_deal_legal_subject' . $l]) && !empty($postdata['crm_deal_legal_subject' . $l])) {
            $sub_crm_legal_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'crm_deal_legal_id' => $sub_crm_legal_id,
                'crm_deal_legal_deal_details_id' => $postdata['crm_deal_details_id'],
                'crm_deal_legal_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_legal_date' . $l]),
                'crm_deal_legal_before' => $postdata['crm_deal_legal_before' . $l],
                'crm_deal_legal_subject' => $postdata['crm_deal_legal_subject' . $l],
                'crm_deal_legal_description' => $postdata['crm_deal_legal_description' . $l],
                'crm_deal_legal_court' => $postdata['crm_deal_legal_court' . $l]
            );

            $upload_data = $this->mastermodel->upload_image('crm_deal_legal_file_name' . $l);
            if (!empty($upload_data['file_name'])) {
                $tblValues_sub_document['crm_deal_legal_file_name'] = $upload_data['file_name'];
            } else {
                $tblValues_sub_document['crm_deal_legal_file_name'] = $postdata['crm_deal_legal_file_name_prev' . $l];
            }
            $l++;
            $this->db->insert('crm_deal_legal', $tblValues_sub_document);
        }



        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
        $output = $this->mastermodel->save_user_activities('Update Deal', $postdata['crm_deal_details_id'], 'crm_deal_details');  //ss
    }

    function get_lead_for_assigning($postdata) {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_lead_details');
        $this->db->where('crm_lead_details_lead_type_id', $postdata['crm_lead_type']);
        $this->db->where('crm_lead_details_category_id', $postdata['crm_lead_category']);
        $this->db->where('crm_lead_details_status', 'active');
//       $this->db->where('crm_lead_details.crm_lead_details_id not in ','(select led.crm_lead_details_parent_id from crm_lead_details led)',false);
        $this->db->order_by('crm_lead_details_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_lead_for_assigning_editPage($postdata) {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_lead_details');
        $this->db->where('crm_lead_details_lead_type_id', $postdata['crm_lead_type']);
        $this->db->where('crm_lead_details_category_id', $postdata['crm_lead_category']);
        $this->db->where('crm_lead_details_id <>', $postdata['crm_lead_details_id']);
        $this->db->where('crm_lead_details_status', 'active');
        $this->db->where('crm_lead_details.crm_lead_details_id not in ', '(select led.crm_lead_details_parent_id from crm_lead_details led)', false);
        $this->db->order_by('crm_lead_details_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_contact_frm_lead_editPage($postdata) {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_lead_details');
        $this->db->where('crm_lead_details_user_id', $postdata['lead_owner']);
        $this->db->where('crm_lead_details_id <>', $postdata['crm_lead_details_id']);
//        $this->db->where('crm_lead_details.crm_lead_details_id not in ','(select led.crm_lead_details_parent_id from crm_lead_details led)',false);
        $this->db->order_by('crm_lead_details_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function search_deal_rv() {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_deal_receipt_voucher');
        $this->db->join('master', 'master.master_id=crm_deal_receipt_voucher.crm_deal_receipt_voucher_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('crm_deal_receipt_voucher_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

//    public function insert_deal_rv($postdata) 
//    {   
//        $data = array();
//        $this->db->trans_begin();
//        $master_id = $this->mastermodel->insertmasterdata();
//        $rv_code = $this->mastermodel->get_ref('crm_deal_rv_code', 'crm_deal_rv', 'crm_deal_rv_code');
//        $tblValues = array(
//            'crm_deal_rv_id' => $master_id,
//            'crm_deal_rv_code' => $rv_code,
//            'crm_deal_rv_date' => $this->mastermodel->convertdateformat($postdata['crm_deal_rv_date']),
//            'crm_deal_rv_deal_details_id' => $postdata['crm_task_details_deal_id'],
//            'crm_deal_rv_buyer_lead_details_id' => $postdata['crm_deal_rv_buyer_lead_details_id'],
//            'crm_deal_rv_buyer_payment_mode_id' => $postdata['crm_deal_rv_buyer_payment_mode_id'],
//            'crm_deal_rv_buyer_receipt_remarks' => $postdata['crm_deal_rv_buyer_receipt_remarks'],
//            'crm_deal_rv_buyer_account' => $postdata['crm_deal_rv_buyer_account'],
//            'crm_deal_rv_buyer_received_from' => $postdata['crm_deal_rv_buyer_received_from'],
//            'crm_deal_rv_buyer_revenue_type' => $postdata['crm_deal_rv_buyer_revenue_type'],
//            'crm_deal_rv_buyer_revenue' => $postdata['crm_deal_rv_buyer_revenue'],
//            'crm_deal_rv_buyer_paid' => $postdata['crm_deal_rv_buyer_paid'],
//            'crm_deal_rv_buyer_amount' => $postdata['crm_deal_rv_buyer_amount'],
//            'crm_deal_rv_buyer_balance' => $postdata['crm_deal_rv_buyer_balance'],
//            'crm_deal_rv_buyer_tax' => $postdata['crm_deal_rv_buyer_tax'],
//            'crm_deal_rv_buyer_tax_amount' => $postdata['crm_deal_rv_buyer_tax_amount'],
//            'crm_deal_rv_buyer_total' => $postdata['crm_deal_rv_buyer_total'],
//            'crm_deal_rv_buyer_discount' => $postdata['crm_deal_rv_buyer_discount'],
//            'crm_deal_rv_buyer_grand_total' => $postdata['crm_deal_rv_buyer_grand_total'],
//            'crm_deal_rv_buyer_note' => $postdata['crm_deal_rv_buyer_note'],
//            'crm_deal_rv_seller_lead_details_id' => $postdata['crm_deal_rv_seller_lead_details_id'],
//            'crm_deal_rv_seller_payment_mode_id' => $postdata['crm_deal_rv_seller_payment_mode_id'],
//            'crm_deal_rv_seller_receipt_remarks' => $postdata['crm_deal_rv_seller_receipt_remarks'],
//            'crm_deal_rv_seller_account' => $postdata['crm_deal_rv_seller_account'],
//            'crm_deal_rv_seller_received_from' => $postdata['crm_deal_rv_seller_received_from'],
//            'crm_deal_rv_seller_revenue_type' => $postdata['crm_deal_rv_seller_revenue_type'],
//            'crm_deal_rv_seller_revenue' => $postdata['crm_deal_rv_seller_revenue'],
//            'crm_deal_rv_seller_paid' => $postdata['crm_deal_rv_seller_paid'],
//            'crm_deal_rv_seller_amount' => $postdata['crm_deal_rv_seller_amount'],
//            'crm_deal_rv_seller_balance' => $postdata['crm_deal_rv_seller_balance'],
//            'crm_deal_rv_seller_tax' => $postdata['crm_deal_rv_seller_tax'],
//            'crm_deal_rv_seller_tax_amount' => $postdata['crm_deal_rv_seller_tax_amount'],
//            'crm_deal_rv_seller_total' => $postdata['crm_deal_rv_seller_total'],
//            'crm_deal_rv_seller_discount' => $postdata['crm_deal_rv_seller_discount'],
//            'crm_deal_rv_seller_grand_total' => $postdata['crm_deal_rv_seller_grand_total'],
//            'crm_deal_rv_seller_note' => $postdata['crm_deal_rv_seller_note']
//        );
//        $this->db->insert('crm_deal_rv', $tblValues);
//
//        if ($this->db->trans_status() === FALSE) {
//            $this->db->trans_rollback();
//            $data['res'] = 0;
//            $data['msg'] = 'Error On Adding Record';
//            return $data;
//        } else {
//            $this->db->trans_commit();
//            $data['res'] = 1;
//            $data['msg'] = 'Record Added Successfully';
//            return $data;
//        }
//    }
    public function insert_deal_rv($postdata) {
        $data = array();
        $this->db->trans_begin();
        $master_id = $this->mastermodel->insertmasterdata();
        $rv_code = $this->mastermodel->get_ref('crm_deal_receipt_voucher_code', 'crm_deal_receipt_voucher', 'crm_deal_receipt_voucher_code');
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $rv_code,
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_receipt_voucher_date']),
        );
        $output = $this->db->insert('ledger_book', $tblValues);


        if ($postdata['crm_deal_receipt_voucher_type'] == 'buyer') {

            $check_ref_no = '';
            $check_ref_date = '';
            $bank_account = '';
            if ($postdata['crm_deal_receipt_voucher_payment_mode'] == 2) {
                $check_ref_no = $postdata['crm_deal_receipt_voucher_check_code'];
                $check_ref_date = $this->mastermodel->convert_date_format($postdata['crm_deal_receipt_voucher_check_date']);
            }
            if ($postdata['crm_deal_receipt_voucher_payment_mode'] == 3) {
                $bank_account = $postdata['crm_deal_rv_account'];
                $lead_buyer_account = $postdata['crm_deal_receipt_voucher_account'];

                $tblValues_led = array(
                    'ledger_book_id' => $ledger_id,
                    'account_ledger_id' => $lead_buyer_account,
                    'credit' => $postdata['crm_deal_receipt_voucher_amount'],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues_led);
                $cdet_id = $this->db->insert_id();

                $tblValues_led = array(
                    'ledger_book_id' => $ledger_id,
                    'account_ledger_id' => $bank_account,
                    'debit' => $postdata['crm_deal_receipt_voucher_amount'],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues_led);
                $cdet_id = $this->db->insert_id();
            }
            if ($postdata['crm_deal_receipt_voucher_payment_mode'] == 1) {

                $lead_buyer_account = $postdata['crm_deal_receipt_voucher_account'];
                $cash_account = $this->accountingmodel->get_account_settings('cash_account');

                $tblValues_led = array(
                    'ledger_book_id' => $ledger_id,
                    'account_ledger_id' => $lead_buyer_account,
                    'credit' => $postdata['crm_deal_receipt_voucher_amount'],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues_led);
                $cdet_id = $this->db->insert_id();

                $tblValues_led = array(
                    'ledger_book_id' => $ledger_id,
                    'account_ledger_id' => $cash_account,
                    'debit' => $postdata['crm_deal_receipt_voucher_amount'],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues_led);
                $cdet_id = $this->db->insert_id();
            }
        }
        if ($postdata['crm_deal_receipt_voucher_type'] == 'seller') {
            $check_ref_no = '';
            $check_ref_date = '';
            $bank_account = '';
            if ($postdata['crm_deal_receipt_voucher_payment_mode'] == 2) {
                $check_ref_no = $postdata['crm_deal_receipt_voucher_check_code'];
                $check_ref_date = $this->mastermodel->convert_date_format($postdata['crm_deal_receipt_voucher_check_date']);
            }
            if ($postdata['crm_deal_receipt_voucher_payment_mode'] == 3) {
                $bank_account = $postdata['crm_deal_rv_account'];
                $leadseller_account = $postdata['crm_deal_receipt_voucher_account'];

                $tblValues_led = array(
                    'ledger_book_id' => $ledger_id,
                    'account_ledger_id' => $leadseller_account,
                    'credit' => $postdata['crm_deal_receipt_voucher_amount'],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues_led);
                $cdet_id = $this->db->insert_id();

                $tblValues_led = array(
                    'ledger_book_id' => $ledger_id,
                    'account_ledger_id' => $bank_account,
                    'debit' => $postdata['crm_deal_receipt_voucher_amount'],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues_led);
                $cdet_id = $this->db->insert_id();
            }
            if ($postdata['crm_deal_receipt_voucher_payment_mode'] == 1) {
                $leadseller_account = $postdata['crm_deal_receipt_voucher_account'];
                $cash_account = $this->accountingmodel->get_account_settings('cash_account');

                $tblValues_led = array(
                    'ledger_book_id' => $ledger_id,
                    'account_ledger_id' => $leadseller_account,
                    'credit' => $postdata['crm_deal_receipt_voucher_amount'],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues_led);
                $cdet_id = $this->db->insert_id();

                $tblValues_led = array(
                    'ledger_book_id' => $ledger_id,
                    'account_ledger_id' => $cash_account,
                    'debit' => $postdata['crm_deal_receipt_voucher_amount'],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues_led);
                $cdet_id = $this->db->insert_id();
            }
        }

        $tblValues = array(
            'crm_deal_receipt_voucher_id' => $master_id,
            'crm_deal_receipt_voucher_code' => $rv_code,
            'crm_deal_receipt_voucher_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_receipt_voucher_date']),
            'crm_deal_receipt_voucher_deal_id' => $postdata['crm_deal_receipt_voucher_deal_id'],
            'crm_deal_receipt_voucher_type' => $postdata['crm_deal_receipt_voucher_type'],
            'crm_deal_receipt_voucher_lead_id' => $postdata['crm_deal_receipt_voucher_lead_id'],
            'crm_deal_receipt_voucher_payment_mode' => $postdata['crm_deal_receipt_voucher_payment_mode'],
            'crm_deal_receipt_voucher_remarks' => $postdata['crm_deal_receipt_voucher_remarks'],
            'crm_deal_receipt_voucher_account' => $postdata['crm_deal_receipt_voucher_account'],
            'crm_deal_receipt_voucher_received_from' => $postdata['crm_deal_receipt_voucher_received_from'],
            'crm_deal_receipt_voucher_revenue_type' => $postdata['crm_deal_receipt_voucher_revenue_type'],
            'crm_deal_receipt_voucher_revenue' => $postdata['crm_deal_receipt_voucher_revenue'],
            'crm_deal_receipt_voucher_paid' => $postdata['crm_deal_receipt_voucher_paid'],
            'crm_deal_receipt_voucher_amount' => $postdata['crm_deal_receipt_voucher_amount'],
            'crm_deal_receipt_voucher_balance' => $postdata['crm_deal_receipt_voucher_balance'],
//                'crm_deal_receipt_voucher_tax_perc' => $postdata['crm_deal_receipt_voucher_tax_perc'],
//                'crm_deal_receipt_voucher_tax_amt' => $postdata['crm_deal_receipt_voucher_tax_amt'],
            'crm_deal_receipt_voucher_total' => $postdata['crm_deal_receipt_voucher_total'],
            'crm_deal_receipt_voucher_discount' => $postdata['crm_deal_receipt_voucher_discount'],
            'crm_deal_receipt_voucher_grand_total' => $postdata['crm_deal_receipt_voucher_grand_total'],
            'crm_deal_receipt_voucher_note' => $postdata['crm_deal_receipt_voucher_note'],
            'crm_deal_receipt_voucher_ledger_id' => $ledger_id,
            'crm_deal_receipt_voucher_check_date' => $check_ref_date,
            'crm_deal_receipt_voucher_check_code' => $check_ref_no,
            'crm_deal_receipt_voucher_account' => $bank_account,
        );

        $this->db->insert('crm_deal_receipt_voucher', $tblValues);

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function update_deal_rv($postdata) {
        $data = array();
        $tblValues = array(
            'crm_deal_rv_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_rv_date']),
            'crm_deal_rv_buyer_payment_mode_id' => $postdata['crm_deal_rv_buyer_payment_mode_id'],
            'crm_deal_rv_buyer_receipt_remarks' => $postdata['crm_deal_rv_buyer_receipt_remarks'],
            'crm_deal_rv_buyer_account' => $postdata['crm_deal_rv_buyer_account'],
            'crm_deal_rv_buyer_paid' => $postdata['crm_deal_rv_buyer_paid'],
            'crm_deal_rv_buyer_amount' => $postdata['crm_deal_rv_buyer_amount'],
            'crm_deal_rv_buyer_balance' => $postdata['crm_deal_rv_buyer_balance'],
            'crm_deal_rv_buyer_tax' => $postdata['crm_deal_rv_buyer_tax'],
            'crm_deal_rv_buyer_tax_amount' => $postdata['crm_deal_rv_buyer_tax_amount'],
            'crm_deal_rv_buyer_total' => $postdata['crm_deal_rv_buyer_total'],
            'crm_deal_rv_buyer_discount' => $postdata['crm_deal_rv_buyer_discount'],
            'crm_deal_rv_buyer_grand_total' => $postdata['crm_deal_rv_buyer_grand_total'],
            'crm_deal_rv_buyer_note' => $postdata['crm_deal_rv_buyer_note'],
            'crm_deal_rv_seller_payment_mode_id' => $postdata['crm_deal_rv_seller_payment_mode_id'],
            'crm_deal_rv_seller_receipt_remarks' => $postdata['crm_deal_rv_seller_receipt_remarks'],
            'crm_deal_rv_seller_account' => $postdata['crm_deal_rv_seller_account'],
            'crm_deal_rv_seller_paid' => $postdata['crm_deal_rv_seller_paid'],
            'crm_deal_rv_seller_amount' => $postdata['crm_deal_rv_seller_amount'],
            'crm_deal_rv_seller_balance' => $postdata['crm_deal_rv_seller_balance'],
            'crm_deal_rv_seller_tax' => $postdata['crm_deal_rv_seller_tax'],
            'crm_deal_rv_seller_tax_amount' => $postdata['crm_deal_rv_seller_tax_amount'],
            'crm_deal_rv_seller_total' => $postdata['crm_deal_rv_seller_total'],
            'crm_deal_rv_seller_discount' => $postdata['crm_deal_rv_seller_discount'],
            'crm_deal_rv_seller_grand_total' => $postdata['crm_deal_rv_seller_grand_total'],
            'crm_deal_rv_seller_note' => $postdata['crm_deal_rv_seller_note']
        );
        $this->db->where('crm_deal_rv_id', $postdata['crm_deal_rv_id']);
        $this->db->update('crm_deal_rv', $tblValues);

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_deal_pay_voucher() {
        $data = array();
        $this->db->select('*');
        $this->db->from('crm_deal_payment_voucher');
        $this->db->join('master', 'master.master_id=crm_deal_payment_voucher.crm_deal_pay_voucher_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
//        $this->db->where('crm_deal_details.crm_deal_details_id not in ','(select deal.crm_deal_details_parent_id from crm_deal_details deal)',false);
        $this->db->order_by('crm_deal_pay_voucher_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_crm_deal_pay_voucher($postdata) {

        $data = array();
        $this->db->trans_begin();
        $pay_voucher_id = $this->mastermodel->insertmasterdata();
        $pay_voucher_code = $this->mastermodel->get_ref('crm_deal_pay_voucher_code', 'crm_deal_pay_voucher', 'crm_deal_pay_voucher_code');
        $tblValues = array(
            'crm_deal_pay_voucher_id' => $pay_voucher_id,
            'crm_deal_pay_voucher_code' => $pay_voucher_code,
            'crm_deal_pay_voucher_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_pay_voucher_date']),
            'crm_deal_pay_voucher_type' => $postdata['crm_deal_pay_voucher_type'],
            'crm_deal_pay_voucher_deal_id' => $postdata['crm_deal_pay_voucher_deal_id'],
            'crm_deal_pay_voucher_lead_id' => $postdata['crm_deal_pay_voucher_lead_id'],
            'crm_deal_pay_voucher_payment_mode' => $postdata['crm_deal_pay_voucher_payment_mode'],
            'crm_deal_pay_voucher_payment_acc_type' => $postdata['crm_deal_pay_voucher_payment_acc_type'],
            'crm_deal_pay_voucher_remarks' => $postdata['crm_deal_pay_voucher_remarks'],
            'crm_deal_pay_voucher_amount' => $postdata['crm_deal_pay_voucher_amount'],
            'crm_deal_pay_voucher_tax_perc' => $postdata['crm_deal_pay_voucher_tax_perc'],
            'crm_deal_pay_voucher_tax_amt' => $postdata['crm_deal_pay_voucher_tax_amt'],
            'crm_deal_pay_voucher_discount' => $postdata['crm_deal_pay_voucher_discount'],
            'crm_deal_pay_voucher_paid_to' => $postdata['crm_deal_pay_voucher_paid_to'],
            'crm_deal_pay_voucher_expense_type' => $postdata['crm_deal_pay_voucher_expense_type'],
            'crm_deal_pay_voucher_payable' => $postdata['crm_deal_pay_voucher_payable'],
            'crm_deal_pay_voucher_paid' => $postdata['crm_deal_pay_voucher_paid'],
            'crm_deal_pay_voucher_balance' => $postdata['crm_deal_pay_voucher_balance'],
            'crm_deal_pay_voucher_total' => $postdata['crm_deal_pay_voucher_total'],
            'crm_deal_pay_voucher_grand_total' => $postdata['crm_deal_pay_voucher_grand_total'],
            'crm_deal_pay_voucher_note' => $postdata['crm_deal_pay_voucher_note']
        );

        $this->db->insert('crm_deal_payment_voucher', $tblValues);

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
        //function to gat payment voucher previous details
    }

    public function update_crm_deal_pay_voucher($postdata) {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'crm_deal_pay_voucher_date' => $this->mastermodel->convert_date_format($postdata['crm_deal_pay_voucher_date']),
            'crm_deal_pay_voucher_buyer_payment_mode' => $postdata['crm_deal_pay_voucher_buyer_payment_mode'],
            'crm_deal_pay_voucher_buyer_payment_acc_type' => $postdata['crm_deal_pay_voucher_buyer_payment_acc_type'],
            'crm_deal_pay_voucher_buyer_remarks' => $postdata['crm_deal_pay_voucher_buyer_remarks'],
//            'crm_deal_pay_voucher_buyer_amount' => $postdata['crm_deal_pay_voucher_buyer_amount'],
//            'crm_deal_pay_voucher_buyer_tax_perc' => $postdata['crm_deal_pay_voucher_buyer_tax_perc'],
//            'crm_deal_pay_voucher_buyer_tax_amt' => $postdata['crm_deal_pay_voucher_buyer_tax_amt'],
            'crm_deal_pay_voucher_buyer_remarks' => $postdata['crm_deal_pay_voucher_buyer_remarks'],
            'crm_deal_pay_voucher_buyer_note' => $postdata['crm_deal_pay_voucher_buyer_note'],
            'crm_deal_pay_voucher_seller_payment_mode' => $postdata['crm_deal_pay_voucher_seller_payment_mode'],
            'crm_deal_pay_voucher_seller_acc_type' => $postdata['crm_deal_pay_voucher_seller_acc_type'],
            'crm_deal_pay_voucher_seller_remarks' => $postdata['crm_deal_pay_voucher_seller_remarks'],
//            'crm_deal_pay_voucher_seller_amount' => $postdata['crm_deal_pay_voucher_seller_amount'],
//            'crm_deal_pay_voucher_tax_amount' => $postdata['crm_deal_pay_voucher_tax_amount'],
//            'crm_deal_pay_voucher_seller_tax_perc' => $postdata['crm_deal_pay_voucher_seller_tax_perc'],
            'crm_deal_pay_voucher_buyer_remarks' => $postdata['crm_deal_pay_voucher_buyer_remarks'],
            'crm_deal_pay_voucher_seller_note' => $postdata['crm_deal_pay_voucher_seller_note'],
        );
        $this->db->where('crm_deal_pay_voucher_id', $postdata['crm_deal_pay_voucher_id']);
        $this->db->update('crm_deal_pay_voucher', $tblValues);

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
        //function to gat payment voucher previous details
    }

    function check_deal_pay_voucher($deal_id) {
        $data = array();
        $this->db->select('*,SUM(crm_deal_pay_voucher.crm_deal_pay_voucher_buyer_amount) AS buyer_amount,SUM(crm_deal_pay_voucher.crm_deal_pay_voucher_seller_amount) AS seller_amount');
        $this->db->from('crm_deal_pay_voucher');
        $this->db->where('crm_deal_pay_voucher_deal_id', $deal_id);
        $this->db->order_by('crm_deal_pay_voucher_id', 'desc');
        $data = $this->db->get()->result();
        // echo $this->db->last_query();
        return $data;
    }

    public function get_task_reminder() {

        $emplo = $_SESSION['employee_id'];
        if ($_SESSION['administrator_privilage'] == 'no') {
            $query = "(";
            $query .= " `crm_task_details_owner` = " . $_SESSION['user_id'];
            $query .= " OR FIND_IN_SET('" . $emplo . "',crm_task_details_assigned_to_id) != 0";



            $query .= ")";
//        $this->db->where($query);
            $data = $this->db->query('SELECT *  from crm_task_reminder JOIN `crm_task_details` ON `crm_task_details`.`crm_task_details_id`=`crm_task_reminder`.`crm_task_reminder_task_details_id` where `crm_task_details_status` =  "active" and now()  >=  crm_task_reminder_before  and now()  <=  crm_task_reminder_date and ' . $query);
        } else {
            $data = $this->db->query('SELECT *  from crm_task_reminder JOIN `crm_task_details` ON `crm_task_details`.`crm_task_details_id`=`crm_task_reminder`.`crm_task_reminder_task_details_id` where `crm_task_details_status` =  "active" and  now()  >=  crm_task_reminder_before  and now()  <=  crm_task_reminder_date');
        }


//     $data =  $this->db->query('SELECT *  from crm_task_reminder where DATE_SUB(date(`crm_task_reminder_date`), INTERVAL crm_task_reminder_before DAY) = CURDATE()');
//$data =  $this->db->query('SELECT *  from crm_task_reminder where   now()  >=  crm_task_reminder_before  and now()  <=  crm_task_reminder_date');

        $data = $data->result();

        return $data;
    }

    public function get_task_complete() {

        $emplo = $_SESSION['employee_id'];
        if ($_SESSION['administrator_privilage'] == 'no') {
            $query = "(";
            $query .= " `crm_task_details_owner` = " . $_SESSION['user_id'];
            $query .= " OR FIND_IN_SET('" . $emplo . "',crm_task_details_assigned_to_id) != 0";



            $query .= ")";
            $data = $this->db->query('SELECT *  from crm_task_details where  `crm_task_details_status` =  "active" and  now()  >=  crm_task_details_reminder_date  and now()  <=  crm_task_details_due_date  and ' . $query);
        } else {
            $data = $this->db->query('SELECT *  from crm_task_details where  `crm_task_details_status` =  "active" and  now()  >=  crm_task_details_reminder_date  and now()  <=  crm_task_details_due_date');
        }
        $data = $data->result();

        return $data;
    }

    function get_sender_details() {
        $this->db->select('*');
        $this->db->from('email_settings');
        $this->db->where('email_settings_id', 1);
        return $this->db->get()->row();
    }

    function send_email_task($email) {
        $sender = $this->get_sender_details();

        $config['protocol'] = 'smtp';
        $config['smtp_host'] = $sender->smtp_server;
        $config['smtp_port'] = $sender->smtp_port;
        $config['smtp_user'] = $sender->email_id;
        $config['smtp_pass'] = $sender->email_password;
        $from = $this->mastermodel->get_single_field_value('user', 'email', 'user_id', $_SESSION['user_id']);
        $config['smtp_crypto'] = "ssl";
        $config['mailtype'] = 'html';
        $config['charset'] = 'iso-8859-1';
        $this->load->library('email', $config);
        $this->email->set_newline("\r\n");
        $this->email->from($from, $sender->email_name);
        $this->email->to($email['to']);
        $this->email->cc($email['cc']);

        $this->email->subject($email['subject']);

        $this->email->message($email['message']);
        if (!empty($email['attachment'])) {
            $this->email->attach($email['attachment']);
        }
        return $this->email->send();
    }

    function update_deal_status($deal_id, $status_id) {
        $this->db->select('user.email,crm_deal_details.crm_deal_details_title,crm_deal_details_status_id');
        $this->db->from('crm_deal_details');
        $this->db->join('user', 'user.user_id=crm_deal_details.crm_deal_details_owner');
        $this->db->where('crm_deal_details.crm_deal_details_id', $deal_id);
        $deal = $this->db->get()->row();

        $this->db->where('crm_deal_details.crm_deal_details_id', $deal_id);
        $this->db->update('crm_deal_details', array('crm_deal_details_status_id' => $status_id));

        $status_change_id = $this->mastermodel->insertmasterdata();
        $tblValues_status = array(
            'status_change_id' => $status_change_id,
            'deal_id' => $deal_id,
            'status_id' => $deal->crm_deal_details_status_id,
            'to_status_id' => $status_id,
            'change_date_time' => date("Y-m-d H:i:s"),
            'change_user' => $_SESSION['user_id'],
        );

        $this->db->insert('crm_deal_status_change_history', $tblValues_status);

        $email['message'] = '<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- [if !mso]> <!-->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- <![endif] -->
    <meta name="format-detection" content="telephone=no">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>MAIL TEMPLATE</title>
<style>
table{
	width: 100%;
	max-width: 600px;
	border: 1px solid #848f99;
	border-radius: 6px;
	text-align: center;
	vertical-align: middle;
	margin-left: auto;
	margin-right: auto;
}
th{
	padding: 4% 11%;
}
.odd {
	text-align: left;
	color: #9ca6af;
	width: 30%;
	padding: 2% 11%;
}
.even {
	text-align: left;
	width: 80%;
	padding: 2% 0%;
}
#header
{
    color: #008ce3;
    max-width: 600px;
    font-size: 26px;
    margin-left: auto;
    margin-right: auto;
}
a{
    font-size: 13px;
}
</style>
</head>
	<body align="center">
                <div style="color: #008ce3;max-width: 600px;font-size: 26px;margin-left: auto;margin-right: auto;">
                    Your Task "' . $deal->crm_deal_details_title . '"</span> status has changed from <span>"' . $this->mastermodel->get_single_field_value('crm_deal_status', 'crm_deal_status_name', 'crm_deal_status_id', $deal->crm_deal_details_status_id) . '"</span> to <span>"' . $this->mastermodel->get_single_field_value('crm_deal_status', 'crm_deal_status_name', 'crm_deal_status_id', $status_id) . '"</span> by <span>' . $_SESSION['user_name'] . '</span>
                
                </div>
            <a href="' . site_url() . '">	View Task in ERP</a>
    	</body>
</html>
  
  
</body>
</html>';
        $email['to'] = $deal->email;
        $cc = $this->mastermodel->get_single_field_value('company', 'cc_other', 'project_id', $_SESSION['project_id']);
        $email['cc'] = $cc;
        $email['subject'] = 'Deal Status Has Changed';
        return $this->send_email_task($email);
    }

    function update_lead_status($lead_id, $status_id) {
        $this->db->select('*');
        $this->db->from('crm_lead_details');
        $this->db->join('user', 'user.user_id=crm_lead_details.crm_lead_details_user_id');
        $this->db->where('crm_lead_details.crm_lead_details_id', $lead_id);
        $lead = $this->db->get()->row();

        $this->db->where('crm_lead_details.crm_lead_details_id', $lead_id);
        $this->db->update('crm_lead_details', array('crm_lead_details_lead_status_id' => $status_id));
        $status_change_id = $this->mastermodel->insertmasterdata();
        $tblValues_status = array(
            'status_change_id' => $status_change_id,
            'lead_id' => $lead_id,
            'status_id' => $lead->crm_lead_details_lead_status_id,
            'to_status_id' => $status_id,
            'change_date_time' => date("Y-m-d H:i:s"),
            'change_user' => $_SESSION['user_id'],
        );

        $this->db->insert('crm_lead_status_change_history', $tblValues_status);

        $email['message'] = '<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- [if !mso]> <!-->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- <![endif] -->
    <meta name="format-detection" content="telephone=no">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>MAIL TEMPLATE</title>
<style>
table{
	width: 100%;
	max-width: 600px;
	border: 1px solid #848f99;
	border-radius: 6px;
	text-align: center;
	vertical-align: middle;
	margin-left: auto;
	margin-right: auto;
}
th{
	padding: 4% 11%;
}
.odd {
	text-align: left;
	color: #9ca6af;
	width: 30%;
	padding: 2% 11%;
}
.even {
	text-align: left;
	width: 80%;
	padding: 2% 0%;
}
#header
{
    color: #008ce3;
    max-width: 600px;
    font-size: 26px;
    margin-left: auto;
    margin-right: auto;
}
a{
    font-size: 13px;
}
</style>
</head>
	<body align="center">
                <div style="color: #008ce3;max-width: 600px;font-size: 26px;margin-left: auto;margin-right: auto;">
                    Your Lead "' . $lead->crm_lead_details_title . '"</span> status has changed from <span>"' . $this->mastermodel->get_single_field_value('crm_lead_status', 'crm_lead_status_name', 'crm_lead_status_id', $lead->crm_lead_details_lead_status_id) . '"</span> to <span>"' . $this->mastermodel->get_single_field_value('crm_lead_status', 'crm_lead_status_name', 'crm_lead_status_id', $status_id) . '"</span> by <span>' . $_SESSION['user_name'] . '</span>
                
                </div>
            <a href="' . site_url() . '">	View Lead in ERP</a>
    	</body>
</html>
  
  
</body>
</html>';
        $email['to'] = $lead->email;
        $cc = $this->mastermodel->get_single_field_value('company', 'cc_other', 'project_id', $_SESSION['project_id']);
        $email['cc'] = $cc;
        $email['subject'] = 'Lead Status Has Changed';

        return $this->send_email_task($email);
    }

    public function get_comaplaints_reminder() {
        $data = array();
        $this->db->select('complaints_note.*,note_type.*');
        $this->db->from('complaints_note');

        $this->db->join('master', 'master.master_id=complaints_note.complaints_note_id');
        $this->db->join('note_type', 'note_type.note_type_id=complaints_note.complaints_note_type_id');
        $this->db->where('master.owner_id', $_SESSION['user_id']);
        $this->db->where('complaints_note.complaints_note_remider_date', date("Y-m-d"));
        $data = $this->db->get()->result();

        return $data;
    }

    public function send_contact_mail($postdata) {
        $status = false;

        $file_name = $this->mastermodel->upload_image('attachment');
        if (!empty($file_name)) {
            $email['to'] = $postdata['crm_more_contact_email'];
            $cc = $this->mastermodel->get_single_field_value('company', 'cc_customer', 'project_id', $_SESSION['project_id']);
            $email['cc'] = $cc;
            $email['attachment'] = 'assets/uploads/' . $file_name["file_name"];
            $email['subject'] = $this->mastermodel->get_single_field_value('mail_template', 'template_name', 'template_id', $postdata['subject']);
            $email['message'] = '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">' . $postdata['mail_body'] . '<pre>';

            $status = $this->send_email_task($email);
        }
        return $status;
    }

    public function send_quotation_mail($postdata) {
        $status = false;

        $file_name = $this->mastermodel->upload_image('attachment');
        if (!empty($file_name)) {
            $email['to'] = $postdata['crm_more_contact_email'];
            $cc[] = $this->mastermodel->get_single_field_value('company', 'cc_customer', 'project_id', $_SESSION['project_id']);
            $i = 1;
            while (isset($postdata['crm_more_contact_emailcc' . $i]) && !empty($postdata['crm_more_contact_emailcc' . $i])) {
                $cc[] = $postdata['crm_more_contact_emailcc' . $i];
                $i++;
            }
            $email['cc'] = $cc;
            $email['attachment'] = 'assets/uploads/' . $file_name["file_name"];
            $email['subject'] = $this->mastermodel->get_single_field_value('mail_template', 'template_name', 'template_id', $postdata['subject']);
            $email['message'] = '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">' . $postdata['mail_body'] . '<pre>';

            $status = $this->send_email_task($email);
        }
        return $status;
    }

    function change_status($table, $id, $field, $status_field) {
        $data = array();
        $output = $this->mastermodel->save_user_activities('Change ' . $table . ' status', $id, $table);  //ss

        $this->db->trans_begin();
        $tblValues = array(
            $status_field => 1
        );
        $this->db->where($field, $id);
        $this->db->update($table, $tblValues);

        $this->db->trans_status();
        $title = '';
        $title1 = '';
        $to = array();
        switch ($table) {
            case 'crm_lead_details':
                $this->db->select('crm_lead_details_title,crm_lead_details_user_id,crm_lead_hr_employees_id as assign');
                $this->db->from('crm_lead_details');
//                $this->db->join('user','user.user_id=crm_lead_details.crm_lead_details_user_id');
                $this->db->where($field, $id);
                $lead = $this->db->get()->row();

                $to[] = $this->mastermodel->get_single_field_value('user', 'email', 'user_id', $lead->crm_lead_details_user_id);
                foreach (explode(',', $lead->assign) as $item) {
                    if (!empty($item)) {
                        $to[] = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_email', 'hr_employees_id', $item);
                    }
                }
                $title = $lead->crm_lead_details_title;
                $title1 = 'Lead';
                break;
            case 'crm_task_details':
                $this->db->select('crm_task_details_title,crm_task_details_assigned_to_id as assign,crm_task_details_owner');
                $this->db->from('crm_task_details');
//                $this->db->join('user','user.user_id=crm_task_details.crm_task_details_owner');
                $this->db->where($field, $id);
                $task = $this->db->get()->row();
                $to[] = $this->mastermodel->get_single_field_value('user', 'email', 'user_id', $task->crm_task_details_owner);
                foreach (explode(',', $task->assign) as $item) {
                    if (!empty($item)) {
                        $to[] = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_email', 'hr_employees_id', $item);
                    }
                }
                $title = $task->crm_task_details_title;
                $title1 = 'Task';
                break;
            case 'crm_deal_details':
                $this->db->select('crm_deal_details_title,crm_deal_details_owner');
                $this->db->from('crm_deal_details');
//                $this->db->join('user','user.user_id=crm_deal_details.crm_deal_details_owner');
                $this->db->where($field, $id);
                $deal = $this->db->get()->row();
                $to[] = $this->mastermodel->get_single_field_value('user', 'email', 'user_id', $deal->crm_deal_details_owner);
                $title = $deal->crm_deal_details_title;
                $title1 = 'Deal';

                break;
        }
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Unable to Change status';
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Status Changed';
            $email['message'] = '<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- [if !mso]> <!-->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- <![endif] -->
    <meta name="format-detection" content="telephone=no">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>MAIL TEMPLATE</title>
<style>
table{
	width: 100%;
	max-width: 600px;
	border: 1px solid #848f99;
	border-radius: 6px;
	text-align: center;
	vertical-align: middle;
	margin-left: auto;
	margin-right: auto;
}
th{
	padding: 4% 11%;
}
.odd {
	text-align: left;
	color: #9ca6af;
	width: 30%;
	padding: 2% 11%;
}
.even {
	text-align: left;
	width: 80%;
	padding: 2% 0%;
}
#header
{
    color: #008ce3;
    max-width: 600px;
    font-size: 26px;
    margin-left: auto;
    margin-right: auto;
}
a{
    font-size: 13px;
}
</style>
</head>
	<body align="center">
                <div style="color: #008ce3;max-width: 600px;font-size: 26px;margin-left: auto;margin-right: auto;">
                    Your ' . $title1 . ' "' . $title . ' " has Completed!!!"
                
                </div>
            <a href="' . site_url() . '">	View ' . $title . ' in ERP</a>
    	</body>
</html>
  
  
</body>
</html>';
            $email['to'] = $to;
            $cc = $this->mastermodel->get_single_field_value('company', 'cc_other', 'project_id', $_SESSION['project_id']);
            $email['cc'] = $cc;
            $email['subject'] = $title1 . ' Status Has Changed';
            $this->send_email_task($email);
        }
        return $data;
    }

    function add_task_note($postdata) {
        $data = array();
        $this->db->trans_begin();


        $i = 0;
        while (!empty($postdata['task_comments_date' . ++$i])) {
            $tblValues = array(
                'note_id' => $this->mastermodel->insertmasterdata(),
                'note_task_id' => $postdata['task_id'],
                'note_user_id' => $_SESSION['user_id'],
                'note_time' => $this->mastermodel->convert_date_format($postdata['task_comments_date' . $i]),
                'note' => $postdata['task_comments_comments' . $i]
            );
            $this->db->insert('task_note', $tblValues);
        }


        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function add_complaints_note($postdata) {
        print_r($postdata);
        $data = array();
        $this->db->trans_begin();
        $code = $this->mastermodel->get_ref('complaints_note_code', 'complaints_note', 'complaints_note_code');

        if ($postdata['reminder_check'] != '1') {
            $postdata['complaints_note_remider_date'] = '00/00/0000';
        }

        $upload_data = $this->mastermodel->upload_image('debtor_doc_attachment');
        if (!empty($upload_data['file_name'])) {
            $file_name = $upload_data['file_name'];
        }

        $tblValues = array(
            'complaints_note_id' => $this->mastermodel->insertmasterdata(),
            'complaints_note_complaints_id' => $postdata['complaints_id'],
            'complaints_note_code' => $code,
            'complaints_note_date' => date("Y-m-d"),
            'complaints_note_user_id' => $_SESSION['user_id'],
            'complaints_note_type_id' => $postdata['complaints_note_type_id'],
            'complaints_note_note' => $postdata['complaints_note_note'],
            'complaints_note_remider_date' => $this->mastermodel->convert_date_format($postdata['complaints_note_remider_date']),
            'court_location' => $postdata['court_location'],
            'case_number' => $postdata['case_number'],
            'excecution_number' => $postdata['excecution_number'],
            'case_level' => $postdata['case_level'],
            'documents' => $file_name,
//'note_templates'=>$postdata['note_templates'],
            'update' => $postdata['update'],
            'next_session_date' => $this->mastermodel->convert_date_format($postdata['next_session_date']),
            'closed_date' => $this->mastermodel->convert_date_format($postdata['closed_date'])
        );
        $this->db->insert('complaints_note', $tblValues);

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function add_lead_note($postdata) {
        $data = array();
        $this->db->trans_begin();
        $id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'note_id' => $id,
            'note_lead_id' => $postdata['lead_id'],
            'note_user_id' => $_SESSION['user_id'],
            'note_time' => date("Y-m-d H:i:s"),
            'note' => $postdata['notes'],
        );
        $this->db->insert('crm_lead_note', $tblValues);

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function add_contact_note($postdata) {
        $data = array();
        $this->db->trans_begin();
        $id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'note_id' => $id,
            'note_contact_id' => $postdata['contact_id'],
            'note_user_id' => $_SESSION['user_id'],
            'note_time' => date("Y-m-d H:i:s"),
            'note' => $postdata['notes'],
        );
        $this->db->insert('crm_contact_note', $tblValues);

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function add_deal_note($postdata) {
        $data = array();
        $this->db->trans_begin();
        $id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'note_id' => $id,
            'note_deal_id' => $postdata['deal_id'],
            'note_user_id' => $_SESSION['user_id'],
            'note_time' => date("Y-m-d H:i:s"),
            'note' => $postdata['notes'],
        );
        $this->db->insert('crm_deal_note', $tblValues);

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function search_crm_lawyer() {
        $data = array();
        $this->db->select('*');
        $this->db->from('lawyer');
        //$this->db->join('sub_document','sub_document.document_id=document.document_id');
        $this->db->join('master', 'master.master_id=lawyer.lawyer_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('lawyer_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function insert_crm_lawyer($postdata) {
        $data = array();
        $this->db->trans_begin();
        $lawyer_id = $this->mastermodel->insertmasterdata();
        $lawyer_code = $this->mastermodel->get_ref('lawyer_code', 'lawyer', 'lawyer_code');
        $set = $this->accountingmodel->get_account_settings('lawyer');
        $ledger_id = $this->mastermodel->insertmasterdata();



        $profile_settings = $this->mastermodel->get_profile_settings();
        $role_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules', 'profile_id', $profile_settings->lawyer_profile_id);
        $modules_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules_permission', 'profile_id', $profile_settings->lawyer_profile_id);
        $username = trim($postdata['lawyer_first_name'] . " " . $postdata['lawyer_last_name']);

        $user_id = $this->mastermodel->insertmasterdata();

        $tblValues = array(
            'user_id' => $user_id,
            'user_name' => $username,
            'phone' => $postdata['lawyer_phone'],
            'email' => $postdata['lawyer_email'],
            'password' => md5($postdata['lawyer_first_name']),
            'profile_id' => $profile_settings->lawyer_profile_id,
            'user_modules' => $role_permission,
            'modules_permission' => $modules_permission,
//            'home_page' => $postdata['role_home_page'],
            'manager_approve' => 0,
            'gm_approve' => 0,
            'lawyer_id' => $lawyer_id,
            'branch_id' => $_SESSION['master_branch']
        );
        $this->db->insert('user', $tblValues);
        $tblValues = array(
            'ledger_id' => $ledger_id,
            'account_group_id' => $set,
            'ledger_name' => $postdata['lawyer_first_name'] . " " . $postdata['lawyer_last_name'],
            'mailing_name' => $postdata['lawyer_first_name'] . " " . $postdata['lawyer_last_name'],
//            'address' => $postdata['address'],
            'phone' => $postdata['lawyer_phone'],
            'mobile' => $postdata['lawyer_mob_1'],
            'email' => $postdata['lawyer_email'],
            'is_party' => 1,
        );
        $output = $this->db->insert('account_ledger', $tblValues);
        $tblValues1 = array(
            'lawyer_id' => $lawyer_id,
            'lawyer_code' => $lawyer_code,
            'lawyer_owner' => $postdata['lawyer_owner'],
            'lawyer_nationality' => $postdata['lawyer_nationality'],
            'lawyer_first_name' => $postdata['lawyer_first_name'],
            'lawyer_last_name' => $postdata['lawyer_last_name'],
            'lawyer_email' => $postdata['lawyer_email'],
            'lawyer_phone' => $postdata['lawyer_phone'],
            'lawyer_mob_1' => $postdata['lawyer_mobile_1'],
            'lawyer_mob_2' => $postdata['lawyer_mobile_2'],
            'lawyer_fax' => $postdata['lawyer_fax'],
            'lawyer_skype_id' => $postdata['lawyer_skype_id'],
            'lawyer_notes' => $postdata['lawyer_notes'],
            'ledger' => $ledger_id,
            'user_id' => $user_id
        );
        $this->db->insert('lawyer', $tblValues1);

        $k = 1;
        while (isset($postdata['lawyer_sub_name' . $k]) && !empty($postdata['lawyer_sub_name' . $k])) {
            $lawyer_sub_id = $this->mastermodel->insertmasterdata();
            $tblValues_more_contact = array(
                'lawyer_sub_id' => $lawyer_sub_id,
                'lawyer_sub_contact_id' => $lawyer_id,
                'lawyer_sub_name' => $postdata['lawyer_sub_name' . $k],
//                'contact_sub_designation' => $postdata['crm_more_contact_designation' . $k],
                'lawyer_sub_mobile' => $postdata['lawyer_sub_mobile' . $k],
                'lawyer_sub_phone' => $postdata['lawyer_sub_phone' . $k],
                'lawyer_sub_email' => $postdata['lawyer_sub_email' . $k],
            );
            $this->db->insert('lawyer_sub', $tblValues_more_contact);
            $k++;
        }
//       
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_crm_lawyer($postdata) {
        $data = array();
        $this->db->trans_begin();

        if (empty($postdata['user_id'])) {
            $profile_settings = $this->mastermodel->get_profile_settings();
            $role_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules', 'profile_id', $profile_settings->lawyer_profile_id);
            $modules_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules_permission', 'profile_id', $profile_settings->lawyer_profile_id);
            $username = trim($postdata['lawyer_first_name'] . " " . $postdata['lawyer_last_name']);

            $user_id = $this->mastermodel->insertmasterdata();

            $tblValues = array(
                'user_id' => $user_id,
                'user_name' => $username,
                'phone' => $postdata['lawyer_phone'],
                'email' => $postdata['lawyer_email'],
                'password' => md5($postdata['lawyer_first_name']),
                'profile_id' => $profile_settings->lawyer_profile_id,
                'user_modules' => $role_permission,
                'modules_permission' => $modules_permission,
//            'home_page' => $postdata['role_home_page'],
                'manager_approve' => 0,
                'gm_approve' => 0,
                'lawyer_id' => $postdata['lawyer_id'],
                'branch_id' => $_SESSION['master_branch']
            );
            $this->db->insert('user', $tblValues);
        } else {

            $tblValues_user = array(
                'phone' => $postdata['lawyer_phone'],
                'email' => $postdata['lawyer_email'],
                'branch_id' => $_SESSION['master_branch']
            );
            $this->db->where('lawyer_id', $postdata['lawyer_id']);
            $this->db->update('user', $tblValues_user);
        }



        $set = $this->accountingmodel->get_account_settings('lawyer');
        $tblValues = array(
            'account_group_id' => $set,
            'ledger_name' => $postdata['lawyer_first_name'] . " " . $postdata['lawyer_last_name'],
            'mailing_name' => $postdata['lawyer_first_name'] . " " . $postdata['lawyer_last_name'],
//            'address' => $postdata['address'],
            'phone' => $postdata['lawyer_phone'],
            'mobile' => $postdata['lawyer_mob_1'],
            'email' => $postdata['lawyer_email'],
            'is_party' => 1,
        );
        $this->db->where('ledger_id', $postdata['ledger_id']);
        $output = $this->db->update('account_ledger', $tblValues);
        $tblValues = array(
            'lawyer_nationality' => $postdata['lawyer_nationality'],
            'lawyer_first_name' => $postdata['lawyer_first_name'],
            'lawyer_last_name' => $postdata['lawyer_last_name'],
            'lawyer_email' => $postdata['lawyer_email'],
            'lawyer_phone' => $postdata['lawyer_phone'],
            'lawyer_mob_1' => $postdata['lawyer_mobile_1'],
            'lawyer_mob_2' => $postdata['lawyer_mobile_2'],
            'lawyer_fax' => $postdata['lawyer_fax'],
            'lawyer_skype_id' => $postdata['lawyer_skype_id'],
            'lawyer_notes' => $postdata['lawyer_notes'],
        );
        if (empty($postdata['user_id'])) {

            $tblValues['user_id'] = $user_id;
        }
        $this->db->where('lawyer_id', $postdata['lawyer_id']);
        $this->db->update('lawyer', $tblValues);

        $this->db->where('lawyer_sub_contact_id', $postdata['lawyer_id']);
        $this->db->delete('lawyer_sub');

        $k = 1;
        while (isset($postdata['lawyer_sub_name' . $k]) && !empty($postdata['lawyer_sub_name' . $k])) {
            $lawyer_sub_id = $this->mastermodel->insertmasterdata();
            $tblValues_more_contact = array(
                'lawyer_sub_id' => $lawyer_sub_id,
                'lawyer_sub_contact_id' => $postdata['lawyer_id'],
                'lawyer_sub_name' => $postdata['lawyer_sub_name' . $k],
//                'contact_sub_designation' => $postdata['crm_more_contact_designation' . $k],
                'lawyer_sub_mobile' => $postdata['lawyer_sub_mobile' . $k],
                'lawyer_sub_phone' => $postdata['lawyer_sub_phone' . $k],
                'lawyer_sub_email' => $postdata['lawyer_sub_email' . $k],
            );
            $this->db->insert('lawyer_sub', $tblValues_more_contact);
            $k++;
        }




        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_ptp() {
                $credior_id_s=$this->mastermodel->get_single_field_value('contact','contact_id','user_id',$_SESSION['user_id']);

        $profile_settings = $this->mastermodel->get_profile_settings();
        $data = array();
        $this->db->select('*');
        $this->db->from('ptp');
        $this->db->join('complaints', 'complaints.complaints_id=ptp.ptp_complaints_id', 'left');
        $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id', 'left');
        $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id', 'left');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_creditor_id', $credior_id_s);
        }
        if ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_assign_ids', $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_id', 'user_id', $_SESSION['user_id']));
        }
        if (($profile_settings->legal_profile_id == $_SESSION['profile_id']) || ($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('complaints.complaints_lawyer_id', $this->mastermodel->get_single_field_value('lawyer', 'lawyer_id', 'user_id', $_SESSION['user_id']));
        }
        // $this->db->where('ptp.ptp_note !=', "direct_note");
               // $this->db->where('ptp.ptp_note !=', "other_note");

        // $this->db->join('master', 'master.master_id=ptp.ptp_id');
        // $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('ptp_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_ptp($postdata) {
        $data = array();
        $this->db->trans_begin();
        $master_id = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('ptp_code', 'ptp', 'ptp_code');

        $tblValues = array(
            'ptp_id' => $master_id,
            'ptp_code' => $code,
            'ptp_date' => $this->mastermodel->convert_date_format($postdata['ptp_date']),
            'ptp_amount' => $postdata['ptp_amount'],
            'ptp_installments' => $postdata['ptp_installments'],
            'ptp_frequency' => $postdata['ptp_frequency'],
            'ptp_start_date' => $this->mastermodel->convert_date_format($postdata['ptp_start_date']),
            'ptp_due_date' => $this->mastermodel->convert_date_format($postdata['ptp_due_date']),
            'ptp_complaints_id' => $postdata['ptp_complaints_id'],
            'ptp_note' => $postdata['ptp_note'],
        );

        $this->db->insert('ptp', $tblValues);

        $i = 1;
        while (!empty($postdata['payment_plan_amount' . $i])) {

            $tblValues = array(
                'ptp_payment_plan_id' => $this->mastermodel->insertmasterdata(),
                'payment_plan_ptp_id' => $master_id,
                'payment_plan_amount' => $postdata['payment_plan_amount' . $i],
                'payment_plan_date' => $this->mastermodel->convert_date_format($postdata['payment_plan_date' . $i]),
            );

            $this->db->insert('ptp_payment_plan', $tblValues);
            $i++;
        }

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function ptp_payment($postdata) {
        $data = array();
        $this->db->trans_begin();
        $i = 1;
        $paid = 0;

        while (!empty($postdata['payment_plan_paid_amount' . $i])) {
            $paid += $postdata['payment_plan_paid_amount' . $i];

            $tblValues = array(
                'payment_plan_paid_amount' => $postdata['payment_plan_paid_amount' . $i],
                'payment_plan_paid_date' => $this->mastermodel->convert_date_format($postdata['payment_plan_paid_date' . $i]),
                'payment_plan_description' => $postdata['payment_plan_description' . $i],
                'payment_plan_mode' => $postdata['payment_plan_mode' . $i],
                'payment_plan_transferred' => $postdata['payment_plan_transferred' . $i],
                'payment_plan_trans_date' => $this->mastermodel->convert_date_format($postdata['payment_plan_trans_date' . $i]),
                'payment_plan_trans_note' => $postdata['payment_plan_trans_note' . $i],
                'payment_plan_commission' => $postdata['payment_plan_commission' . $i],
            );
            $this->db->where('ptp_payment_plan_id', $postdata['ptp_payment_plan_id' . $i]);
            $this->db->update('ptp_payment_plan', $tblValues);
            $i++;
        }
        if (isset($postdata['partial_payment'])) {
 $total = $postdata['payment_plan_amount1'];
            $amount = $total - $paid;
            if ($amount > 0) {
                $master_id_ptp = $postdata['payment_plan_ptp_id1'];
               
                $ptp_payment_plan_id = $this->mastermodel->insertmasterdata();
                $tblValues1 = array(
                    'ptp_payment_plan_id' => $ptp_payment_plan_id,
                    'payment_plan_ptp_id' => $master_id_ptp,
                    'payment_plan_amount' => $total - $paid,
                    'payment_plan_date' => $this->mastermodel->convert_date_format(date('d/m/Y')),
                );

                $this->db->insert('ptp_payment_plan', $tblValues1);
            }
        }

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function add_legal($postdata) {

        $data = array();
        $this->db->trans_begin();
        $tblValues1['complaints_lawyer_id'] = $postdata['legal_lawyer_id'];
        $this->db->where('complaints_id', $postdata['legal_complaints_id']);
        $this->db->update('complaints', $tblValues1);

        $tblValues = array(
            'legal_date' => $this->mastermodel->convert_date_format($postdata['legal_date']),
            'legal_lawyer_id' => $postdata['legal_lawyer_id'],
            'legal_note' => $this->mastermodel->get_single_field_value('crm_terms_condition', 'crm_terms_condition_title', 'crm_terms_condition_id', $postdata['quotation_terms']),
            'legal_complaints_id' => $postdata['legal_complaints_id'],
            'legal_templates' => $postdata['terms_cntnt'],
        );
        if (empty($postdata['legal_id'])) {
            $id = $this->mastermodel->insertmasterdata();
            $code = $this->mastermodel->get_ref('legal_code', 'legal', 'legal_code');
            $tblValues['legal_id'] = $id;

            $tblValues['legal_code'] = $code;
            $this->db->insert('legal', $tblValues);
        } else {
            $this->db->where('legal_id', $postdata['legal_id']);
            $this->db->update('legal', $tblValues);
        }


        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function add_expense($postdata) {
        $data = array();
        $this->db->trans_begin();
        $id = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('expense_code', 'expense', 'expense_code');
        $tblValues = array(
            'expense_id' => $id,
            'expense_code' => $code,
            'expense_date' => $this->mastermodel->convert_date_format($postdata['expense_date']),
            'expense_lawyer_id' => $postdata['expense_lawyer_id'],
            'expense_note' => $postdata['expense_note'],
            'expense_complaints_id' => $postdata['expense_complaints_id'],
            'expense_amount' => $postdata['expense_amount'],
        );

        $this->db->insert('expense', $tblValues);


        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function get_ptp($id) {
        $data = array();
        $this->db->select('*');
        $this->db->from('ptp');
        $this->db->join('complaints', 'complaints.complaints_id=ptp.ptp_complaints_id');
        $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id');
        $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id');

        $this->db->join('master', 'master.master_id=ptp.ptp_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('ptp.ptp_id', $id);
        $this->db->order_by('ptp_id', 'desc');
        $data = $this->db->get()->row();
        return $data;
    }

    public function ptp_approval($ptpid) {
        $tblValues = array(
            'ptp_approve' => 1,
        );
        $this->db->where('ptp_id', $ptpid);
        $output = $this->db->update('ptp', $tblValues);

        $status = $output;
    }

    public function update_invoice_status($ptpid) {
        $tblValues = array(
            'ptp_plan_invoiced' => 1,
        );
        $this->db->where('payment_plan_ptp_id', $ptpid);
        $output = $this->db->update('ptp_payment_plan', $tblValues);

        $status = $output;
    }

    public function get_complaint($postdata) {
        $data = array();
        $this->db->select('*');
        $this->db->from('complaints');
        if (!empty($postdata['task_debtor_id'])) {
            $this->db->where('complaints_debtor_id', $postdata['task_debtor_id']);
        }
        if (!empty($postdata['task_creditor_id'])) {
            $this->db->where('complaints_creditor_id', $postdata['task_creditor_id']);
        }

        $data = $this->db->get()->result();
        return $data;
    }

    function excel_insert($data_debtor, $data_complaint, $data_complaint_status) {

        $data = array();
        $this->db->trans_begin();
        foreach ($data_debtor as $row) {

            $this->db->insert('debtor', $row);
        }

        foreach ($data_complaint as $row) {

            $this->db->insert('complaints', $row);
        }

        foreach ($data_complaint_status as $row) {

            $this->db->insert('complaints_status', $row);
        }



        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function get_complaints($field1 = '', $value1 = '', $field2 = '', $value2 = '') {
        $profile_settings = $this->mastermodel->get_profile_settings();
        $data = array();
        $this->db->select('*');
        $this->db->from('complaints');
        $this->db->order_by('complaints_id', 'desc');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('contact.user_id', $_SESSION['user_id']);
        }
        if ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_assign_ids', $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_id', 'user_id', $_SESSION['user_id']));
        }
        if (($profile_settings->legal_profile_id == $_SESSION['profile_id']) || ($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('complaints.complaints_lawyer_id', $this->mastermodel->get_single_field_value('lawyer', 'lawyer_id', 'user_id', $_SESSION['user_id']));
        }
        if ($field1 != '')
            $this->db->where($field1, $value1);
        if ($field2 != '')
            $this->db->where($field2, $value2);
        $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id');
        // $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id');
        $data['results'] = $this->db->get();
        return $data;
    }
 function get_complaints_dashboard($field1 = '', $value1 = '', $field2 = '', $value2 = '') {
        $profile_settings = $this->mastermodel->get_profile_settings();
        $data = array();
        $this->db->select('count(*) as counts,debtor.debtor_contact_id');
        $this->db->from('complaints');
        $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id');
        $this->db->order_by('complaints_id', 'desc');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('debtor.debtor_contact_id', $_SESSION['user_id']);
        }
        if ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_assign_ids', $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_id', 'user_id', $_SESSION['user_id']));
        }
        if (($profile_settings->legal_profile_id == $_SESSION['profile_id']) || ($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('complaints.complaints_lawyer_id', $this->mastermodel->get_single_field_value('lawyer', 'lawyer_id', 'user_id', $_SESSION['user_id']));
        }
        if ($field1 != '')
            $this->db->where($field1, $value1);
        if ($field2 != '')
            $this->db->where($field2, $value2);
        
        // $this->db->join('contact', 'contact.contact_id=complaints.complaints_creditor_id');
        $data = $this->db->count_all_results();
        return $data;
    }









    function readExcelData() {
        $data = array();
        $this->db->trans_begin();

        $config['upload_path'] = './assets/uploads/';
        $config['allowed_types'] = '*';
        $config['max_size'] = '200000';
        $config['max_height'] = '200000';
        $config['max_width'] = '200000';
        $config['remove_spaces'] = true;
        $config['overwrite'] = false;

        $this->load->library('upload', $config);

        if ($this->upload->do_upload('excel')) {
            $upload_data = $this->upload->data();
        } else {
            $upload_data = array('error' => $this->upload->display_errors());
        }
       // $filename = "/home/makanerp/public_html/matrix/assets/uploads/". $upload_data['file_name'];
       
        $filename = "https://erp.matrixdebtc.com/assets/uploads/". $upload_data['file_name'];
        $file = fopen($filename, "r");
$row=1;
        while (($emapData = fgetcsv($file, 100000, ",")) !== FALSE) {
 $num = count($emapData);
if($row>1){

         $data= $this->excel_import($emapData);
}
$row++;
           
        }
        fclose($file);
        return $data;
    }
   public function excel_import($emapData) {
        $data = array();
        $this->db->trans_begin();
     //   print_r($emapData);
       // print_r($emapData); die();
if($this->mastermodel->check_already_exist($emapData[9])){
        $crm_debtor_id = $this->mastermodel->insertmasterdata();
        $crm_debtor_code = $this->mastermodel->get_ref('crm_debtor_code', 'debtor', 'crm_debtor_code');
        $tblValues = array(
            'crm_debtor_id' => $crm_debtor_id,
            'crm_debtor_code' => $crm_debtor_code,
            'debtor_contact_id' => 142069,
            
            
            'crm_debtor_owner' => 7002,
            'crm_debtor_salutation_id' => 1,
            'crm_debtor_first_name' => $emapData[2],
            'crm_debtor_middle_name' => $emapData[3],
            'crm_debtor_last_name' => $emapData[4],
            'crm_debtor_gender' => 'male',
            'crm_debtor_company_name' => $emapData[5],
            'crm_debtor_dob' => $this->mastermodel->convert_date_format('26/12/1989'),
            'crm_debtor_country' => 'Oman',
            'crm_debtor_nationality' => 3628,
            'crm_debtor_mobile_1' => $emapData[14],
            'crm_debtor_mobile_2' => $emapData[15],
            'crm_debtor_phone' => $emapData[16],
            'crm_debtor_branch' => $emapData[80],
            
            'crm_debtor_id_number' => $emapData[81],
            'crm_debtor_cr_number' => $emapData[82],
            'crm_debtor_gid_number' => $emapData[83],
            'crm_debtor_g2id_number' => $emapData[84],
            'crm_debtor_contract_year1' => $emapData[85],
            
            
            'crm_debtor_fax' => $emapData[17],
            'crm_debtor_skype_id' => $emapData[18],
            'crm_debtor_email' => $emapData[19],
            'crm_debtor_residential_address' => $emapData[20],
            'crm_debtor_residential_street' => $emapData[21],
            'crm_debtor_residential_city' => $emapData[22],
            'crm_debtor_residential_state' => $emapData[23],
            'crm_debtor_residential_zipcode' => $emapData[24],
            'crm_debtor_residential_country' => 'Oman',
            'crm_debtor_curr_empname' => $emapData[26],
            'crm_debtor_curr_empaddress' => $emapData[27],
            'crm_debtor_curr_empdesignation' => $emapData[28],
            'crm_debtor_curr_empyear' => $emapData[29],
            'crm_debtor_curr_empdetails' => $emapData[30],
            'crm_debtor_part_empname' => $emapData[31],
            'crm_debtor_part_empaddress' => $emapData[32],
            'crm_debtor_part_empdesignation' => $emapData[33],
            'crm_debtor_part_empdetails' => $emapData[34],
            'crm_debtor_part_empyear' => $emapData[35],
            'debtor_selfincome_totalamount' => $emapData[36],
            'debtor_partincome_totalamount' => $emapData[37],
            'debtor_recexp_totalamount' => $emapData[42],
            'debtor_loans_totalamount' => $emapData[43],
            'debtor_insurance_totalamount' => $emapData[44],
            'debtor_otherexp_totalamount' => $emapData[45],
            'crm_debtor_home_owner' => $emapData[54],
            'crm_debtor_home_detailes' => $emapData[55],
            'crm_debtor_home_value' => $emapData[56],
            'crm_debtor_home_loan' => $emapData[57],
            'crm_debtor_home_othdetails' => $emapData[58],
            
            'crm_debtor_agreement_no' => $emapData[9],
        );

        $this->db->insert('debtor', $tblValues);

        //$i = 1;
        //while (isset($postdata['debtor_selfincome_amount' . $i]) && !empty($postdata['debtor_selfincome_amount' . $i])) {
            $debtor_selfincome_id = $this->mastermodel->insertmasterdata();
            $debtor_selfincome = array(
                'debtor_selfincome_id' => $debtor_selfincome_id,
                'debtor_id' => $crm_debtor_id,
                'debtor_selfincome_desc' => $emapData[38],
                'debtor_selfincome_amount' => $emapData[39],
            );
            $this->db->insert('debtor_selfincome', $debtor_selfincome);
          //  $i++;
       // }

       // $i = 1;
       // while (isset($postdata['debtor_partincome_amount' . $i]) && !empty($postdata['debtor_partincome_amount' . $i])) {
            $debtor_partincome_id = $this->mastermodel->insertmasterdata();
            $debtor_selfincome = array(
                'debtor_partincome_id' => $debtor_partincome_id,
                'debtor_id' => $crm_debtor_id,
                'debtor_partincome_desc' => $emapData[40],
                'debtor_partincome_amount' => $emapData[41],
            );
            $this->db->insert('debtor_partincome', $debtor_selfincome);
         //   $i++;
      //  }


       // $i = 1;
       // while (isset($postdata['debtor_recexp_amount' . $i]) && !empty($postdata['debtor_recexp_amount' . $i])) {
            $debtor_recexp_id = $this->mastermodel->insertmasterdata();
            $debtor_selfincome = array(
                'debtor_recexp_id' => $debtor_recexp_id,
                'debtor_id' => $crm_debtor_id,
                'debtor_recexp_desc' => $emapData[46],
                'debtor_recexp_amount' => $emapData[47],
            );
            $this->db->insert('debtor_recexp', $debtor_selfincome);
          //  $i++;
       // }

       // $i = 1;
       // while (isset($postdata['debtor_loans_amount' . $i]) && !empty($postdata['debtor_loans_amount' . $i])) {
            $debtor_loans_id = $this->mastermodel->insertmasterdata();
            $debtor_loans = array(
                'debtor_loans_id' => $debtor_loans_id,
                'debtor_id' => $crm_debtor_id,
                'debtor_loans_desc' => $emapData[48],
                'debtor_loans_amount' => $emapData[49],
            );
            $this->db->insert('debtor_loans', $debtor_loans);
          //  $i++;
       // }

      //  $i = 1;
      //  while (isset($postdata['debtor_insurance_amount' . $i]) && !empty($postdata['debtor_insurance_amount' . $i])) {
            $debtor_insurance_id = $this->mastermodel->insertmasterdata();
            $debtor_insurance = array(
                'debtor_insurance_id' => $debtor_insurance_id,
                'debtor_id' => $crm_debtor_id,
                'debtor_insurance_desc' =>$emapData[50],
                'debtor_insurance_amount' => $emapData[51],
            );
            $this->db->insert('debtor_insurance', $debtor_insurance);
         //   $i++;
      //  }

       // $i = 1;
       // while (isset($postdata['debtor_otherexp_amount' . $i]) && !empty($postdata['debtor_otherexp_amount' . $i])) {
            $debtor_otherexp_id = $this->mastermodel->insertmasterdata();
            $debtor_otherexp = array(
                'debtor_otherexp_id' => $debtor_otherexp_id,
                'debtor_id' => $crm_debtor_id,
                'debtor_otherexp_desc' => $emapData[52],
                'debtor_otherexp_amount' => $emapData[53],
            );
            $this->db->insert('debtor_otherexp', $debtor_otherexp);
         //   $i++;
        //}

      //  $i = 1;
       // while (isset($postdata['debtor_property_type' . $i]) && !empty($postdata['debtor_property_type' . $i])) {
            $property_details_id = $this->mastermodel->insertmasterdata();
            $debtor_selfincome = array(
                'property_details_id' => $property_details_id,
                'debtor_id' => $crm_debtor_id,
                'debtor_property_type' => $emapData[59],
                'property_details_desc' => $emapData[60],
                'debtor_ownership_type' => $emapData[61],
                'property_details_value' => $emapData[62],
                'property_details_loanval' => $emapData[63],
            );
            $this->db->insert('debtor_property_details', $debtor_selfincome);
          //  $i++;
       // }


        $i = 1;
       // while (isset($postdata['associated_credit_name' . $i]) && !empty($postdata['associated_credit_name' . $i])) {
            $associated_credit_id = $this->mastermodel->insertmasterdata();
            $associated_credit = array(
                'associated_credit_id' => $associated_credit_id,
                'debtor_id' => $crm_debtor_id,
                'associated_credit_name' => $emapData[64],
                'associated_credit_type' => $emapData[65],
                'associated_credit_accref' => $emapData[66],
                'associatedcre_credit_amnt' => $emapData[67],
                'associated_credit_balamnt' => $emapData[68],
                'associated_credit_status' => $emapData[69],
                'associated_credit_remarks' => $emapData[70],
            );
            $this->db->insert('debtor_associated_credit', $associated_credit);
          //  $i++;
        //}


       // $i = 1;
       // while (isset($postdata['debtor_notes_title' . $i]) && !empty($postdata['debtor_notes_title' . $i])) {
            $debtor_notes_id = $this->mastermodel->insertmasterdata();
            $debtor_notes = array(
                'debtor_notes_id' => $debtor_notes_id,
                'debtor_id' => $crm_debtor_id,
                'debtor_notes_title' => $emapData[71],
                'debtor_notes_date' => $this->mastermodel->convert_date_format($emapData[72]),
                'debtor_notes_ref' => $emapData[73],
                'debtor_notes_desc' => $emapData[74],
            );

            $this->db->insert('debtor_notes', $debtor_notes);
          //  $i++;
       // }
      //  $i = 1;
      //  while (isset($postdata['other_contact_name' . $i]) && !empty($postdata['other_contact_name' . $i])) {
            $other_contact_id = $this->mastermodel->insertmasterdata();
            $other_contact = array(
                'other_contact_id' => $other_contact_id,
                'debtor_id' => $crm_debtor_id,
                'other_contact_name' => $emapData[75],
                'other_contact_mobile' => $emapData[76],
                'other_contact_phone' => $emapData[77],
                'other_contact_email' => $emapData[78],
            );

            $this->db->insert('debtor_other_contact', $other_contact);
         //   $i++;
        //}

}
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            $data['id'] = $crm_debtor_id;
            return $data;
        }
    }
  function get_debtor_excel_example($id) {
        if ($id == 1) {
            $this->db->select('contact_company_name as name,contact_id as value');
            $this->db->from('contact');
            $data['results'] = $this->db->get();

            return $data;
        } else if ($id == 8) {
            $this->db->select('crm_salutaion_name as name,crm_selutation_id as value');
            $this->db->from('crm_salutaion');
            $data['results'] = $this->db->get();

            return $data;
        } else if ($id == 2) {
            $this->db->select('nationality_name as name,nationality_id as value');
            $this->db->from('nationality');
            $data['results'] = $this->db->get();
            return $data;
        } else if ($id == 3) {
            $this->db->select('country_name as name,country_name as value');
            $this->db->from('apps_countries');
            $data['results'] = $this->db->get();
            return $data;
        } else if ($id == 4) {
            $this->db->select('property_type_name as name,property_type_id as value');
            $this->db->from('debtor_property_type');
            $data['results'] = $this->db->get();
            return $data;
        }
        else if ($id == 5) {
            $this->db->select('ownership_type_name as name,ownership_type_id as value');
            $this->db->from('debtor_ownership_type');
            $data['results'] = $this->db->get();
            return $data;
        }
         else if ($id == 6) {
            $this->db->select('credit_type_name as name,credit_type_id as value');
            $this->db->from(' debtor_credit_type');
            $data['results'] = $this->db->get();
            return $data;
        }
        
       
        else {
            $this->db->select('debtor_status_name as name,debtor_status_id as value');
            $this->db->from('debtor_status');
            $data['results'] = $this->db->get();
            return $data;
        }
    }
    
    
     function add_payment_extra($postdata) {
        $data = array();
        $this->db->trans_begin();
          $config['upload_path'] = './assets/uploads/';
        $config['allowed_types'] = '*';
        $config['max_size'] = '200000';
        $config['max_height'] = '200000';
        $config['max_width'] = '200000';
        $config['remove_spaces'] = true;
        $config['overwrite'] = false;

        $this->load->library('upload', $config);
        $file='';
        if ($this->upload->do_upload('file_upload')) {
            $upload_data = $this->upload->data();
            $file= $upload_data['file_name'];
        }else{
               $upload_data = array('error' => $this->upload->display_errors());
              
        }
        $id = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('expense_code', 'expense', 'expense_code');
        $tblValues = array(
            'expense_id' => $id,
            //'expense_code' => $code,
            'expense_date' => $this->mastermodel->convert_date_format($postdata['expense_date']),
         //   'expense_lawyer_id' => $postdata['expense_lawyer_id'],
            'expense_note' => $postdata['expense_note'],
            'expense_complaints_id' => $postdata['expense_complaints_id'],
            'expense_amount' => $postdata['expense_amount'],
            'expense_file'=> $file
        );

        $this->db->insert('payment_extra', $tblValues);
        
        
        
        
         if ($this->mastermodel->get_num_rows('ptp', 'ptp_complaints_id', $postdata['expense_complaints_id']) <= 0) {
                $tblValues111['extra_amount_paid'] = $postdata['expense_amount'];
                
                 $tblValues111['complaints_extra_recieved_date'] = $postdata['expense_date'];
                
                
                  $this->db->where('complaints_id', $postdata['expense_complaints_id']);
        $this->db->update('complaints', $tblValues111);
                
                $master_id_ptp = $this->mastermodel->insertmasterdata();
                
                
                $code = $this->mastermodel->get_ref('ptp_code', 'ptp', 'ptp_code');

                $tblValues2 = array(
                    'ptp_id' => $master_id_ptp,
                    'ptp_code' => $code,
                    'ptp_date' => $this->mastermodel->convert_date_format($postdata['expense_date']),
                    'ptp_amount' => $postdata['expense_amount'],
                    'ptp_installments' => 0,
                    'ptp_frequency' => 0,
                    'ptp_start_date' => $this->mastermodel->convert_date_format($postdata['expense_date']),
                    'ptp_due_date' => $this->mastermodel->convert_date_format($postdata['expense_date']),
                    'ptp_complaints_id' => $postdata['expense_complaints_id'],
                    'ptp_note' => "other_note",
                    'ptp_approve' => 1
                );

                $this->db->insert('ptp', $tblValues2);
                $ptp_payment_plan_id = $this->mastermodel->insertmasterdata();
                $tblValues1 = array(
                    'ptp_payment_plan_id' => $ptp_payment_plan_id,
                    'payment_plan_ptp_id' => $master_id_ptp,
                    'payment_plan_amount' => $postdata['expense_amount'],
                    'payment_plan_date' => $this->mastermodel->convert_date_format($postdata['expense_date']),
                );

                $this->db->insert('ptp_payment_plan', $tblValues1);
            }
        
        
        
        
        
        
        
        
        
        
        


        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    
    
       function readExcelDataComplaint() {
        $data = array();
        $this->db->trans_begin();

        $config['upload_path'] = './assets/uploads/';
        $config['allowed_types'] = '*';
        $config['max_size'] = '200000';
        $config['max_height'] = '200000';
        $config['max_width'] = '200000';
        $config['remove_spaces'] = true;
        $config['overwrite'] = false;

        $this->load->library('upload', $config);

        if ($this->upload->do_upload('excel')) {
            $upload_data = $this->upload->data();
        } else {
            $upload_data = array('error' => $this->upload->display_errors());
        }
       // $filename = "/home/makanerp/public_html/matrix/assets/uploads/". $upload_data['file_name'];
       
        $filename = base_url() ."assets/uploads/". $upload_data['file_name'];
//         $file = fopen($filename, "r");
// $row=1;
//         while (($emapData = fgetcsv($file, 10000, ",")) !== FALSE) {
//  $num = count($emapData);
// if($row>1){

         $data=$this->update_complaints_excel($filename);
// }
// $row++;
           
//         }
        fclose($file);
        return $data;
    }
    
    function search_crm_debtor_paginate($postData=null){

     $response = array();

     ## Read value
     $draw = $postData['draw'];
     $start = $postData['start'];
     $rowperpage = $postData['length']; // Rows display per page
     $columnIndex = $postData['order'][0]['column']; // Column index
     $columnName = $postData['columns'][$columnIndex]['data']; // Column name
     $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
     $searchValue = $postData['search']['value']; // Search value

     ## Search 
     $searchQuery = "";
     if($searchValue != ''){
        $searchQuery = "(crm_debtor_id like '%".$searchValue."%' or crm_debtor_company_name like '%".$searchValue."%' or crm_debtor_residential_address like'%".$searchValue."%' or contact_company_name like'%".$searchValue."%' or crm_debtor_agreement_no like'%".$searchValue."%' or crm_debtor_mobile_1 like'%".$searchValue."%') ";
     }


       $profile_settings = $this->mastermodel->get_profile_settings();
        $user_id = $_SESSION['user_id'];
        $data = array();
       
        $this->db->join('contact', 'contact.contact_id=debtor.debtor_contact_id', 'left');
        $this->db->join('master', 'master.master_id=debtor.crm_debtor_id');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('contact.user_id', $_SESSION['user_id']);
        }
        if (($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('debtor.crm_debtor_id not in ', '(select complaints.complaints_debtor_id from complaints where complaints_lawyer_id = ' . $user_id . ' )', false);
        }
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('crm_debtor_id', 'desc');
        $totalRecords  = $this->db->count_all_results('debtor');


     ## Total number of record with filtering
     
      $this->db->join('contact', 'contact.contact_id=debtor.debtor_contact_id', 'left');
        $this->db->join('master', 'master.master_id=debtor.crm_debtor_id');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('contact.user_id', $_SESSION['user_id']);
        }
        if (($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('debtor.crm_debtor_id not in ', '(select complaints.complaints_debtor_id from complaints where complaints_lawyer_id = ' . $user_id . ' )', false);
        }
         if($searchQuery != '')
        $this->db->where($searchQuery);
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('crm_debtor_id', 'desc');
        $totalRecordwithFilter  = $this->db->count_all_results('debtor');


     ## Fetch records
     $this->db->select('*');
        $this->db->from('debtor');
        $this->db->join('contact', 'contact.contact_id=debtor.debtor_contact_id', 'left');
        $this->db->join('master', 'master.master_id=debtor.crm_debtor_id');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('contact.user_id', $_SESSION['user_id']);
        }
        if (($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('debtor.crm_debtor_id not in ', '(select complaints.complaints_debtor_id from complaints where complaints_lawyer_id = ' . $user_id . ' )', false);
        }
         if($searchQuery != '')
        $this->db->where($searchQuery);
        $this->db->where('master.project_id', $_SESSION['project_id']);
         $this->db->order_by('crm_debtor_id', $columnSortOrder);
        $this->db->limit($rowperpage, $start);
      $records= $this->db->get()->result();

     $data = array();
 
     foreach($records as $key=> $row ){

     $debitor_name='<a target="blank" href="#" title="Edit" onclick=singleformdata("client,"edit_page",'.$row->crm_debtor_id.',"debtor,"crm_debtor_id","management","single_page_crm_debitor")>';

               if(!empty($row->crm_debtor_company_name)||($row->crm_debtor_company_name!='')){
                 $debitor_name.=$row->crm_debtor_company_name;
                } else {
                 $debitor_name.=$row->crm_debtor_first_name;
                }
                 $debitor_name.='</a>';
                 
       $action='<a class="edit" href="#" title="Edit" onclick=editformdata("client","edit_page","'.$row->crm_debtor_id.'","debtor","crm_debtor_id","management","add_crm_debitor")><i class="fa fa-edit"></i></a>';
                       
                        if($this->mastermodel->get_num_rows("complaints","complaints_debtor_id",$row->crm_debtor_id) <= 0){
                               $action.='<a class="delete" href="#" title="Delete" onclick=deletedata("debtor",'.$row->crm_debtor_id.',"crm_debtor_id","client","viewinclientsearch","search_crm_debtor","management","view_crm_debtor","","")><i class="fa fa-trash"></i></a>';
                          }
                         $action.='<a class="" href="#" title="Add Complaint" onclick=editformdata("client","edit_page","'.$row->crm_debtor_id.'","debtor","crm_debtor_id","management","add_complaints")><i  class="fa fa-level-up"></i></a>';
                                 
                 
                 
        $data[] = array( 
           "id"=>$key+1,
           "crm_debtor_id"=>$row->crm_debtor_id,
           "debitor_name"=>$debitor_name,
           "crm_debtor_residential_address"=>$row->crm_debtor_residential_address,
           "contact_company_name"=>$row->contact_company_name,
           "crm_debtor_agreement_no"=>$row->crm_debtor_agreement_no,
           "crm_debtor_mobile_1"=>$row->crm_debtor_mobile_1,
           "action"=>$action
        ); 
     }

     ## Response
     $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data
     );

     return $response; 
   }
     
     
      function search_complaints_paginate($postData=null){
        $credior_id_s=$this->mastermodel->get_single_field_value('contact','contact_id','user_id',$_SESSION['user_id']);

     $response = array();

     ## Read value
     $draw = $postData['draw'];
     $start = $postData['start'];
     $rowperpage = $postData['length']; // Rows display per page
     $columnIndex = $postData['order'][0]['column']; // Column index
     $columnName = $postData['columns'][$columnIndex]['data']; // Column name
     $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
     $searchValue = $postData['search']['value']; // Search value

     ## Search 
     $searchQuery = "";
     if($searchValue != ''){
        $searchQuery = "(complaints_code like '%".$searchValue."%' or crm_debtor_company_name like '%".$searchValue."%' or crm_debtor_mobile_1 like'%".$searchValue."%' or complaints_debtor_principle_amnt like'%".$searchValue."%' ) ";
     }

      $profile_settings = $this->mastermodel->get_profile_settings();
      
      $lawyer= $this->mastermodel->get_single_field_value('lawyer', 'lawyer_id', 'user_id', $_SESSION['user_id']);
    
        $data = array();
        $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id');
        $this->db->order_by('complaints_id', 'desc');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_creditor_id', $credior_id_s);
        }
        if ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_assign_ids', $_SESSION['employee_id']);
        }
        if (($profile_settings->legal_profile_id == $_SESSION['profile_id']) || ($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('complaints.complaints_lawyer_id', $lawyer);
        }

       
       $totalRecords = $this->db->count_all_results('complaints');
        



     ## Total number of record with filtering
     
        $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id');
        $this->db->order_by('complaints_id', 'desc');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_creditor_id', $credior_id_s);
        }
        if ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_assign_ids', $_SESSION['employee_id']);
        }
        if (($profile_settings->legal_profile_id == $_SESSION['profile_id']) || ($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('complaints.complaints_lawyer_id', $lawyer);
        }
       if($searchQuery != '')
        $this->db->where($searchQuery);
       
       $totalRecordwithFilter = $this->db->count_all_results('complaints');
       
      

     ## Fetch records
       $this->db->join('debtor', 'debtor.crm_debtor_id=complaints.complaints_debtor_id');
        if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_creditor_id', $credior_id_s);
        }
        if ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {

            $this->db->where('complaints.complaints_assign_ids', $_SESSION['employee_id']);
        }
        if (($profile_settings->legal_profile_id == $_SESSION['profile_id']) || ($profile_settings->lawyer_profile_id == $_SESSION['profile_id'])) {

            $this->db->where('complaints.complaints_lawyer_id', $lawyer);
        }
       if($searchQuery != '')
        $this->db->where($searchQuery);
       $this->db->order_by('complaints_id', $columnSortOrder);
        $this->db->limit($rowperpage, $start);
       $records = $this->db->get('complaints')->result();

     $data = array();
 
     foreach($records as $key=> $row ){


    $creditor_id=$this->mastermodel->get_single_field_value('debtor','debtor_contact_id','crm_debtor_id',$row->complaints_debtor_id);
    $creditor = $this->mastermodel->selected_data_by_id('contact',array('contact_id','contact_first_name','contact_last_name','contact_company_name'),'contact_id',$creditor_id)[0];
    $debitor = $this->mastermodel->selected_data_by_id('debtor',array('crm_debtor_id','crm_debtor_first_name','crm_debtor_last_name','crm_debtor_country','crm_debtor_mobile_1','contact_passport_no','crm_debtor_company_name','crm_debtor_agreement_no'),'crm_debtor_id',$row->complaints_debtor_id)[0];
            
         if(!empty($debitor->crm_debtor_company_name)){  
             $debitor_name= $debitor->crm_debtor_company_name;
         }else {
             $debitor_name= $debitor->crm_debtor_first_name.' '.$debitor->crm_debtor_last_name; 
         }
                 
       $action='<a class="edit" href="#" title="Edit" onclick=editformdata("client","edit_page","'.$row->crm_debtor_id.'","debtor","crm_debtor_id","management","add_crm_debitor")><i class="fa fa-edit"></i></a>';
                       
                        if($this->mastermodel->get_num_rows("complaints","complaints_debtor_id",$row->crm_debtor_id) <= 0){
                               $action.='<a class="delete" href="#" title="Delete" onclick=deletedata("debtor",'.$row->crm_debtor_id.',"crm_debtor_id","client","viewinclientsearch","search_crm_debtor","management","view_crm_debtor","","")><i class="fa fa-trash"></i></a>';
                          }
                         $action.='<a class="" href="#" title="Add Complaint" onclick=editformdata("client","edit_page","'.$row->crm_debtor_id.'","debtor","crm_debtor_id","management","add_complaints")><i  class="fa fa-level-up"></i></a>';
                                 
                 
       ////////////////////
       
                $crm_lead_type='<input type="hidden" value="'.$row->complaints_id.'" class="complaints_id" name="complaints_id" id="complaints_id">';
                  if($_SESSION['profile_id']!=5654){
                                 $crm_lead_type.='<select class="select2 case_type" name="case_type" id="case_type" style="width: 100px !important;" >';

                    }else{
                       $crm_lead_type.='<select class="select2 case_type" name="case_type" id="case_type" style="width: 100px !important;" disabled >';
                    }
                                         $crm_lead_type.='<option value="">--select--</option>';
                                    
                                        $val = $this->mastermodel->select_data("crm_lead_type");
                                        foreach ($val as $item) {
                                            $selected='';
                                        if ($row->complaints_case_type == $item->crm_lead_type_id) {
                                            $selected= "selected";
                                        }
                                         $crm_lead_type.='<option value="'.$item->crm_lead_type_id.'" '.$selected.' >'.$item->crm_lead_type_name.'</option>';
                                
                                        } 
                                 
                                     $crm_lead_type.='</select>';
       
       
       
       
       ////////////////////
       
                      $crm_lead_status=  '<select class="select2 status_id" name="status_id" id="status_id" style="width: 100px !important;">';
                      $crm_lead_status.='<option value="">--select--</option>';
                                        $val = $this->mastermodel->selected_data_by_id('crm_lead_status',array('crm_lead_status_type_id','crm_lead_status_id','crm_lead_status_name'),'crm_lead_status_type_id',$row->complaints_case_type);
                                        foreach ($val as $item) {
                                   $selected='';
                                   if ($row->complaints_status_id == $item->crm_lead_status_id) {
                                      $selected= "selected";
                                       
                                   } 
                                        $crm_lead_status.='<option value="'.$item->crm_lead_status_id.'" '.$selected.' >'.$item->crm_lead_status_name.'</option>';
                                   
                                        } 
                                    $crm_lead_status.= '</select>';
                                    
               
               //////////////////////////////action

              $action='<a class="btn btn-sm btn-danger" href="#" title="Add Note" onclick="load_modal(this)" data-id="'.$row->complaints_id.'" data-page="modal_note_page"><i class="fa fa-pencil"></i></a>';
                                $action.='<a class="btn btn-sm btn-danger" title="pdf" href="'.site_url("client/invoice_pdf_new/client/management/invoice_pdf/$row->complaints_id").'"><i class="fa fa-print" aria-hidden="true"></i>
</a>';
               
$action.='<a href="#" class="btn btn-sm btn-danger"   title="Add Payment" onclick="load_modalpayment(this)" data-id="'.$row->complaints_id.'" data-page="modal_payment_page"><i class="fa fa-usd"></i></a>';

     if($_SESSION["profile_id"]!=6659){
if($_SESSION["administrator_privilage"] == "no"){
if($profile_settings->legal_profile_id == $_SESSION["profile_id"]){

$action.='<a href="#"  class="btn btn-sm btn-danger" title="Add Legal" onclick="load_modal(this)" data-id="'.$row->complaints_id.'" data-page="modal_legal_page"><i class="fa fa-legal"></i></a>';


}  
}
else{
   
  $action.='<a href="#"  class="btn btn-sm btn-danger" title="Add Legal" onclick="load_modal(this)" data-id="'.$row->complaints_id.'" data-page="modal_legal_page"><i class="fa fa-legal"></i></a>';

}
  if($_SESSION["administrator_privilage"] == "no"){
if(($profile_settings->legal_profile_id == $_SESSION["profile_id"]) || ($profile_settings->lawyer_profile_id == $_SESSION["profile_id"])){

     
      $action.='<a href="#" class="btn btn-sm btn-danger"  title="Add Expense" onclick="load_modal(this)" data-id="'.$row->complaints_id.'" data-page="modal_expense_page"><i class="fa fa-money"></i></a>';



    
}     if(($profile_settings->legal_profile_id == $_SESSION["profile_id"]) || ($profile_settings->collector_profile_id == $_SESSION["profile_id"])){

      
     
      $action.='<a  href="#" class="btn btn-sm btn-danger" title="" onclick=singleformdata("client","edit_page","'.$row->complaints_id.'","complaints","complaints_id","management","add_task")><i class="fa fa-caret-square-o-right"></i></a>';

}   
  }  
    else{
   
        $action.='<a  class="btn btn-sm btn-danger" href="#"   title="Add Expense" onclick="load_modal(this)" data-id="'.$row->complaints_id.'" data-page="modal_expense_page"><i class="fa fa-money"></i></a>';

      $action.='<a  class="btn btn-sm btn-danger" href="#" title="" onclick=singleformdata("client","edit_page","'.$row->complaints_id.'","complaints","complaints_id","management","add_task")><i class="fa fa-caret-square-o-right"></i></a>';

}
  
if($row->complaints_is_settled != 1)
{

$action.='<a class="edit btn btn-sm btn-danger" href="#" title="Edit" onclick=editformdata("client","edit_page","'.$row->complaints_id.'","complaints","complaints_id","management","edit_complaints")><i class="fa fa-edit"></i></a>';
if($_SESSION["profile_id"]!=6638){
$action.='<a class="delete btn btn-sm btn-danger" href="#" title="Delete" onclick=deletedata("complaints","'.$row->complaints_id.'","complaints_id","client","viewinclientsearch","search_complaints","management","view_complaints","","")"><i class="fa fa-trash"></i></a>';
}


}else if(($this->mastermodel->get_num_rows("task","task_complaint_id",$row->complaints_id) <= 0) && ($this->mastermodel->get_num_rows("ptp","ptp_complaints_id",$row->complaints_id) <= 0)){  

if($_SESSION["profile_id"]!=6638){
$action.='<a class="delete btn btn-sm btn-danger" href="#" title="Delete" onclick=deletedata("complaints","'.$row->complaints_id.'","complaints_id","client","viewinclientsearch","search_complaints","management","view_complaints","","")><i class="fa fa-trash"></i></a>';
}

}else if($row->complaints_is_settled_direct !=0){

$ptp_id=$this->mastermodel->get_single_field_value("ptp","ptp_id","ptp_complaints_id",$row->complaints_id);

$action.='<a class="btn btn-sm btn-danger"  href="#"  title="Add Payment" onclick="load_modal(this)" data-id="'.$ptp_id.'" data-page="modal_complaints_payment_page"><i class="fa fa-credit-card"></i></a>';
$action.='<a class="btn btn-sm btn-danger" title="pdf" href="'.site_url("client/ptp_invoice_pdf/client/management/ptp_invoice/$ptp_id").'"><i class="fa fa-file-pdf-o" ></i></a>';




} 
}
               
               
               
               ////////////////////////////////
               
                 
        $data[] = array( 
           "complaints_id"=>$key+1,
           "contact_company_name"=>$creditor->contact_company_name,
           "debitor_name"=>$debitor_name,
           "crm_debtor_mobile_1"=>$debitor->crm_debtor_mobile_1.' '.$row->crm_lead_details_LastName,
           "complaints_debtor_agreement_no"=>$debitor->crm_debtor_agreement_no,
           "complaints_debtor_principle_amnt"=>$row->complaints_debtor_principle_amnt,
           "complaints_code"=>'<a  href="#" title="Edit" onclick=singleformdata("client","edit_page",'.$row->complaints_id.',"complaints","complaints_id","management","single_complaints")>'.$row->complaints_code.'</a>',
           "crm_lead_type"=>$crm_lead_type,
           "crm_lead_status"=>$crm_lead_status,
           "action"=>$action
        ); 
     }

     ## Response
     $response = array(
        "draw" => intval($draw),
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data
     );

     return $response; 
   }
    
function search_crm_debtor_count() {
    $profile_settings = $this->mastermodel->get_profile_settings();
    $user_id = $_SESSION['user_id'];
    $data = array();

    // Build the query
    $this->db->select('*');
    $this->db->from('debtor');
    $this->db->join('contact', 'contact.contact_id = debtor.debtor_contact_id', 'left');
    $this->db->join('master', 'master.master_id = debtor.crm_debtor_id');

    if ($profile_settings->creditor_profile_id == $_SESSION['profile_id']) {
        $this->db->where('contact.user_id', $_SESSION['user_id']);
    }
    
    if ($profile_settings->lawyer_profile_id == $_SESSION['profile_id']) {
        $this->db->where('debtor.crm_debtor_id NOT IN', '(SELECT complaints.complaints_debtor_id FROM complaints WHERE complaints_lawyer_id = ' . $user_id . ')', false);
    }

    $this->db->where('master.project_id', $_SESSION['project_id']);
    $this->db->order_by('crm_debtor_id', 'desc');

    // Execute the query
    $query = $this->db->get();

    // Get the results and the number of rows
  //  $data['results'] = $query->result(); // Get the results as an array of objects
    $data['num_rows'] = $query->num_rows(); // Get the number of rows returned

    return $data;
}
}

